/*
 * Decompiled with CFR 0.152.
 */
package fi.darkwood;

import fi.darkwood.Creature;
import fi.darkwood.GameConstants;
import fi.darkwood.Player;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Monster
extends Creature {
    private int a;
    private boolean a;

    public Monster(String string, String string2, int n, int n2) {
        super(string, string2, n2, n);
        this.money = GameConstants.getMonsterMoney(n2);
        this.setLevel(n2);
    }

    public Monster(String string, String string2, int n) {
        super(string, string2, 0, n);
    }

    public void setLevel(int n) {
        this.level = n;
        this.money = GameConstants.getMonsterMoney(n);
        this.updateStats();
        this.health = this.maxHealth;
        this.mana = this.maxMana;
    }

    public void updateStats() {
        this.strength = 2 * this.level;
        this.dexterity = 2 * this.level;
        this.constitution = 2 * this.level;
        this.willpower = 2 * this.level;
        super.restartBuffs();
        this.updateMaxHealthAndMana();
    }

    public void updateMaxHealthAndMana() {
        this.maxHealth = (int)((double)this.constitution * 0.7 + (double)(this.strength + this.dexterity + this.willpower) * 0.1) * 10 + 1;
        if (this.a) {
            this.maxHealth *= 3;
        }
        this.maxMana = (int)((double)this.willpower * 0.9 + (double)this.constitution * 0.1) * 10 + 1;
    }

    public int getId() {
        return this.a;
    }

    public void setId(int n) {
        this.a = n;
    }

    public boolean hates(Creature creature) {
        return creature instanceof Player;
    }

    public double getDamage() {
        return GameConstants.getMonsterDPS(this.level);
    }

    public void awardKill(Creature creature) {
    }

    public void combatSpecial(Creature creature) {
    }

    public void setElite(boolean bl) {
        this.a = bl;
        this.updateMaxHealthAndMana();
        this.health = this.maxHealth;
        this.mana = this.maxMana;
    }

    public boolean isElite() {
        return this.a;
    }
}

