/*
 * Decompiled with CFR 0.152.
 */
package fi.darkwood.level.one;

import fi.darkwood.EquipmentFactory;
import fi.darkwood.Game;
import fi.darkwood.GameConstants;
import fi.darkwood.Potion;
import fi.darkwood.Zone;
import fi.darkwood.level.one.eq.ShiningPlateMail;
import fi.darkwood.level.one.quest.QuestKillWolves;
import fi.darkwood.room.CityRoom;
import fi.darkwood.room.MapRoom;
import fi.darkwood.room.Room;
import fi.darkwood.room.RoomFactory;
import fi.darkwood.room.ShopRoom;

public class DarkwoodCityZone
extends Zone {
    private RoomFactory a;
    public MapRoom crossroads;

    public DarkwoodCityZone() {
        super("Darkwood", "/images/background/darkwood_town/background.png");
        this.firstQuest = new QuestKillWolves();
        this.firstQuest.setReward(new ShiningPlateMail());
        this.allQuestsDoneMessage = "Travel north to the Capital of the Border Kingdoms. The Queen requires your services.";
        this.a = new RoomFactory();
        Room room = (CityRoom)this.a.constructCityEntrance(this, "center", "/images/background/tier1_city/background.png");
        ((CityRoom)room).setSpriteImage("/images/background/tier1_city/lantern_frames.png", 6, 63, 88);
        ((CityRoom)room).setSpriteFrameTime(new int[]{10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10});
        ((CityRoom)room).setEyesSpriteImage("/images/background/tier1_city/eyes_frames.png", 13, 113, 115);
        ((CityRoom)room).setEyesSpriteFrameTime(new int[]{20, 1, 20, 1, 10, 1});
        ((CityRoom)room).cityDesc = "Welcome to town of Darkwood";
        room = this.a.constructMapRoomSouth(this, this.entrance, "Map");
        this.crossroads = (MapRoom)room;
        this.crossroads.setCoordinates(243, 504, "/images/map/icons/darkwood_hut.png");
        this.a.constructStatRoomNorth(this, this.entrance, "Trainer", "trainer");
        this.a.constructTavernRoomEast(this, this.entrance, "Tavern", "tavern");
        room = this.a.constructShopRoomWest(this, this.entrance, "Smithy", "shop");
        ((ShopRoom)room).setWelcomeText("Welcome to the Darkwood town smithy. Here you may buy new equipment and replenish potions.");
        int n = GameConstants.getArmorTypeforClass(Game.player.characterClass);
        EquipmentFactory equipmentFactory = EquipmentFactory.getInstance();
        ((ShopRoom)room).addItem(equipmentFactory.createEquipment(2, 1, n, 0));
        ((ShopRoom)room).addItem(equipmentFactory.createEquipment(2, 1, n, 1));
        ((ShopRoom)room).addItem(equipmentFactory.createEquipment(4, 1, n, 1));
        ((ShopRoom)room).addItem(equipmentFactory.createEquipment(3, 2, n, 0));
        ((ShopRoom)room).addItem(equipmentFactory.createEquipment(4, 2, n, 1));
        ((ShopRoom)room).addItem(equipmentFactory.createEquipment(3, 3, n, 0));
        ((ShopRoom)room).addItem(new Potion());
    }

    public void resetZone() {
        System.out.println("In darkwoodcityzone resetZone()");
        System.out.println("Before removeAllElements, vector size: " + this.crossroads.zones.size());
        this.crossroads.zones.removeAllElements();
        System.out.println("After clearing vector, size: " + this.crossroads.zones.size());
        this.crossroads.addZone("/fi/darkwood/level/one/VillageFields.xml", 238, 462, this.getClass().getName(), "/images/map/icons/fields.png");
        this.crossroads.addZone("/fi/darkwood/level/one/DarkForest.xml", 187, 492, this.getClass().getName(), "/images/map/icons/wolves.png");
        this.crossroads.addZone("/fi/darkwood/level/one/OmniousForest.xml", 231, 557, this.getClass().getName(), "/images/map/icons/witch.png");
        this.crossroads.addZone("/fi/darkwood/level/one/PartyForest.xml", 297, 519, this.getClass().getName(), "/images/map/icons/wolves.png");
        QuestKillWolves questKillWolves = new QuestKillWolves();
        if (Game.player.completedQuests.contains(questKillWolves)) {
            this.crossroads.addZone("/fi/darkwood/level/one/ForestRoad.xml", 319, 391, this.getClass().getName(), "/images/map/icons/city capital.png");
            System.out.println("ADDED QUESTZONE2!");
        }
    }

    public String getDescription() {
        return "Town of Darkwood";
    }
}

