/*
 * Decompiled with CFR 0.152.
 */
package fi.darkwood.ability;

import fi.darkwood.Ability;
import fi.darkwood.Creature;
import fi.darkwood.Game;
import fi.darkwood.GameConstants;
import fi.darkwood.Monster;
import fi.darkwood.Player;
import fi.darkwood.ui.component.MessageLog;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;

public abstract class AreaDamageAbility
extends Ability {
    private Vector a;

    public AreaDamageAbility(String string, String string2, int n) {
        super(string, string2, n);
    }

    public abstract int getAbilityRank();

    public boolean effect(Creature creature) {
        this.a = new Vector();
        Creature creature2 = creature;
        Enumeration enumeration = Game.player.room.getCreatures().elements();
        while (enumeration.hasMoreElements()) {
            Creature creature3 = (Creature)enumeration.nextElement();
            if (!(creature3 instanceof Monster) || !creature3.isAlive()) continue;
            this.a.addElement(creature3);
        }
        if (!creature2.isReadyToAct(this.getAbilitySlot())) {
            return false;
        }
        if (this.a.isEmpty()) {
            System.out.println("No target for ability!");
            return false;
        }
        if (creature2.mana < this.getManaCost(creature2, null)) {
            if (creature.getId() == Game.player.getId()) {
                MessageLog.getInstance().addMessage("Not enough energy!");
            }
            return false;
        }
        creature2.addAbilityCooldown(this.getCooldownInRounds(), this.getAbilitySlot());
        float f = 1.0f;
        if (creature2 instanceof Player) {
            enumeration = (Player)creature2;
            ((Player)((Object)enumeration)).setAbilityInvokeAnimationFrameSequence();
            f = (float)GameConstants.classAbilityCoef(((Player)((Object)enumeration)).characterClass);
        }
        creature2.reduceMana(this.getManaCost(creature2, null));
        enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            float f2;
            creature = (Creature)enumeration.nextElement();
            float f3 = f * (float)this.getDamage(creature2, creature);
            if (f2 < 0.0f) {
                f3 = 0.0f;
            }
            creature.harm(f3);
        }
        creature = (Creature)this.a.firstElement();
        creature.addAbilityEffect(this.getTargetVisualEffect());
        Game.party.sendVisualEffect(creature.getId(), this.getTargetVisualEffect());
        if (this.getSelfVisualEffect() != null) {
            creature2.addAbilityEffect(this.getSelfVisualEffect());
            Game.party.sendVisualEffect(creature2.getId(), this.getSelfVisualEffect());
        }
        return true;
    }

    public String getDescription() {
        Player player = Game.player;
        return "Inflicts around " + this.getDamage(player, player) + " damage to all opponents for " + this.getManaCost(player, player) + " mana.";
    }

    public abstract int getDamage(Creature var1, Creature var2);

    public abstract int getManaCost(Creature var1, Creature var2);

    static {
        new Random(System.currentTimeMillis());
    }
}

