/*
 * Decompiled with CFR 0.152.
 */
package com.rovio.rtool.mobile;

import com.rovio.rtool.mobile.Core;
import com.rovio.rtool.mobile.Resources;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class Device {
    public static final int INFINITE_LOOP = -1;
    private static boolean sm_musicEnabled = true;
    private static Player sm_currentMusic = null;
    private static int sm_musicVolume = 60;
    private static byte[][] sm_musicDatas = new byte[0][];
    private static int[] sm_musicIds = new int[0];
    private static int sm_currentMusicId = -1;
    private static boolean vibraEnabled = true;

    public static int getCurrentMusicId() {
        return sm_currentMusicId;
    }

    public static void cacheMusic(byte[] byArray, int n, String string) {
        if (byArray == null) {
            InputStream inputStream = Core.loadResource(string);
            try {
                byArray = Resources.getBytes(inputStream, -1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (int i = 0; i < sm_musicIds.length; ++i) {
            if (sm_musicIds[i] != n) continue;
            Device.sm_musicDatas[i] = null;
            Device.sm_musicIds[i] = -1;
        }
        byte[][] byArrayArray = new byte[sm_musicDatas.length + 1][];
        System.arraycopy(sm_musicDatas, 0, byArrayArray, 0, sm_musicDatas.length);
        sm_musicDatas = byArrayArray;
        Device.sm_musicDatas[Device.sm_musicDatas.length - 1] = byArray;
        int[] nArray = new int[sm_musicIds.length + 1];
        System.arraycopy(sm_musicIds, 0, nArray, 0, sm_musicIds.length);
        sm_musicIds = nArray;
        Device.sm_musicIds[Device.sm_musicIds.length - 1] = n;
    }

    public static void releaseCache(int n) {
        for (int i = 0; i < sm_musicIds.length; ++i) {
            if (sm_musicIds[i] != n) continue;
            Device.sm_musicDatas[i] = null;
            Device.sm_musicIds[i] = -1;
            return;
        }
    }

    public static void releaseAll() {
        for (int i = 0; i < sm_musicDatas.length; ++i) {
            Device.sm_musicDatas[i] = null;
        }
        sm_musicDatas = new byte[0][];
        sm_musicIds = new int[0];
    }

    public static void playMusic(int n, int n2) {
        int n3 = -1;
        for (int i = 0; i < sm_musicIds.length; ++i) {
            if (sm_musicIds[i] != n) continue;
            n3 = i;
            break;
        }
        if (n3 == -1) {
            return;
        }
        Device.stopMusic();
        if (sm_musicEnabled) {
            try {
                sm_currentMusic = Manager.createPlayer((InputStream)new ByteArrayInputStream(sm_musicDatas[n3]), (String)"audio/midi");
                sm_currentMusic.prefetch();
                VolumeControl volumeControl = (VolumeControl)sm_currentMusic.getControl("VolumeControl");
                if (volumeControl != null) {
                    volumeControl.setLevel(sm_musicVolume);
                }
                if (n2 == -1) {
                    sm_currentMusicId = n;
                }
                sm_currentMusic.setLoopCount(n2);
                sm_currentMusic.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void handleInterruption() {
        Device.stopMusic();
    }

    public static void stopMusic() {
        if (sm_musicEnabled && sm_currentMusic != null) {
            try {
                sm_currentMusic.stop();
                sm_currentMusic.deallocate();
                sm_currentMusic.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            sm_currentMusicId = -1;
            sm_currentMusic = null;
        }
    }

    public static void setMusicEnabled(boolean bl) {
        if (!bl) {
            Device.stopMusic();
        }
        sm_musicEnabled = bl;
    }

    public static boolean isMusicEnabled() {
        return sm_musicEnabled;
    }

    public static int getVolume() {
        return sm_musicVolume / 20;
    }

    public static void setVolume(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 5) {
            n = 5;
        }
        sm_musicVolume = n * 20;
    }

    public static void playSoundFX(int n, int n2) {
    }

    public static void stopSoundFX() {
    }

    public static void setSoundFXEnabled(boolean bl) {
    }

    public static boolean isSoundFXEnabled() {
        return false;
    }

    public static void vibrate(int n) {
        if (vibraEnabled) {
            Core.display.vibrate(n);
        }
    }

    public static void setVibraEnabled(boolean bl) {
        vibraEnabled = bl;
    }

    public boolean isVibraEnabled() {
        return vibraEnabled;
    }

    public static void backlightOn() {
    }

    public static void backlightOff() {
    }
}

