/*
 * Decompiled with CFR 0.152.
 */
package module.ekernel.container;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import module.ekernel.container.GameScreen;

public abstract class GameMidlet
extends MIDlet
implements Runnable {
    private static GameMidlet _instance;
    private static int _frames;
    public static int _fps;
    private static boolean _testFps;
    private GameScreen _screen;
    private Display _display;
    private boolean _isNokiaSecdPlatform;
    private boolean _exitMidlet = false;

    protected GameMidlet() {
        _instance = this.activeMidlet();
        this._screen = GameScreen.instance();
        this.initGamePage(this._screen);
        this._display = Display.getDisplay((MIDlet)this);
        String string = System.getProperty("microedition.platform");
        if (string != null) {
            this._isNokiaSecdPlatform = string.indexOf("N72") >= 0 || string.indexOf("N70") >= 0;
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    protected abstract GameMidlet activeMidlet();

    protected abstract void initGamePage(GameScreen var1);

    protected void pauseApp() {
        this._screen.hideNotify();
    }

    protected void startApp() throws MIDletStateChangeException {
        this._display.setCurrent((Displayable)this._screen);
    }

    protected void destroyApp(boolean bl) throws MIDletStateChangeException {
        this._display.setCurrent(null);
    }

    public void run() {
        if (this._isNokiaSecdPlatform) {
            this.platform2();
        } else {
            this.platform1();
        }
    }

    protected void platform1() {
        try {
            long l = System.currentTimeMillis();
            _frames = 0;
            _fps = 10;
            long l2 = System.currentTimeMillis();
            do {
                if (!this._screen.paintable()) continue;
                long l3 = System.currentTimeMillis() - l;
                if (l3 < 90L) {
                    Thread.sleep(90L - l3);
                }
                this._screen.repaint();
                l = System.currentTimeMillis();
                if (!_testFps || ++_frames != 5) continue;
                _fps = (int)((long)(_frames * 1000) / (l - l2));
                _frames = 0;
                l2 = l;
            } while (!this._exitMidlet);
            this.notifyDestroyed();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void platform2() {
        try {
            long l = System.currentTimeMillis();
            _frames = 0;
            _fps = 10;
            long l2 = System.currentTimeMillis();
            do {
                if (!this._screen.paintable()) continue;
                long l3 = System.currentTimeMillis() - l;
                if (l3 < 90L) {
                    Thread.sleep(90L - l3);
                }
                this._screen.repaint();
                this._screen.serviceRepaints();
                l = System.currentTimeMillis();
                if (!_testFps || ++_frames != 5) continue;
                _fps = (int)((long)(_frames * 1000) / (l - l2));
                _frames = 0;
                l2 = l;
            } while (!this._exitMidlet);
            this.notifyDestroyed();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        _testFps = false;
    }
}

