/*
 * Decompiled with CFR 0.152.
 */
package pzg.extend.gameUI;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import pzg.basic.puzzle.PuzzleFunction;
import pzg.extend.game.GameInterface;
import pzg.extend.game.GameMainLogic;
import pzg.extend.game.GameRms;
import pzg.extend.game.PzgScene;
import pzg.extend.game.SmsUi;
import pzg.extend.gameUI.UIHandler;
import pzg.extend.gameUtil.GameFunction;
import pzg.extend.gameUtil.GameMenu;
import pzg.extend.gameUtil.GameMessageBox;
import rpg.basic.gameUtil.Function;
import rpg.basic.gameUtil.MenuHandler;
import rpg.basic.gameUtil.MessageBoxHandler;

public class LeftSoftInterface
extends UIHandler
implements MenuHandler,
MessageBoxHandler {
    private GameMainLogic _mainLogic;
    private static LeftSoftInterface _instance;
    int pos = 0;
    public static final String[] MENU_ITEM;
    public static final int[] MENU_SPT_ID;
    private int _curItemIndex;
    private int _itemStartX;
    private int _itemStartY;
    private int _itemSpace;
    private boolean _isSubPage;
    private GameInterface _interfaceInstance;
    public GameMenu _gameMenu;
    private GameMessageBox _messageBox;
    private boolean _isDrawReturnMenu;
    private static Vector _infoName;
    private static Vector _infoNews;
    private String[] _infoContext;
    private int _curRecordIndex;
    private int _curRecordIndexFlag;
    private static int PER_PAGE_LINES;
    public boolean _detailState;
    public int _curLine;
    public int _curPage;
    private Vector _recordNameVector = new Vector(100);
    private Vector _recordContextVector = new Vector(100);

    public LeftSoftInterface() {
        this._mainLogic = GameMainLogic.getInstance();
        this.format();
    }

    public static LeftSoftInterface getInstance() {
        if (_instance == null) {
            _instance = new LeftSoftInterface();
        }
        return _instance;
    }

    private void format() {
        this._itemStartX = 60;
        this._itemStartY = 80;
        this._itemSpace = 30;
    }

    public void addNewInfo(String string, String string2) {
        _infoName.addElement(string);
        _infoNews.addElement(string2);
    }

    public static void saveNewInfo(DataOutputStream dataOutputStream) {
        String string;
        Enumeration enumeration = _infoName.elements();
        try {
            dataOutputStream.writeShort(_infoName.size());
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                dataOutputStream.writeUTF(string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        enumeration = _infoNews.elements();
        try {
            dataOutputStream.writeShort(_infoNews.size());
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                dataOutputStream.writeUTF(string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void resetNewInfo() {
        _infoName.removeAllElements();
        _infoNews.removeAllElements();
    }

    public static void loadNewInfo(DataInputStream dataInputStream) {
        _infoName.removeAllElements();
        _infoNews.removeAllElements();
        try {
            int n = dataInputStream.readShort();
            int n2 = 0;
            while (n2 < n) {
                _infoName.addElement(dataInputStream.readUTF());
                ++n2;
            }
            n = dataInputStream.readShort();
            int n3 = 0;
            while (n3 < n) {
                _infoNews.addElement(dataInputStream.readUTF());
                ++n3;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void update() {
        if (!this._isSubPage) {
            this.updateMenu();
        } else {
            this.updateSubMenu();
        }
    }

    private void updateMenu() {
        if (GameMainLogic.isPressCancelKey()) {
            PzgScene.getInstance().changeToWorld();
        } else if (GameMainLogic.isPressConfirmKey()) {
            this.menuConfirm();
        }
        int n = GameMainLogic.getCurKey();
        switch (n) {
            case 8: {
                ++this._curItemIndex;
                int n2 = SmsUi._isBuy[1] == 0 ? 1 : 0;
                if (this._curItemIndex <= MENU_ITEM.length - 1) break;
                this._curItemIndex = n2;
                break;
            }
            case 4: {
                int n3 = SmsUi._isBuy[1] == 0 ? 1 : 0;
                --this._curItemIndex;
                if (this._curItemIndex >= n3) break;
                this._curItemIndex = MENU_ITEM.length - 1;
            }
        }
        GameMainLogic.resetCurKey();
    }

    private void updateSubMenu() {
        if (GameMainLogic.isPressCancelKey()) {
            this._isSubPage = false;
            this._isDrawReturnMenu = false;
            GameMainLogic.resetCurKey();
        } else if (GameMainLogic.isPressConfirmKey()) {
            GameMainLogic.resetCurKey();
            if (this._curItemIndex == 4) {
                if (!PzgScene.getInstance().isCanSaveScene()) {
                    this._messageBox = GameMessageBox.getInstance(this);
                    this._messageBox.initSinglePageStyle(0, 0, "\u52a8\u4f5c\u5173\uff0c\u4e0d\u80fd\u5b58\u6863", 0);
                    return;
                }
                this._gameMenu = GameMenu.getInstance(this);
                if (GameRms.isExistRecord(this._interfaceInstance.getCurRmsIndex())) {
                    this._gameMenu.initChooseStyle("\u662f\u5426\u8986\u76d6\u5b58\u6863\uff1f", new String[]{"\u662f", "\u5426"});
                } else {
                    this._gameMenu.initChooseStyle("\u662f\u5426\u5b58\u6863\uff1f", new String[]{"\u662f", "\u5426"});
                }
            }
        }
        int n = GameMainLogic.getCurKey();
        switch (n) {
            case 8: {
                if (this._curItemIndex != 4) break;
                this._interfaceInstance.nextRmsIndex();
                break;
            }
            case 4: {
                if (this._curItemIndex != 4) break;
                this._interfaceInstance.preRmsIndex();
                break;
            }
            case 1: {
                if (this._curItemIndex != 2) break;
                this._interfaceInstance.keyForSound();
                break;
            }
            case 2: {
                if (this._curItemIndex != 2) break;
                this._interfaceInstance.keyForSound();
            }
        }
        GameMainLogic.resetCurKey();
    }

    public void draw(Graphics graphics) {
        GameFunction.initAlphaArray(14141108, 80, 1);
        GameFunction.drawAlpha1(graphics, 22, 25, 196, 270);
        graphics.setClip(20, 23, 200, 280);
        graphics.setColor(5127214);
        graphics.drawRoundRect(20, 23, 199, 273, 10, 10);
        graphics.drawRoundRect(21, 24, 197, 271, 10, 10);
        if (!this._isSubPage) {
            this.drawInMenu(graphics);
        } else {
            this.drawSubMenu(graphics);
        }
        if (this._isDrawReturnMenu) {
            UIHandler.drawReturnMenu(graphics);
        } else {
            UIHandler.drawMenu(graphics);
        }
    }

    private void drawInMenu(Graphics graphics) {
        int n = 0;
        int n2 = SmsUi._isBuy[1] == 0 ? 1 : 0;
        int n3 = n2;
        while (n3 < MENU_ITEM.length) {
            graphics.setClip(0, 0, 240, 320);
            int n4 = SmsUi._isBuy[1] == 0 ? this._itemStartY + this._itemSpace * (n3 - 1) + 10 : this._itemStartY + this._itemSpace * n3;
            if (this._curItemIndex == n3) {
                GameInterface.C_GAME_PANEL.draw(graphics, this._itemStartX, n4 - 15 - n, 66, 0);
            }
            graphics.setColor(4072721);
            graphics.setClip(0, 0, 240, 320);
            graphics.drawString(MENU_ITEM[n3], 120, n4 - 1, 1 | 0x20);
            ++n3;
        }
        if (this._gameMenu != null) {
            this._gameMenu.draw(graphics);
        }
    }

    private int getPate(String[] stringArray) {
        if (stringArray.length % PER_PAGE_LINES == 0) {
            return stringArray.length / PER_PAGE_LINES;
        }
        return stringArray.length / PER_PAGE_LINES + 1;
    }

    private void drawSubMenu(Graphics graphics) {
        switch (this._curItemIndex) {
            case 2: {
                this._isDrawReturnMenu = true;
                this._interfaceInstance.drawSoundPage(graphics);
                break;
            }
            case 3: {
                this._isDrawReturnMenu = true;
                this._interfaceInstance.gameHelpAbout(graphics);
                break;
            }
            case 4: {
                this._interfaceInstance.gameRmsPage(graphics);
                if (this._messageBox != null) {
                    this._messageBox.draw(graphics);
                }
                if (this._gameMenu == null) break;
                this._gameMenu.draw(graphics);
                break;
            }
            case 5: {
                this.drawGameAllnfo(graphics);
                if (!this._detailState) {
                    graphics.setColor(0);
                    graphics.drawString("\u6863\u6848", 35, this._itemStartY - 20, 20);
                    this.paintStringList(graphics, 60, 106, this._curRecordIndex, PER_PAGE_LINES, this._curRecordIndex, _infoName, 0, 0x828282);
                } else if (this._infoContext != null) {
                    graphics.setColor(0);
                    graphics.drawString((String)_infoName.elementAt(this._curRecordIndex), 35, this._itemStartY - 20, 20);
                    this.paintStringList2(graphics, 30, 106, 0, PER_PAGE_LINES, this._curLine, this._infoContext, 0, 0);
                }
                this.updataAllInfo();
            }
        }
    }

    public void drawGameAllnfo(Graphics graphics) {
        graphics.setColor(6906458);
        graphics.drawLine(30, this._itemStartY, 200, this._itemStartY);
        graphics.drawLine(30, this._itemStartY + 1, 200, this._itemStartY + 1);
        int n = 0;
        int n2 = 0;
        GameInterface.C_GAME_PANEL.draw(graphics, 200, this._itemStartY + 25 + n, 76, 0);
        int n3 = 0;
        while (n3 < (320 - 2 * (this._itemStartY + 2)) / GameInterface.C_GAME_PANEL.getSptHeight(77)) {
            GameInterface.C_GAME_PANEL.draw(graphics, 200, this._itemStartY + 30 + n + GameInterface.C_GAME_PANEL.getSptHeight(77) * n3, 77, 0);
            ++n3;
        }
        GameInterface.C_GAME_PANEL.draw(graphics, 200, 320 - this._itemStartY + 20 + n, 76, 0);
        if (!this._detailState) {
            if (_infoName.size() > 0) {
                GameInterface.C_GAME_PANEL.draw(graphics, 201, this._itemStartY + 35 + n + (170 + n2) / _infoName.size() * this._curRecordIndex, 78, 0);
                GameInterface.C_GAME_PANEL.draw(graphics, 201, this._itemStartY + 38 + n + (170 + n2) / _infoName.size() * this._curRecordIndex, 79, 0);
                GameInterface.C_GAME_PANEL.draw(graphics, 201, this._itemStartY + 33 + n + (170 + n2) / _infoName.size() * this._curRecordIndex, 80, 0);
            }
        } else if (this._infoContext != null) {
            GameInterface.C_GAME_PANEL.draw(graphics, 201, this._itemStartY + 35 + n + 170 / this.getPate(this._infoContext) * this._curPage, 78, 0);
            GameInterface.C_GAME_PANEL.draw(graphics, 201, this._itemStartY + 38 + n + 170 / this.getPate(this._infoContext) * this._curPage, 79, 0);
            GameInterface.C_GAME_PANEL.draw(graphics, 201, this._itemStartY + 33 + n + 170 / this.getPate(this._infoContext) * this._curPage, 80, 0);
        }
    }

    public void updataAllInfo() {
        if (GameMainLogic.isPressConfirmKey() && _infoNews.size() > 0) {
            this._detailState = true;
            this._infoContext = PuzzleFunction.divDialogStr((String)_infoNews.elementAt(this._curRecordIndex), 140);
        }
        if (GameMainLogic.isPressCancelKey()) {
            if (this._detailState) {
                this._detailState = false;
                this._curLine = 0;
                this._curPage = 0;
                GameMainLogic.resetCurKey();
                return;
            }
            this._isSubPage = false;
        }
        int n = GameMainLogic.getCurKey();
        switch (n) {
            case 8: {
                if (!this._detailState) {
                    ++this._curRecordIndex;
                    if (this._curRecordIndex >= _infoName.size()) {
                        this._curRecordIndex = _infoName.size() - 1;
                    }
                    ++this._curRecordIndexFlag;
                    if (this._curRecordIndexFlag < PER_PAGE_LINES) break;
                    this._curRecordIndexFlag = PER_PAGE_LINES - 1;
                    break;
                }
                this._curLine += PER_PAGE_LINES;
                ++this._curPage;
                if (this._curPage >= this.getPate(this._infoContext)) {
                    this._curPage = this.getPate(this._infoContext) - 1;
                }
                if (this._curLine < this._infoContext.length) break;
                this._curLine -= PER_PAGE_LINES;
                break;
            }
            case 4: {
                if (!this._detailState) {
                    if (--this._curRecordIndex <= 0) {
                        this._curRecordIndex = 0;
                    }
                    if (this._curRecordIndex >= PER_PAGE_LINES || --this._curRecordIndexFlag > 0) break;
                    this._curRecordIndexFlag = 0;
                    break;
                }
                --this._curPage;
                if (this._curPage <= 0) {
                    this._curPage = 0;
                }
                this._curLine -= PER_PAGE_LINES;
                if (this._curLine > 0) break;
                this._curLine = 0;
            }
        }
        GameMainLogic.resetCurKey();
    }

    public void reset() {
        GameFunction.initDrawItemsBack();
        this._curItemIndex = SmsUi._isBuy[1] == 0 ? 1 : 0;
        this._isSubPage = false;
        this._interfaceInstance = this._mainLogic._interface;
        this._curRecordIndex = 0;
        this._curRecordIndexFlag = 0;
        this._curLine = 0;
        this._curPage = 1;
    }

    private void menuConfirm() {
        switch (this._curItemIndex) {
            case 0: {
                PzgScene.getInstance().openClueList(4);
                break;
            }
            case 2: {
                this._isSubPage = true;
                this._interfaceInstance.initSoundPage();
                break;
            }
            case 3: {
                this._isSubPage = true;
                this._interfaceInstance.initGameHelp();
                break;
            }
            case 4: {
                this._isSubPage = true;
                this._interfaceInstance.initGameSave();
                break;
            }
            case 5: {
                this._isSubPage = true;
                break;
            }
            case 6: {
                this._gameMenu = GameMenu.getInstance(this);
                this._gameMenu.initChooseStyle("\u662f\u5426\u8fd4\u56de\u4e3b\u83dc\u5355", new String[]{"\u662f", "\u5426"});
                break;
            }
            case 1: {
                PzgScene.getInstance().changeToWorld();
                break;
            }
            case 7: {
                Function._isContinue = true;
                Function.stopSound();
                this._mainLogic.changeToInterface(13);
            }
        }
    }

    public void cancelHandle() {
        this._gameMenu = null;
    }

    public void resultHandle(int n) {
        this._gameMenu = null;
        if (this._curItemIndex == 6) {
            if (n == 0) {
                this._mainLogic.changeToInterface(3);
                Function.stopSound();
                Function.changeSoundState(6, -1);
            }
        } else if (this._curItemIndex == 4 && n == 0) {
            GameRms.saveGame(this._interfaceInstance.getCurRmsIndex());
        }
        GameMainLogic.resetCurKey();
    }

    public void finishHandle() {
        this._messageBox = null;
    }

    static {
        MENU_ITEM = new String[]{"\u77ed\u4fe1\u5546\u57ce", "\u7ee7\u7eed\u6e38\u620f", "\u58f0\u97f3", "\u5e2e\u52a9", "\u5b58\u6863", "\u6863\u6848\u8bb0\u5f55", "\u8fd4\u56de\u4e3b\u83dc\u5355", "\u9000\u51fa\u6e38\u620f"};
        MENU_SPT_ID = new int[]{17, 14, 22, 18, 23, 23};
        _infoName = new Vector();
        _infoNews = new Vector();
        PER_PAGE_LINES = 7;
    }
}

