/*
 * Decompiled with CFR 0.152.
 */
package pzg.extend.game;

import javax.microedition.lcdui.Graphics;
import module.ekernel.animation.Animation;
import pzg.extend.game.Police;
import pzg.extend.game.PzgScene;
import pzg.extend.gameUtil.GameMessageBox;
import rpg.basic.actor.Actor;
import rpg.basic.gameUtil.Function;
import rpg.basic.scene.UnitData;

public class NpcActor
extends Actor {
    private int _state;
    private int _keepCounter;
    private int _preAction;
    protected UnitData _data;
    private static final int[] C_RANDOM_WAIT_DIR = new int[]{1, -2147483647, 0, 2};
    GameMessageBox _messageBox;
    private static Animation EXPRESS_ANI;
    protected int _expressAction;
    private int _fram;
    private boolean _isOpenExpress;

    public NpcActor(int n, Animation animation) {
        super(n, animation);
    }

    public boolean init(UnitData unitData) {
        this._data = unitData;
        boolean bl = super.init(unitData);
        byte[] byArray = unitData.getParameter();
        if (byArray != null && byArray[5] == 1) {
            this.setSkin(1);
        }
        return bl;
    }

    public void init(int n, int n2, int n3) {
        super.init(n, n2, n3);
        this.changeWait();
    }

    private final void changeWait() {
        if (this.isMovable()) {
            this._state = 1;
            this.updateKeepTime();
        } else {
            this._state = 0;
        }
    }

    public void changeToWait(int n) {
        this._vx = 0;
        this._vy = 0;
        this.changeAction(n);
    }

    private final boolean isMovable() {
        return this._data != null && this._data.getParameter() != null;
    }

    private final void updateKeepTime() {
        this._keepCounter = Function.Random(20, true) + 20;
    }

    public void disActive() {
        this._data = null;
        super.disActive();
    }

    public boolean isCurActionEnd() {
        if (this._curAction == 2 && this._curFrame == this._actFrmNum - 1) {
            this.changeAction(3);
            return true;
        }
        return false;
    }

    public void ai() {
        if (this.isArrive()) {
            this._vy = 0;
            this._vx = 0;
        }
        if (!this.isExecuteAI()) {
            return;
        }
        switch (this._state) {
            case 0: {
                this.updateForAlwayWait();
                break;
            }
            case 1: {
                this.updateForWait();
                break;
            }
            case 2: {
                this.updateForNpcDialog();
                break;
            }
            case 3: {
                this.updataForScript();
            }
        }
    }

    public void updateForWait() {
        if (this.scriptHandle()) {
            this.changeScript();
            return;
        }
    }

    public void updateForNpcDialog() {
        if (this.scriptHandle()) {
            PzgScene.getInstance()._analyzePuzzle.setDialogInex(this._type, 0);
            return;
        }
    }

    public final void updateForAlwayWait() {
        if (PzgScene.getInstance()._messageBox == null && this.scriptHandle()) {
            UnitData unitData = PzgScene.getInstance().getUnitData(this._id);
            byte[] byArray = unitData.getParameter();
            if (byArray[0] == 1) {
                PzgScene.getInstance()._analyzePuzzle.setDialogInex(byArray[1], 0);
            } else {
                PzgScene.getInstance().captorToDialog(byArray);
            }
        }
    }

    public final void updataForScript() {
    }

    public final void changeScript() {
        this._preAction = this._curAction;
        this.faceToMain();
        this._state = 3;
    }

    protected void changeToWalk(int n) {
        if (this.getPath() != null) {
            switch (n) {
                case 4: {
                    this._vx = 6144;
                    this._vy = 0;
                    break;
                }
                case -2147483644: {
                    this._vx = -6144;
                    this._vy = 0;
                    break;
                }
                case 3: {
                    this._vx = 0;
                    this._vy = 6144;
                    break;
                }
                case 5: {
                    this._vx = 0;
                    this._vy = -6144;
                }
            }
        }
        if (this._curAction == n) {
            return;
        }
        this.changeAction(n);
    }

    public void changeToWait() {
        this._vy = 0;
        this._vx = 0;
        switch (this._curAction) {
            case 4: {
                this.changeAction(1);
                break;
            }
            case -2147483644: {
                this.changeAction(-2147483647);
                break;
            }
            case 3: {
                this.changeAction(0);
                break;
            }
            case 5: {
                this.changeAction(2);
            }
        }
    }

    public void disLife() {
        this._data = null;
        super.disLife();
    }

    protected boolean scriptHandle() {
        return this.isMatchTriggerCondition();
    }

    protected boolean isMatchTriggerCondition() {
        if (this._data == null) {
            return false;
        }
        int n = this._data.GetTriggerKind();
        switch (n) {
            case 0: {
                return false;
            }
            case 1: {
                return this.isPressConfirmKey() && this.isCollideMain() && !Police._isChase;
            }
            case 2: {
                return this.isCollideMain();
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        super.draw(graphics, n, n2, n3, n4);
        this.drawExpress(graphics);
        if (this._messageBox != null) {
            this._messageBox.draw(graphics);
        }
    }

    public void faceToMain() {
    }

    public NpcActor() {
    }

    public int getPriority() {
        if (this._type == 82 || this._type == 44) {
            return 0;
        }
        if (this._type == 33 && ((this._curAction & Integer.MIN_VALUE) != 0 || this._curAction == 2)) {
            return 3;
        }
        if (this._type == 34 || this._type == 4) {
            return 3;
        }
        return 1;
    }

    public void initExpress() {
        if (EXPRESS_ANI == null) {
            EXPRESS_ANI = Animation.load("/res/ani.bin", 79, 1);
        }
        this._expressAction = 0;
        this._fram = 0;
        this._isOpenExpress = true;
    }

    public void setOpenExpress(int n) {
        this.initExpress();
        this._expressAction = n;
    }

    public void closeExpress() {
        this._isOpenExpress = false;
    }

    public void drawExpress(Graphics graphics) {
        if (this._isOpenExpress) {
            int n = this._x - PzgScene.getInstance()._camx >> 10;
            int n2 = this._y - PzgScene.getInstance()._camy >> 10;
            EXPRESS_ANI.draw(graphics, n + 5, n2 + this._vt, this._expressAction, this._fram, 0);
            ++this._fram;
            if (this._fram > EXPRESS_ANI.getActFrmNum(this._expressAction) - 1) {
                this._fram = 0;
            }
        }
    }
}

