/*
 * Decompiled with CFR 0.152.
 */
package module.ekernel.map.mutilayers;

import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import module.ekernel.map.mutilayers.BaseLayer;
import module.ekernel.map.mutilayers.Map;

public class UnitsLayer
extends BaseLayer {
    private short[] _uid;
    private short[] _x;
    private short[] _y;
    private short[][] _sector;
    private int _dynamicDrawNum;
    private int _staticDrawNum;
    private short[][] _dynamicDrawUnits;
    private short[][] _staticDrawUnits;

    public UnitsLayer(Map map) {
        super(map);
        this.initDynamicDraws();
        this.initStaticDraws();
    }

    public void dispose() {
        this._uid = null;
        this._x = null;
        this._y = null;
        int n = 0;
        while (n < this._map.getMapHeight() / this._map._ch) {
            this._sector[n] = null;
            ++n;
        }
        this._sector = null;
        this._dynamicDrawUnits = null;
        this._staticDrawUnits = null;
    }

    public void drawToBuffer(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        n3 += Map._bktw;
        n4 += Map._bkth;
        int n7 = this._map.getMapWidth();
        int n8 = this._map.getMapHeight();
        int n9 = this._map._cw;
        int n10 = this._map._ch;
        int n11 = n7 / n9;
        int n12 = n2 / n10;
        int n13 = n / n9;
        if (n12 > 0 && n2 + n10 > n8) {
            --n12;
        }
        if (n13 > 0 && n + n9 > n7) {
            --n13;
        }
        short[] sArray = this._sector[n12 * n11 + n13];
        int n14 = sArray.length;
        int n15 = 0;
        while (n15 < n14) {
            short s = sArray[n15];
            short s2 = this._uid[s];
            short s3 = this._x[s];
            short s4 = this._y[s];
            Image image = this._map._pattern[s2 & 0xFFF]._img;
            int n16 = this._x[s] + image.getWidth();
            int n17 = this._y[s] + image.getHeight();
            if (n16 > n && s3 < n3 && n17 > n2 && s4 < n4) {
                this.drawUnitToBuffer(graphics, n, n2, n3, n4, n5, n6, s);
            }
            ++n15;
        }
    }

    public void drawShelter(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.findShelterUnits(n, n2, n3, n4, n5, n6, n7, n8);
        this.drawShelterUnits(graphics, n, n2, this._dynamicDrawNum, this._dynamicDrawUnits);
    }

    public void lastDrawShelter(Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawShelterUnits(graphics, n, n2, this._staticDrawNum, this._staticDrawUnits);
    }

    protected void initLastDrawShelter() {
        this.initStaticDraws();
    }

    private void findShelterUnits(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.initDynamicDraws();
        int n9 = this._map.getMapWidth();
        int n10 = this._map.getMapHeight();
        int n11 = n9 / n3;
        int n12 = n2 / n4;
        int n13 = n / n3;
        if (n12 > 0 && n2 + n4 > n10) {
            --n12;
        }
        if (n13 > 0 && n + n3 > n9) {
            --n13;
        }
        short[] sArray = this._sector[n12 * n11 + n13];
        int n14 = sArray.length;
        int n15 = 0;
        while (n15 < n14) {
            short s = sArray[n15];
            int n16 = this._uid[s] & 0xFFF;
            if (this._map._pattern[n16]._shelter != 0) {
                Image image = this._map._pattern[n16]._img;
                short s2 = this._x[s];
                short s3 = this._y[s];
                int n17 = this._x[s] + image.getWidth();
                int n18 = this._y[s] + image.getHeight();
                if (n17 > n && s2 < n + n3 && n18 > n2 && s3 < n2 + n4 && n17 > n5 && s2 < n7 && n18 > n6 && s3 < n8) {
                    if (this._map._pattern[n16]._shelter == 2) {
                        this.addToStaticDraws(s, n15);
                    } else if (s3 + this._map._pattern[n16]._oy > n8) {
                        this.addToDynamicDraws(s, n15);
                    }
                }
            }
            ++n15;
        }
        if (this._dynamicDrawNum > 0) {
            this.finder(sArray, 0, n, n2, n3, n4);
            this.sortDrawUnits(this._dynamicDrawNum, this._dynamicDrawUnits);
            this.sortDrawUnits(this._staticDrawNum, this._staticDrawUnits);
        }
    }

    private void finder(short[] sArray, int n, int n2, int n3, int n4, int n5) {
        short s = this._dynamicDrawUnits[n][0];
        short s2 = this._uid[s];
        Image image = this._map._pattern[s2 & 0xFFF]._img;
        short s3 = this._x[s];
        short s4 = this._y[s];
        int n6 = this._x[s] + image.getWidth();
        int n7 = this._y[s] + image.getHeight();
        int n8 = this._dynamicDrawUnits[n][1] + 1;
        while (n8 < sArray.length) {
            s = sArray[n8];
            s2 = this._uid[s];
            image = this._map._pattern[s2 & 0xFFF]._img;
            short s5 = this._x[s];
            short s6 = this._y[s];
            int n9 = this._x[s] + image.getWidth();
            int n10 = this._y[s] + image.getHeight();
            if (this._map._pattern[s2 & 0xFFF]._shelter != 0 && n9 > n2 && s5 < n2 + n4 && n10 > n3 && s6 < n3 + n5 && n9 > s3 && s5 < n6 && n10 > s4 && s6 < n7) {
                if (this._map._pattern[s2 & 0xFFF]._shelter == 2) {
                    this.addToStaticDraws(s, n8);
                } else {
                    this.addToDynamicDraws(s, n8);
                }
            }
            ++n8;
        }
        if (n + 1 < this._dynamicDrawNum) {
            this.finder(sArray, n + 1, n2, n3, n4, n5);
        }
    }

    private void drawShelterUnits(Graphics graphics, int n, int n2, int n3, short[][] sArray) {
        int n4 = 0;
        while (n4 < n3) {
            short s = sArray[n4][0];
            short s2 = this._uid[s];
            Image image = this._map._pattern[s2 & 0xFFF]._img;
            short s3 = this._x[s];
            short s4 = this._y[s];
            int n5 = image.getWidth();
            int n6 = image.getHeight();
            int n7 = s2 & 0xF000;
            this.copyFromUnitImg(graphics, 0, 0, n5, n6, s3 - n, s4 - n2, image, n7);
            ++n4;
        }
    }

    private void sortDrawUnits(int n, short[][] sArray) {
        int n2 = 0;
        while (n2 < n - 1) {
            int n3 = n2;
            int n4 = n2 + 1;
            while (n4 < n) {
                if (sArray[n4][0] < sArray[n3][0]) {
                    n3 = n4;
                }
                ++n4;
            }
            if (n2 != n3) {
                short s = sArray[n2][0];
                sArray[n2][0] = sArray[n3][0];
                sArray[n3][0] = s;
            }
            ++n2;
        }
    }

    private void initDynamicDraws() {
        if (this._dynamicDrawUnits == null) {
            this._dynamicDrawUnits = new short[100][2];
        }
        this._dynamicDrawNum = 0;
    }

    private void initStaticDraws() {
        if (this._staticDrawUnits == null) {
            this._staticDrawUnits = new short[100][2];
        }
        this._staticDrawNum = 0;
    }

    private void addToDynamicDraws(int n, int n2) {
        int n3 = 0;
        while (n3 < this._dynamicDrawNum) {
            if (this._dynamicDrawUnits[n3][0] == n) {
                return;
            }
            ++n3;
        }
        this._dynamicDrawUnits[this._dynamicDrawNum][0] = (short)n;
        this._dynamicDrawUnits[this._dynamicDrawNum][1] = (short)n2;
        ++this._dynamicDrawNum;
    }

    private void addToStaticDraws(int n, int n2) {
        int n3 = 0;
        while (n3 < this._staticDrawNum) {
            if (this._staticDrawUnits[n3][0] == n) {
                return;
            }
            ++n3;
        }
        this._staticDrawUnits[this._staticDrawNum][0] = (short)n;
        this._staticDrawUnits[this._staticDrawNum][1] = (short)n2;
        ++this._staticDrawNum;
    }

    public void loadData(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readShort();
        this._uid = new short[n];
        this._x = new short[n];
        this._y = new short[n];
        int n2 = 0;
        while (n2 < n) {
            this._uid[n2] = dataInputStream.readShort();
            this._x[n2] = dataInputStream.readShort();
            this._y[n2] = dataInputStream.readShort();
            ++n2;
        }
        this.calcuFastSector();
    }

    public int getPhyBlock(int n, int n2) {
        return -1;
    }

    private final void drawUnitToBuffer(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        short s = this._uid[n7];
        int n8 = s & 0xF000;
        Image image = this._map._pattern[s & 0xFFF]._img;
        int n9 = this._x[n7];
        int n10 = this._y[n7];
        int n11 = this._x[n7] + image.getWidth();
        int n12 = this._y[n7] + image.getHeight();
        int n13 = n9 < n ? n : n9;
        int n14 = n10 < n2 ? n2 : n10;
        int n15 = n11 > n3 ? n3 : n11;
        int n16 = n12 > n4 ? n4 : n12;
        int n17 = n15 - n13;
        int n18 = n16 - n14;
        int n19 = n13 - n9;
        int n20 = n14 - n10;
        int n21 = n13 % n5;
        int n22 = n14 % n6;
        int n23 = n15 % n5;
        int n24 = n16 % n6;
        if (n23 > n21) {
            if (n24 > n22) {
                this.copyFromUnitImg(graphics, n19, n20, n17, n18, n21, n22, image, n8);
            } else {
                this.copyFromUnitImg(graphics, n19, n20, n17, n18 - n24, n21, n22, image, n8);
                this.copyFromUnitImg(graphics, n19, n20 + n18 - n24, n17, n24, n21, 0, image, n8);
            }
        } else if (n24 > n22) {
            this.copyFromUnitImg(graphics, n19, n20, n17 - n23, n18, n21, n22, image, n8);
            this.copyFromUnitImg(graphics, n19 + n17 - n23, n20, n23, n18, 0, n22, image, n8);
        } else {
            this.copyFromUnitImg(graphics, n19, n20, n17 - n23, n18 - n24, n21, n22, image, n8);
            this.copyFromUnitImg(graphics, n19, n20 + n18 - n24, n17 - n23, n24, n21, 0, image, n8);
            this.copyFromUnitImg(graphics, n19 + n17 - n23, n20, n23, n18 - n24, 0, n22, image, n8);
            this.copyFromUnitImg(graphics, n19 + n17 - n23, n20 + n18 - n24, n23, n24, 0, 0, image, n8);
        }
    }

    private final void copyFromUnitImg(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, Image image, int n7) {
        int n8 = 0;
        int n9 = n;
        int n10 = n2;
        int n11 = image.getWidth();
        int n12 = image.getHeight();
        if ((n7 & 0x1000) != 0 && (n7 & 0x2000) != 0) {
            n8 = 3;
            n9 = n11 - n - n3;
            n10 = n12 - n2 - n4;
        } else if ((n7 & 0x1000) != 0) {
            n8 = 2;
            n9 = n11 - n - n3;
        } else if ((n7 & 0x2000) != 0) {
            n8 = 1;
            n10 = n12 - n2 - n4;
        }
        graphics.drawRegion(image, n9, n10, n3, n4, n8, n5, n6, 4 | 0x10);
    }

    private final void calcuFastSector() {
        int n = this._map.getMapWidth();
        int n2 = this._map.getMapHeight();
        int n3 = this._map._cw;
        int n4 = this._map._ch;
        int n5 = n / n3;
        int n6 = n2 / n4;
        this._sector = new short[n5 * n6][];
        short[] sArray = new short[this._uid.length];
        int n7 = 0;
        while (n7 < n6) {
            int n8 = 0;
            while (n8 < n5) {
                int n9 = n8 * n3;
                int n10 = n7 * n4;
                int n11 = (n8 + 2) * n3;
                int n12 = (n7 + 2) * n4;
                int n13 = 0;
                int n14 = this._uid.length;
                int n15 = 0;
                while (n15 < n14) {
                    short s = this._uid[n15];
                    Image image = this._map._pattern[s & 0xFFF]._img;
                    short s2 = this._x[n15];
                    short s3 = this._y[n15];
                    int n16 = this._x[n15] + image.getWidth();
                    int n17 = this._y[n15] + image.getHeight();
                    if (n16 >= n9 && s2 <= n11 && n17 >= n10 && s3 <= n12) {
                        sArray[n13++] = (short)n15;
                    }
                    ++n15;
                }
                this._sector[n7 * n5 + n8] = new short[n13];
                System.arraycopy(sArray, 0, this._sector[n7 * n5 + n8], 0, n13);
                ++n8;
            }
            ++n7;
        }
    }
}

