/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class GameMap {
    static final int TILE_PASS = 0;
    static int SCREEN_WIDTH;
    static int SCREEN_HEIGHT;
    static byte tileWidth;
    static byte tileHight;
    static int[] mapSize;
    short[] tileProperties;
    String[] name;
    static int setOffX;
    static int setOffY;
    int roleY;
    short roleX;
    short dogY;
    short dogX;
    int[][] fgX;
    byte curBine;
    byte[] mapData;
    byte gameRank;
    short[][] singleData;
    GameEngine engine;
    short[][] trapData;
    public static final byte TRAP_x = 0;
    public static final byte TRAP_y = 1;
    public static final byte TRAP_type = 2;
    public static final byte TRAP_curStatus = 3;
    public static final byte TRAP_index = 4;
    public static final byte TRAP_temp = 5;
    int blockSpeedX = 0;
    int blockSpeedY = 0;
    byte blockNo = 0;
    static int startPos;
    static byte shakeTime;
    int startX = 240;
    int posX = 45;
    int posY;
    public static final byte SCEEN_MOVE = 10;
    boolean isStop;
    boolean isStop_2;
    int mapW;
    boolean isGoOn = true;

    public void free() {
        this.trapData = null;
        this.mapData = null;
        this.singleData = null;
        System.gc();
    }

    public GameMap(int sw, int sh, GameEngine ge) {
        SCREEN_WIDTH = sw;
        SCREEN_HEIGHT = sh;
        GameMap.setOff(0, 0);
        this.engine = ge;
    }

    public static void setOff(int x, int y) {
        setOffX = x;
        setOffY = y;
    }

    public void init(int GameRank) {
        this.gameRank = (byte)GameRank;
        this.free();
        this.isStop = false;
        this.isStop_2 = false;
        switch (this.gameRank) {
            case 0: {
                this.fgX = new int[][]{{75, setOffY + 30, 6, 1, 5}, {250, setOffY + 50, 7, 1, 5}, {130, setOffY + 72, 7, 2, 5}, {130, setOffY + SCREEN_HEIGHT - 25, 9, 2, 100}};
                this.singleData = new short[][]{{-35, 220, 85, 0, 99}, {399, 167, 86, 0, 4}};
                break;
            }
            case 1: {
                this.fgX = new int[][]{{75, setOffY + 30, 6, 1, 5}, {250, setOffY + 50, 7, 1, 5}, {130, setOffY + 72, 7, 2, 5}};
                this.singleData = new short[][]{{40, 170, 85, 0, 5}, {80, 170, 86, 0, 4}, {115, 167, 28, 0, 5}, {274, 167, 28, 0, 5}, {266, 167, 88, 0, 99}, {343, 126, 28, 1, 5}, {411, 95, 89, 1, 99}, {580, 119, 86, 0, 4}, {543, 119, 28, 1, 5}, {683, 95, 85, 0, 5}, {662, 95, 88, 0, 5}, {750, 95, 85, 0, 99}, {725, 95, 28, 0, 5}, {816, 143, 28, 0, 5}, {850, 143, 86, 0, 4}, {989, 119, 28, 0, 99}, {1086, 95, 86, 0, 4}, {1225, 119, 85, 0, 4}, {1253, 119, 28, 0, 99}, {1260, 119, 85, 0, 5}, {1386, 143, 28, 0, 5}, {1735, 167, 85, 0, 5}};
                break;
            }
            case 11: {
                this.fgX = new int[][]{{75, setOffY + 30, 6, 1, 5}, {250, setOffY + 50, 7, 1, 5}, {130, setOffY + 72, 7, 2, 5}};
                this.singleData = new short[][]{{49, 167, 85, 0, 5}, {77, 167, 28, 0, 5}, {147, 119, 87, 0, 5}, {196, 119, 85, 0, 99}, {215, 119, 28, 0, 5}, {328, 167, 86, 0, 4}, {517, 167, 28, 0, 5}, {755, 119, 89, 0, 5}, {800, 119, 89, 0, 99}, {935, 71, 86, 0, 4}, {963, 71, 28, 0, 5}, {990, 71, 28, 0, 5}, {1138, 143, 88, 0, 5}, {1292, 143, 88, 0, 99}, {1335, 143, 89, 0, 5}, {1520, 167, 85, 0, 5}, {1731, 167, 86, 0, 4}};
            }
        }
        String mapname = "map" + this.gameRank + ".dat";
        this.loadMap(mapname);
        Tools.createImage(this.name, 1);
        setOffX = GameEngine.role.x - this.posX;
        setOffX = (short)Math.max(setOffX, 0);
        setOffX = (short)Math.min(setOffX, mapSize[0] * tileWidth - SCREEN_WIDTH);
        setOffY = mapSize[1] * 24 - 320;
        if (GameEngine.gameRank == 13) {
            setOffY = 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void drawTrap(short[][] array) {
        if (array == null) {
            return;
        }
        short[][] imgData = null;
        Object data = null;
        byte[] motion = null;
        Object adjustX = null;
        byte[] adjustY = null;
        int w = 0;
        int h = 0;
        int i = 0;
        while (i < array.length) {
            switch (array[i][2]) {
                case 4: {
                    switch (array[i][3]) {
                        case 0: {
                            imgData = new short[][]{{0, 0, 33, 39}, {33, 0, 36, 39}, {69, 0, 35, 39}, {104, 0, 33, 39}, {137, 1, 28, 16}};
                            motion = new byte[]{0, 1, 2};
                            Tools.addObject(27, (int)array[i][0], (int)array[i][1], imgData[array[i][4] % 3], 36, (byte)0, 20);
                            short[] sArray = array[i];
                            sArray[4] = (short)(sArray[4] + 1);
                            break;
                        }
                        case 1: {
                            motion = new byte[]{3, 0};
                            Tools.addObject(27, (int)array[i][0], (int)array[i][1], (short[])imgData[array[i][4] % 2], 36, (byte)0, 20);
                            short[] sArray = array[i];
                            sArray[4] = (short)(sArray[4] + 1);
                            short[] sArray2 = array[i];
                            sArray2[4] = (short)(sArray2[4] + 1);
                            if (sArray2[4] != motion.length) break;
                            short[] sArray3 = array[i];
                            sArray3[5] = (short)(sArray3[5] - 1);
                            if (array[i][5] <= 0) {
                                array[i][3] = 2;
                                break;
                            }
                            array[i][3] = 0;
                            break;
                        }
                        case 2: {
                            adjustY = new byte[]{-20, -30, 40, 40, 40, 40, 40, 40};
                            short[] sArray = array[i];
                            sArray[1] = (short)(sArray[1] + adjustY[array[i][4] % 6]);
                            Tools.addObject(27, (int)array[i][0], (int)array[i][1], (short[])imgData[4], 36, (byte)0, 20);
                            short[] sArray4 = array[i];
                            sArray4[4] = (short)(sArray4[4] + 1);
                            if (sArray4[4] != adjustY.length) break;
                            array[i][3] = 3;
                        }
                    }
                    break;
                }
            }
            if (this.trapData[i][3] > 0 && array[i][2] < 2) {
                if (Tools.hit(GameEngine.role.x, GameEngine.role.y, GameEngine.role.w, GameEngine.role.h / 2, this.trapData[i][0], this.trapData[i][1], w, h)) {
                    GameEngine.role.InjureRole(50, 20);
                }
            }
            ++i;
        }
    }

    public void moveTrap(short[][] array) {
        if (array == null) {
            return;
        }
    }

    public void checkTrap(short[][] array) {
    }

    public boolean onBlock(short[][] array) {
        if (array == null) {
            return false;
        }
        int i = 0;
        while (i < array.length) {
            if (Tools.hit(GameEngine.role.x, GameEngine.role.y, GameEngine.role.w, 10, array[i][0], array[i][1], 60, 17)) {
                this.roleY = (short)(array[i][1] - 14);
                this.blockNo = (byte)i;
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void drawFullScreenBG3(int imgIndex, int y, int speed, int level) {
        Image img = Tools.getImage(imgIndex);
        int imgW = img.getWidth();
        int imgH = img.getHeight();
        if ((startPos -= speed) <= -imgW) {
            startPos += imgW;
        }
        int i = 0;
        while (i < 5) {
            Tools.addObject(imgIndex, startPos + i * imgW + setOffX, y, 36, (byte)0, level);
            ++i;
        }
    }

    public void setTile() {
        int n = setOffX / tileWidth * mapSize[1] + setOffY / tileHight;
        int nw = SCREEN_WIDTH / tileWidth + 2;
        int nh = SCREEN_HEIGHT / tileHight + 2;
        int j = 0;
        while (j < nw) {
            int s;
            int i = s = n + j * mapSize[1];
            while (i < s + nh) {
                if (i < this.mapData.length && i >= 0 && this.mapData[i] != -1) {
                    int dataTemp = GameMap.getLow(this.mapData[i]);
                    int x = i / mapSize[1] * tileHight;
                    int y = i % mapSize[1] * tileWidth;
                    byte trans = 0;
                    switch (GameMap.getTrans(this.mapData[i])) {
                        case 0: {
                            trans = 0;
                            break;
                        }
                        case 1: {
                            trans = 1;
                            break;
                        }
                        case 2: {
                            trans = 2;
                            break;
                        }
                        case 3: {
                            trans = 3;
                        }
                    }
                    int layer = 10;
                    Tools.addObject(150 + dataTemp, x, y, 0, 0, tileWidth, tileHight, 20, trans, layer);
                }
                ++i;
            }
            ++j;
        }
    }

    public void setMap(Graphics g) {
        block6: {
            block5: {
                block4: {
                    if (this.mapData != null) {
                        this.setTile();
                    }
                    this.setMapFG(g);
                    if (GameEngine.gameRank >= 6) break block4;
                    if (GameEngine.gameRank < 10) break block5;
                }
                if (GameEngine.gameRank / 10 >= 6) break block6;
                if (GameEngine.gameRank <= 10) break block6;
            }
            this.drawFG();
        }
        this.drawTrap(this.trapData);
        this.drawSingThings(this.singleData);
    }

    public void drawFG() {
        if (this.fgX == null) {
            return;
        }
        int i = 0;
        while (i < this.fgX.length) {
            int[] nArray = this.fgX[i];
            nArray[0] = nArray[0] - this.fgX[i][3];
            if (this.fgX[i][0] < setOffX - SCREEN_WIDTH * 2) {
                this.fgX[i][0] = setOffX + SCREEN_WIDTH * 2;
            }
            Tools.addObject((byte)this.fgX[i][2], this.fgX[i][0], this.fgX[i][1], 36, (byte)0, this.fgX[i][4]);
            ++i;
        }
    }

    public void setMapFG(Graphics g) {
        g.setColor(0);
        g.fillRect(setOffX, setOffY, 240, 220);
        switch (this.gameRank) {
            case 0: {
                GameMap.drawFullScreenBG(0, setOffY, 10, 5, true);
                GameMap.drawFullScreenBG(8, setOffY + SCREEN_HEIGHT - Tools.getImage(8).getHeight(), 10, 5, true);
                Tools.addObject(92, 7, 224, 36, (byte)0, 5);
                Tools.addObject(92, 115, 224, 36, (byte)0, 5);
                Tools.addObject(16, 38, 224, 36, (byte)1, 5);
                Tools.addObject(16, 84, 224, 36, (byte)0, 5);
                Tools.addObject(17, 72, 279, 36, (byte)0, 5);
                break;
            }
            case 2: {
                GameMap.drawFullScreenBG(0, setOffY, 10, 5, true);
                Tools.addObject(74, 81, 172, 36, (byte)0, 5);
                Tools.addObject(64, 150, 172, 36, (byte)0, 5);
                Tools.addObject(60, 100, 172, 36, (byte)0, 5);
                Tools.addObject(84, 759, 172, 36, (byte)0, 5);
                Tools.addObject(39, 353, 100, 36, (byte)0, 5);
                Tools.addObject(39, 598, 100, 36, (byte)0, 5);
                Tools.addObject(64, 870, 172, 36, (byte)0, 5);
                Tools.addObject(60, 997, 167, 36, (byte)0, 5);
                break;
            }
            case 1: 
            case 11: {
                GameMap.drawFullScreenBG(1, setOffY, 10, 5, true);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 61: 
            case 71: 
            case 81: {
                GameMap.drawFullScreenBG(2, setOffY, 10, 5, true);
                break;
            }
            case 3: 
            case 31: {
                Tools.addObject(3, setOffX, setOffY, 20, (byte)0, 5);
                GameMap.drawFullScreenBG(5, setOffY + SCREEN_HEIGHT - 140, 10, 6, true);
                break;
            }
            case 4: 
            case 5: 
            case 51: {
                Tools.addObject(4, setOffX, setOffY, 20, (byte)0, 5);
            }
        }
    }

    public void drawSingThings(short[][] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        while (i < array.length) {
            Tools.addObject(array[i][2], array[i][0], array[i][1] + 3, 36, (byte)array[i][3], array[i][4]);
            ++i;
        }
    }

    public void screenShake() {
        if (shakeTime > 0) {
            shakeTime = (byte)(shakeTime - 1);
            setOffY = GameEngine.time % 2 == 0 ? (short)(setOffY + 2) : (short)(setOffY - 2);
        }
        setOffY = (short)Math.max(setOffY, 0);
        setOffY = (short)Math.min(setOffY, mapSize[1] * tileHight - SCREEN_HEIGHT);
    }

    public void drawSingleThing(byte imdIndex, int y, int speed) {
        if (GameEngine.time % 200 == 0) {
            if (GameEngine.time >= 20) {
                this.startX = 240 + setOffX;
            }
        }
        this.startX += speed;
        Tools.addObject(imdIndex, this.startX, y, 36, (byte)0, 25);
    }

    public boolean onBlock(int x, int y) {
        if (this.trapData == null) {
            return false;
        }
        return false;
    }

    public void initY() {
        setOffY = mapSize[1] * 24 - 320;
    }

    public void initSetOff(GameRole role, int x, int y, boolean isLeft) {
        this.posX = 45;
        this.posY = 150;
        setOffX = isLeft ? x - (SCREEN_WIDTH - this.posX) : x - this.posX;
        setOffX = (short)Math.max(setOffX, 0);
        setOffX = (short)Math.min(setOffX, mapSize[0] * tileWidth - SCREEN_WIDTH);
        setOffY = (short)(y - this.posY);
    }

    public void checkStop() {
        if (!this.isStop_2 && setOffX > mapSize[0] * 24 - 300) {
            this.isStop = true;
            this.isStop_2 = true;
            this.mapW = mapSize[0] * 24 - 300;
        }
    }

    public void AdjustSrceen(int x, int y, boolean isLeft) {
        if (GameEngine.role.isSky) {
            this.posX = 45;
            this.posY = 120;
            GameMap.setOff(0, 0);
            return;
        }
        this.posX = 90;
        this.posY = 200;
        if (this.engine.isSctrpe) {
            if (GameEngine.gameRank != 6) {
                if (GameEngine.gameRank != 8) {
                    if (GameEngine.role.curStatus != 21) {
                        return;
                    }
                }
            }
        }
        if (isLeft) {
            if (Math.abs(x - (setOffX + SCREEN_WIDTH - this.posX)) <= 10) {
                setOffX = x - (SCREEN_WIDTH - this.posX);
            } else {
                if (x - setOffX < SCREEN_WIDTH - this.posX) {
                    setOffX -= 10;
                }
                if (x - setOffX > SCREEN_WIDTH - this.posX) {
                    setOffX += 10;
                }
            }
        } else if (Math.abs(x - (setOffX + this.posX)) <= 10) {
            setOffX = x - this.posX;
        } else {
            if (x - setOffX > this.posX) {
                setOffX += 10;
            }
            if (x - setOffX < this.posX) {
                setOffX -= 10;
            }
        }
        setOffX = this.isStop ? (int)((short)Math.max(setOffX, this.mapW)) : (int)((short)Math.max(setOffX, 0));
        setOffX = (short)Math.min(setOffX, mapSize[0] * tileWidth - SCREEN_WIDTH);
        if (GameEngine.gameRank > 4) {
            setOffY = Math.abs(y - setOffY - this.posY) > 10 ? (y - setOffY - this.posY >= 10 ? (setOffY += 10) : (setOffY -= 10)) : (int)((short)(y - this.posY));
        }
        setOffY = (short)Math.max(setOffY, 0);
        setOffY = (short)Math.min(setOffY, mapSize[1] * tileHight - SCREEN_HEIGHT);
    }

    public boolean canSlant_RIGHT(int x, int y) {
        if (this.mapData == null || this.inMapData(x, y) == -1) {
            return false;
        }
        return Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y))], (byte)12) && GameMap.getTrans(this.inMapData(x, y)) == 0;
    }

    public boolean canSlant_LEFT(int x, int y) {
        if (this.mapData == null || this.inMapData(x, y) == -1) {
            return false;
        }
        return Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y))], (byte)12) && GameMap.getTrans(this.inMapData(x, y)) == 1;
    }

    public final boolean isLadder(int x, int y) {
        if (this.mapData == null) {
            return false;
        }
        byte v = this.inMapData(x, y);
        if (v == -1) {
            return false;
        }
        return Tools.getProperties(this.tileProperties[GameMap.getLow(v)], (byte)11);
    }

    public boolean canUp(int x, int y) {
        return this.inMapData(x, y) == -1 || Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y))], (byte)13);
    }

    public final boolean canRebound(int x, int y) {
        if (this.inMapData(x, y) == -1) {
            return false;
        }
        if (Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y))], (byte)2)) {
            if (x - x / 24 * 24 > 12 && GameMap.getTrans(this.inMapData(x, y)) == 0) {
                return true;
            }
            if (x - x / 24 * 24 < 12 && GameMap.getTrans(this.inMapData(x, y)) == 1) {
                return true;
            }
        }
        return false;
    }

    public final boolean canFall(int x, int y) {
        if (this.mapData == null) {
            return true;
        }
        return this.inMapData(x, y) == -1 || Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y))], (byte)14);
    }

    public final boolean canClimb(int x, int y) {
        if (this.mapData == null) {
            return false;
        }
        if (this.inMapData(x, y) == -1) {
            return false;
        }
        return Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y))], (byte)3);
    }

    public boolean canRun(int x, int y) {
        if (this.mapData == null) {
            return true;
        }
        return this.inMapData(x, y) == -1 || Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y))], (byte)15);
    }

    public byte inMapData(int x, int y) {
        int tx = x / tileWidth;
        int ty = y / tileHight;
        if (tx < 0 || tx >= mapSize[0] || ty < 0 || ty >= mapSize[1]) {
            return -1;
        }
        int n = tx * mapSize[1] + ty;
        return this.mapData[n];
    }

    public static int getTrans(int v) {
        return v >> 6 & 3;
    }

    public static int get2nd(int v) {
        return v << 1 >> 7 & 1;
    }

    public static int getLow(int v) {
        return v & 0x3F;
    }

    static int bToi(byte byte0) {
        int i = byte0;
        if (byte0 < 0) {
            i += 256;
        }
        return i;
    }

    public static void drawFullScreenBG(int imgIndex, int y, int speed, int level, boolean isTransNone) {
        int imgW = Tools.getImage(imgIndex).getWidth();
        int times = SCREEN_WIDTH / imgW + 2;
        int startPos = setOffX * speed * 10 / 800;
        while (setOffX - startPos >= imgW) {
            startPos += imgW;
        }
        int i = 0;
        while (i < times) {
            Tools.addObject(imgIndex, startPos + i * imgW, y, 20, isTransNone ? (byte)0 : 1, level);
            ++i;
        }
    }

    public void loadMap(String file) {
        this.mapData = null;
        this.tileProperties = null;
        DataInputStream in = new DataInputStream(this.getClass().getResourceAsStream("/dat/" + file));
        try {
            GameMap.mapSize[0] = GameMap.bToi(in.readByte());
            GameMap.mapSize[1] = GameMap.bToi(in.readByte());
            tileWidth = in.readByte();
            tileHight = in.readByte();
            int size = mapSize[0] * mapSize[1];
            this.mapData = new byte[size];
            in.read(this.mapData);
            int len = in.readShort();
            this.name = new String[len];
            this.tileProperties = new short[len];
            int i = 0;
            while (i < len) {
                byte nameLen = in.readByte();
                byte[] names = new byte[nameLen];
                in.read(names);
                this.name[i] = new String(names);
                this.tileProperties[i] = in.readShort();
                ++i;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    static {
        mapSize = new int[2];
        startPos = 0;
        shakeTime = 0;
    }
}

