/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Shape;
import at.emini.physics2D.util.FXVector;
import java.util.Vector;

public class MultiShape
extends Shape {
    protected Shape[] shapes;
    protected int[] vertexStartIndices;
    protected int[] axesStartIndices;

    public MultiShape(Vector vector) {
        this.initShapeMembers(vector);
    }

    protected void initShapeMembers(Vector vector) {
        int n;
        this.shapes = new Shape[vector.size()];
        this.vertexStartIndices = new int[vector.size() + 1];
        this.axesStartIndices = new int[vector.size() + 1];
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < vector.size(); ++n) {
            this.shapes[n] = (Shape)vector.elementAt(n);
            this.vertexStartIndices[n] = n2;
            n2 += this.shapes[n].corners.length;
            n3 += this.shapes[n].f;
        }
        this.vertexStartIndices[vector.size()] = n2;
        this.corners = new FXVector[n2];
        n = 0;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            for (int i = 0; i < this.shapes[n2].corners.length; ++i) {
                this.corners[n++] = this.shapes[n2].corners[i];
            }
        }
        this.updateInternals();
        this.setMassFX(n3);
    }

    public MultiShape(MultiShape multiShape) {
        this.corners = new FXVector[multiShape.corners.length];
        System.arraycopy(multiShape.corners, 0, this.corners, 0, this.corners.length);
        this.shapes = new Shape[multiShape.shapes.length];
        System.arraycopy(multiShape.shapes, 0, this.shapes, 0, this.shapes.length);
        this.vertexStartIndices = new int[multiShape.vertexStartIndices.length];
        System.arraycopy(multiShape.vertexStartIndices, 0, this.vertexStartIndices, 0, this.vertexStartIndices.length);
        this.axesStartIndices = new int[multiShape.axesStartIndices.length];
        System.arraycopy(multiShape.axesStartIndices, 0, this.axesStartIndices, 0, this.axesStartIndices.length);
        this.setElasticityFX(multiShape.elasticityFX);
        this.setFrictionFX(multiShape.frictionFX);
        this.updateInternals();
        this.setMassFX(multiShape.f);
        if (multiShape.userData != null) {
            this.userData = multiShape.userData.copy();
        }
    }

    public Shape getShape(int n) {
        return this.shapes[n];
    }

    public int getShapeCount() {
        return this.shapes.length;
    }

    final void a() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.shapes.length; ++n) {
            n2 += this.shapes[n].b;
        }
        this.b = n2;
        this.a = new int[n2];
        n = 0;
        for (n2 = 0; n2 < this.shapes.length; ++n2) {
            this.axesStartIndices[n2] = n / 2;
            for (int i = 0; i < this.shapes[n2].b; ++i) {
                this.a[n++] = this.vertexStartIndices[n2] + this.shapes[n2].a[i];
            }
        }
        this.axesStartIndices[this.shapes.length] = n / 2;
    }

    final void b() {
        this.e = 0L;
        this.h = 0L;
        for (int i = 0; i < this.shapes.length; ++i) {
            this.e += this.shapes[i].e;
            this.h += this.shapes[i].h;
        }
        if (this.h == 0L) {
            this.i = Integer.MAX_VALUE;
            return;
        }
        this.i = 0x1000000000L / this.h;
    }
}

