/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.screens;

import com.ximad.pvn.audio.SoundSystem;
import com.ximad.pvn.engine.Application;
import com.ximad.pvn.engine.Bitmap;
import com.ximad.pvn.engine.CustomButton;
import com.ximad.pvn.engine.CustomLabelField;
import com.ximad.pvn.engine.UiScreen;
import com.ximad.pvn.game.GameParameters;
import com.ximad.pvn.game.LevelCompleteStat;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.Scenario;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.screens.GameScreen;
import com.ximad.pvn.screens.HomeScreen;
import com.ximad.pvn.screens.StatisticScreen;
import javax.microedition.lcdui.Graphics;

public class EndLevelScreen
extends UiScreen {
    private static EndLevelScreen instance;
    private CustomButton btSecond;
    private Bitmap farBackground;
    private CustomLabelField level;
    private CustomLabelField score;
    private CustomLabelField high_score;
    public int medal = 0;
    private boolean final_level = false;
    private boolean next = false;
    private boolean win = false;

    public EndLevelScreen() {
        CustomButton btRestart = new CustomButton(Textures.endlevelRestart, Textures.endlevelRestart, null){

            protected void touchAction() {
                GameScreen.getInstance().restart();
                Application.setScreen(GameScreen.getInstance());
            }
        };
        this.btSecond = new CustomButton(Textures.endlevelNextOff, Textures.endlevelNext, null){

            protected void touchAction() {
                if (EndLevelScreen.this.final_level) {
                    EndLevelScreen.this.showStatistic();
                } else if (EndLevelScreen.this.next) {
                    EndLevelScreen.this.nextLevel();
                }
            }
        };
        CustomButton btExit = new CustomButton(Textures.endlevelExit, Textures.endlevelExit, null){

            protected void touchAction() {
                EndLevelScreen.this.quit();
            }
        };
        this.level = new CustomLabelField("2", 14, 0);
        this.score = new CustomLabelField("score: ", 14, 0);
        this.high_score = new CustomLabelField("high score: ", 14, 0);
        this.add(btRestart, 375, 0);
        this.add(this.btSecond, 375, 123);
        this.add(btExit, 375, 211);
        this.add(this.level, 165, 146);
        this.add(this.score, 165, 172);
        this.add(this.high_score, 225, 198);
    }

    public void onPaint(Graphics g) {
        if (this.farBackground != null) {
            this.farBackground.draw(g, 0, 0);
        }
        Textures.endlevelPapirus.draw(g, 30, 0);
        Textures.medalOff.draw(g, 150, 228);
        switch (this.medal) {
            case 1: {
                Textures.medalBronze.draw(g, 150, 228);
                break;
            }
            case 2: {
                Textures.medalSilver.draw(g, 150, 228);
                break;
            }
            case 3: {
                Textures.medalGold.draw(g, 150, 228);
            }
        }
        if (this.win) {
            Textures.endLevelCompleted.drawFlag(g, 192, 110, 3);
        } else {
            Textures.endLevelFailed.drawFlag(g, 192, 110, 3);
        }
        super.onPaint(g);
    }

    public void onShow() {
        this.level.setText("" + (MyWorld.currentLevelInt + 1));
        this.score.setText("" + MyWorld.score);
        this.high_score.setText("" + MyWorld.highscore);
        this.medal = this.win ? (MyWorld.score < MyWorld.bronze ? 0 : (MyWorld.score < MyWorld.silver ? 1 : (MyWorld.score < MyWorld.gold ? 2 : 3))) : 0;
        if (MyWorld.currentLevelInt == 24 && GameParameters.indexCurrentScenario == 4) {
            this.final_level = true;
            this.btSecond.setOffImage(Textures.endlevelStatistics);
            this.btSecond.setOnImage(Textures.endlevelStatistics);
        } else {
            this.final_level = false;
            this.next = MyWorld.currentLevelInt < 24 ? ((LevelCompleteStat)GameParameters.currentScenario.level.get((int)(MyWorld.currentLevelInt + 1))).isOpen : (GameParameters.scenarios.get(GameParameters.indexCurrentScenario + 1) != null ? ((LevelCompleteStat)((Scenario)GameParameters.scenarios.get((int)(GameParameters.indexCurrentScenario + 1))).level.get((int)0)).isOpen : false);
            if (this.next) {
                this.btSecond.setOffImage(Textures.endlevelNext);
                this.btSecond.setOnImage(Textures.endlevelNext);
            } else {
                this.btSecond.setOffImage(Textures.endlevelNextOff);
                this.btSecond.setOnImage(Textures.endlevelNextOff);
            }
        }
        EndLevelScreen.repaint();
    }

    public void setFon(Bitmap image) {
        this.farBackground = image;
        this.farBackground.setDark(100);
    }

    public void setWin(boolean win) {
        this.win = win;
    }

    public void setText(String text) {
        this.level.setText(text);
    }

    private void quit() {
        Application.setScreen(HomeScreen.getInstance());
        SoundSystem.SOUND_MAIN_THEME.playInLoop();
    }

    private void showStatistic() {
        Application.setScreen(StatisticScreen.getInstance());
        SoundSystem.SOUND_MAIN_THEME.playInLoop();
    }

    private void nextLevel() {
        if (GameParameters.currentLevelInt == 24) {
            GameScreen.getInstance().loadLevel(GameParameters.indexCurrentScenario + 2, 1);
        } else {
            GameScreen.getInstance().loadLevel(GameParameters.indexCurrentScenario + 1, GameParameters.currentLevelInt + 2);
        }
        Application.setScreen(GameScreen.getInstance());
    }

    public static EndLevelScreen getInstance() {
        if (instance == null) {
            instance = new EndLevelScreen();
        }
        return instance;
    }
}

