/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game;

import com.ximad.pvn.audio.SoundSystem;
import com.ximad.pvn.game.Camera;
import com.ximad.pvn.game.Game;
import com.ximad.pvn.game.GameObject;
import com.ximad.pvn.game.GameParameters;
import com.ximad.pvn.game.LevelCompleteStat;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.Point;
import com.ximad.pvn.game.Point_system;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.game.pandas.PandaTypes;
import com.ximad.pvn.utils.ArrayList;
import com.ximad.pvn.utils.Utils;
import javax.microedition.lcdui.Graphics;

public class WaitingPanda
extends GameObject {
    public int type;
    static int time;
    static int timetowait;
    int score = 5000;
    boolean show;

    public void reset() {
        time = 0;
        timetowait = 0;
    }

    public static void updateSounds(long dt) {
        if ((time = (int)((long)time + dt)) >= timetowait && MyWorld.currentPanda != -1) {
            if (Camera.position <= 100) {
                timetowait = 10000;
                if (MyWorld.currentPanda == PandaTypes.PANDANORMAL) {
                    SoundSystem.SOUND_ON_PANDA_CRY[0].play();
                }
                if (MyWorld.currentPanda == PandaTypes.PANDATRIPLE) {
                    SoundSystem.SOUND_ON_PANDA_CRY[1].play();
                }
                if (MyWorld.currentPanda == PandaTypes.PANDAEXPLODE) {
                    SoundSystem.SOUND_ON_PANDA_CRY[2].play();
                }
                if (MyWorld.currentPanda == PandaTypes.PANDAACCELERATE) {
                    SoundSystem.SOUND_ON_PANDA_CRY[3].play();
                }
            }
            time = 0;
        }
    }

    public void update(long dt) {
        if (Utils.random.nextInt(2) == 1 && !this.isAnimationPlaying) {
            this.setRandomPlayerAnimation();
        }
        if (MyWorld.onWin && Game.showScore && this.show) {
            Point_system.createPoints(this, this.score);
            this.show = false;
            MyWorld.score += this.score;
            ((LevelCompleteStat)GameParameters.currentScenario.level.get((int)MyWorld.currentLevelInt)).score += (long)this.score;
        }
    }

    public void draw(Graphics g) {
        if (this.nFrames > 0) {
            this.frames[this.getCurrentFrame()].draw(g, this.position.x - Camera.position, this.position.y);
        }
    }

    public void setFlyAnimationSequence() {
        this.animationSequence.clear();
        for (int i = 0; i < 4; ++i) {
            this.animationSequence.add(new Integer(i));
        }
        this.repeatAnimation = true;
        this.isAnimationPlaying = true;
        this.animationStartTime = System.currentTimeMillis();
    }

    public static void createWaitingPanda(int pandaType) {
        WaitingPanda obj = new WaitingPanda();
        obj.type = pandaType;
        ArrayList shape = new ArrayList();
        obj.radius = 15;
        obj.typeDinamicalObjects = 102;
        shape.add(new Point(0, 0));
        obj.position.set(30 + (int)((double)(MyWorld.lives * obj.radius) * 2.5 + (double)(5 * MyWorld.lives)), MyWorld.floor - obj.radius * 2);
        if (obj.type == PandaTypes.PANDANORMAL) {
            obj.frames = Textures.pandaNormal;
            obj.nFrames = 8;
        }
        if (obj.type == PandaTypes.PANDAACCELERATE) {
            obj.frames = Textures.pandaSuper;
            obj.nFrames = 8;
        }
        if (obj.type == PandaTypes.PANDATRIPLE) {
            obj.frames = Textures.pandaGhost;
            obj.nFrames = 8;
        }
        if (obj.type == PandaTypes.PANDAEXPLODE) {
            obj.frames = Textures.pandaKamikaze;
            obj.nFrames = 8;
        }
        ++MyWorld.lives;
        ++MyWorld.livesDisapearedPanda;
        MyWorld.wPandas.add(obj);
        obj.panda = true;
        obj.show = true;
        time = 0;
        timetowait = Utils.random.nextInt(5000) + 2000;
    }
}

