/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class DWAnimation {
    public static final byte METHOD_NORMAL = 0;
    public static final byte METHOD_REWIND = 1;
    public static final byte STATE_PAUSE = 2;
    public static final byte STATE_START = 1;
    public static final byte STATE_STOP = 0;
    private byte count;
    private short[][][] data;
    private short[] delay;
    private byte frame;
    private short height;
    private byte method;
    private byte number;
    private Sprite[] sprites;
    private byte state;
    private long timer;
    private int transform;
    private boolean visible;
    private short width;
    private short x;
    private short y;

    public DWAnimation(Sprite[] sprites, String path) throws IOException {
        this.sprites = sprites;
        this.setData(path);
        this.setVisible(true);
    }

    public boolean collidesWith(Sprite[] sprites) {
        short[][] data = this.data[this.getFrame()];
        int layer = 0;
        while (layer < data.length) {
            Sprite sprite = this.sprites[data[layer][0]];
            if (sprite != null) {
                switch (this.transform) {
                    case 2: {
                        sprite.setFrame((int)data[layer][3]);
                        sprite.setTransform(this.transform);
                        sprite.setPosition(this.getX() + data[layer][1] + 2 * (this.getX() + this.getWidth() / 2 - (this.getX() + data[layer][1] + sprite.getWidth())) + sprite.getWidth(), this.getY() + data[layer][2]);
                        sprite.setVisible(this.isVisible());
                        int a = 0;
                        while (a < sprites.length) {
                            if (sprite.collidesWith(sprites[a], true)) {
                                sprite.setTransform(0);
                                return true;
                            }
                            a = (byte)(a + 1);
                        }
                        sprite.setTransform(0);
                        break;
                    }
                    default: {
                        sprite.setFrame((int)data[layer][3]);
                        sprite.setPosition(this.getX() + data[layer][1], this.getY() + data[layer][2]);
                        sprite.setVisible(this.isVisible());
                        int a = 0;
                        while (a < sprites.length) {
                            if (sprite.collidesWith(sprites[a], true)) {
                                return true;
                            }
                            a = (byte)(a + 1);
                        }
                        break;
                    }
                }
            }
            layer = (byte)(layer + 1);
        }
        return false;
    }

    public void firstFrame() {
        this.setFrame((byte)0);
    }

    public byte getFrame() {
        return this.frame;
    }

    public short getHeight() {
        return this.height;
    }

    public byte getMethod() {
        return this.method;
    }

    public byte getNumberFrame() {
        return (byte)this.data.length;
    }

    public byte getNumberSprite() {
        return (byte)this.sprites.length;
    }

    public Sprite getSprite(byte index) {
        return this.sprites[index];
    }

    public byte getState() {
        return this.state;
    }

    public short getWidth() {
        return this.width;
    }

    public short getX() {
        return this.x;
    }

    public short getY() {
        return this.y;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void lastFrame() {
        this.setFrame((byte)(this.getNumberFrame() - 1));
    }

    public void nextFrame() {
        if (this.getFrame() + 1 < this.data.length) {
            this.setFrame((byte)(this.getFrame() + 1));
        } else {
            this.setFrame((byte)0);
        }
    }

    public void paint(Graphics g) {
        short[][] data = this.data[this.getFrame()];
        int layer = 0;
        while (layer < data.length) {
            Sprite sprite = this.sprites[data[layer][0]];
            if (sprite != null) {
                switch (this.transform) {
                    case 2: {
                        sprite.setFrame((int)data[layer][3]);
                        sprite.setTransform(this.transform);
                        sprite.setPosition(this.getX() + data[layer][1] + 2 * (this.getX() + this.getWidth() / 2 - (this.getX() + data[layer][1] + sprite.getWidth())) + sprite.getWidth(), this.getY() + data[layer][2]);
                        sprite.setVisible(this.isVisible());
                        sprite.paint(g);
                        sprite.setTransform(0);
                        break;
                    }
                    default: {
                        sprite.setFrame((int)data[layer][3]);
                        sprite.setPosition(this.getX() + data[layer][1], this.getY() + data[layer][2]);
                        sprite.setVisible(this.isVisible());
                        sprite.paint(g);
                    }
                }
            }
            layer = (byte)(layer + 1);
        }
    }

    public void pause() {
        switch (this.getState()) {
            case 2: {
                this.setState((byte)1);
                break;
            }
            case 1: {
                this.setState((byte)2);
            }
        }
    }

    public void previousFrame() {
        if (this.getFrame() - 1 >= 0) {
            this.setFrame((byte)(this.getFrame() - 1));
        } else {
            this.setFrame((byte)(this.getNumberFrame() - 1));
        }
    }

    public boolean run(long delay) {
        boolean repaint = false;
        block0 : switch (this.getState()) {
            case 1: {
                this.timer += delay;
                if (this.timer < (long)this.delay[this.getFrame()]) break;
                this.timer = 0L;
                repaint = true;
                if (this.number < 1) {
                    switch (this.getMethod()) {
                        case 1: {
                            this.previousFrame();
                            break block0;
                        }
                    }
                    this.nextFrame();
                    break;
                }
                switch (this.getMethod()) {
                    case 1: {
                        if (this.getFrame() - 1 >= 0) {
                            this.previousFrame();
                            break block0;
                        }
                        this.count = (byte)(this.count + 1);
                        if (this.count < this.number) {
                            this.previousFrame();
                            break block0;
                        }
                        this.stop();
                        break block0;
                    }
                }
                if (this.getFrame() + 1 < this.getNumberFrame()) {
                    this.nextFrame();
                    break;
                }
                this.count = (byte)(this.count + 1);
                if (this.count < this.number) {
                    this.nextFrame();
                    break;
                }
                this.stop();
            }
        }
        return repaint;
    }

    public void setData(String path) throws IOException {
        DataInputStream dis = new DataInputStream(super.getClass().getResourceAsStream(path));
        byte[] data = new byte[]{dis.readByte(), dis.readByte()};
        this.width = DWAnimation.turnByteToShort(data);
        data[0] = dis.readByte();
        data[1] = dis.readByte();
        this.height = DWAnimation.turnByteToShort(data);
        this.data = new short[dis.readByte()][][];
        this.delay = new short[this.data.length];
        int frame = 0;
        while (frame < this.data.length) {
            data[0] = dis.readByte();
            data[1] = dis.readByte();
            this.delay[frame] = DWAnimation.turnByteToShort(data);
            this.data[frame] = new short[dis.readByte()][4];
            byte layer = (byte)(this.data[frame].length - 1);
            while (layer >= 0) {
                this.data[frame][layer][0] = dis.readByte();
                data[0] = dis.readByte();
                data[1] = dis.readByte();
                data[0] = dis.readByte();
                data[1] = dis.readByte();
                data[0] = dis.readByte();
                data[1] = dis.readByte();
                this.data[frame][layer][1] = DWAnimation.turnByteToShort(data);
                data[0] = dis.readByte();
                data[1] = dis.readByte();
                this.data[frame][layer][2] = DWAnimation.turnByteToShort(data);
                this.data[frame][layer][3] = dis.readByte();
                if (this.data[frame][layer][3] < 0) {
                    this.data[frame][layer][3] = 0;
                }
                layer = (byte)(layer - 1);
            }
            frame = (byte)(frame + 1);
        }
    }

    public void setFrame(byte frame) {
        this.frame = frame;
        this.timer = 0L;
    }

    public void setPosition(short x, short y) {
        this.x = x;
        this.y = y;
    }

    public void setSprite(byte index, Sprite sprite) {
        this.sprites[index] = sprite;
    }

    private void setState(byte state) {
        this.state = state;
    }

    public void setTransform(int transform) {
        this.transform = transform;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void start(byte method, byte number) {
        switch (this.getState()) {
            case 0: {
                this.method = method;
                this.number = number;
                this.count = 0;
                this.timer = 0L;
                switch (method) {
                    case 1: {
                        this.lastFrame();
                        break;
                    }
                    default: {
                        this.firstFrame();
                    }
                }
                this.setState((byte)1);
            }
        }
    }

    public void start() {
        switch (this.getState()) {
            case 2: {
                this.setState((byte)1);
            }
        }
    }

    public void stop() {
        switch (this.getState()) {
            case 1: 
            case 2: {
                this.setState((byte)0);
            }
        }
    }

    public static short turnByteToShort(byte[] b) {
        int k = b[0];
        int l = b[1];
        if (k < 0) {
            k += 256;
        }
        if (l < 0) {
            l += 256;
        }
        return (short)(k + (l << 8));
    }
}

