/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.mgs.game.ingame;

import com.jarbull.mgs.game.ingame.Ball;
import com.jarbull.mgs.game.ingame.GolfCourse;
import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.TiledLayer;

public class Sand
extends TiledLayer {
    public static final double SAND_FRICTION = 0.05;
    private static final int TILE_WIDTH = 10;
    private static final int TILE_HEIGHT = 10;

    public Sand(GolfCourse golfCourse, int width, int height, int x, int y) throws IOException {
        super(width / 10, height / 10, Image.createImage((String)"/res/image/ingame/sand.png"), 10, 10);
        int columns = width / 10;
        int rows = height / 10;
        if (columns == 1 && rows == 1) {
            this.setCell(0, 0, 1);
        } else if (columns == 1) {
            this.fillCells(0, 1, 1, rows - 1, 6);
            this.setCell(0, 0, 4);
            this.setCell(0, rows - 1, 5);
        } else if (rows == 1) {
            this.fillCells(1, 0, columns - 1, 1, 7);
            this.setCell(0, 0, 3);
            this.setCell(columns - 1, 0, 2);
        } else {
            this.fillCells(1, 1, columns - 1, rows - 1, 16);
            for (int i = columns * rows - 1; i >= 0; --i) {
                int column = i % columns;
                int row = (i - column) / columns;
                if (row == rows - 1) {
                    if (column == 0) {
                        this.setCell(column, row, 15);
                        continue;
                    }
                    if (column == columns - 1) {
                        this.setCell(column, row, 14);
                        continue;
                    }
                    this.setCell(column, row, 11);
                    continue;
                }
                if (row == 0) {
                    if (column == 0) {
                        this.setCell(column, row, 13);
                        continue;
                    }
                    if (column == columns - 1) {
                        this.setCell(column, row, 12);
                        continue;
                    }
                    this.setCell(column, row, 10);
                    continue;
                }
                if (column == columns - 1) {
                    this.setCell(column, row, 8);
                    continue;
                }
                if (column != 0) continue;
                this.setCell(column, row, 9);
            }
        }
        golfCourse.append((Layer)this);
        this.setPosition(x, y);
    }

    public boolean checkCollision(Ball ball) {
        return ball.collidesWith(this, true);
    }

    public void responseCollision(Ball ball) {
        ball.velocity = ball.velocity > 0.05 ? (ball.velocity -= 0.05) : 0.0;
    }
}

