/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.mgs.game.screens;

import com.jarbull.jbf.JBManager;
import com.jarbull.mgs.game.MiniGolfMidlet;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.TiledLayer;
import javax.microedition.midlet.MIDlet;

public class LevelEndScreen
extends Canvas
implements Runnable {
    public static final int STATE__IDLE = 0;
    public static final int STATE__WAIT = 1;
    public static final int STATE__EXIT = 2;
    public static final int TEXT_LINE_STATE__NORMAL = 0;
    public static final int TEXT_LINE_STATE__FLICKER = 1;
    private MiniGolfMidlet midlet;
    private Displayable previousDisplay;
    private Thread thread;
    private Image backgroundImage;
    private Image topImage;
    private int textSpace = 10;
    private Vector textLines;
    private Vector textLinesState;
    private Hashtable imageOfTextTable;
    private TiledLayer background;
    private int screenCenterX;
    private int screenCenterY;
    private int state = 0;
    private boolean flicker = false;

    public LevelEndScreen(MiniGolfMidlet midlet, Image image) {
        this.initalize(midlet);
        this.backgroundImage = image;
    }

    public LevelEndScreen(MiniGolfMidlet midlet) {
        this.initalize(midlet);
    }

    public void initalize(MiniGolfMidlet midlet) {
        this.midlet = midlet;
        this.setFullScreenMode(true);
        this.previousDisplay = Display.getDisplay((MIDlet)midlet).getCurrent();
        try {
            this.backgroundImage = Image.createImage((String)"/res/image/framework/bg3.png");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Image tiledBackground = null;
        try {
            tiledBackground = Image.createImage((String)"/res/image/ingame/background.png");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        int backgroundColumns = this.getWidth() / (tiledBackground.getWidth() / 2) + 1;
        int backgroundRows = this.getHeight() / tiledBackground.getHeight() + 1;
        this.background = new TiledLayer(backgroundColumns, backgroundRows, tiledBackground, tiledBackground.getWidth() / 2, tiledBackground.getHeight());
        this.background.fillCells(0, 0, backgroundColumns, backgroundRows, 1);
        for (int i = 0; i < backgroundRows; i += 2) {
            this.background.fillCells(0, i, backgroundColumns, 1, 2);
        }
        this.textLines = new Vector();
        this.textLinesState = new Vector();
        this.imageOfTextTable = new Hashtable();
        this.screenCenterX = this.getWidth() / 2;
        this.screenCenterY = this.getHeight() / 2;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setNextDisplay(Displayable nextDisplay) {
        this.previousDisplay = nextDisplay;
    }

    public void setTextSpace(int textSpace) {
        this.textSpace = textSpace + 10;
    }

    public void setTopImage(Image image) {
        this.topImage = image;
    }

    public void addText(String text) {
        this.addText(text, 0);
    }

    public void addText(String text, int state) {
        this.addText(text, state, null);
    }

    public void addText(String text, Image image) {
        this.addText(text, 0, image);
    }

    private void addText(String text, int state, Image image) {
        this.textLinesState.addElement(new Integer(state));
        this.textLines.addElement(JBManager.getInstance().getTextImage(text, "10x10"));
        if (image != null) {
            this.imageOfTextTable.put(this.textLines.lastElement(), image);
        }
    }

    public void removeTextFromEnd(int count) {
        for (int i = count - 1; i >= 0; --i) {
            this.imageOfTextTable.remove(this.textLines.lastElement());
            this.textLinesState.removeElement(this.textLinesState.lastElement());
            this.textLines.removeElement(this.textLines.lastElement());
        }
    }

    public void clearText() {
        this.textLines.removeAllElements();
        this.textLinesState.removeAllElements();
        this.imageOfTextTable.clear();
    }

    public void clearTopImage() {
        this.topImage = null;
    }

    public void clear() {
        this.textSpace = 10;
        this.clearTopImage();
        this.clearText();
    }

    public void show() {
        this.thread = new Thread(this);
        this.thread.start();
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this);
    }

    public void waitForClose() {
        try {
            this.thread.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public void paint(Graphics g) {
        this.background.paint(g);
        g.drawImage(this.backgroundImage, this.screenCenterX, this.screenCenterY, 3);
        int totalHeight = (this.topImage != null ? this.topImage.getHeight() : 0) + (this.textLines.size() + 1) * this.textSpace;
        block4: for (int i = this.textLines.size() - 1; i >= 0; --i) {
            switch ((Integer)this.textLinesState.elementAt(i)) {
                case 0: {
                    Image textImage = (Image)this.textLines.elementAt(i);
                    Image imageOfText = (Image)this.imageOfTextTable.get(textImage);
                    int location = this.screenCenterY - (this.textLines.size() - i) * this.textSpace + totalHeight / 2;
                    int imageOfTextWidthHalf = 0;
                    if (imageOfText != null) {
                        imageOfTextWidthHalf = imageOfText.getWidth() / 2;
                        g.drawImage(imageOfText, this.screenCenterX - textImage.getWidth() / 2 - 2, location - 2, 17);
                    }
                    g.drawImage(textImage, this.screenCenterX + imageOfTextWidthHalf, location, 17);
                    continue block4;
                }
                case 1: {
                    if (this.flicker) continue block4;
                    g.drawImage((Image)this.textLines.elementAt(i), this.screenCenterX, this.screenCenterY - (this.textLines.size() - i) * this.textSpace + totalHeight / 2, 17);
                }
            }
        }
        if (this.topImage != null) {
            g.drawImage(this.topImage, this.screenCenterX, this.screenCenterY - totalHeight / 2, 17);
        }
        this.flicker = !this.flicker;
    }

    protected void keyPressed(int keyCode) {
        if (this.state != 1) {
            this.state = 2;
        }
    }

    protected void pointerPressed(int x, int y) {
        if (this.state != 1) {
            this.state = 2;
        }
    }

    public void run() {
        while (true) {
            if (this.state == 2) break;
            this.repaint();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        Display.getDisplay((MIDlet)this.midlet).setCurrent(this.previousDisplay);
    }
}

