/*
 * Decompiled with CFR 0.152.
 */
package zrong.main;

import com.nokia.mid.ui.FullCanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;
import zrong.game.Game;
import zrong.main.BaseGame;
import zrong.main.MainMIDlet;
import zrong.main.SysDef;
import zrong.ui.Event;
import zrong.ui.UIManager;
import zrong.util.Sound;

public class MainCanvas
extends FullCanvas
implements Runnable {
    private static MainCanvas instance = null;
    public static int keySteady;
    public static int keySingle;
    private boolean isRun = true;
    private MainMIDlet midlet;
    private static BaseGame currentGame;
    public static byte pointerActionCode;
    public static int pointerX;
    public static int pointerY;
    public static int pauseCount;
    public static final int pauseCountMax = 160;
    public static boolean isCanPauseCount;
    public static final int CODE_SOFT_KEY1 = -6;
    public static final int CODE_SOFT_KEY2 = -7;
    public static int test_key;

    public static MainCanvas getInstance() {
        return instance;
    }

    public MIDlet getMidlet() {
        return this.midlet;
    }

    public MainCanvas(MainMIDlet mainMIDlet) {
        instance = this;
        this.midlet = mainMIDlet;
        new Thread(this).start();
    }

    public static void clearStat() {
        MainCanvas.clearKeyEvent();
        pointerX = -1;
        pointerY = -1;
        pointerActionCode = 0;
    }

    public static boolean isKeyPreesedEvent(int n) {
        boolean bl = (keySingle & n) > 0;
        keySingle &= ~n;
        return bl;
    }

    public static boolean isKeyDowned(int n) {
        return (keySteady & n) > 0;
    }

    public static void clearKeyEvent() {
        keySingle = 0;
        keySteady = 0;
    }

    public static boolean isPointerAction(byte by) {
        return (pointerActionCode & by) != 0;
    }

    public static boolean isPointerAction(byte by, int n, int n2, int n3, int n4) {
        boolean bl;
        boolean bl2 = bl = MainCanvas.isPointerAction(by) && MainCanvas.isActionField(n, n2, n3, n4);
        if (bl) {
            pointerX = -1;
            pointerY = -1;
            pointerActionCode = 0;
        }
        return bl;
    }

    public static boolean isPointerAction(byte by, int[] nArray) {
        return MainCanvas.isPointerAction(by) && MainCanvas.isActionField(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public static boolean isActionField(int n, int n2, int n3, int n4) {
        return pointerActionCode != 0 && MainCanvas.inField(pointerX, pointerY, n, n2, n3, n4);
    }

    public static boolean isActionField(int[] nArray) {
        return pointerActionCode != 0 && MainCanvas.inField(pointerX, pointerY, nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public static boolean inField(int n, int n2, int n3, int n4, int n5, int n6) {
        return n >= n3 && n <= n3 + n5 && n2 >= n4 && n2 <= n4 + n6;
    }

    protected void paint(Graphics graphics) {
        if (currentGame != null) {
            if (Game.isPause) {
                if (pauseCount <= 0) {
                    graphics.setColor(0);
                    graphics.setClip(0, 0, 240, 320);
                    graphics.fillRect(0, 0, 240, 320);
                    graphics.setColor(0xFFFFFF);
                    graphics.drawString("\u6309\u4efb\u610f\u952e\u7ee7\u7eed\u6e38\u620f", 120, 160, 1 | 0x10);
                } else {
                    graphics.setColor(0);
                    graphics.setClip(0, 0, 240, 320);
                    graphics.fillRect(0, 0, 240, 320);
                    graphics.setColor(0xFFFFFF);
                    graphics.drawString("\u6b63\u5728\u8fd4\u56de...", 120, 160, 1 | 0x10);
                }
            } else {
                currentGame.draw(graphics);
            }
        }
    }

    public void drawSpecial(Graphics graphics) {
        int n = 240;
        int n2 = 320;
        int n3 = 640 - n2;
        graphics.setColor(0);
        graphics.setClip(0, n2, n, n3);
        graphics.fillRect(0, n2, n, n3);
    }

    public void run() {
        BaseGame.setCurrent(Game.getInstance());
        while (this.isRun) {
            try {
                long l = System.currentTimeMillis();
                currentGame = BaseGame.getCurrentGame();
                if (currentGame != null) {
                    UIManager.getBackEvent();
                    currentGame.run();
                }
                this.repaint();
                this.serviceRepaints();
                long l2 = System.currentTimeMillis();
                long l3 = SysDef.FRAME_TIME - (l2 - l);
                l3 = Math.max(10L, l3);
                Thread.sleep(l3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void hideNotify() {
        if ((Game)currentGame != null) {
            ((Game)currentGame).hideNotify();
        }
    }

    protected void showNotify() {
        if ((Game)currentGame != null) {
            ((Game)currentGame).showNotify();
        }
    }

    public void keyPressed(int n) {
        if (n == -6) {
            keySingle |= 0x20000;
            keySteady |= 0x20000;
        } else if (n == -7) {
            keySingle |= 0x40000;
            keySteady |= 0x40000;
        } else if (n == 49) {
            keySingle |= 0x10;
            keySteady |= 0x10;
        } else if (n == 50) {
            keySingle |= 0x20;
            keySteady |= 0x20;
        } else if (n == 51) {
            keySingle |= 0x40;
            keySteady |= 0x40;
        } else if (n == 52) {
            keySingle |= 0x80;
            keySteady |= 0x80;
        } else if (n == 53) {
            keySingle |= 0x100;
            keySteady |= 0x100;
        } else if (n == 54) {
            keySingle |= 0x200;
            keySteady |= 0x200;
        } else if (n == 55) {
            keySingle |= 0x400;
            keySteady |= 0x400;
        } else if (n == 56) {
            keySingle |= 0x800;
            keySteady |= 0x800;
        } else if (n == 57) {
            keySingle |= 0x1000;
            keySteady |= 0x1000;
        } else if (n == 48) {
            keySingle |= 0x2000;
            keySteady |= 0x2000;
        } else if (n == 42) {
            keySingle |= 0x4000;
            keySteady |= 0x4000;
        } else if (n == 35) {
            keySingle |= 0x8000;
            keySteady |= 0x8000;
        }
        if (SysDef.IS_NUM_SOFTKEY || n < 49 || n > 57) {
            int n2 = this.getGameAction(n);
            if (n2 == 8) {
                keySingle |= 0x10000;
                keySteady |= 0x10000;
            } else if (n2 == 1) {
                keySingle |= 1;
                keySteady |= 1;
            } else if (n2 == 6) {
                keySingle |= 2;
                keySteady |= 2;
            } else if (n2 == 2) {
                keySingle |= 4;
                keySteady |= 4;
            } else if (n2 == 5) {
                keySingle |= 8;
                keySteady |= 8;
            }
        }
        if (n != 0 && Game.isPause) {
            if (pauseCount <= 0) {
                Game.isPause = false;
                Game.noShowBack = false;
                if (Game.isOpenMusic) {
                    Sound.stopPlaying();
                    Game.sound.createSound(Game.sound.nameID, false, 1, Game.sound.curTimes);
                }
                MainCanvas.clearStat();
                isCanPauseCount = true;
            }
            return;
        }
        UIManager.setEventBack(new Event(1, keySingle, -1, -1));
        UIManager.setEventSteady(1, keySteady, -1, -1);
        MainCanvas.clearStat();
    }

    protected void keyReleased(int n) {
        if (n == -6) {
            keySteady &= 0xFFFDFFFF;
        } else if (n == -7) {
            keySteady &= 0xFFFBFFFF;
        } else if (n == 49) {
            keySteady &= 0xFFFFFFEF;
        } else if (n == 50) {
            keySteady &= 0xFFFFFFDF;
        } else if (n == 51) {
            keySteady &= 0xFFFFFFBF;
        } else if (n == 52) {
            keySteady &= 0xFFFFFF7F;
        } else if (n == 53) {
            keySteady &= 0xFFFFFEFF;
        } else if (n == 54) {
            keySteady &= 0xFFFFFDFF;
        } else if (n == 55) {
            keySteady &= 0xFFFFFBFF;
        } else if (n == 56) {
            keySteady &= 0xFFFFF7FF;
        } else if (n == 57) {
            keySteady &= 0xFFFFEFFF;
        } else if (n == 48) {
            keySteady &= 0xFFFFDFFF;
        } else if (n == 42) {
            keySteady &= 0xFFFFBFFF;
        } else if (n == 35) {
            keySteady &= 0xFFFF7FFF;
        }
        if (SysDef.IS_NUM_SOFTKEY || n < 49 || n > 57) {
            int n2 = this.getGameAction(n);
            if (n2 == 8) {
                keySteady &= 0xFFFEFFFF;
            } else if (n2 == 1) {
                keySteady &= 0xFFFFFFFE;
            } else if (n2 == 6) {
                keySteady &= 0xFFFFFFFD;
            } else if (n2 == 2) {
                keySteady &= 0xFFFFFFFB;
            } else if (n2 == 5) {
                keySteady &= 0xFFFFFFF7;
            }
        }
        UIManager.setEventSteady(1, keySteady, -1, -1);
    }

    protected void pointerDragged(int n, int n2) {
        pointerX = n;
        pointerY = n2;
        pointerActionCode = (byte)(pointerActionCode | 8);
    }

    protected void pointerPressed(int n, int n2) {
        pointerX = n;
        pointerY = n2;
        pointerActionCode = (byte)(pointerActionCode | 1);
        UIManager.setEventSteady(8, -1, n, n2);
        UIManager.setEventBack(new Event(8, -1, n, n2));
        if (Game.isPause && UIManager.pointerInXY(n, n2, 0, 0, 240, 320)) {
            Game.isPause = false;
            Game.noShowBack = false;
            if (Game.isOpenMusic) {
                Sound.stopPlaying();
                Game.sound.createSound(Game.sound.nameID, false, 1, Game.sound.curTimes);
            }
            return;
        }
        MainCanvas.clearStat();
    }

    protected void pointerReleased(int n, int n2) {
        pointerX = -1;
        pointerY = -1;
        pointerActionCode = 0;
        UIManager.setEventBack(new Event(8, -1, pointerX, pointerY));
        UIManager.setEventSteady(8, -1, pointerX, pointerY);
    }

    protected void keyRepeated(int n) {
    }

    static {
        currentGame = null;
        pointerX = 0;
        pointerY = 0;
        pauseCount = 0;
        isCanPauseCount = false;
        test_key = 0;
    }
}

