/*
 * Decompiled with CFR 0.152.
 */
package websurf.mobile.wtk.midp20;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import websurf.mobile.GameUtil;

public class Sound {
    private static final String SOUND_TYPE = ".mid";
    private boolean _enabled = true;
    private Player _sound;
    private byte[][] _tones = new byte[0][];
    private int _volume = -1;

    public void createSound(String[] stringArray) {
        this._tones = new byte[stringArray.length][];
        int n = 0;
        while (n < stringArray.length) {
            this._tones[n] = GameUtil.loadData(stringArray[n] + SOUND_TYPE);
            ++n;
        }
    }

    public int getVolume() {
        return this._volume;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public boolean isPlaying() {
        if (this._sound != null) {
            if (this._sound.getState() == 400) {
                return true;
            }
        }
        return false;
    }

    public void pause() {
        try {
            if (this._sound != null) {
                this._sound.stop();
            }
        }
        catch (Exception exception) {}
    }

    public void play(int n) {
        this.play(n, 1, true);
    }

    public void play(int n, int n2, boolean bl) {
        if (!this.isEnabled() || n < 0 || n >= this._tones.length) {
            return;
        }
        this.stop();
        try {
            this._sound = Manager.createPlayer((InputStream)new ByteArrayInputStream(this._tones[n]), (String)"audio/midi");
            this._sound.realize();
            this.updateVolume();
            if (n2 <= 0) {
                n2 = -1;
            }
            this._sound.setLoopCount(n2);
            this._sound.start();
        }
        catch (Exception exception) {}
    }

    public void resume() {
        try {
            if (this._sound != null) {
                this._sound.start();
            }
        }
        catch (Exception exception) {}
    }

    public void setEnable(boolean bl) {
        this._enabled = bl;
        if (!this._enabled) {
            this.stop();
        }
    }

    public void setVolume(int n) {
        if (n < 0 || n > 100) {
            n = -1;
        }
        this._volume = n;
        this.updateVolume();
    }

    public void stop() {
        try {
            if (this._sound != null) {
                this._sound.stop();
                this._sound.close();
            }
        }
        catch (Exception exception) {}
    }

    private void updateVolume() {
        block3: {
            if (this._sound == null) break block3;
            try {
                VolumeControl volumeControl = (VolumeControl)this._sound.getControl("VolumeControl");
                if (volumeControl != null && this._volume != -1) {
                    volumeControl.setLevel(this._volume);
                }
            }
            catch (Exception exception) {}
        }
    }
}

