/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class JavaPhoneAnimation {
    public static final int AnimationDir_Backward = -1;
    public static final int AnimationDir_BackwardLoop = -2;
    public static final int AnimationDir_BackwardReverse = -4;
    public static final int AnimationDir_Forward = 1;
    public static final int AnimationDir_ForwardLoop = 2;
    public static final int AnimationDir_ForwardReverse = 4;
    public static final int AnimationDir_None = 0;
    public static final int AnimationDir_TheSame = 65535;
    public static final boolean DEBUG_CHECK = false;
    public static final byte DESC_CurrentFrameIndex = 6;
    public static final byte DESC_DelayCount = 10;
    public static final byte DESC_Dir = 11;
    public static final byte DESC_DrawX = 0;
    public static final byte DESC_DrawY = 1;
    public static final byte DESC_End = 13;
    public static final byte DESC_FrameCount = 12;
    public static final byte DESC_LoopCount = 14;
    public static final byte DESC_MaxFrameIndex = 9;
    public static final byte DESC_MinFrameIndex = 8;
    public static final byte DESC_NextFrame = 4;
    public static final byte DESC_NextFrameIndex = 7;
    public static final byte DESC_Node = 2;
    public static final byte DESC_Page = 3;
    public static final byte DESC_PageIndex = 5;
    public static final int DESC_SIZE = 15;
    public static final String PngPath = "/png/";
    int SCREEN_HEIGHT = 320;
    int SCREEN_LEFT = 0;
    int SCREEN_TOP = 0;
    int SCREEN_WIDTH = 240;
    public static final boolean ZIP_MODE = false;
    short[] m_EIndex;
    byte[] m_FrameDelayCount;
    byte[] m_FrameProcValue;
    int m_FrameStartIndex;
    Game m_GameMidlet;
    Image[] m_Image;
    String[] m_ImageFileName;
    short[][] m_LayerData;
    short[] m_SIndex;
    String[][] m_TextString;
    public static boolean m_bEnablePause = false;

    public JavaPhoneAnimation(Game game) {
        this.m_GameMidlet = game;
    }

    public boolean ChangeDrawDescPage(short[] DrawDesc, int iPage, int iDir, int iMinFrame, int iMaxFrame, int iLoopCount) {
        short iNode = DrawDesc[2];
        DrawDesc[3] = (short)iPage;
        DrawDesc[5] = (short)(this.m_SIndex[iNode] + iPage);
        if (iDir != 65535) {
            DrawDesc[11] = (short)iDir;
        }
        DrawDesc[10] = 0;
        DrawDesc[12] = 0;
        DrawDesc[14] = (short)iLoopCount;
        if (iMinFrame < 0) {
            iMinFrame = this.m_EIndex[DrawDesc[5]] - this.m_SIndex[DrawDesc[5]];
        }
        if (iMaxFrame < 0) {
            iMaxFrame = this.m_EIndex[DrawDesc[5]] - this.m_SIndex[DrawDesc[5]];
        }
        DrawDesc[4] = DrawDesc[11] >= 0 ? (short)iMinFrame : (short)iMaxFrame;
        DrawDesc[8] = (short)(iMinFrame + this.m_SIndex[DrawDesc[5]]);
        DrawDesc[9] = (short)(iMaxFrame + this.m_SIndex[DrawDesc[5]]);
        DrawDesc[7] = (short)(this.m_SIndex[DrawDesc[5]] + DrawDesc[4]);
        DrawDesc[13] = 0;
        return true;
    }

    public boolean ComputeNextFrame(short[] DrawDesc) {
        if (m_bEnablePause) {
            return false;
        }
        if (DrawDesc[12] < Short.MAX_VALUE) {
            DrawDesc[12] = (short)(DrawDesc[12] + 1);
        }
        if (DrawDesc[13] < 0) {
            return false;
        }
        DrawDesc[10] = (short)(DrawDesc[10] + 1);
        if (this.m_FrameDelayCount[DrawDesc[7] - this.m_FrameStartIndex] <= DrawDesc[10]) {
            DrawDesc[10] = 0;
            if (DrawDesc[11] > 0) {
                DrawDesc[7] = (short)(DrawDesc[7] + 1);
                if (DrawDesc[7] > DrawDesc[9]) {
                    if ((DrawDesc[11] & 1) != 0) {
                        DrawDesc[7] = DrawDesc[9];
                        DrawDesc[13] = -1;
                        return false;
                    }
                    if ((DrawDesc[11] & 2) != 0) {
                        DrawDesc[7] = DrawDesc[8];
                        if (DrawDesc[13] < Short.MAX_VALUE) {
                            DrawDesc[13] = (short)(DrawDesc[13] + 2);
                        }
                    } else {
                        DrawDesc[11] = -DrawDesc[11];
                        DrawDesc[7] = (short)(DrawDesc[9] - 1);
                        if (DrawDesc[7] < DrawDesc[8]) {
                            DrawDesc[7] = DrawDesc[8];
                        }
                        if (DrawDesc[13] < Short.MAX_VALUE) {
                            DrawDesc[13] = (short)(DrawDesc[13] + 1);
                        }
                    }
                }
            } else if (DrawDesc[11] < 0) {
                DrawDesc[7] = (short)(DrawDesc[7] - 1);
                if (DrawDesc[7] < DrawDesc[8]) {
                    if ((DrawDesc[11] & 1) != 0) {
                        DrawDesc[7] = DrawDesc[8];
                        DrawDesc[13] = -1;
                        return false;
                    }
                    if ((DrawDesc[11] & 2) != 0) {
                        DrawDesc[7] = DrawDesc[9];
                        if (DrawDesc[13] < Short.MAX_VALUE) {
                            DrawDesc[13] = (short)(DrawDesc[13] + 2);
                        }
                    } else {
                        DrawDesc[11] = -DrawDesc[11];
                        DrawDesc[7] = (short)(DrawDesc[8] + 1);
                        if (DrawDesc[7] > DrawDesc[9]) {
                            DrawDesc[7] = DrawDesc[9];
                        }
                        if (DrawDesc[13] < Short.MAX_VALUE) {
                            DrawDesc[13] = (short)(DrawDesc[13] + 1);
                        }
                    }
                }
            } else {
                DrawDesc[13] = -1;
                return false;
            }
        }
        return true;
    }

    public void DrawBrickImage(Graphics g, int iDrawX, int iDrawY, int iImage, int iClipX, int iClipY, int iClipW, int iClipH, int iCountX, int iCountY) {
        if (this.LoadImage(iImage)) {
            if (g == null) {
                return;
            }
            int iOrgDrawX = iDrawX;
            int y = 0;
            while (y < iCountY) {
                iDrawX = iOrgDrawX;
                int x = 0;
                while (x < iCountX) {
                    g.setClip(this.SCREEN_LEFT, this.SCREEN_TOP, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
                    g.clipRect(iDrawX, iDrawY, iClipW, iClipH);
                    g.drawImage(this.m_Image[iImage], iDrawX - iClipX, iDrawY - iClipY, 20);
                    iDrawX += iClipW;
                    ++x;
                }
                iDrawY += iClipH;
                ++y;
            }
        }
    }

    public void DrawClipImage(Graphics g, int iX, int iY, int iImage, int iClipX, int iClipY, int iClipW, int iClipH) {
        if (this.LoadImage(iImage)) {
            if (g == null) {
                return;
            }
            g.clipRect(iX, iY, iClipW, iClipH);
            g.drawImage(this.m_Image[iImage], iX - iClipX, iY - iClipY, 20);
        }
    }

    public void DrawDesc(Graphics g, short[] DrawDesc, boolean bDraw, boolean bPause) {
        if (bDraw) {
            this.DrawFrameS(g, DrawDesc, DrawDesc[0], DrawDesc[1], DrawDesc[7]);
            DrawDesc[6] = DrawDesc[7];
        }
        if (!bPause) {
            this.ComputeNextFrame(DrawDesc);
        }
    }

    public void DrawDesc(Graphics g, short[] DrawDesc, int iShiftX, int iShiftY) {
        this.DrawFrameS(g, DrawDesc, DrawDesc[0] + iShiftX, DrawDesc[1] + iShiftY, DrawDesc[7]);
        DrawDesc[6] = DrawDesc[7];
        this.ComputeNextFrame(DrawDesc);
    }

    public void DrawDesc(Graphics g, short[] DrawDesc) {
        this.DrawFrameS(g, DrawDesc, DrawDesc[0], DrawDesc[1], DrawDesc[7]);
        DrawDesc[6] = DrawDesc[7];
        this.ComputeNextFrame(DrawDesc);
    }

    public void DrawFillLRColorRect(Graphics g, int iDrawX, int iDrawY, int iDrawW, int iDrawH, int iColorR, int iColorG, int iColorB, int iIncR, int iIncG, int iIncB, int iIncW) {
        g.clipRect(iDrawX, iDrawY, iDrawW, iDrawH);
        int iEndX = iDrawX + iDrawW;
        while (iDrawX < iEndX) {
            g.setColor(iColorR, iColorG, iColorB);
            g.fillRect(iDrawX, iDrawY, iIncW, iDrawH);
            iColorR += iIncR;
            iColorG += iIncG;
            iColorB += iIncB;
            iDrawX += iIncW;
        }
    }

    public void DrawFillRect(Graphics g, int iDrawX, int iDrawY, int iDrawW, int iDrawH, int iColor) {
        g.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        g.setColor(iColor);
        g.fillRect(iDrawX, iDrawY, iDrawW, iDrawH);
    }

    public void DrawFillUDColorRect(Graphics g, int iDrawX, int iDrawY, int iDrawW, int iDrawH, int iColorR, int iColorG, int iColorB, int iIncR, int iIncG, int iIncB, int iIncH) {
        g.clipRect(iDrawX, iDrawY, iDrawW, iDrawH);
        int iEndY = iDrawY + iDrawH;
        while (iDrawY < iEndY) {
            if (iColorR >= 0 && iColorG >= 0 && iColorB >= 0 && iColorR <= 255 && iColorG <= 255 && iColorB <= 255) {
                g.setColor(iColorR, iColorG, iColorB);
            }
            g.fillRect(iDrawX, iDrawY, iDrawW, iIncH);
            iColorR += iIncR;
            iColorG += iIncG;
            iColorB += iIncB;
            iDrawY += iIncH;
        }
    }

    public void DrawFrame(Graphics g, short[] DrawDesc, int iDrawX, int iDrawY, int iNode, int iPage, int iFrame) {
        int iFrameIndex = this.m_SIndex[this.m_SIndex[iNode] + iPage] + iFrame;
        this.DrawFrameS(g, DrawDesc, iDrawX, iDrawY, iFrameIndex);
    }

    public void DrawFrameS(Graphics g, short[] DrawDesc, int iX, int iY, int iFrameSIndex) {
        int i = this.m_SIndex[iFrameSIndex];
        while (i <= this.m_EIndex[iFrameSIndex]) {
            this.DrawLayer(g, DrawDesc, iX, iY, this.m_LayerData[i]);
            ++i;
        }
    }

    public void DrawHorizonColorRect(Graphics g, int iDrawX, int iDrawY, int iDrawW, int iDrawH, int iColorR, int iColorG, int iColorB, int iIncR, int iIncG, int iIncB, int iInc) {
        g.clipRect(iDrawX, iDrawY, iDrawW, iDrawH);
        iDrawH += iDrawY;
        iDrawW += iDrawX;
        while (iDrawY < iDrawH) {
            g.setColor(iColorR, iColorG, iColorB);
            g.drawLine(iDrawX, iDrawY, iDrawW, iDrawY);
            iColorR += iIncR;
            iColorG += iIncG;
            iColorB += iIncB;
            iDrawY += iInc;
        }
    }

    public void DrawHorizonRect(Graphics g, int iDrawX, int iDrawY, int iDrawW, int iDrawH, int iColor, int iInc) {
        g.clipRect(iDrawX, iDrawY, iDrawW, iDrawH);
        iDrawH += iDrawY;
        iDrawW += iDrawX;
        g.setColor(iColor);
        while (iDrawY < iDrawH) {
            g.drawLine(iDrawX, iDrawY, iDrawW, iDrawY);
            iDrawY += iInc;
        }
    }

    public void DrawLayer(Graphics g, short[] DrawDesc, int iDrawX, int iDrawY, int iNode, int iPage, int iFrame, int iLayer) {
        int iLayerIndex = this.m_SIndex[this.m_SIndex[this.m_SIndex[iNode] + iPage] + iFrame] + iLayer;
        this.DrawLayer(g, DrawDesc, iDrawX, iDrawY, this.m_LayerData[iLayerIndex]);
    }

    public void DrawLayer(Graphics g, short[] DrawDesc, int iX, int iY, short[] Layer) {
        if (Layer == null) {
            return;
        }
        if (Layer[0] == 1024) {
            this.DrawLayer(g, DrawDesc, iX, iY, this.m_LayerData[Layer[1]]);
            return;
        }
        if (g != null) {
            g.setClip(this.SCREEN_LEFT, this.SCREEN_TOP, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        }
        if (Layer[0] == 1) {
            short iImage = Layer[1];
            short iDrawX = Layer[2];
            short iDrawY = Layer[3];
            short iClipX = Layer[4];
            short iClipY = Layer[5];
            short iClipW = Layer[6];
            short iClipH = Layer[7];
            this.DrawClipImage(g, iX + iDrawX, iY + iDrawY, iImage, iClipX, iClipY, iClipW, iClipH);
        } else if (Layer[0] == 2) {
            short iImage = Layer[1];
            short iDrawX = Layer[2];
            short iDrawY = Layer[3];
            short iClipX = Layer[4];
            short iClipY = Layer[5];
            short iClipW = Layer[6];
            short iClipH = Layer[7];
            short iXCount = Layer[8];
            short iYCount = Layer[9];
            this.DrawBrickImage(g, iX + iDrawX, iY + iDrawY, iImage, iClipX, iClipY, iClipW, iClipH, iXCount, iYCount);
        } else if (Layer[0] == 4) {
            short iTextIndex = Layer[1];
            short iDrawX = Layer[2];
            short iDrawY = Layer[3];
            short iStartRow = Layer[4];
            short iRowCount = Layer[5];
            short iDrawMode = Layer[6];
            short iDrawCount = Layer[7];
            short i2Color1 = Layer[8];
            short i2Color2 = Layer[9];
            short i2Color3 = Layer[10];
            int iColor1 = (i2Color1 << 8) + (i2Color3 & 0xFF);
            int iColor2 = (i2Color2 << 8) + ((i2Color3 & 0xFF00) >> 8);
            if (this.m_TextString == null || iTextIndex >= this.m_TextString.length) {
                return;
            }
            this.DrawText(g, this.m_TextString[iTextIndex], iX + iDrawX, iY + iDrawY, iStartRow, iRowCount, iDrawMode, iDrawCount, iColor1, iColor2, 20);
        } else if (Layer[0] == 5) {
            short iTextIndex = Layer[1];
            short iDrawX = Layer[2];
            short iDrawY = Layer[3];
            short iDrawW = Layer[4];
            short iDrawH = Layer[5];
            short iDrawMode = Layer[6];
            short iDrawCount = Layer[7];
            short i2Color1 = Layer[8];
            short i2Color2 = Layer[9];
            short i2Color3 = Layer[10];
            int iColor1 = (i2Color1 << 8) + (i2Color3 & 0xFF);
            int iColor2 = (i2Color2 << 8) + ((i2Color3 & 0xFF00) >> 8);
            short iValue = Layer[11];
        } else if (Layer[0] == 16) {
            short iDrawX = Layer[1];
            short iDrawY = Layer[2];
            int iValue1 = Layer[3] & 0xFF;
            int iValue2 = Layer[3] >> 8 & 0xFF;
        } else if (Layer[0] == 17) {
            short iDrawX = Layer[1];
            short iDrawY = Layer[2];
            short iDrawW = Layer[3];
            short iDrawH = Layer[4];
            int iValue1 = Layer[5] & 0xFF;
            int iValue2 = Layer[5] >> 8 & 0xFF;
        } else if (Layer[0] == 18) {
            short iDrawY = Layer[1];
            int iValue1 = Layer[2] & 0xFF;
            int iValue2 = Layer[2] >> 8 & 0xFF;
        } else if (Layer[0] == 19) {
            short iDrawX = Layer[1];
            int iValue1 = Layer[2] & 0xFF;
            int iValue2 = Layer[2] >> 8 & 0xFF;
        } else if (g != null) {
            if (Layer[0] == 6) {
                short iDrawX = Layer[1];
                short iDrawY = Layer[2];
                short iDrawW = Layer[3];
                short iDrawH = Layer[4];
                int iColor = (Layer[5] << 8) + Layer[6];
                this.DrawFillRect(g, iX + iDrawX, iY + iDrawY, iDrawW, iDrawH, iColor);
            } else if (Layer[0] == 7) {
                short iDrawX = Layer[1];
                short iDrawY = Layer[2];
                short iDrawW = Layer[3];
                short iDrawH = Layer[4];
                int iColorR = Layer[5] & 0xFF;
                int iColorG = Layer[6] & 0xFF;
                int iColorB = Layer[7] & 0xFF;
                byte iIncR = (byte)(Layer[5] >> 8 & 0xFF);
                byte iIncG = (byte)(Layer[6] >> 8 & 0xFF);
                byte iIncB = (byte)(Layer[7] >> 8 & 0xFF);
                short iIncH = Layer[8];
                this.DrawFillUDColorRect(g, iX + iDrawX, iY + iDrawY, iDrawW, iDrawH, iColorR, iColorG, iColorB, iIncR, iIncG, iIncB, iIncH);
            } else if (Layer[0] == 8) {
                short iDrawX = Layer[1];
                short iDrawY = Layer[2];
                short iDrawW = Layer[3];
                short iDrawH = Layer[4];
                int iColorR = Layer[5] & 0xFF;
                int iColorG = Layer[6] & 0xFF;
                int iColorB = Layer[7] & 0xFF;
                byte iIncR = (byte)(Layer[5] >> 8 & 0xFF);
                byte iIncG = (byte)(Layer[6] >> 8 & 0xFF);
                byte iIncB = (byte)(Layer[7] >> 8 & 0xFF);
                short iIncW = Layer[8];
            } else if (Layer[0] == 9) {
                short iDrawX = Layer[1];
                short iDrawY = Layer[2];
                short iDrawW = Layer[3];
                short iDrawH = Layer[4];
                int iColor = (Layer[5] << 8) + Layer[6];
                this.DrawNodeRect(g, iX + iDrawX, iY + iDrawY, iDrawW, iDrawH, iColor);
            } else if (Layer[0] == 10) {
                short iDrawX = Layer[1];
                short iDrawY = Layer[2];
                short iDrawW = Layer[3];
                short iDrawH = Layer[4];
                int iColor = (Layer[5] << 8) + Layer[6];
                short iInc = Layer[7];
                this.DrawHorizonRect(g, iX + iDrawX, iY + iDrawY, iDrawW, iDrawH, iColor, iInc);
            } else if (Layer[0] == 11) {
                short iDrawX = Layer[1];
                short iDrawY = Layer[2];
                short iDrawW = Layer[3];
                short iDrawH = Layer[4];
                int iColorR = Layer[5] & 0xFF;
                int iColorG = Layer[6] & 0xFF;
                int iColorB = Layer[7] & 0xFF;
                byte iIncR = (byte)(Layer[5] >> 8 & 0xFF);
                byte iIncG = (byte)(Layer[6] >> 8 & 0xFF);
                byte iIncB = (byte)(Layer[7] >> 8 & 0xFF);
                short iInc = Layer[8];
                this.DrawHorizonColorRect(g, iX + iDrawX, iY + iDrawY, iDrawW, iDrawH, iColorR, iColorG, iColorB, iIncR, iIncG, iIncB, iInc);
            } else if (Layer[0] == 12) {
                short iDrawX = Layer[1];
                short iDrawY = Layer[2];
                short iDrawW = Layer[3];
                short iDrawH = Layer[4];
                int iColor = (Layer[5] << 8) + Layer[6];
                short iInc = Layer[7];
                this.DrawVerticalRect(g, iX + iDrawX, iY + iDrawY, iDrawW, iDrawH, iColor, iInc);
            } else if (Layer[0] == 13) {
                short iDrawX = Layer[1];
                short iDrawY = Layer[2];
                short iDrawW = Layer[3];
                short iDrawH = Layer[4];
                int iColorR = Layer[5] & 0xFF;
                int iColorG = Layer[6] & 0xFF;
                int iColorB = Layer[7] & 0xFF;
                byte iIncR = (byte)(Layer[5] >> 8 & 0xFF);
                byte iIncG = (byte)(Layer[6] >> 8 & 0xFF);
                byte iIncB = (byte)(Layer[7] >> 8 & 0xFF);
                short iInc = Layer[8];
                this.DrawVerticalColorRect(g, iX + iDrawX, iY + iDrawY, iDrawW, iDrawH, iColorR, iColorG, iColorB, iIncR, iIncG, iIncB, iInc);
            }
        }
    }

    public void DrawLayerSpecial(Graphics g, int iX, int iY, int iClipX, int iClipY, int iClipW, int iClipH, short[] Layer) {
        if (Layer == null) {
            return;
        }
        if (g != null) {
            g.setClip(this.SCREEN_LEFT, this.SCREEN_TOP, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
            if (Layer[0] == 1) {
                short iImage = Layer[1];
                short iDrawX = Layer[2];
                short iDrawY = Layer[3];
                if (iClipX < Layer[4]) {
                    iClipX = Layer[4];
                }
                if (iClipY < Layer[5]) {
                    iClipY = Layer[5];
                }
                if (iClipW > Layer[6]) {
                    iClipW = Layer[6];
                }
                if (iClipH > Layer[7]) {
                    iClipH = Layer[7];
                }
                this.DrawClipImage(g, iX + iDrawX, iY + iDrawY, iImage, iClipX, iClipY, iClipW, iClipH);
            }
        }
    }

    public void DrawNodeRect(Graphics g, int iDrawX, int iDrawY, int iDrawW, int iDrawH, int iColor) {
        g.setColor(iColor);
        g.clipRect(iDrawX, iDrawY, iDrawW, iDrawH);
        int iEndX = iDrawX + iDrawW + iDrawH;
        iDrawX -= iDrawH;
        while (iDrawX < iEndX) {
            g.drawLine(iDrawX, iDrawY, iDrawX + iDrawH, iDrawY + iDrawH);
            iDrawX += 2;
        }
    }

    public void DrawRect(Graphics g, int iDrawX, int iDrawY, int iDrawW, int iDrawH, int iColor) {
        g.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        g.setColor(iColor);
        g.drawRect(iDrawX, iDrawY, iDrawW, iDrawH);
    }

    public void DrawString(Graphics g, String Text, int iDrawX, int iDrawY, int iDrawMode, int iDrawCount, int iColor1, int iColor2, int iAlign) {
        if (g == null) {
            return;
        }
        int[][] DrawWay = new int[][]{{1, 1}, {0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}, {1, 0}};
        int iIncX = DrawWay[iDrawMode & 7][0];
        int iIncY = DrawWay[iDrawMode & 7][1];
        int iXAdd = iIncX;
        if ((iDrawMode & 8) != 0) {
            iIncX <<= 1;
            iIncY <<= 1;
        }
        int iIncXCount = iDrawCount * iIncX;
        int iIncYCount = iDrawCount * iIncY;
        int iShiftCount = iDrawCount;
        g.setColor(iColor2);
        while (iShiftCount > 0) {
            int iLineDrawX = iDrawX + iDrawCount;
            int iLineDrawY = iDrawY + iDrawCount;
            int iDrawType = iDrawMode & 0xF0;
            if (iDrawType == 0) {
                iLineDrawX = iDrawX + iIncXCount;
                iLineDrawY = iDrawY + iIncYCount;
                g.drawString(Text, iLineDrawX, iLineDrawY, iAlign);
            } else if (iDrawType == 16) {
                iLineDrawX = iDrawX + iIncXCount;
                iLineDrawY = iDrawY + iIncYCount;
                g.drawString(Text, iLineDrawX, iLineDrawY, iAlign);
                iLineDrawX = iDrawX + iIncXCount + iXAdd;
                iLineDrawY = iDrawY + iIncYCount;
                g.drawString(Text, iLineDrawX, iLineDrawY, iAlign);
            } else if (iDrawType == 32) {
                iLineDrawX = iDrawX - iIncXCount;
                iLineDrawY = iDrawY;
                g.drawString(Text, iLineDrawX, iLineDrawY, iAlign);
                iLineDrawX = iDrawX;
                iLineDrawY = iDrawY - iIncYCount;
                g.drawString(Text, iLineDrawX, iLineDrawY, iAlign);
                iLineDrawX = iDrawX + iIncXCount;
                iLineDrawY = iDrawY;
                g.drawString(Text, iLineDrawX, iLineDrawY, iAlign);
                iLineDrawX = iDrawX;
                iLineDrawY = iDrawY + iIncYCount;
                g.drawString(Text, iLineDrawX, iLineDrawY, iAlign);
            }
            --iShiftCount;
            iIncXCount -= iIncX;
            iIncYCount -= iIncY;
        }
        g.setColor(iColor1);
        g.drawString(Text, iDrawX, iDrawY, iAlign);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public void DrawText(Graphics g, String[] Strings, int iDrawX, int iDrawY, int iStartRow, int iRowCount, int iDrawMode, int iDrawCount, int iColor1, int iColor2, int iAlign) {
        if (g == null) {
            return;
        }
        if (Strings == null) {
            return;
        }
        if (iRowCount <= 0) {
            iRowCount = Strings.length;
        }
        int iEndRow = iStartRow + iRowCount;
        int iRow = iStartRow;
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                String Text = Strings[iRow];
                this.DrawString(g, Text, iDrawX, iDrawY, iDrawMode, iDrawCount, iColor1, iColor2, iAlign);
                iDrawY += g.getFont().getHeight();
                ++iRow;
            }
            if (iRow >= iEndRow) break;
        } while (iRow < Strings.length);
    }

    public void DrawVerticalColorRect(Graphics g, int iDrawX, int iDrawY, int iDrawW, int iDrawH, int iColorR, int iColorG, int iColorB, int iIncR, int iIncG, int iIncB, int iInc) {
        g.clipRect(iDrawX, iDrawY, iDrawW, iDrawH);
        iDrawH += iDrawY;
        iDrawW += iDrawX;
        while (iDrawX < iDrawW) {
            g.setColor(iColorR, iColorG, iColorB);
            g.drawLine(iDrawX, iDrawY, iDrawX, iDrawH);
            iColorR += iIncR;
            iColorG += iIncG;
            iColorB += iIncB;
            iDrawX += iInc;
        }
    }

    public void DrawVerticalRect(Graphics g, int iDrawX, int iDrawY, int iDrawW, int iDrawH, int iColor, int iInc) {
        g.clipRect(iDrawX, iDrawY, iDrawW, iDrawH);
        iDrawH += iDrawY;
        iDrawW += iDrawX;
        g.setColor(iColor);
        while (iDrawX < iDrawW) {
            g.drawLine(iDrawX, iDrawY, iDrawX, iDrawH);
            iDrawX += iInc;
        }
    }

    public void Free() {
        this.m_ImageFileName = null;
        this.m_TextString = null;
        this.m_SIndex = null;
        this.m_EIndex = null;
        this.m_FrameDelayCount = null;
        this.m_FrameProcValue = null;
        this.m_LayerData = null;
        this.m_Image = null;
    }

    public void FreeAllImage() {
        int i = 0;
        while (i < this.m_Image.length) {
            this.m_Image[i] = null;
            ++i;
        }
    }

    public void FreeImage(int iIndex) {
        if (this.m_Image[iIndex] != null) {
            this.m_Image[iIndex] = null;
        }
    }

    public short[] GetLayer(int iNode, int iPage, int iFrame, int iLayer) {
        int iLayerIndex = this.m_SIndex[this.m_SIndex[this.m_SIndex[iNode] + iPage] + iFrame] + iLayer;
        short[] Layer = this.m_LayerData[iLayerIndex];
        if (Layer[0] == 1024) {
            Layer = this.m_LayerData[Layer[1]];
        }
        return Layer;
    }

    public int GetLayerCount(int iNode, int iPage, int iFrame) {
        int iFrameIndex = this.m_SIndex[this.m_SIndex[iNode] + iPage] + iFrame;
        return this.m_EIndex[iFrameIndex] - this.m_SIndex[iFrameIndex] + 1;
    }

    public short GetLayerData(short[] Layer, int iIndex) {
        if (Layer[0] == 1024) {
            return this.GetLayerData(this.m_LayerData[Layer[1]], iIndex);
        }
        if (iIndex == 0) {
            return (short)(Layer[0] & 0x3FF);
        }
        int iLinkNum = (Layer[0] & 0xFC00) >> 10;
        if (iLinkNum == 0 || iIndex < iLinkNum) {
            return Layer[iIndex];
        }
        return this.GetLayerData(this.m_LayerData[Layer[iLinkNum]], iIndex);
    }

    public static int GetLoopCount(short[] DrawDesc) {
        return DrawDesc[13] > 0 ? DrawDesc[13] >> 1 : -DrawDesc[13];
    }

    public int GetMaxFrame(int iNode, int iPage) {
        int iPageIndex = this.m_SIndex[iNode] + iPage;
        return this.m_EIndex[iPageIndex] - this.m_SIndex[iPageIndex];
    }

    public int GetMaxNode() {
        return this.m_SIndex[0] - 1;
    }

    public int GetMaxPage(int iNode) {
        return this.m_EIndex[iNode] - this.m_SIndex[iNode];
    }

    public int GetNextFrameDelayCount(short[] DrawDesc) {
        return this.m_FrameDelayCount[DrawDesc[7] - this.m_FrameStartIndex];
    }

    public int GetNextProcValue(short[] DrawDesc) {
        return this.m_FrameProcValue[DrawDesc[7] - this.m_FrameStartIndex];
    }

    public int GetProcValue(short[] DrawDesc) {
        return this.m_FrameProcValue[DrawDesc[6] - this.m_FrameStartIndex];
    }

    public int GetRealFrame(short[] DrawDesc, int iFrameIndex) {
        return iFrameIndex - this.m_SIndex[DrawDesc[5]];
    }

    public static boolean IsEnd(short[] DrawDesc) {
        if (DrawDesc[11] == 0) {
            return true;
        }
        if ((DrawDesc[11] & 1) != 0) {
            return DrawDesc[13] < 0;
        }
        if (DrawDesc[14] > 0) {
            return DrawDesc[13] >> 1 >= DrawDesc[14];
        }
        return false;
    }

    public void LoadAllImage() {
        int i = 0;
        while (i < this.m_ImageFileName.length) {
            this.LoadImage(i);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public byte[] LoadAnB(String FileName, int filemax) {
        void var3_3;
        byte[] b1 = new byte[filemax];
        InputStream Stream2 = this.getClass().getResourceAsStream(FileName);
        DataInputStream DataStream = new DataInputStream(Stream2);
        try {
            DataStream.readFully(b1);
        }
        catch (Exception e) {
        }
        finally {
            try {
                Stream2.close();
            }
            catch (Exception e) {
            }
        }
        return var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean LoadAni(String FileName) {
        void var2_2;
        boolean ret = false;
        InputStream Stream2 = this.getClass().getResourceAsStream(FileName);
        try {
            DataInputStream DataStream = new DataInputStream(Stream2);
            short sFuncCount = DataStream.readShort();
            while (sFuncCount > 0) {
                int sLength;
                int j;
                short sLength2;
                int i;
                byte byfunc = DataStream.readByte();
                if (byfunc == 1) {
                    short sPictureCount = DataStream.readShort();
                    this.m_ImageFileName = new String[sPictureCount];
                    this.m_Image = new Image[sPictureCount];
                    i = 0;
                    while (i < sPictureCount) {
                        this.m_ImageFileName[i] = "";
                        sLength2 = DataStream.readShort();
                        while (sLength2 > 0) {
                            int n = i;
                            this.m_ImageFileName[n] = this.m_ImageFileName[n] + (char)DataStream.readByte();
                            sLength2 = (short)(sLength2 - 1);
                        }
                        this.m_ImageFileName[i] = PngPath + this.m_ImageFileName[i];
                        ++i;
                    }
                }
                if (byfunc == 2) {
                    int sTextCount = DataStream.readShort();
                    this.m_TextString = new String[sTextCount][];
                    i = 0;
                    while (i < sTextCount) {
                        int sLineCount = DataStream.readShort();
                        this.m_TextString[i] = new String[sLineCount];
                        j = 0;
                        while (j < sLineCount) {
                            this.m_TextString[i][j] = DataStream.readUTF();
                            ++j;
                        }
                        ++i;
                    }
                }
                if (byfunc == 3) {
                    sLength = DataStream.readShort();
                    this.m_SIndex = new short[sLength];
                    i = 0;
                    while (i < sLength) {
                        this.m_SIndex[i] = DataStream.readShort();
                        ++i;
                    }
                    sLength = DataStream.readShort();
                    this.m_EIndex = new short[sLength];
                    int i2 = 0;
                    while (i2 < sLength) {
                        this.m_EIndex[i2] = DataStream.readShort();
                        ++i2;
                    }
                    this.m_FrameStartIndex = this.m_SIndex[this.m_SIndex[0]];
                }
                if (byfunc == 4) {
                    sLength = DataStream.readShort();
                    this.m_FrameDelayCount = new byte[sLength];
                    DataStream.read(this.m_FrameDelayCount);
                }
                if (byfunc == 5) {
                    sLength = DataStream.readShort();
                    this.m_FrameProcValue = new byte[sLength];
                    DataStream.read(this.m_FrameProcValue);
                }
                if (byfunc == 6) {
                    short sLayerCount = DataStream.readShort();
                    this.m_LayerData = new short[sLayerCount][];
                    i = 0;
                    while (i < sLayerCount) {
                        sLength2 = DataStream.readShort();
                        if (sLength2 > 0) {
                            this.m_LayerData[i] = new short[sLength2];
                            j = 0;
                            while (j < sLength2) {
                                this.m_LayerData[i][j] = DataStream.readShort();
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                sFuncCount = (short)(sFuncCount - 1);
            }
            ret = true;
        }
        catch (Exception e) {
        }
        finally {
            try {
                Stream2.close();
            }
            catch (Exception e) {
            }
        }
        return (boolean)var2_2;
    }

    public boolean LoadImage(int iIndex) {
        if (this.m_Image[iIndex] != null) {
            return true;
        }
        try {
            this.m_Image[iIndex] = Image.createImage((String)this.m_ImageFileName[iIndex]);
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.m_Image[iIndex] != null;
    }

    public short[] NewDrawDesc(int iX, int iY, int iNode, int iPage, int iDir, int iMinFrame, int iMaxFrame, int iLoopCount) {
        short[] DrawDesc = new short[15];
        DrawDesc[0] = (short)iX;
        DrawDesc[1] = (short)iY;
        DrawDesc[2] = (short)iNode;
        DrawDesc[6] = -1;
        if (!this.ChangeDrawDescPage(DrawDesc, iPage, iDir, iMinFrame, iMaxFrame, iLoopCount)) {
            return null;
        }
        return DrawDesc;
    }

    public short[] NewDrawDescExt(int iX, int iY, int iNode, int iPage, int iDir, int iMinFrame, int iMaxFrame, int iLoopCount, int ExtDataCount) {
        short[] DrawDesc = new short[15 + ExtDataCount];
        DrawDesc[0] = (short)iX;
        DrawDesc[1] = (short)iY;
        DrawDesc[2] = (short)iNode;
        DrawDesc[6] = -1;
        if (!this.ChangeDrawDescPage(DrawDesc, iPage, iDir, iMinFrame, iMaxFrame, iLoopCount)) {
            return null;
        }
        return DrawDesc;
    }

    public void SetClipRect(int iClipX, int iClipY, int iClipWidth, int iClipHeight) {
        this.SCREEN_LEFT = iClipX;
        this.SCREEN_TOP = iClipY;
        this.SCREEN_WIDTH = iClipWidth;
        this.SCREEN_HEIGHT = iClipHeight;
    }
}

