/*
 * Decompiled with CFR 0.152.
 */
package HG.Game;

import HG.Animation.ColRect;
import HG.Game.GameActor;
import HG.Game.GamePiffList;
import HG.Game.Weapon;
import HG.Main.MainCanvas;
import HG.Public.Constant;
import HG.Scene.GameScene;
import HG.Tool.MathTool;

public class GameBonus
extends GameActor {
    public static final int BONUS_POWER = 0;
    public static final int BONUS_SHIELD = 1;
    public static final int BONUS_WEAPON = 2;
    public static final int BONUS_MISSION = 3;
    private boolean is_InSupperAtk = false;

    public GameBonus(MainCanvas mc) {
        super(mc);
        this.game = this.canvas.sceneMgr.scene_game;
    }

    public void process(long gameTime, GameActor[] actorPool) {
        if (this.isStopProcessing()) {
            return;
        }
        if (this.is_InSupperAtk) {
            return;
        }
        this.setLife((int)(this.canvas.sceneMgr.scene_game.getCurGameTime() - this.time_stateStart));
        ColRect crBonus = this.getColRect(gameTime, 0);
        crSelf.Copy(this.getX(), this.getY(), this.getColRect(gameTime, 0));
        crOther.Copy(GameScene.getPlayer().getX(), GameScene.getPlayer().getY(), GameScene.getPlayer().getColRect(gameTime, 0));
        GameBonus.crOther.w >>= 1;
        GameBonus.crOther.h >>= 1;
        GameBonus.crOther.x += GameBonus.crOther.w;
        GameBonus.crOther.y += GameBonus.crOther.h;
        if (ColRect.RectIntersect(crSelf, crOther) && !GameScene.getPlayer().isPlayerDead()) {
            if (this.getType() == 0) {
                this.game.is_tipGainItem[0] = true;
                this.game.tip_GainItem_x[0] = -this.game.gainItemBorder_w;
                this.game.tip_GainItem_frame[0] = 0;
                this.game.tip_GainItem_lang[0] = 134;
                GameScene.getPlayer().increaseBulletLevel(gameTime);
            } else if (this.getType() == 1) {
                this.game.is_tipGainItem[1] = true;
                this.game.tip_GainItem_x[1] = -this.game.gainItemBorder_w;
                this.game.tip_GainItem_frame[1] = 0;
                this.game.tip_GainItem_lang[1] = 135;
                GameScene.getPlayer().setShieldLife(100);
            } else if (this.getType() == 2) {
                this.game.is_tipGainItem[1] = true;
                this.game.tip_GainItem_x[1] = -this.game.gainItemBorder_w;
                this.game.tip_GainItem_frame[1] = 0;
                this.game.tip_GainItem_lang[1] = 136;
                Weapon weapon = null;
                switch (Constant.indexOfLevel) {
                    case 0: 
                    case 1: 
                    case 3: 
                    case 4: {
                        weapon = new Weapon(MathTool.getRandom(0, 5));
                        GameScene.getPlayer().player_WeaponBag.addWeapon(weapon);
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        weapon = new Weapon(MathTool.getRandom(6, 10));
                        GameScene.getPlayer().player_WeaponBag.addWeapon(weapon);
                        break;
                    }
                    case 2: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: {
                        weapon = new Weapon(MathTool.getRandom(11, 14));
                        GameScene.getPlayer().player_WeaponBag.addWeapon(weapon);
                        break;
                    }
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        weapon = new Weapon(MathTool.getRandom(15, 16));
                        GameScene.getPlayer().player_WeaponBag.addWeapon(weapon);
                        break;
                    }
                    case 19: {
                        weapon = new Weapon(17);
                        GameScene.getPlayer().player_WeaponBag.addWeapon(weapon);
                    }
                }
            } else if (this.getType() == 3) {
                this.game.is_tipGainItem[1] = true;
                this.game.tip_GainItem_x[1] = -this.game.gainItemBorder_w;
                this.game.tip_GainItem_frame[1] = 0;
                this.game.tip_GainItem_lang[1] = 137;
            }
            this.setInUse(false);
        } else {
            if (this.getLife() > 0) {
                if (this.getX() - (crBonus.w >> 1) < 0) {
                    this.setX(0 + (crBonus.w >> 1));
                    this.setVx(-this.getVx());
                } else if (this.getX() + (crBonus.w >> 1) > 240) {
                    this.setX(240 - (crBonus.w >> 1));
                    this.setVx(-this.getVx());
                }
                if (this.getY() - (crBonus.h >> 1) < 55) {
                    this.setY(55 + (crBonus.h >> 1));
                    this.setVy(-this.getVy());
                } else if (this.getY() + (crBonus.h >> 1) > 295) {
                    this.setY(295 - (crBonus.h >> 1));
                    this.setVy(-this.getVy());
                }
            }
            this.x += this.vx;
            this.y += this.vy;
            if (this.getLife() <= 0) {
                if (this.getX() + (crBonus.w >> 1) < 0 || this.getX() - (crBonus.w >> 1) > 240) {
                    this.setInUse(false);
                }
                if (this.getY() + (crBonus.h >> 1) < 55 || this.getY() - (crBonus.h >> 1) > 295) {
                    this.setInUse(false);
                }
            }
        }
    }

    public void initGameActor(long gameTime, int type) {
        this.setInUse(true);
        this.setLife(20000);
        this.setAnimation(GamePiffList.bonus_Pif);
        this.setType(type);
        switch (this.getType()) {
            case 0: {
                this.setRenderContent(0, true, gameTime);
                break;
            }
            case 1: {
                this.setRenderContent(1, true, gameTime);
                break;
            }
            case 2: {
                this.setRenderContent(2, true, gameTime);
                break;
            }
            case 3: {
                this.setRenderContent(3, true, gameTime);
            }
        }
        int speed = MathTool.getRandom(-3, 3);
        speed = speed > 0 ? ++speed : --speed;
        this.setVx(speed);
        speed = MathTool.getRandom(-3, 3);
        speed = speed > 0 ? ++speed : --speed;
        this.setVy(speed);
    }

    public void beginNotify(long gameTime, int type) {
        this.is_InSupperAtk = true;
    }

    public void endNotify(long gameTime, int type) {
        this.is_InSupperAtk = false;
        this.time_stateStart = this.canvas.sceneMgr.scene_game.getCurGameTime();
    }

    public void reduceLife(int reducePoint, int type, ColRect rc, long gametime) {
    }

    public void clearGameActor() {
    }
}

