/*
 * Decompiled with CFR 0.152.
 */
package HG.Game;

import HG.Animation.ColRect;
import HG.Game.Enemy;
import HG.Game.GameActor;
import HG.Game.GamePiffList;
import HG.Game.Player;
import HG.Main.MainCanvas;
import HG.Scene.GameScene;

public class GameBullet
extends GameActor {
    public static final byte STATUS_FLY = 0;
    public static final byte STATUS_BOOM = 1;
    public static final byte STATUS_CATCH = 2;
    public static final byte STATUS_BORN = 3;
    public static final int SUBTYPE_PLAYER_LEVEL_0 = 0;
    public static final int SUBTYPE_PLAYER_LEVEL_1 = 1;
    public static final int SUBTYPE_PLAYER_LEVEL_2_0 = 2;
    public static final int SUBTYPE_PLAYER_LEVEL_2_1 = 3;
    public static final int SUBTYPE_PLAYER_LEVEL_2_2 = 4;
    public static final int SUBTYPE_PLAYER_LEVEL_3_0 = 5;
    public static final int SUBTYPE_PLAYER_LEVEL_3_1 = 6;
    public static final int SUBTYPE_PLAYER_LEVEL_3_2 = 7;
    public static final int SUBTYPE_PLAYER_LEVEL_4_0 = 8;
    public static final int SUBTYPE_PLAYER_LEVEL_4_1 = 9;
    public static final int SUBTYPE_PLAYER_LEVEL_4_2 = 10;
    private int bullet_x = 0;
    private int bullet_y = 0;
    public int bullet_damage = 0;
    public int bullet_radius = 0;
    public int bullet_angel = 0;
    public long time_BulletStay = 0L;
    private boolean is_pig_bulletR2L = true;

    public GameBullet(MainCanvas mc) {
        super(mc);
    }

    public void initGameActor(long gameTime, int type) {
        this.game = this.canvas.sceneMgr.scene_game;
        this.setType(type);
        this.setSubType(0);
        this.setCurState((byte)0, gameTime);
        this.setInUse(true);
        this.bullet_damage = 4;
        this.time_BulletStay = -1L;
        this.bullet_radius = 40;
        this.bullet_angel = 0;
    }

    public void setCurState(byte newState, long time) {
        switch (this.getType()) {
            case 0: {
                this.setStateNormal(newState, time);
                break;
            }
            case 1: {
                super.setCurState(newState, time);
            }
        }
    }

    public void setStateNormal(byte newState, long time) {
        super.setCurState(newState, time);
        switch (newState) {
            case 0: {
                this.setRenderContent(0 + this.getSubType() - 0, true, time);
                break;
            }
            case 1: {
                break;
            }
            default: {
                this.setRenderContent(0, true, time);
            }
        }
    }

    public void process(long gameTime, GameActor[] actorPool) {
        if (this.isStopProcessing()) {
            return;
        }
        block0 : switch (this.getCurState()) {
            case 0: {
                this.updatePosition();
                this.processFly(gameTime, actorPool);
                if (this.getType() == 0) {
                    for (int i = 0; i < actorPool.length; ++i) {
                        if (actorPool[i] == null || !actorPool[i].inUse() || actorPool[i].getType() != 1 || actorPool[i].getSubType() == 29 || actorPool[i].getCurState() == 7 || !this.isCollide(gameTime, actorPool[i], 0, 0)) continue;
                        this.setCurState((byte)1, gameTime);
                        actorPool[i].reduceLife(GameScene.getPlayer().getPlayerATL(), 0, this.getIntersectRect(gameTime, actorPool[i], 0, 0), gameTime);
                        this.setVx(1);
                        switch (this.getSubType()) {
                            default: 
                        }
                        this.setAnimation(GamePiffList.playerBulletBoom_Pif);
                        this.setRenderContent(0, false, gameTime);
                        break block0;
                    }
                    break;
                }
                if (GameScene.getPlayer() == null) {
                    return;
                }
                if (!this.isCollide(gameTime, GameScene.getPlayer(), 0, 0)) break;
                switch (this.getSubType()) {
                    case 45: {
                        if (this.animID == 5) {
                            GameScene.getPlayer().reduceLife(this.bullet_damage, 7, this.getIntersectRect(gameTime, GameScene.getPlayer(), 0, 0), gameTime);
                            if (GameScene.getPlayer().getCurState() == 13) break block0;
                            GameScene.getPlayer().setCurState((byte)12, gameTime);
                            break block0;
                        }
                        if (this.animID == 6) {
                            GameScene.getPlayer().reduceLife(this.bullet_damage, 7, this.getIntersectRect(gameTime, GameScene.getPlayer(), 0, 0), gameTime);
                            break block0;
                        }
                        if (this.animID != 7) break block0;
                        GameScene.getPlayer().reduceLife(this.bullet_damage, 9, this.getIntersectRect(gameTime, GameScene.getPlayer(), 0, 0), gameTime);
                        break block0;
                    }
                    case 42: {
                        if (this.animID == 10) {
                            if (Player.is_boneHold) break block0;
                            Player.is_boneHold = true;
                            GameScene.getPlayer().reduceLife(this.bullet_damage, 0, this.getIntersectRect(gameTime, GameScene.getPlayer(), 0, 0), gameTime);
                            break block0;
                        }
                        GameScene.getPlayer().reduceLife(this.bullet_damage, 0, this.getIntersectRect(gameTime, GameScene.getPlayer(), 0, 0), gameTime);
                        this.setCurState((byte)1, gameTime);
                        this.setVx(-1);
                        this.setVy(0);
                        this.setAnimation(GamePiffList.enemyBulletBoom_Pif);
                        this.setRenderContent(0, false, gameTime);
                        break block0;
                    }
                    case 44: {
                        GameScene.getPlayer().reduceLife(this.bullet_damage, 9, this.getIntersectRect(gameTime, GameScene.getPlayer(), 0, 0), gameTime);
                        this.setCurState((byte)1, gameTime);
                        this.setVx(-1);
                        this.setVy(0);
                        this.setRenderContent(10, false, gameTime);
                        break block0;
                    }
                    case 25: {
                        GameScene.getPlayer().reduceLife(this.bullet_damage, 0, this.getIntersectRect(gameTime, GameScene.getPlayer(), 0, 0), gameTime);
                        if (this.animID != 8) break block0;
                        this.setCurState((byte)1, gameTime);
                        this.setVx(-1);
                        this.setVy(0);
                        this.setAnimation(GamePiffList.enemyBulletBoom_Pif);
                        this.setRenderContent(0, false, gameTime);
                        break block0;
                    }
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: {
                        GameScene.getPlayer().reduceLife(this.bullet_damage, 0, this.getIntersectRect(gameTime, GameScene.getPlayer(), 0, 0), gameTime);
                        GameScene.getPlayer().setPoisonTime(5000L);
                        this.setCurState((byte)1, gameTime);
                        this.setVx(-1);
                        this.setVy(0);
                        this.setAnimation(GamePiffList.enemyBulletBoom_Pif);
                        this.setRenderContent(0, false, gameTime);
                        break block0;
                    }
                }
                GameScene.getPlayer().reduceLife(this.bullet_damage, 0, this.getIntersectRect(gameTime, GameScene.getPlayer(), 0, 0), gameTime);
                this.setCurState((byte)1, gameTime);
                this.setVx(-1);
                this.setVy(0);
                this.setAnimation(GamePiffList.enemyBulletBoom_Pif);
                this.setRenderContent(0, false, gameTime);
                break;
            }
            case 1: {
                this.processBoom(gameTime);
            }
        }
    }

    private void processFly(long gameTime, GameActor[] actorPool) {
        switch (this.getSubType()) {
            case 45: {
                if (!this.isAnimationOver(gameTime)) break;
                this.setInUse(false);
                break;
            }
            case 42: {
                if (this.animID == 10) {
                    if (!this.isAnimationOver(gameTime)) break;
                    Player.is_boneHold = false;
                    this.setInUse(false);
                    break;
                }
                if (this.getX() > 240 || this.getX() < 0) {
                    this.setInUse(false);
                }
                if (this.getY() <= 295 && this.getY() >= 55) break;
                this.setInUse(false);
                break;
            }
            case 25: {
                if (this.animID != 8) break;
                if (this.getX() > 240 || this.getX() < 0) {
                    this.setInUse(false);
                }
                if (this.getY() <= 295 && this.getY() >= 55) break;
                this.setInUse(false);
                break;
            }
            default: {
                if (this.getX() > 240 || this.getX() < 0) {
                    this.setInUse(false);
                }
                if (this.getY() <= 295 && this.getY() >= 55) break;
                this.setInUse(false);
            }
        }
    }

    private void processBoom(long gameTime) {
        switch (this.getSubType()) {
            default: 
        }
        if (this.isAnimationOver(gameTime)) {
            this.setInUse(false);
        } else {
            this.setX(this.getX() + this.getVx());
        }
    }

    private void updatePosition() {
        if (this.getType() == 0) {
            this.x += this.vx;
            this.y += this.vy;
        } else {
            switch (this.getSubType()) {
                case 25: {
                    if (this.animID == 8) {
                        this.setX(this.getX() + this.getVx());
                        this.setY(this.getY() + this.getVy());
                        break;
                    }
                    if (this.is_pig_bulletR2L) {
                        this.setX(this.getX() + this.getVx());
                        this.setY(this.getY() + this.getVy());
                        if (this.getX() >= -100) break;
                        this.is_pig_bulletR2L = false;
                        break;
                    }
                    this.setX(this.getX() - this.getVx());
                    this.setY(this.getY() - this.getVy());
                    if (this.getX() < Enemy.pig_bullet_initX) break;
                    this.is_pig_bulletR2L = true;
                    this.setInUse(false);
                    Enemy.is_pigWeaponFlyOver = true;
                    break;
                }
                default: {
                    this.setX(this.getX() + this.getVx());
                    this.setY(this.getY() + this.getVy());
                }
            }
        }
    }

    public void beginNotify(long gameTime, int type) {
        this.setInUse(false);
        this.is_pig_bulletR2L = true;
        Enemy.is_pigWeaponFlyOver = true;
    }

    public void clearGameActor() {
        super.clearActor();
    }

    public void setGoalX(int goalX) {
        this.bullet_x = goalX;
    }

    public int getGoalX() {
        return this.bullet_x;
    }

    public void setGoalY(int goalY) {
        this.bullet_y = goalY;
    }

    public int getGoalY() {
        return this.bullet_y;
    }

    public void endNotify(long gameTime, int type) {
    }

    public void reduceLife(int reducePoint, int type, ColRect rc, long gametime) {
    }
}

