/*
 * Decompiled with CFR 0.152.
 */
package HG.Game;

import HG.Animation.ColRect;
import HG.Game.GameActor;
import HG.Game.GamePiffList;
import HG.Game.Player;
import HG.Main.MainCanvas;
import HG.Public.Constant;
import HG.Scene.GameScene;
import HG.Tool.MathTool;
import javax.microedition.lcdui.Graphics;

public class Spirit
extends GameActor {
    public static final int SPIRIT_HEALTH = 0;
    public static final int SPIRIT_MAGIC = 1;
    public static final int SPIRIT_SOUL = 2;
    public static final byte STATUS_FLY = 0;
    public static final byte STATUS_EAT = 1;
    public static int soul_traceSpeed = 0;
    private int[][] trailPosition = new int[][]{{-1, -1}, {-1, -1}, {-1, -1}};

    public Spirit(MainCanvas mc) {
        super(mc);
    }

    public void initGameActor(long gameTime, int type) {
        this.setInUse(true);
        this.setType(type);
        this.setAnimation(GamePiffList.soul_Pif);
        soul_traceSpeed = 0;
        for (int i = 0; i < this.trailPosition.length; ++i) {
            this.trailPosition[i][0] = -1;
            this.trailPosition[i][1] = -1;
        }
        this.setCurState((byte)0, gameTime);
    }

    public void setCurState(byte newState, long time) {
        super.setCurState(newState, time);
        if (this.getType() == 0) {
            if (this.getCurState() == 0) {
                this.setRenderContent(4, true, time);
            } else if (this.getCurState() == 1) {
                for (int i = 0; i < this.trailPosition.length; ++i) {
                    this.trailPosition[i][0] = -1;
                    this.trailPosition[i][1] = -1;
                }
                this.setRenderContent(1, false, time);
            }
        } else if (this.getType() == 1) {
            if (this.getCurState() == 0) {
                this.setRenderContent(8, true, time);
            } else if (this.getCurState() == 1) {
                this.setRenderContent(3, false, time);
            }
        } else if (this.getCurState() == 0) {
            this.setRenderContent(14, true, time);
        } else if (this.getCurState() == 1) {
            this.setRenderContent(13, false, time);
        }
    }

    public void process(long gameTime, GameActor[] actorPool) {
        if (this.getCurState() == 0) {
            Player player;
            ColRect rect;
            int oldSign;
            int lastFrameX = this.getX();
            int lastFrameY = this.getY();
            if (this.ax != 0) {
                this.x += this.vx;
                oldSign = this.vx > 0 ? 1 : -1;
                this.vx += this.ax;
                if (oldSign * this.vx <= 0) {
                    this.ax = 0;
                }
            }
            if (this.ay != 0) {
                this.y += this.vy;
                oldSign = this.vy > 0 ? 1 : -1;
                this.vy += this.ay;
                if (oldSign * this.vy <= 0) {
                    this.ay = 0;
                }
            }
            if ((rect = (player = GameScene.getPlayer()).getColRect(gameTime, 0)) != null && this.moveToArea(player.getX(), player.getY() - (rect.h >> 1), MathTool.F2I(soul_traceSpeed), rect.w >> 1, rect.h >> 1, true, gameTime, false)) {
                this.setCurState((byte)1, gameTime);
            } else {
                if ((soul_traceSpeed += 8192) > MathTool.I2F(10)) {
                    soul_traceSpeed = MathTool.I2F(10);
                }
                if (this.trailPosition[0][0] != lastFrameX || this.trailPosition[0][1] != lastFrameY) {
                    for (int i = this.trailPosition.length - 1; i > 0; --i) {
                        this.trailPosition[i][0] = this.trailPosition[i - 1][0];
                        this.trailPosition[i][1] = this.trailPosition[i - 1][1];
                    }
                    this.trailPosition[0][0] = lastFrameX;
                    this.trailPosition[0][1] = lastFrameY;
                }
            }
        } else if (this.getCurState() == 1) {
            Player player = GameScene.getPlayer();
            if (this.isAnimationOver(gameTime) && !player.isPlayerDead()) {
                this.setInUse(false);
                if (this.getType() == 0) {
                    player.setLife(player.getLife() + this.getLife());
                    if (player.getLife() > player.getMaxlife()) {
                        player.setLife(player.getMaxlife());
                    }
                } else if (this.getType() == 1) {
                    Player.setMana(Player.getMana() + this.getLife());
                    if (Player.getMana() > Player.getMaxMana()) {
                        Player.setMana(Player.getMaxMana());
                    }
                } else if (this.getType() == 2) {
                    Player.setPlayerSouls(Player.getPlayerSouls() + this.getLife());
                }
            }
        }
    }

    public void renderGameActor(Graphics g, long gameTime) {
        for (int i = this.trailPosition.length - 1; i > -1; --i) {
            if (this.trailPosition[i][0] == -1) continue;
            this.animation.drawAnimation(g, this.animID + i + 1, gameTime - this.time_stateStart, this.trailPosition[i][0], this.trailPosition[i][1] - Constant.Camera_y, this.animCyclic);
        }
        super.renderGameActor(g, gameTime);
    }

    public void clearGameActor() {
        this.trailPosition = null;
    }

    public void reduceLife(int reducePoint, int type, ColRect rc, long gametime) {
    }

    public void beginNotify(long gameTime, int type) {
    }

    public void endNotify(long gameTime, int type) {
    }
}

