/*
 * Decompiled with CFR 0.152.
 */
package HG.MotionWelder;

import HG.MotionWelder.AnuData;
import HG.Tool.GraphicsTool;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AnuPlayer {
    public AnuData m_doc;
    public int m_nCurrAniID;
    public int m_nCurrFrameID;
    private int m_nLoopCnt;
    private int m_nCurrPlayCnt;
    public int m_nAniX;
    public int m_nAniY;
    public int m_nCurrColiCnt;
    public int[][] m_anCurrColiRc = new int[100][4];
    private boolean is_playing = false;
    private int m_nCurrFrameDelay = 0;

    public AnuPlayer(AnuData doc) {
        this.m_doc = doc;
    }

    private void drawClip(Graphics g, int x, int y, int nClipID, int nFlag) {
        if (nFlag == 15) {
            return;
        }
        if ((nFlag & 7) == 0 || (nFlag & 7) == 2 || (nFlag & 7) == 4) {
            this.drawImgClip(g, x, y, this.m_doc.m_anClipImg[nClipID], nFlag);
            return;
        }
        switch (nFlag) {
            case 1: 
            case 3: {
                this.drawEllipse(g, x, y, this.m_doc.m_anClipEllipse[nClipID], nFlag);
                break;
            }
            case 5: {
                this.drawLineClip(g, x, y, this.m_doc.m_anClipLine[nClipID], nFlag);
                break;
            }
            case 7: 
            case 9: {
                this.drawRectClip(g, x, y, this.m_doc.m_anClipRect[nClipID], nFlag);
                break;
            }
            case 11: 
            case 13: {
                this.drawRoundRectClip(g, x, y, this.m_doc.m_anClipRoundRect[nClipID], nFlag);
                break;
            }
        }
    }

    private void drawRoundRectClip(Graphics g, int x, int y, int[] an, int nFlag) {
        g.setColor(an[4]);
        if (nFlag == 11) {
            g.drawRoundRect(x, y, an[0], an[1], an[2], an[3]);
        } else if (nFlag == 13) {
            g.fillRoundRect(x, y, an[0], an[1], an[2], an[3]);
        }
    }

    private void drawRectClip(Graphics g, int x, int y, int[] an, int nFlag) {
        g.setColor(an[2]);
        if (nFlag == 7) {
            g.drawRect(x, y, an[0], an[1]);
        } else if (nFlag == 9) {
            g.fillRect(x, y, an[0], an[1]);
        }
    }

    private void drawLineClip(Graphics g, int x, int y, int[] an, int nFlag) {
        g.setColor(an[2]);
        g.drawLine(x, y, this.m_nAniX + an[0], this.m_nAniY + an[1]);
    }

    private void drawEllipse(Graphics g, int x, int y, int[] an, int nFlag) {
        g.setColor(an[4]);
        if (nFlag == 1) {
            g.drawArc(x, y, an[0], an[1], an[2], an[3]);
        } else if (nFlag == 3) {
            g.fillArc(x, y, an[0], an[1], an[2], an[3]);
        }
    }

    private void drawImgClip(Graphics g, int x, int y, int[] anClipData, int nFlag) {
        int nImgID = anClipData[0];
        int nClipX = anClipData[1];
        int nClipY = anClipData[2];
        int nClipW = anClipData[3];
        int nClipH = anClipData[4];
        int nClipImgBufID = anClipData[5];
        Image imgClip = this.m_doc.m_aimgClipImgBuf[nClipImgBufID];
        if ((nFlag & 2) == 2) {
            if (!this.m_doc.m_bSplitImg) {
                GraphicsTool.drawRegion(g, this.m_doc.m_aimgSource[nImgID], nClipX, nClipY, nClipW, nClipH, 2, x, y, 20);
            } else {
                GraphicsTool.drawRegion(g, imgClip, 0, 0, imgClip.getWidth(), imgClip.getHeight(), 2, x, y, 20);
            }
        } else if ((nFlag & 4) == 4) {
            if (!this.m_doc.m_bSplitImg) {
                GraphicsTool.drawRegion(g, this.m_doc.m_aimgSource[nImgID], nClipX, nClipY, nClipW, nClipH, 1, x, y, 20);
            } else {
                GraphicsTool.drawRegion(g, imgClip, 0, 0, imgClip.getWidth(), imgClip.getHeight(), 1, x, y, 20);
            }
        } else {
            if (!this.m_doc.m_bSplitImg) {
                GraphicsTool.drawRegion(g, this.m_doc.m_aimgSource[nImgID], nClipX, nClipY, nClipW, nClipH, 0, x, y, 20);
            } else {
                g.setClip(x, y, imgClip.getWidth(), imgClip.getHeight());
                g.drawImage(imgClip, x, y, 20);
            }
            GraphicsTool.restClip(g);
        }
    }

    private void drawFrame(Graphics g, int x, int y, int nFrameID) {
        nFrameID = this.m_doc.m_anFramePool[nFrameID][0];
        if (this.m_doc.m_anFrameClipPool == null) {
            return;
        }
        int[][] anClipList = this.m_doc.m_anFrameClipPool[nFrameID];
        for (int i = 0; i < anClipList.length; ++i) {
            if (anClipList[i][3] == 15) continue;
            this.drawClip(g, x + anClipList[i][1], y + anClipList[i][2], anClipList[i][0], anClipList[i][3]);
        }
    }

    private void drawAnimation(Graphics g, int x, int y) {
        this.m_nAniX = x;
        this.m_nAniY = y;
        this.drawFrame(g, x, y, this.m_nCurrFrameID);
    }

    public void paint(Graphics g, int x, int y) {
        this.drawAnimation(g, x, y);
    }

    public boolean update() {
        if (this.m_doc.m_anAniPool == null) {
            return true;
        }
        if (this.m_nCurrFrameID < this.m_doc.m_anAniPool[this.m_nCurrAniID][0] || this.m_nCurrFrameID > this.m_doc.m_anAniPool[this.m_nCurrAniID][1]) {
            this.m_nCurrFrameID = this.m_doc.m_anAniPool[this.m_nCurrAniID][0];
            return true;
        }
        if (this.m_nCurrFrameID < this.m_doc.m_anAniPool[this.m_nCurrAniID][1]) {
            if (this.m_nCurrFrameDelay >= this.m_doc.m_anFramePool[this.m_nCurrFrameID][1] - 1) {
                ++this.m_nCurrFrameID;
                this.m_nCurrFrameDelay = 0;
            } else {
                ++this.m_nCurrFrameDelay;
            }
            return true;
        }
        if (this.m_nLoopCnt == -1) {
            this.m_nCurrFrameID = this.m_doc.m_anAniPool[this.m_nCurrAniID][0];
            return true;
        }
        if (this.m_nCurrPlayCnt + 1 < this.m_nLoopCnt) {
            this.m_nCurrFrameID = this.m_doc.m_anAniPool[this.m_nCurrAniID][0];
            ++this.m_nCurrPlayCnt;
            return true;
        }
        this.is_playing = false;
        return false;
    }

    public boolean isPlaying() {
        return this.is_playing;
    }

    public void setAnimation(int nAniID, int nLoopCnt) {
        this.m_nCurrPlayCnt = 0;
        this.m_nCurrFrameID = this.m_doc.m_anAniPool[this.m_nCurrAniID][0];
        this.is_playing = true;
        this.m_nCurrAniID = nAniID;
        this.m_nLoopCnt = nLoopCnt;
        this.update();
    }

    public int[] getRect() {
        return this.getRect(this.m_nCurrAniID, this.m_nCurrFrameID - this.m_doc.m_anAniPool[this.m_nCurrAniID][0]);
    }

    public int[] getRect(int nAniID, int nFrameIdx) {
        if (this.m_doc.m_anFrameClipPool == null) {
            return null;
        }
        int nFrameID = this.m_doc.m_anAniPool[nAniID][0] + nFrameIdx;
        int[][] anClipList = this.m_doc.m_anFrameClipPool[nFrameID];
        int[] an = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
        for (int i = 0; i < anClipList.length; ++i) {
            int nFlag = anClipList[i][3];
            if ((nFlag &= 7) != 0 && nFlag != 2 && nFlag != 4) continue;
            int nClipID = anClipList[i][0];
            int[] anSize = new int[]{this.m_doc.m_anClipImg[nClipID][1], this.m_doc.m_anClipImg[nClipID][2]};
            an[0] = Math.min(an[0], anClipList[i][1]);
            an[1] = Math.min(an[1], anClipList[i][2]);
            an[2] = Math.max(an[2], anClipList[i][1] + anSize[0]);
            an[3] = Math.max(an[3], anClipList[i][2] + anSize[1]);
        }
        return an;
    }

    public void refreshColiRect() {
        int nFrameID = this.m_doc.m_anFramePool[this.m_nCurrFrameID][0];
        int[][] anClipList = this.m_doc.m_anFrameClipPool[nFrameID];
        this.m_nCurrColiCnt = 0;
        for (int i = 0; i < anClipList.length; ++i) {
            if (anClipList[i][3] != 15) continue;
            int nClipID = anClipList[i][0];
            this.m_anCurrColiRc[this.m_nCurrColiCnt][0] = anClipList[i][1] + this.m_nAniX;
            this.m_anCurrColiRc[this.m_nCurrColiCnt][1] = anClipList[i][2] + this.m_nAniY;
            this.m_anCurrColiRc[this.m_nCurrColiCnt][2] = this.m_doc.m_anClipCollision[nClipID][0];
            this.m_anCurrColiRc[this.m_nCurrColiCnt][3] = this.m_doc.m_anClipCollision[nClipID][1];
            ++this.m_nCurrColiCnt;
        }
    }

    public boolean isCollision(AnuPlayer player2) {
        this.refreshColiRect();
        player2.refreshColiRect();
        int[][] anColis1 = this.m_anCurrColiRc;
        int[][] anColis2 = player2.m_anCurrColiRc;
        for (int i = 0; i < this.m_nCurrColiCnt; ++i) {
            for (int j = 0; j < player2.m_nCurrColiCnt; ++j) {
                boolean b = this.checkRectCross(anColis1[i], anColis2[j]);
                if (!b) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkRectCross(int[] an1, int[] an2) {
        if (an1[0] < an2[0] && an1[0] + an1[2] < an2[0]) {
            return false;
        }
        if (an2[0] < an1[0] && an2[0] + an2[2] < an1[0]) {
            return false;
        }
        if (an1[1] < an2[1] && an1[1] + an1[3] < an2[1]) {
            return false;
        }
        return an2[1] >= an1[1] || an2[1] + an2[3] >= an1[1];
    }
}

