/*
 * Decompiled with CFR 0.152.
 */
package HG.Tool;

import HG.Main.MainCanvas;
import HG.Scene.ScenePublic;
import HG.Tool.GraphicsTool;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TextTool {
    private final char sign = (char)42;
    private final char sign_special = (char)35;
    private int draw_x = 0;
    private int draw_y = 0;
    private int draw_width = 0;
    private int page_showID = 0;
    private int page_maxline = 0;
    private int page_showline = 0;
    private boolean is_sequence = false;
    private boolean is_up_sequence = false;
    private int special_x = 0;
    private int special_index = 0;
    private boolean is_own_special = false;
    private boolean is_typewriting = false;
    private boolean is_endInSpl = false;
    private int typewrite_index = 0;
    private String[] string = null;
    private String[] special_string = null;
    private boolean[] special_colour = null;
    public static final byte TEXT_LEFT = 0;
    public static final byte TEXT_RIGHT = 1;
    public static final byte TEXT_CENTER = 2;
    private static int char_width = 0;
    private static int char_height = 0;
    private static int char_space = 0;
    private static int char_lineheight = 0;
    private final int char_rollspeed;
    private int char_rolly = 0;
    public boolean is_rollend = false;
    private int typewrite_line_x = 0;
    private int typewrite_line_y = 0;
    private int typewrite_line_showtime = 0;
    public static Font font = null;
    private Vector vector = new Vector();
    private Vector colour = new Vector();
    public Image img_number_small = null;
    public Image img_number_mid = null;
    public Image img_number_big = null;
    public static final byte NUMBER_SMALL = 0;
    public static final byte NUMBER_MIDDLE = 1;
    public static final byte NUMBER_BIG = 2;
    public static final byte NUMBER_PLUS = 10;
    public static final byte NUMBER_PER = 12;
    public static final byte NUMBER_DIV = 12;
    public final int number_small_w;
    public final int number_small_h;
    public final int number_middle_w;
    public final int number_middle_h;
    public final int number_big_w;
    public final int number_big_h;

    public TextTool(Font ft) {
        this.char_rollspeed = 2;
        this.number_small_w = 6;
        this.number_small_h = 8;
        this.number_middle_w = 9;
        this.number_middle_h = 12;
        this.number_big_w = 8;
        this.number_big_h = 12;
        font = ft == null ? Font.getFont((int)0, (int)0, (int)8) : ft;
        char_height = font.getHeight();
        char_width = font.charWidth('\u811a');
        char_space = 2;
        char_lineheight = 0;
    }

    public TextTool() {
        this(Font.getFont((int)0, (int)0, (int)8));
    }

    public void setFont(Graphics g) {
        g.setFont(font);
    }

    public static int getCharWidth(char character) {
        return font.charWidth(character);
    }

    public static int getCharWidth() {
        return char_width;
    }

    public static int getCharHeight() {
        return char_height;
    }

    public static int stringWidth(String str) {
        return font.stringWidth(str);
    }

    public static int getCharSpace() {
        return char_space;
    }

    public static int getCharDistance() {
        return char_lineheight + char_height;
    }

    public static int getLineSpace() {
        return char_lineheight;
    }

    public static void setSpace(int width, int height) {
        char_width = width;
        char_lineheight = height;
    }

    public static int getShowLine(int height) {
        return height / (char_height + char_lineheight);
    }

    public String[] getStringArray() {
        return this.string;
    }

    public static String[] spliteString(String string, char sign) {
        int number = 0;
        char[] content = string.toCharArray();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < content.length; ++i) {
            if (content[i] != sign) continue;
            ++number;
        }
        String[] dis_string = new String[number];
        number = 0;
        for (int i = 0; i < content.length; ++i) {
            if (content[i] == sign) {
                dis_string[number] = buffer.toString();
                buffer.delete(0, buffer.length());
                ++number;
                continue;
            }
            buffer.append(content[i]);
        }
        buffer = null;
        content = null;
        System.gc();
        return dis_string;
    }

    public String[] spliteString(String str, int width) {
        int beginID = 0;
        int endID = 0;
        int lineWidth = 0;
        int strlen = str.length();
        boolean is_endline = false;
        for (int i = 0; i < strlen; ++i) {
            is_endline = false;
            if (i == strlen - 1 && str.charAt(i) != '*') {
                endID = i + 1;
                is_endline = true;
            } else if (str.charAt(i) == '*') {
                endID = i;
                is_endline = true;
            } else {
                lineWidth = font.substringWidth(str, beginID, i - beginID + 1);
                if (lineWidth >= width) {
                    endID = i;
                    is_endline = true;
                }
            }
            if (!is_endline) continue;
            this.vector.addElement(str.substring(beginID, endID));
            beginID = endID < strlen && str.charAt(endID) == '*' ? endID + 1 : endID;
        }
        Object[] dis_string = new String[this.vector.size()];
        this.vector.copyInto(dis_string);
        this.vector.removeAllElements();
        System.gc();
        return dis_string;
    }

    public static String[] spliteString(String str, int width, char sign) {
        int beginID = 0;
        int endID = 0;
        int lineWidth = 0;
        int strlen = str.length();
        boolean is_endline = false;
        Vector<String> v_strbuff = new Vector<String>();
        for (int i = 0; i < strlen; ++i) {
            is_endline = false;
            if (i == strlen - 1 && str.charAt(i) != sign) {
                endID = i + 1;
                is_endline = true;
            } else if (str.charAt(i) == sign) {
                endID = i;
                is_endline = true;
            } else {
                lineWidth = font.substringWidth(str, beginID, i - beginID + 1);
                if (lineWidth >= width) {
                    endID = i;
                    is_endline = true;
                }
            }
            if (!is_endline) continue;
            v_strbuff.addElement(str.substring(beginID, endID));
            beginID = endID < strlen && str.charAt(endID) == sign ? endID + 1 : endID;
        }
        Object[] dis_string = new String[v_strbuff.size()];
        v_strbuff.copyInto(dis_string);
        v_strbuff.removeAllElements();
        System.gc();
        return dis_string;
    }

    public void initText(String str, int x, int y, int width, int line) {
        this.resetText();
        this.draw_x = x;
        this.draw_y = y;
        this.draw_width = width;
        this.string = this.spliteString(str, this.draw_width);
        this.is_typewriting = true;
        this.typewrite_index = 0;
        this.is_endInSpl = false;
        this.page_showID = 0;
        this.page_maxline = this.string.length;
        this.page_showline = line >= this.string.length ? this.string.length : line;
        System.gc();
    }

    public void initText(int x, int y, int width, int line) {
        this.draw_x = x;
        this.draw_y = y;
        this.draw_width = width;
        this.page_showID = 0;
        this.page_maxline = this.string.length;
        this.page_showline = line >= this.string.length ? this.string.length : line;
    }

    public void drawText(Graphics g, int anchor) {
        if (null == this.string) {
            System.out.println("text splite error");
            return;
        }
        GraphicsTool.restClip(g);
        block5: for (int i = 0; i < this.page_showline; ++i) {
            if (this.page_showID + i >= this.page_maxline) continue;
            switch (anchor) {
                case 0: {
                    g.drawString(this.string[this.page_showID + i], this.draw_x, this.draw_y + (char_lineheight + char_height) * i, 20);
                    continue block5;
                }
                case 1: {
                    g.drawString(this.string[this.page_showID + i], this.draw_x + (this.draw_width - TextTool.stringWidth(this.string[this.page_showID + i])), this.draw_y + (char_lineheight + char_height) * i, 20);
                    continue block5;
                }
                case 2: {
                    g.drawString(this.string[this.page_showID + i], this.draw_x + (this.draw_width - TextTool.stringWidth(this.string[this.page_showID + i]) >> 1), this.draw_y + (char_lineheight + char_height) * i, 20);
                    continue block5;
                }
                default: {
                    MainCanvas.debug("drawText anchor error!");
                }
            }
        }
        if (this.is_sequence) {
            if (this.is_up_sequence) {
                this.keyPageUp(true);
            } else {
                this.keyPageDown(true);
            }
        }
    }

    public void drawText(Graphics g, int fontcolor, int bkcolor, int anchor) {
        if (null == this.string) {
            System.out.println("text splite error");
            return;
        }
        GraphicsTool.restClip(g);
        block5: for (int i = 0; i < this.page_showline; ++i) {
            if (this.page_showID + i >= this.page_maxline) continue;
            switch (anchor) {
                case 0: {
                    this.drawOutlineString(g, this.string[this.page_showID + i], fontcolor, bkcolor, this.draw_x, this.draw_y + (char_lineheight + char_height) * i, 20);
                    continue block5;
                }
                case 1: {
                    this.drawOutlineString(g, this.string[this.page_showID + i], fontcolor, bkcolor, this.draw_x + (this.draw_width - TextTool.stringWidth(this.string[this.page_showID + i])), this.draw_y + (char_lineheight + char_height) * i, 20);
                    continue block5;
                }
                case 2: {
                    this.drawOutlineString(g, this.string[this.page_showID + i], fontcolor, bkcolor, this.draw_x + (this.draw_width - TextTool.stringWidth(this.string[this.page_showID + i]) >> 1), this.draw_y + (char_lineheight + char_height) * i, 20);
                    continue block5;
                }
                default: {
                    MainCanvas.debug("drawText anchor error!");
                }
            }
        }
        if (this.is_sequence) {
            if (this.is_up_sequence) {
                this.keyPageUp(true);
            } else {
                this.keyPageDown(true);
            }
        }
    }

    public void drawTextRoll(Graphics g, int begin_color, int color, int end_color, int height) {
        if (null == this.string) {
            System.out.println("text splite error");
            return;
        }
        this.char_rolly = this.char_rolly >= height + this.string.length * TextTool.getCharDistance() ? 0 : (this.char_rolly += 2);
        g.setClip(this.draw_x, this.draw_y, this.draw_width, height);
        for (int i = 0; i < this.string.length; ++i) {
            if (this.draw_y + height - this.char_rolly + i * TextTool.getCharDistance() > this.draw_y + height - TextTool.getCharHeight()) {
                g.setColor(begin_color);
            } else if (this.draw_y + height - this.char_rolly + i * TextTool.getCharDistance() < this.draw_y) {
                g.setColor(end_color);
            } else {
                g.setColor(color);
            }
            g.drawString(this.string[i], this.draw_x, this.draw_y + height - this.char_rolly + i * TextTool.getCharDistance(), 20);
        }
    }

    private void checkSpecialWord(String str) {
        int beginID = 0;
        boolean is_special = false;
        this.is_own_special = false;
        if (this.special_index == 1) {
            is_special = true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '#') {
                String str_split;
                this.is_own_special = true;
                boolean bl = is_special = !is_special;
                if (is_special) {
                    str_split = str.substring(beginID, i);
                    if (str_split.length() > 0) {
                        this.special_index = 0;
                        this.vector.addElement(str_split);
                        this.colour.addElement(String.valueOf(this.special_index));
                    }
                    if (i == str.length() - 1) {
                        this.special_index = 1;
                    }
                } else {
                    this.special_index = 1;
                    str_split = str.substring(beginID, i);
                    this.vector.addElement(str_split);
                    this.colour.addElement(String.valueOf(this.special_index));
                    if (i == str.length() - 1) {
                        this.special_index = 0;
                    }
                }
                beginID = i + 1;
                continue;
            }
            if (i != str.length() - 1) continue;
            this.special_index = is_special ? 1 : 0;
            this.colour.addElement(String.valueOf(this.special_index));
            this.vector.addElement(str.substring(beginID, str.length()));
            is_special = false;
        }
        if (this.is_own_special) {
            this.special_string = null;
            this.special_string = new String[this.vector.size()];
            this.vector.copyInto(this.special_string);
            this.special_colour = null;
            this.special_colour = new boolean[this.colour.size()];
            for (int pos = 0; pos < this.colour.size(); ++pos) {
                this.special_colour[pos] = Integer.parseInt((String)this.colour.elementAt(pos)) != 0;
            }
        }
        this.vector.removeAllElements();
        this.colour.removeAllElements();
    }

    public void resetSpecialWord() {
        this.resetText();
        this.special_string = null;
        this.special_colour = null;
        System.gc();
    }

    public void drawSpecialText(Graphics g, int colour, int spl_colour) {
        if (null == this.string) {
            System.out.println("text splite error");
            return;
        }
        GraphicsTool.restClip(g);
        for (int i = 0; i < this.page_showline; ++i) {
            this.checkSpecialWord(this.string[this.page_showID + i]);
            if (this.page_showID + i >= this.page_maxline) continue;
            if (this.is_own_special) {
                this.special_x = 0;
                for (int j = 0; j < this.special_string.length; ++j) {
                    if (this.special_colour[j]) {
                        g.setColor(spl_colour);
                    } else {
                        g.setColor(colour);
                    }
                    this.special_x = j > 0 ? (this.special_x += font.stringWidth(this.special_string[j - 1])) : this.draw_x;
                    g.drawString(this.special_string[j], this.special_x, this.draw_y + (char_lineheight + char_height) * i, 20);
                }
                continue;
            }
            g.setColor(colour);
            g.drawString(this.string[this.page_showID + i], this.draw_x, this.draw_y + (char_lineheight + char_height) * i, 20);
        }
        if (this.is_sequence) {
            if (this.is_up_sequence) {
                this.keyPageUp(true);
            } else {
                this.keyPageDown(true);
            }
        }
    }

    public void drawTypeText(MainCanvas mc, Graphics g, int colour, int spl_colour) {
        if (null == this.string) {
            System.out.println("text splite error");
            return;
        }
        boolean flag_colour = false;
        boolean is_splColour = false;
        if (this.is_endInSpl) {
            flag_colour = true;
            is_splColour = true;
        }
        if (!this.is_typewriting) {
            this.typewrite_index = 0;
            for (int i = 0; i < this.page_showline; ++i) {
                int index;
                int flag_count;
                if (this.page_showID + i < this.page_maxline) {
                    this.typewrite_index += this.string[this.page_showID + i].length();
                    flag_count = 0;
                    for (index = 0; index < this.string[this.page_showID + i].length(); ++index) {
                        if (this.string[this.page_showID + i].charAt(index) == '#') {
                            if (!flag_colour) {
                                is_splColour = true;
                                g.setColor(spl_colour);
                            } else {
                                is_splColour = false;
                                g.setColor(colour);
                            }
                            ++flag_count;
                            flag_colour = !flag_colour;
                            continue;
                        }
                        if (!is_splColour) {
                            g.setColor(colour);
                        } else {
                            g.setColor(spl_colour);
                        }
                        GraphicsTool.restClip(g);
                        g.drawChar(this.string[this.page_showID + i].charAt(index), this.draw_x + (index - flag_count) * (char_width + char_space), this.draw_y + (char_lineheight + char_height) * i, 20);
                    }
                    if (i != this.page_showline - 1) continue;
                    this.typewrite_line_x = this.draw_x + (this.string[this.page_showline - 1].length() - flag_count) * (char_width + char_space);
                    this.typewrite_line_y = this.draw_y + (char_lineheight + char_height) * (this.page_showline - 1);
                    ++this.typewrite_line_showtime;
                    this.typewrite_line_showtime %= 10;
                    if (this.typewrite_line_showtime > 5) continue;
                    GraphicsTool.fillRect(g, -1, 230, this.typewrite_line_y + (char_height >> 2), 2, char_height >> 1);
                    continue;
                }
                flag_count = 0;
                for (index = 0; index < this.string[this.page_showID + i - 1].length(); ++index) {
                    if (this.string[this.page_showID + i - 1].charAt(index) != '#') continue;
                    ++flag_count;
                }
                this.typewrite_line_x = this.draw_x + (this.string[this.page_showID + i - 1].length() - flag_count) * (char_width + char_space);
                this.typewrite_line_y = this.draw_y + (char_lineheight + char_height) * (i - 1);
                ++this.typewrite_line_showtime;
                this.typewrite_line_showtime %= 10;
                if (this.typewrite_line_showtime > 5) continue;
                GraphicsTool.fillRect(g, -1, 230, this.typewrite_line_y + (char_height >> 2), 2, char_height >> 1);
            }
        } else {
            int i;
            int typeline = 0;
            int curIndex = 0;
            int availine = 0;
            int fontAll = this.typewrite_index;
            for (i = 0; i < this.page_showline; ++i) {
                if (this.page_showID + i >= this.page_maxline) continue;
                ++availine;
                if (fontAll >= this.string[this.page_showID + i].length()) {
                    ++typeline;
                    fontAll -= this.string[this.page_showID + i].length();
                    continue;
                }
                curIndex = fontAll;
                break;
            }
            if (typeline >= availine) {
                this.is_typewriting = false;
            }
            for (i = 0; i < this.page_showline; ++i) {
                int index;
                if (this.page_showID + i >= this.page_maxline) continue;
                int flag_count = 0;
                if (i < typeline) {
                    for (index = 0; index < this.string[this.page_showID + i].length(); ++index) {
                        if (this.string[this.page_showID + i].charAt(index) == '#') {
                            if (!flag_colour) {
                                is_splColour = true;
                                g.setColor(spl_colour);
                            } else {
                                is_splColour = false;
                                g.setColor(colour);
                            }
                            ++flag_count;
                            flag_colour = !flag_colour;
                            continue;
                        }
                        if (!is_splColour) {
                            g.setColor(colour);
                        } else {
                            g.setColor(spl_colour);
                        }
                        g.drawChar(this.string[this.page_showID + i].charAt(index), this.draw_x + (index - flag_count) * (char_width + char_space), this.draw_y + (char_lineheight + char_height) * i, 20);
                    }
                    continue;
                }
                if (i != typeline) continue;
                for (index = 0; index < curIndex; ++index) {
                    if (this.string[this.page_showID + i].charAt(index) == '#') {
                        if (!flag_colour) {
                            is_splColour = true;
                            g.setColor(spl_colour);
                        } else {
                            is_splColour = false;
                            g.setColor(colour);
                        }
                        ++flag_count;
                        flag_colour = !flag_colour;
                        continue;
                    }
                    if (!is_splColour) {
                        g.setColor(colour);
                    } else {
                        g.setColor(spl_colour);
                    }
                    g.drawChar(this.string[this.page_showID + i].charAt(index), this.draw_x + (index - flag_count) * (char_width + char_space), this.draw_y + (char_lineheight + char_height) * i, 20);
                }
                if (this.string[this.page_showID + i].charAt(curIndex) == '#') {
                    if (!flag_colour) {
                        is_splColour = true;
                        g.setColor(spl_colour);
                    } else {
                        is_splColour = false;
                        g.setColor(colour);
                    }
                    flag_colour = !flag_colour;
                } else if (!is_splColour) {
                    g.setColor(colour);
                } else {
                    g.setColor(spl_colour);
                }
                ++this.typewrite_index;
            }
        }
    }

    public void drawString(Graphics g, String str, int x, int y, int anchor) {
        if ((anchor & 8) == 8) {
            x -= TextTool.stringWidth(str);
        } else if ((anchor & 1) == 1) {
            x -= TextTool.stringWidth(str) >> 1;
        }
        if ((anchor & 0x20) == 32) {
            y -= char_height;
        } else if ((anchor & 2) == 2) {
            y -= char_height >> 1;
        }
        g.setClip(0, y, 240, char_height << 1);
        g.drawString(str, x, y, 20);
    }

    public void drawString(Graphics g, String str, int colour, int x, int y, int anchor) {
        if ((anchor & 8) == 8) {
            x -= TextTool.stringWidth(str);
        } else if ((anchor & 1) == 1) {
            x -= TextTool.stringWidth(str) >> 1;
        }
        if ((anchor & 0x20) == 32) {
            y -= char_height;
        } else if ((anchor & 2) == 2) {
            y -= char_height >> 1;
        }
        g.setColor(colour);
        g.setClip(0, y, 240, char_height << 1);
        g.drawString(str, x, y, 20);
    }

    public void drawOutlineString(Graphics g, String str, int fontcolor, int bkcolor, int x, int y, int anchor) {
        if ((anchor & 8) == 8) {
            x -= TextTool.stringWidth(str);
        } else if ((anchor & 1) == 1) {
            x -= TextTool.stringWidth(str) >> 1;
        }
        if ((anchor & 0x20) == 32) {
            y -= char_height;
        } else if ((anchor & 2) == 2) {
            y -= char_height >> 1;
        }
        g.setClip(0, y - 2, 240, char_height << 1);
        g.setColor(bkcolor);
        g.drawString(str, x + 1, y, 20);
        g.drawString(str, x - 1, y, 20);
        g.drawString(str, x, y + 1, 20);
        g.drawString(str, x, y - 1, 20);
        g.setColor(fontcolor);
        g.drawString(str, x, y, 20);
    }

    public void drawBigFont(Graphics g, int x, int y, String txt, int nBgColor, int nForColor, Font font) {
        int h = char_height;
        Image img = Image.createImage((int)h, (int)h);
        Graphics gf = img.getGraphics();
        gf.setColor(nBgColor);
        gf.fillRect(0, 0, h, h);
        gf.setColor(nForColor);
        gf.setFont(font);
        gf.drawString(txt, 0, 0, 0);
        int[] ab = new int[h * h];
        img.getRGB(ab, 0, h, 0, 0, h, h);
        int hbig = h * 2;
        int[] abBig = new int[hbig * hbig];
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < h; ++j) {
                abBig[i * 2 * hbig + j * 2] = ab[i * h + j];
                abBig[i * 2 * hbig + j * 2 + 1] = ab[i * h + j];
                abBig[(i * 2 + 1) * hbig + j * 2] = ab[i * h + j];
                abBig[(i * 2 + 1) * hbig + j * 2 + 1] = ab[i * h + j];
            }
        }
        g.drawRGB(abBig, 0, hbig, x, y, hbig, hbig, true);
    }

    public void drawTip(Graphics g, int x, int y, int distance) {
        if (this.page_showline >= this.page_maxline) {
            return;
        }
        if (this.page_showID <= 0) {
            ScenePublic.drawPointer(g, x, y, distance, false, true, false, false);
        } else if (this.page_showID + this.page_showline >= this.page_maxline) {
            ScenePublic.drawPointer(g, x, y, distance, true, false, false, false);
        } else {
            ScenePublic.drawPointer(g, x, y, distance, true, true, false, false);
        }
    }

    public void keyPageUp(boolean sequence) {
        if (this.page_showID > 0) {
            --this.page_showID;
        }
        this.is_sequence = sequence;
        this.is_up_sequence = true;
    }

    public void keyPageDown(boolean sequence) {
        if (this.page_showID + this.page_showline < this.page_maxline) {
            ++this.page_showID;
        }
        this.is_sequence = sequence;
        this.is_up_sequence = false;
    }

    public void keyTypeNextText() {
        if (this.is_TypeWriting()) {
            this.setTypeWriting(false);
        } else if (this.page_showID + this.page_showline < this.page_maxline) {
            boolean flag_end = false;
            if (this.is_endInSpl) {
                flag_end = true;
            }
            for (int i = 0; i < this.page_showline; ++i) {
                for (int index = 0; index < this.string[this.page_showID + i].length(); ++index) {
                    if (this.string[this.page_showID + i].charAt(index) != '#') continue;
                    flag_end = !flag_end;
                }
            }
            this.is_endInSpl = flag_end;
            this.typewrite_index = 0;
            this.page_showID += this.page_showline;
            this.setTypeWriting(true);
        }
    }

    public void keyPageRelease() {
        this.is_sequence = false;
    }

    public boolean PageEnd() {
        return this.page_showID + this.page_showline >= this.page_maxline;
    }

    public void resetPage() {
        this.page_showID = 0;
    }

    public void resetText() {
        this.draw_x = 0;
        this.draw_y = 0;
        this.draw_width = 0;
        this.page_showID = 0;
        this.page_maxline = 0;
        this.page_showline = 0;
        this.char_rolly = 0;
        this.typewrite_index = 0;
        this.is_endInSpl = false;
        this.is_typewriting = false;
        this.string = null;
    }

    public boolean is_TypeWriting() {
        return this.is_typewriting;
    }

    public void setTypeWriting(boolean state) {
        this.is_typewriting = state;
    }

    public void loadNumber() {
        try {
            this.img_number_small = Image.createImage((String)"/num_small.png");
            this.img_number_mid = Image.createImage((String)"/num_mid.png");
            this.img_number_big = Image.createImage((String)"/num_big.png");
        }
        catch (IOException ex) {
            System.out.println("Number image error");
            ex.printStackTrace();
        }
    }

    public int getNumberWidth(int type) {
        switch (type) {
            case 0: {
                return 7;
            }
            case 1: {
                return 10;
            }
            case 2: {
                return 9;
            }
        }
        return -1;
    }

    public int getNumberHeight(int type) {
        switch (type) {
            case 0: {
                return 9;
            }
            case 1: {
                return 13;
            }
            case 2: {
                return 13;
            }
        }
        return -1;
    }

    public int getNumberArrayWidth(int type, int number) {
        if (number >= 0) {
            return String.valueOf(number).length() * this.getNumberWidth(type);
        }
        System.out.println("\u6570\u5b57\u8d1f\u6570\u8d8a\u754c");
        return -1;
    }

    public void drawNumberPic(Graphics g, int number, int x, int y, int type) {
        switch (type) {
            case 0: {
                g.setClip(x, y, 6, 8);
                g.drawImage(this.img_number_small, x - number * 6, y, 20);
                break;
            }
            case 1: {
                g.setClip(x, y, 9, 12);
                g.drawImage(this.img_number_mid, x - number * 9, y, 20);
                break;
            }
            case 2: {
                g.setClip(x, y, 8, 12);
                g.drawImage(this.img_number_big, x - number * 8, y, 20);
            }
        }
    }

    public void drawNumber(Graphics g, int number, int x, int y, int type) {
        if (number >= 0) {
            String tmp_str = String.valueOf(number);
            for (int i = 0; i < tmp_str.length(); ++i) {
                int n = tmp_str.charAt(i) - 48;
                this.drawNumberPic(g, n, x - i * this.getNumberWidth(type), y, type);
            }
        } else {
            System.out.println("\u6570\u5b57\u8d1f\u6570\u8d8a\u754c");
        }
    }

    public void drawNumberSymbol(Graphics g, Image image, int count, boolean is_symbol, int number, int x, int y) {
        int width = image.getWidth() / count;
        if (is_symbol) {
            g.setClip(x, y, width, image.getHeight());
            g.drawImage(image, x - number * width, y, 20);
        } else {
            String tmp_str = String.valueOf(number);
            for (int i = 0; i < tmp_str.length(); ++i) {
                int n = tmp_str.charAt(i) - 48;
                g.setClip(x - (tmp_str.length() - i - 1) * width, y, width, image.getHeight());
                g.drawImage(image, x - n * width - (tmp_str.length() - i - 1) * width, y, 20);
            }
        }
    }

    public void drawNumberSymbol(Graphics g, Image image, int count, int number, int x, int y) {
        int width = image.getWidth() / count;
        String tmp_str = String.valueOf(number);
        for (int i = 0; i < tmp_str.length(); ++i) {
            int n = tmp_str.charAt(i) - 48;
            g.setClip(x + i * width, y, width, image.getHeight());
            g.drawImage(image, x + (i - n) * width, y, 20);
        }
    }
}

