/*
 * Decompiled with CFR 0.152.
 */
package HG.Game;

import HG.Animation.ColRect;
import HG.Animation.PWPifLifeAnimations;
import HG.Game.GameActor;
import HG.Game.GameBullet;
import HG.Game.ItemBag;
import HG.Game.Weapon;
import HG.Game.WeaponBag;
import HG.Main.MainCanvas;
import HG.MotionWelder.AnuData;
import HG.MotionWelder.AnuPlayer;
import HG.MotionWelder.MSimpleAnimationPlayer;
import HG.MotionWelder.MSpriteLoader;
import HG.Public.Constant;
import HG.Scene.GameScene;
import HG.Tool.GraphicsTool;
import HG.Tool.KeySystem;
import HG.Tool.MathTool;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Player
extends GameActor {
    public static final byte STATUS_WAIT = 0;
    public static final byte STATUS_ATTACK = 1;
    public static final byte STATUS_SUPER_ATTACK_PLAYER_SPLITTER = 2;
    public static final byte STATUS_SUPER_ATTACK_PLAYER_CALLL_GOD = 3;
    public static final byte STATUS_SUPER_ATTACK_PLAYER_CALL_MASTER = 4;
    public static final byte STATUS_SUPER_ATTACK_PLAYER_INVINCIBLE = 5;
    public static final byte STATUS_SUPER_ATTACK_PLAYER_KING_ADVENT = 6;
    public static final byte STATUS_HURT = 7;
    public static final byte STATUS_BUMP = 8;
    public static final byte STATUS_LEVEL_UP = 9;
    public static final byte STATUS_CAUGHT = 10;
    public static final byte STATUS_PALSY = 11;
    public static final byte STATUS_IMPACT = 12;
    public static final byte STATUS_DEAD = 13;
    public static final byte STATUS_REVIVAL = 14;
    public static final byte SUB_STATUS_NORMAL = 0;
    public static final byte SUB_STATUS_EJECTING_RIGHT = 2;
    public static final byte SUB_STATUS_EJECTED_RIGHT = 3;
    public static final byte SUB_STATUS_EJECTING_TOP = 4;
    public static final byte SUB_STATUS_EJECTED_TOP = 5;
    public static final byte SUB_STATUS_LEVEL_UP_BEGIN = 6;
    public static final byte SUB_STATUS_LEVEL_UP_IN = 7;
    public static final byte SUB_STATUS_LEVEL_UP_END = 8;
    public static final byte SUB_STATUS_SUPERATK_BEGIN = 9;
    public static final byte SUB_STATUS_SUPERATK_IN = 10;
    public static final int PLAYER_PROPERTY_HP = 0;
    public static final int PLAYER_PROPERTY_MP = 1;
    public static final int PLAYER_PROPERTY_ATS = 2;
    public static final int PLAYER_PROPERTY_ATL = 3;
    public static final int PLAYER_PROPERTY_DFS = 4;
    public static final int PLAYER_PROPERTY_DFL = 5;
    public static final int PLAYER_PROPERTY_SPD = 6;
    public static final int PLAYER_PROPERTY_SP = 7;
    public static final int PLAYER_PROPERTY_LV = 8;
    public static final int PLAYER_PROPERTY_NEXT = 9;
    public static final int PLAYER_PROPERTY_SOUL = 10;
    public static final int PLAYER_PROPERTY_TOTAL_KILLED_ENEMY = 11;
    public static final int PLAYER_PROPERTY_POINT = 12;
    public static final int PLAYER_PROPERTY_MAGIC_SPLITTER = 13;
    public static final int PLAYER_PROPERTY_MAGIC_CALL_GOD = 14;
    public static final int PLAYER_PROPERTY_MAGIC_CALL_MASTER = 15;
    public static final int PLAYER_PROPERTY_MAGIC_HEALING = 16;
    public static final int PLAYER_PROPERTY_MAGIC_INVINCIBILITY = 17;
    public static final int PLAYER_PROPERTY_BULLET_LEVEL = 18;
    public static final int PLAYER_BORDER_CR_W = 30;
    public static final int PLAYER_BORDER_CR_H = 60;
    public static final int PLAYER_FLY_SPEED = 7;
    public static final int PLAYER_SPLITTER_SPEED = 10;
    public static final int PLAYER_BULLET_FLY_SPEED = 10;
    public static final int PLAYER_BULLET_LEAN_FLY_Y_SPEED = 4;
    public static final int PLAYER_BULLET_LEAN_FLY_X_SPEED = 8;
    public static final int PLAYER_HIT_FREEZE_TIME = 5;
    public static final int PLAYER_HURT_BY_FARATK = 4;
    public static final int PLAYER_HURT_BY_CLOSEATK = 4;
    public static final int PLAYER_HURT_BACK_SPEED = 14;
    public static final int PLAYER_HURT_BY_POISION_TIME = 3000;
    public static final int PLAYER_HURT_BY_POISION = 4;
    private static int player_Level = 0;
    private static int player_HP = 0;
    private static int player_Point = 0;
    private static int player_Souls = 0;
    private static int player_mana = 0;
    private static int player_point_Mana = 0;
    private long manaRestoreTime = 0L;
    private int player_point_Life = 99;
    private int player_point_DefClose = 12;
    private int player_point_DefFarAway = 6;
    private int player_point_Spirit = 3;
    private int player_point_AtkClose = 0;
    public int player_point_AtkFarAway = 6;
    public int player_FlySpeed = 7;
    private int player_LeanFlySpeed = 5;
    private static int[] player_Property = null;
    private int[] player_PropertyData = new int[]{232, 59, 10, 4, 5, 5, 7, 6, 1, 72, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static int player_totalKilledEnemy = 0;
    private static int player_deadCount = 0;
    private static int player_maxContinuousHits = 0;
    private static long player_totalPlayedTime = 0L;
    private static int player_bulletLevel = 0;
    private long time_lastHit = 0L;
    private long time_poison = 0L;
    private long time_poisonStart = 0L;
    private long time_poisonHold = 0L;
    private long time_palsy = 0L;
    private long time_palsyStart = 0L;
    private static long time_invincible = 0L;
    private long time_invincibleStart = 0L;
    private long time_lure = 0L;
    private long time_lureStart = 0L;
    private int continuousHits = 0;
    private int animID_playerAtk = 0;
    private PWPifLifeAnimations hero_bullet_pif = null;
    private boolean is_addBullet = true;
    private boolean is_freezeBullet = false;
    private PWPifLifeAnimations levelUP_pif = null;
    private MSimpleAnimationPlayer player_Dizzy = null;
    private MSimpleAnimationPlayer player_Confuse = null;
    public static int[] experience = new int[]{0, 72, 185, 347, 572, 880, 1297, 1855, 2592, 3552, 4785, 6347, 8300, 10712, 13657, 17215, 21472, 26520, 32457, 39387, 47420, 56672, 67265, 79327, 92992, 108400, 125697, 145035, 166572, 190472, 216905, 246047, 278080, 313192, 351577, 393435, 438972, 488400, 541937, 599807, 662240, 729472, 801745, 879307, 962412, 1051320, 1146297, 1247615, 1355552, 1470392, 1592425, 1721947, 1859260, 2004672, 2158497, 2321055, 2492672, 2673680, 2864417, 3065227, 3276460, 3498472, 3731625, 3976287, 4232832, 4501640, 4783097, 5077595, 5385532, 5707312, 6043345, 6394047, 6759840, 7141152, 7538417, 7952075, 8382572, 8830360, 9295897, 9779647, 10282080, 10803672, 11344905, 11906267, 12488252, 13091360, 13716097, 14362975, 15032512, 15725232, 16441665, 17182347, 17947820, 18738632, 19555337, 20398495, 21268672, 22166440, 23092377, 24047067, 1999999999};
    public Image img_missionItem = null;
    public Image img_MagicIcon = null;
    public static final byte MAGIC_ICON_SIZE = 14;
    public static byte player_useMagic_0 = 0;
    public static byte player_useMagic_star = (byte)-1;
    public static byte player_useMagic_pound = (byte)-1;
    private int player_MagicDamage = 8;
    public static short[] magic_ManaCost = new short[]{60, 95, 120, 100, 150};
    public static final int MAGIC_LEVEL_REQUIRE = 0;
    public static final int MAGIC_LEVEL0_POINT = 1;
    public static final int MAGIC_LEVEL1_POINT = 2;
    public static final int MAGIC_LEVEL2_POINT = 3;
    public static final int MAGIC_LEVEL3_POINT = 4;
    public static final int MAGIC_LEVEL4_POINT = 5;
    public static short[][] magic_Damage = new short[][]{{30, 40, 50, 60, 70}, {50, 60, 70, 80, 100}, {10, 15, 20, 25, 30}, {5000, 6000, 7000, 8000, 9000}, {130, 150, 200, 270, 320}};
    private static short[][] magic_LevelRequirement = new short[][]{{0, 0, 450, 1200, 2300, 3800}, {5, 0, 1000, 2500, 3300, 5300}, {8, 0, 1500, 3400, 6700, 9000}, {12, 0, 2000, 4500, 7000, 9500}, {17, 0, 3000, 5000, 8000, 9999}};
    private long time_renderPowerUp = 0L;
    private MSimpleAnimationPlayer levelUP = null;
    public static final int player_WeaponTypeDiff = 13;
    public static int player_WeaponType = 0;
    public Weapon player_useWeapon = null;
    public WeaponBag player_WeaponBag = new WeaponBag(18);
    public static final int PLAYER_HOLDMAX_WEAPON = 18;
    public ItemBag player_ItemBag = new ItemBag();
    private boolean is_inEatItem = false;
    private int animID_eatItem = 0;
    private MSimpleAnimationPlayer player_eatItem = null;
    public static final byte MISSIONITEM_HARROW = 0;
    public static final byte MISSIONITEM_BONE_CHERI = 1;
    public static final byte MISSIONITEM_BINANGLE = 2;
    public static final byte MISSIONITEM_DOUBLE_BLADE = 3;
    public static final byte MISSIONITEM_FIRE_SPEARH = 4;
    public static final byte MISSIONITEM_SIENRONG = 5;
    public static final byte MISSIONITEM_UNIVERSE_STICK = 6;
    public static boolean[] player_MissionItem = null;
    public static final byte PLAYER_HEADICON_NULL = 0;
    public static final byte PLAYER_HEADICON_HURT = 1;
    public static final byte PLAYER_HEADICON_SUPERATK = 2;
    public static final byte PLAYER_HEADICON_APPROCH_DEATH = 3;
    public static final byte PLAYER_HEADICON_LEVELUP = 4;
    public static final byte PLAYER_HEADICON_NONE = 5;
    public static byte state_headIconShow = 0;
    private Image img_comboNumStart = null;
    private Image img_comboNumEnd = null;
    private Image img_comboNameStart = null;
    private Image img_comboNameEnd = null;
    private int combo_x = 0;
    private int combo_y = 0;
    private int combo_frame = 0;
    private boolean is_comboBegin = false;
    private boolean is_comboFly = false;
    private int dead_sleepFrame = 0;
    public int dead_colorChange = 0;
    public int[] dead_colorData = null;
    private AnuPlayer icon_superAtk = null;
    private Image img_superFont = null;
    private int offset_superIcon = 0;
    private final int SPLITTER_SHADOW_INFO_COUNT;
    private int[][] splitterInfo = null;
    private int[][][] splitterShadowInfo = null;
    private PWPifLifeAnimations god_pif = null;
    private int godhit_count = 0;
    private long time_godhit = 0L;
    private PWPifLifeAnimations fireeye_pif = null;
    private int animID_fireeye = 0;
    private int fireeye_step = 0;
    private long time_fireeye = 0L;
    private int frame_fireeye = 0;
    private PWPifLifeAnimations invincible_Pif = null;
    public static boolean is_invincible = false;
    private PWPifLifeAnimations kingAdvent_Pif = null;
    private long time_kingAdvent = 0L;
    public static boolean is_crabHold = false;
    public static boolean is_boneHold = false;

    public Player(MainCanvas mc) {
        super(mc);
        this.SPLITTER_SHADOW_INFO_COUNT = 10;
        this.player_useWeapon = new Weapon(0);
        Player.changePlayerWeapon(this.player_useWeapon.weapon_id);
        this.player_WeaponBag.addWeapon(this.player_useWeapon);
        player_MissionItem = new boolean[]{false, false, false, false, false, false, false};
    }

    public void setCurState(byte newState, long time) {
        this.game.setDarkScreen(false);
        this.game.setShakeScreen(false);
        switch (newState) {
            case 0: {
                super.setCurState(newState, time);
                this.setRenderContent(10 + player_WeaponType * 13, true, time);
                break;
            }
            case 10: {
                super.setCurState(newState, time);
                state_headIconShow = 1;
                this.setRenderContent(3 + player_WeaponType * 13, true, time);
                break;
            }
            case 11: {
                super.setCurState(newState, time);
                state_headIconShow = 1;
                this.setRenderContent(3 + player_WeaponType * 13, true, time);
                this.setPalsyTime(3000L);
                this.player_Dizzy.setAnimation(0);
                this.player_Dizzy.setLoopOffset(-1);
                break;
            }
            case 12: {
                super.setCurState(newState, time);
                state_headIconShow = 1;
                this.setRenderContent(0, true, time);
                this.game.setShakeScreen(true);
                this.setY(this.getY() - 50);
                break;
            }
            case 1: {
                if (this.animID >= 4 + player_WeaponType * 13 && this.animID <= 9 + player_WeaponType * 13) break;
                this.animID_playerAtk = 4 + player_WeaponType * 13;
                super.setCurState(newState, time);
                this.setRenderContent(this.animID_playerAtk, false, time);
                break;
            }
            case 9: {
                if (this.getCurState() == 9 || this.isPlayerDead()) break;
                this.game.setDarkScreen(true);
                this.game.resetBulletPool();
                this.invokeBeginIncident(time, 5);
                state_headIconShow = (byte)4;
                this.setSubType(6);
                super.setCurState(newState, time);
                this.setRenderContent(11 + player_WeaponType * 13, false, time);
                break;
            }
            case 7: {
                super.setCurState(newState, time);
                this.setRenderContent(3 + player_WeaponType * 13, false, time);
                this.setX(this.getX() - 7);
                break;
            }
            case 13: {
                if (this.isPlayerDead()) break;
                this.setRelatePlayer(null);
                this.invokeBeginIncident(time, 6);
                this.game.setStopScrollBG(true);
                super.setCurState(newState, time);
                this.setRenderContent(3 + player_WeaponType * 13, false, time);
                this.vx = this.x - this.x_last >> 2;
                this.vy = this.y - this.y_last;
                if (this.vy > -MathTool.I2F(1) >> 1) {
                    this.vy = -MathTool.I2F(1) >> 1;
                }
                this.ax = 0;
                this.ay = MathTool.I2F(1) >> 1;
                this.dead_sleepFrame = 500;
                this.dead_colorData = GraphicsTool.createOpaqueData(0, 0, 240, 320);
                break;
            }
            case 14: {
                this.initGameActor(time, 0);
                ColRect crHero = this.getColRect(time, 0);
                super.setCurState(newState, time);
                this.setX(-crHero.w);
                this.setY(235);
                break;
            }
            case 8: {
                super.setCurState(newState, time);
                state_headIconShow = 1;
                this.setRenderContent(3 + player_WeaponType * 13, true, time);
                break;
            }
            case 2: {
                this.game.setDarkScreen(true);
                this.game.resetBulletPool();
                this.initSplitterShadowInfo();
                super.setCurState(newState, time);
                this.setSubType(9);
                this.invokeBeginIncident(time, 0);
                this.setRenderContent(11 + player_WeaponType * 13, false, time);
                this.icon_superAtk.setAnimation(1, 1);
                break;
            }
            case 3: {
                this.game.setDarkScreen(true);
                this.game.resetBulletPool();
                super.setCurState(newState, time);
                this.setSubType(9);
                this.invokeBeginIncident(time, 2);
                this.setRenderContent(11 + player_WeaponType * 13, false, time);
                this.icon_superAtk.setAnimation(1, 1);
                this.godhit_count = 0;
                this.time_godhit = time;
                break;
            }
            case 4: {
                this.game.setDarkScreen(true);
                this.game.resetBulletPool();
                super.setCurState(newState, time);
                this.setSubType(9);
                this.invokeBeginIncident(time, 1);
                this.setRenderContent(11 + player_WeaponType * 13, false, time);
                this.icon_superAtk.setAnimation(1, 1);
                this.fireeye_step = 0;
                break;
            }
            case 5: {
                this.game.setDarkScreen(true);
                this.game.resetBulletPool();
                super.setCurState(newState, time);
                this.setSubType(9);
                this.invokeBeginIncident(time, 3);
                this.setRenderContent(11 + player_WeaponType * 13, false, time);
                this.icon_superAtk.setAnimation(1, 1);
                break;
            }
            case 6: {
                this.game.setDarkScreen(true);
                this.game.resetBulletPool();
                super.setCurState(newState, time);
                this.setSubType(9);
                this.invokeBeginIncident(time, 4);
                this.setRenderContent(11 + player_WeaponType * 13, false, time);
                this.icon_superAtk.setAnimation(1, 1);
                break;
            }
            default: {
                super.setCurState(newState, time);
                this.setRenderContent(10 + player_WeaponType * 13, true, time);
            }
        }
    }

    public void initGameActor(long gameTime, int type) {
        try {
            this.game = this.canvas.sceneMgr.scene_game;
            if (Constant.is_haveSave) {
                MainCanvas.stream.LoadGame();
                this.resetPlayerData();
            }
            this.img_missionItem = GraphicsTool.loadImage("/menu/mission_icon.png");
            this.img_MagicIcon = GraphicsTool.loadImage("/menu/UI_03_icon.png");
            this.img_comboNumEnd = GraphicsTool.loadImage("/game/comboNumEnd.png");
            this.img_comboNameEnd = GraphicsTool.loadImage("/game/comboNameEnd.png");
            this.img_comboNumStart = this.img_comboNumEnd;
            this.img_comboNameStart = this.img_comboNameEnd;
            this.img_superFont = GraphicsTool.loadImage("/game/magic_bg_text.png");
            this.hero_bullet_pif = new PWPifLifeAnimations(MainCanvas.stream.getResDate("/Animation/bullet.trans"));
            this.levelUP_pif = new PWPifLifeAnimations(MainCanvas.stream.getResDate("/Animation/LevelUp.aej"), 0, true);
            this.loadMagicRes();
            this.player_eatItem = new MSimpleAnimationPlayer(MSpriteLoader.loadMSprite("/menu/effect_EatItem.anu", false, this.game), 0, 0);
            this.player_eatItem.setAnimation(this.animID_eatItem);
            this.player_eatItem.setLoopOffset(-1);
            this.levelUP = new MSimpleAnimationPlayer(MSpriteLoader.loadMSprite("/menu/Levelup.anu", false, this.game), 0, 0);
            this.levelUP.setAnimation(0);
            this.levelUP.setLoopOffset(-1);
            String[] asImgList = new String[]{"/game/magic_bg.png"};
            AnuData ad = new AnuData("/game/superAtkBg.anu", asImgList);
            ad.loadResAll();
            this.icon_superAtk = new AnuPlayer(ad);
            this.icon_superAtk.setAnimation(1, 1);
            this.game.bk_superAtk = new AnuPlayer(ad);
            this.game.bk_superAtk.setAnimation(0, -1);
            this.splitterInfo = new int[50][5];
            this.splitterShadowInfo = new int[this.splitterInfo.length][10][3];
            this.player_Dizzy = new MSimpleAnimationPlayer(MSpriteLoader.loadMSprite("/game/Dizzy.anu", false, this.game), 0, 0);
            this.player_Dizzy.setAnimation(0);
            this.player_Dizzy.setLoopOffset(-1);
            this.player_Confuse = new MSimpleAnimationPlayer(MSpriteLoader.loadMSprite("/game/Confuse.anu", false, this.game), 0, 0);
            this.player_Confuse.setAnimation(0);
            this.player_Confuse.setLoopOffset(-1);
            this.calculatePlayerProperty(true);
            Player.setKilledEnemy(0);
            Player.setDeadCount(0);
            Player.setMaxContinuousHits(0);
            Player.setTotalPlayedTime(0L);
            this.setShieldLife(0);
            Player.setBulletLevel(0);
            this.stopProcessing = false;
            is_invincible = false;
            this.time_kingAdvent = 0L;
            this.time_stopProcessing = 0L;
            playerHitLevel = 0;
            this.manaRestoreTime = 0L;
            this.setPoisonTime(0L);
            this.setRenderPowerUpTime(0L);
            Player.setInvincibleTime(0L);
            this.setX(60);
            this.setY(160);
            this.setRelatePlayer(null);
            this.setSubType(0);
            this.setCurState((byte)0, gameTime);
            this.setInUse(true);
        }
        catch (Exception ex) {
            MainCanvas.debug("\u52a0\u8f7d\u4e3b\u89d2\u8d44\u6e90\u51fa\u9519");
            ex.printStackTrace();
        }
    }

    public void renderGameActor(Graphics g, long gameTime) {
        if (this.getRelatePlayer() != null) {
            return;
        }
        if (this.getCurState() == 9) {
            if (this.getSubType() == 6) {
                GraphicsTool.restClip(g);
                this.levelUP.drawFrame(g, this.getX(), 160);
                this.levelUP.update();
                if (!this.levelUP.isPlaying()) {
                    this.levelUP.setAnimation(1);
                    this.levelUP.setLoopOffset(-1);
                    this.setSubType(7);
                }
            } else if (this.getSubType() == 7) {
                GraphicsTool.restClip(g);
                this.levelUP.drawFrame(g, this.getX(), 160);
                this.levelUP.update();
                if (!this.levelUP.isPlaying()) {
                    this.levelUP.setAnimation(1);
                    this.levelUP.setLoopOffset(-1);
                }
                if (this.game.getCurGameTime() - this.time_stateStart > 1500L) {
                    this.levelUP.setAnimation(2);
                    this.levelUP.setLoopOffset(-1);
                    this.setSubType(8);
                }
            } else {
                GraphicsTool.restClip(g);
                this.levelUP.drawFrame(g, this.getX(), 160);
                this.levelUP.update();
                if (!this.levelUP.isPlaying()) {
                    this.levelUP.setAnimation(0);
                    this.levelUP.setLoopOffset(-1);
                    this.game.setDarkScreen(false);
                    this.setCurState((byte)0, gameTime);
                    this.invokeEndIncident(gameTime, 5);
                    state_headIconShow = 0;
                }
            }
            if (!this.levelUP_pif.animationIsOver(0, (int)(gameTime - this.time_stateStart)) && this.getSubType() != 8) {
                this.levelUP_pif.drawAnimation(g, 0, (int)(gameTime - this.time_stateStart), this.getX(), this.getY() - Constant.Camera_y, false);
            }
        }
        if (this.getCurState() == 2) {
            if (this.getSubType() == 9) {
                GraphicsTool.restClip(g);
                this.icon_superAtk.paint(g, 120, 160 + this.offset_superIcon);
                this.icon_superAtk.update();
                if (!this.icon_superAtk.isPlaying()) {
                    this.icon_superAtk.setAnimation(1, 1);
                    this.setSubType(10);
                    this.invokeBeginIncident(gameTime, 0);
                }
                g.setClip(240 - this.img_superFont.getWidth(), 55 + this.img_superFont.getHeight() / 3, this.img_superFont.getWidth(), this.img_superFont.getHeight() / 3);
                g.drawImage(this.img_superFont, 240 - this.img_superFont.getWidth(), 55 + this.img_superFont.getHeight() / 3, 20);
            } else if (this.getSubType() == 10) {
                int i;
                GraphicsTool.restClip(g);
                for (i = 0; i < this.splitterShadowInfo.length; ++i) {
                    if (this.splitterShadowInfo[i][9][0] != -1) {
                        this.getAnimation().drawFrame(g, this.getAnimation().animations[this.splitterShadowInfo[i][9][0]] & 0xFF, this.splitterShadowInfo[i][9][1], this.splitterShadowInfo[i][9][2] - Constant.Camera_y, (byte)0, 50);
                    }
                    if (this.splitterShadowInfo[i][5][0] == -1) continue;
                    this.getAnimation().drawFrame(g, this.getAnimation().animations[this.splitterShadowInfo[i][5][0]] & 0xFF, this.splitterShadowInfo[i][5][1], this.splitterShadowInfo[i][5][2] - Constant.Camera_y, (byte)0, 50);
                }
                GraphicsTool.restClip(g);
                for (i = 0; i < this.splitterInfo.length; ++i) {
                    if (this.splitterInfo[i][4] == -1 || this.splitterInfo[i][0] > 9 + player_WeaponType * 13) continue;
                    this.getAnimation().drawAnimation(g, this.splitterInfo[i][0], gameTime - (long)this.splitterInfo[i][1], this.splitterInfo[i][2], this.splitterInfo[i][3] - Constant.Camera_y, true);
                    this.pushSplitterShadowInfo(i, this.getAnimation().getFramePos(this.splitterInfo[i][0], gameTime - (long)this.splitterInfo[i][1], true), this.splitterInfo[i][2], this.splitterInfo[i][3]);
                }
            }
        } else if (this.getCurState() == 3) {
            if (this.getSubType() == 9) {
                GraphicsTool.restClip(g);
                this.icon_superAtk.paint(g, 120, 160 + this.offset_superIcon);
                this.icon_superAtk.update();
                if (!this.icon_superAtk.isPlaying()) {
                    this.icon_superAtk.setAnimation(1, 1);
                    this.setSubType(10);
                    this.invokeBeginIncident(gameTime, 2);
                    this.setRenderContent(1 + player_WeaponType * 13, true, gameTime);
                }
                g.setClip(240 - this.img_superFont.getWidth(), 55 + this.img_superFont.getHeight() / 5, this.img_superFont.getWidth(), this.img_superFont.getHeight() / 5);
                g.drawImage(this.img_superFont, 240 - this.img_superFont.getWidth(), 55, 20);
            } else if (this.getSubType() == 10) {
                ColRect shakeRect;
                ColRect crHero = this.getColRect(gameTime, 0);
                GraphicsTool.restClip(g);
                if (this.god_pif.drawAnimation(g, 0, gameTime - this.time_godhit, this.getX() + (crHero.w >> 2), this.getY() - crHero.h - Constant.Camera_y, false) == -1) {
                    ++this.godhit_count;
                    this.time_godhit = gameTime;
                    if (this.godhit_count > 8) {
                        this.godhit_count = 0;
                        this.time_godhit = 0L;
                        state_headIconShow = 0;
                        this.setCurState((byte)0, gameTime);
                        this.invokeEndIncident(gameTime, 2);
                        this.game.setDarkScreen(false);
                    }
                }
                if ((shakeRect = this.god_pif.GetColRect(0, gameTime - this.time_godhit, true, 3)) != null && state_headIconShow != 0) {
                    this.game.setShakeScreen(true);
                } else {
                    this.game.setShakeScreen(false);
                }
            }
        } else if (this.getCurState() == 4) {
            if (this.getSubType() == 9) {
                GraphicsTool.restClip(g);
                this.icon_superAtk.paint(g, 120, 160 + this.offset_superIcon);
                this.icon_superAtk.update();
                if (!this.icon_superAtk.isPlaying()) {
                    this.icon_superAtk.setAnimation(1, 1);
                    this.setSubType(10);
                    this.invokeBeginIncident(gameTime, 1);
                    this.setRenderContent(1 + player_WeaponType * 13, true, gameTime);
                    this.time_fireeye = gameTime;
                    this.animID_fireeye = 0;
                }
                g.setClip(240 - this.img_superFont.getWidth(), 55 + this.img_superFont.getHeight() / 5, this.img_superFont.getWidth(), this.img_superFont.getHeight() / 5);
                g.drawImage(this.img_superFont, 240 - this.img_superFont.getWidth(), 55 - this.img_superFont.getHeight() / 5, 20);
            } else if (this.getSubType() == 10) {
                ColRect crHero = this.getColRect(gameTime, 0);
                GraphicsTool.restClip(g);
                switch (this.fireeye_step) {
                    case 0: {
                        if (this.fireeye_pif.drawAnimation(g, this.animID_fireeye, gameTime - this.time_fireeye, this.getX() + (crHero.w >> 2) + 128, this.getY() - crHero.h + 15 - Constant.Camera_y, false) != -1) break;
                        this.time_fireeye = gameTime;
                        ++this.fireeye_step;
                        this.animID_fireeye = 1;
                        break;
                    }
                    case 1: {
                        if (this.fireeye_pif.drawAnimation(g, this.animID_fireeye, gameTime - this.time_fireeye, this.getX() + (crHero.w >> 2) + 128, this.getY() - crHero.h + 15 - Constant.Camera_y, false) != -1 || gameTime - this.time_fireeye < 5000L) break;
                        this.time_fireeye = gameTime;
                        ++this.fireeye_step;
                        this.animID_fireeye = 2;
                        break;
                    }
                    case 2: {
                        if (this.fireeye_pif.drawAnimation(g, this.animID_fireeye, gameTime - this.time_fireeye, this.getX() + (crHero.w >> 2) + 128, this.getY() - crHero.h + 15 - Constant.Camera_y, false) != -1) break;
                        this.time_fireeye = 0L;
                        this.fireeye_step = 0;
                        this.animID_fireeye = 0;
                        this.game.setDarkScreen(false);
                        state_headIconShow = 0;
                        this.setCurState((byte)0, gameTime);
                        this.invokeEndIncident(gameTime, 1);
                    }
                }
            }
        } else if (this.getCurState() == 5) {
            if (this.getSubType() == 9) {
                GraphicsTool.restClip(g);
                this.icon_superAtk.paint(g, 120, 160 + this.offset_superIcon);
                this.icon_superAtk.update();
                if (!this.icon_superAtk.isPlaying()) {
                    this.icon_superAtk.setAnimation(1, 1);
                    this.setSubType(10);
                    this.invokeBeginIncident(gameTime, 3);
                    this.setRenderContent(1 + player_WeaponType * 13, true, gameTime);
                }
                g.setClip(240 - this.img_superFont.getWidth(), 55 + this.img_superFont.getHeight() / 3, this.img_superFont.getWidth(), this.img_superFont.getHeight() / 3);
                g.drawImage(this.img_superFont, 240 - this.img_superFont.getWidth(), 55, 20);
            } else if (this.getSubType() == 10) {
                this.game.setDarkScreen(false);
                state_headIconShow = 0;
                this.setCurState((byte)0, gameTime);
                this.invokeEndIncident(gameTime, 3);
                is_invincible = true;
                Player.setInvincibleTime(magic_Damage[3][Player.getMagicLevel(3)]);
            }
        } else if (this.getCurState() == 6) {
            if (this.getSubType() == 9) {
                GraphicsTool.restClip(g);
                this.icon_superAtk.paint(g, 120, 160 + this.offset_superIcon);
                this.icon_superAtk.update();
                if (!this.icon_superAtk.isPlaying()) {
                    this.time_kingAdvent = gameTime;
                    this.icon_superAtk.setAnimation(1, 1);
                    this.setSubType(10);
                    this.invokeBeginIncident(gameTime, 4);
                    this.setRenderContent(1 + player_WeaponType * 13, true, gameTime);
                }
                g.setClip(240 - this.img_superFont.getWidth(), 55 + this.img_superFont.getHeight() / 3, this.img_superFont.getWidth(), this.img_superFont.getHeight() / 3);
                g.drawImage(this.img_superFont, 240 - this.img_superFont.getWidth(), 55 - this.img_superFont.getHeight() / 3, 20);
            } else if (this.getSubType() == 10) {
                GraphicsTool.restClip(g);
                if (this.kingAdvent_Pif.drawAnimation(g, this.animID_fireeye, gameTime - this.time_kingAdvent, 120, 160, false) == -1) {
                    for (int i = 0; i < GameScene.actorPool.length; ++i) {
                        if (GameScene.actorPool[i] == null || !GameScene.actorPool[i].inUse || GameScene.actorPool[i].getType() != 1) continue;
                        crOther.Copy(GameScene.actorPool[i].getX(), GameScene.actorPool[i].getY(), GameScene.actorPool[i].getColRect(gameTime, 0));
                        if (GameScene.actorPool[i] == null || !GameScene.actorPool[i].inUse || GameScene.actorPool[i].getType() != 1) continue;
                        short damage = magic_Damage[4][Player.getMagicLevel(4)];
                        GameScene.actorPool[i].reduceLife(damage, 10, crOther, gameTime);
                    }
                    this.game.setDarkScreen(false);
                    state_headIconShow = 0;
                    this.setCurState((byte)0, gameTime);
                    this.invokeEndIncident(gameTime, 4);
                }
            }
        } else if (this.getCurState() == 11) {
            GraphicsTool.restClip(g);
            this.player_Dizzy.drawFrame(g, this.getX() - 15, this.getY() - 48 - Constant.Camera_y);
            this.player_Dizzy.update();
            if (!this.player_Dizzy.isPlaying()) {
                this.player_Dizzy.setAnimation(0);
                this.player_Dizzy.setLoopOffset(-1);
            }
        }
        if (this.is_comboBegin) {
            int word_x = 0;
            ++this.combo_frame;
            if (this.is_comboFly) {
                word_x = this.img_comboNumEnd.getWidth() / 10 + 10;
                this.combo_x += 10;
                if (this.combo_x > 240 + word_x * 2) {
                    this.is_comboFly = false;
                    this.is_comboBegin = false;
                    this.setContinuousHits(0);
                }
                this.canvas.text.drawNumberSymbol(g, this.img_comboNumEnd, 10, false, this.getContinuousHits(), this.combo_x, this.combo_y);
                GraphicsTool.restClip(g);
                g.drawImage(this.img_comboNameEnd, this.combo_x + word_x, this.combo_y + (this.img_comboNumEnd.getHeight() - this.img_comboNameEnd.getHeight()) / 2, 20);
            } else if (this.combo_frame <= 10) {
                word_x = this.img_comboNumStart.getWidth() / 10;
                this.canvas.text.drawNumberSymbol(g, this.img_comboNumStart, 10, false, this.getContinuousHits(), this.combo_x, this.combo_y);
                GraphicsTool.restClip(g);
                g.drawImage(this.img_comboNameStart, this.combo_x + word_x, this.combo_y + (this.img_comboNumStart.getHeight() - this.img_comboNameStart.getHeight()) / 2, 20);
            } else {
                word_x = this.img_comboNumEnd.getWidth() / 10;
                this.canvas.text.drawNumberSymbol(g, this.img_comboNumEnd, 10, false, this.getContinuousHits(), this.combo_x, this.combo_y);
                GraphicsTool.restClip(g);
                g.drawImage(this.img_comboNameEnd, this.combo_x + word_x, this.combo_y + (this.img_comboNumEnd.getHeight() - this.img_comboNameEnd.getHeight()) / 2, 20);
            }
        }
        if (is_invincible) {
            GraphicsTool.restClip(g);
            this.invincible_Pif.drawAnimation(g, 0, gameTime, this.getX(), this.getY() - 10 - Constant.Camera_y, true);
        } else if (Player.getInvincibleTime() > 0L && gameTime % 3L > 1L && this.getCurState() != 12 && this.getCurState() != 13) {
            return;
        }
        super.renderGameActor(g, gameTime);
        if (this.getPoisonTime() > 0L) {
            ColRect crHero = this.getColRect(gameTime, 0);
            int height = (int)(1000L - this.getPoisonTime() % 1000L);
            this.canvas.text.drawOutlineString(g, "-4", -1, 0xFF0000, this.getX() + (crHero.w >> 1), this.getY() - crHero.h - (height >>= 5) - Constant.Camera_y, 33);
        }
        if (this.is_inEatItem) {
            ColRect crHero = this.getColRect(gameTime, 0);
            this.player_eatItem.drawFrame(g, this.getX() + (crHero.w >> 2), this.getY() - Constant.Camera_y);
            this.player_eatItem.update();
            if (!this.player_eatItem.isPlaying()) {
                this.is_inEatItem = false;
            }
        }
        if (this.getLureTime() > 0L) {
            this.player_Confuse.drawFrame(g, this.getX() - 6, this.getY() - 50 - Constant.Camera_y);
            this.player_Confuse.update();
            if (!this.player_Confuse.isPlaying()) {
                this.player_Confuse.setAnimation(0);
                this.player_Confuse.setLoopOffset(-1);
            }
        }
    }

    public void process(long gameTime, GameActor[] actorPool) {
        if (this.getLife() <= 0 && this.getCurState() != 13) {
            this.setLife(0);
            this.setCurState((byte)13, gameTime);
        }
        if (this.isStopProcessing()) {
            if (gameTime - this.time_stopProcessing > (long)(5 * GameActor.playerHitLevel)) {
                this.setAllRoleStopProcessing(false, gameTime);
                this.game.setShakeScreen(false);
            }
            return;
        }
        if (this.manaRestoreTime == 0L) {
            this.manaRestoreTime = this.game.getCurGameTime();
        } else if (this.game.getCurGameTime() - this.manaRestoreTime > 1000L) {
            Player.setMana(Player.getMana() + this.player_point_Spirit);
            if (Player.getMana() > player_point_Mana) {
                Player.setMana(player_point_Mana);
            }
            this.manaRestoreTime = 0L;
        }
        if (Player.getInvincibleTime() > 0L) {
            if (this.time_invincibleStart == 0L) {
                this.time_invincibleStart = this.game.getCurGameTime();
            } else {
                long newTime = this.game.getCurGameTime() - this.time_invincibleStart;
                if (newTime >= Player.getInvincibleTime()) {
                    Player.setInvincibleTime(0L);
                    this.time_invincibleStart = 0L;
                    is_invincible = false;
                }
            }
        }
        if (this.getPalsyTime() > 0L) {
            if (this.time_palsyStart == 0L) {
                this.time_palsyStart = this.game.getCurGameTime();
            } else {
                long palsyTime = this.game.getCurGameTime() - this.time_palsyStart;
                if (this.getPalsyTime() - palsyTime <= 0L) {
                    this.setPalsyTime(0L);
                    this.time_palsyStart = 0L;
                    if (this.getLife() <= 0) {
                        this.setLife(0);
                        this.setCurState((byte)13, gameTime);
                    } else {
                        state_headIconShow = 0;
                        this.setCurState((byte)0, gameTime);
                    }
                }
            }
        }
        if (this.getLureTime() > 0L) {
            if (this.time_lureStart == 0L) {
                this.time_lureStart = this.game.getCurGameTime();
            } else {
                long lureTime = this.game.getCurGameTime() - this.time_lureStart;
                if (this.getLureTime() - lureTime <= 0L) {
                    this.setLureTime(0L);
                    this.time_lureStart = 0L;
                }
            }
        }
        if (this.getPoisonTime() > 0L) {
            if (this.time_poisonStart == 0L) {
                this.time_poisonStart = this.game.getCurGameTime();
                this.time_poisonHold = 0L;
            } else {
                long poisonTime = this.game.getCurGameTime() - this.time_poisonStart;
                if (this.getPoisonTime() - poisonTime <= 0L) {
                    this.setPoisonTime(0L);
                    this.time_poisonHold = 0L;
                    this.time_poisonStart = 0L;
                }
                if (poisonTime / 1000L == this.time_poisonHold) {
                    ++this.time_poisonHold;
                    if (this.getPoisonTime() > 0L) {
                        this.setLife(this.getLife() - 4);
                    }
                    if (this.getLife() <= 0) {
                        this.setLife(0);
                        this.setCurState((byte)13, gameTime);
                    }
                }
            }
        }
        switch (this.getCurState()) {
            case 0: {
                if (is_crabHold || is_boneHold) break;
                this.processWait(gameTime);
                break;
            }
            case 10: {
                if (!KeySystem.IsKeyPressed(262144) || this.getRelatePlayer() == null) break;
                this.getRelatePlayer().setPowerNewton(this.getRelatePlayer().getPowerNewton() + -10);
                break;
            }
            case 12: {
                long impactTime = this.game.getCurGameTime() - this.time_stateStart;
                if (this.animID == 3 + player_WeaponType * 13 && impactTime > 200L) {
                    this.setY(this.getY() + 25);
                    this.time_stateStart = 0L;
                    state_headIconShow = 0;
                    this.setCurState((byte)0, gameTime);
                    break;
                }
                if (impactTime <= 800L) break;
                this.game.setShakeScreen(false);
                if (this.animID == 3 + player_WeaponType * 13) break;
                this.setY(this.getY() + 25);
                this.setRenderContent(3 + player_WeaponType * 13, true, gameTime);
                break;
            }
            case 1: {
                this.processAttack(gameTime, actorPool);
                break;
            }
            case 13: {
                this.x += this.vx;
                this.y += this.vy;
                this.vy += this.ay;
                this.dead_sleepFrame = this.dead_sleepFrame <= 0 ? 0 : this.dead_sleepFrame - 50;
                MainCanvas.sleep(this.dead_sleepFrame);
                break;
            }
            case 14: {
                this.setX(this.getX() + 3);
                break;
            }
            case 7: {
                if (!is_crabHold && !is_boneHold) {
                    this.processKey(gameTime);
                }
                if (!this.isAnimationOver(gameTime)) break;
                this.setX(this.getX() - 14);
                state_headIconShow = 0;
                this.setCurState((byte)0, gameTime);
                break;
            }
            case 8: {
                if (this.getSubType() == 2) {
                    if (this.canMove(gameTime, -28, 0)) {
                        this.setX(this.getX() - 28);
                        break;
                    }
                    this.game.setShakeScreen(true);
                    this.setSubType(3);
                    break;
                }
                if (this.getSubType() == 4) {
                    if (this.canMove(gameTime, 0, 28)) {
                        this.setY(this.getY() + 28);
                        break;
                    }
                    this.game.setShakeScreen(true);
                    this.setSubType(5);
                    break;
                }
                if (this.getSubType() == 3) {
                    if (this.getX() < 28) {
                        if (this.canMove(gameTime, 7, 0)) {
                            this.setX(this.getX() + 7);
                            state_headIconShow = 0;
                            this.setCurState((byte)0, gameTime);
                            break;
                        }
                        this.game.setShakeScreen(false);
                        break;
                    }
                    this.game.setShakeScreen(false);
                    this.setCurState((byte)0, gameTime);
                    break;
                }
                if (this.getSubType() != 5) break;
                if (this.getY() > 267) {
                    this.game.setShakeScreen(true);
                    if (this.canMove(gameTime, 0, -7)) {
                        this.setY(this.getY() - 7);
                        state_headIconShow = 0;
                        this.setCurState((byte)0, gameTime);
                        break;
                    }
                    this.game.setShakeScreen(false);
                    break;
                }
                this.game.setShakeScreen(false);
                this.setCurState((byte)0, gameTime);
                break;
            }
            case 2: {
                if (this.getSubType() != 10) break;
                this.processSplitter(gameTime, actorPool);
                break;
            }
            case 3: {
                if (this.getSubType() != 10) break;
                this.processSuperGod(gameTime, actorPool);
                break;
            }
            case 4: {
                if (this.getSubType() != 10) break;
                this.processFireEyes(gameTime, actorPool);
                break;
            }
            case 5: {
                break;
            }
        }
        if (this.getContinuousHits() > 0 && gameTime - this.getLastHitTime() > 3000L) {
            this.setLastHitTime(0L);
            this.is_comboFly = true;
        }
        if (this.getLife() <= this.getMaxlife() * 3 / 10 && state_headIconShow == 0) {
            state_headIconShow = (byte)3;
        } else if (this.getLife() > this.getMaxlife() * 3 / 10 && state_headIconShow == 3) {
            state_headIconShow = 0;
        }
    }

    private void processWait(long gameTime) {
        if (KeySystem.IsKeyPressed(4) || KeySystem.IsKeyHold(4)) {
            if (!this.is_freezeBullet) {
                if (this.getLureTime() > 0L) {
                    if (this.animID != 10 + player_WeaponType * 13) {
                        this.setRenderContent(10 + player_WeaponType * 13, true, gameTime);
                    }
                } else if (this.animID != 2 + player_WeaponType * 13) {
                    this.setRenderContent(2 + player_WeaponType * 13, true, gameTime);
                }
            } else if (this.getLureTime() > 0L) {
                if (this.animID != 1 + player_WeaponType * 13) {
                    this.setRenderContent(1 + player_WeaponType * 13, true, gameTime);
                }
            } else if (this.animID != 13 + player_WeaponType * 13) {
                this.setRenderContent(13 + player_WeaponType * 13, true, gameTime);
            }
        } else if (this.is_freezeBullet) {
            if (this.getLureTime() > 0L) {
                if (this.animID != 13 + player_WeaponType * 13) {
                    this.setRenderContent(13 + player_WeaponType * 13, true, gameTime);
                }
            } else if (this.animID != 1 + player_WeaponType * 13) {
                this.setRenderContent(1 + player_WeaponType * 13, true, gameTime);
            }
        } else if (this.getLureTime() > 0L) {
            if (this.animID != 2 + player_WeaponType * 13) {
                this.setRenderContent(2 + player_WeaponType * 13, true, gameTime);
            }
        } else if (this.animID != 10 + player_WeaponType * 13) {
            this.setRenderContent(10 + player_WeaponType * 13, true, gameTime);
        }
        this.processKey(gameTime);
        if (!this.is_freezeBullet) {
            ColRect bulletRect = this.getColRect(gameTime, 1);
            if (bulletRect != null) {
                if (this.is_addBullet) {
                    GameActor bullet2;
                    if (Player.getBulletLevel() == 0) {
                        bullet2 = this.getABullet(gameTime, bulletRect);
                        this.adjustBullet(gameTime, bulletRect, bullet2, 0);
                    } else if (Player.getBulletLevel() == 1) {
                        bullet2 = this.getABullet(gameTime, bulletRect);
                        this.adjustBullet(gameTime, bulletRect, bullet2, 1);
                    }
                    if (Player.getBulletLevel() == 2) {
                        for (int bulletCount = 0; bulletCount < 3; ++bulletCount) {
                            GameActor bullet3 = this.getABullet(gameTime, bulletRect);
                            this.adjustBullet(gameTime, bulletRect, bullet3, 2 + bulletCount);
                            if (bulletCount == 0) {
                                bullet3.setVx(8);
                                bullet3.setVy(-4);
                                continue;
                            }
                            if (bulletCount != 2) continue;
                            bullet3.setVx(8);
                            bullet3.setVy(4);
                        }
                    } else if (Player.getBulletLevel() == 3) {
                        for (int bulletCount = 0; bulletCount < 3; ++bulletCount) {
                            GameActor bullet4 = this.getABullet(gameTime, bulletRect);
                            this.adjustBullet(gameTime, bulletRect, bullet4, 5 + bulletCount);
                            if (bulletCount == 0) {
                                bullet4.setVx(8);
                                bullet4.setVy(-4);
                                continue;
                            }
                            if (bulletCount != 2) continue;
                            bullet4.setVx(8);
                            bullet4.setVy(4);
                        }
                    } else if (Player.getBulletLevel() == 4) {
                        for (int bulletCount = 0; bulletCount < 3; ++bulletCount) {
                            GameActor bullet5 = this.getABullet(gameTime, bulletRect);
                            this.adjustBullet(gameTime, bulletRect, bullet5, 8 + bulletCount);
                            if (bulletCount == 0) {
                                bullet5.setVx(8);
                                bullet5.setVy(-4);
                                continue;
                            }
                            if (bulletCount != 2) continue;
                            bullet5.setVx(8);
                            bullet5.setVy(4);
                        }
                    }
                    this.is_addBullet = false;
                }
            } else {
                this.is_addBullet = true;
            }
        }
    }

    private void processAttack(long gameTime, GameActor[] actorPool) {
        if (this.isAnimationOver(gameTime)) {
            if (this.animID_playerAtk > this.animID) {
                if (this.animID_playerAtk == 9 + player_WeaponType * 13) {
                    this.game.setDarkScreen(true);
                }
                this.setRenderContent(this.animID_playerAtk, false, gameTime);
            } else {
                this.game.setDarkScreen(false);
                this.setCurState((byte)0, gameTime);
            }
        } else if (KeySystem.IsKeyPressed(262144) && this.animID_playerAtk < 9 + player_WeaponType * 13) {
            this.animID_playerAtk = this.animID + 1;
        }
        boolean hitEnemy = false;
        int hitLevel = 0;
        for (int i = 0; i < actorPool.length; ++i) {
            if (actorPool[i] == null || !actorPool[i].inUse() || actorPool[i].getType() != 1 || !this.isCollide(gameTime, actorPool[i], 3, 0)) continue;
            hitEnemy = true;
            if (actorPool[i].getSubType() == 29) {
                hitEnemy = false;
            }
            hitLevel = this.animID - 4 - player_WeaponType * 13;
            int damage = this.getPlayerATS(hitLevel);
            actorPool[i].reduceLife(damage, 1 + hitLevel, this.getIntersectRect(gameTime, actorPool[i], 3, 0), gameTime);
            if (hitLevel == 5) {
                hitLevel = 6;
            }
            if (gameTime - this.time_stopProcessing <= 500L && GameActor.playerHitLevel == hitLevel + 1) continue;
            actorPool[i].setStopProcessing(true, gameTime);
            this.setStopProcessing(true, gameTime);
            this.game.setShakeScreen(true);
            GameActor.playerHitLevel = hitLevel + 1;
        }
        if (hitEnemy && gameTime - this.getLastHitTime() > 200L && !GameScene.is_boss_alarm && !this.game.isDialog()) {
            this.setLastHitTime(gameTime);
            this.increaseContinuousHits();
            this.is_comboBegin = true;
            this.is_comboFly = false;
            this.combo_frame = 0;
            this.combo_x = 240 - this.img_comboNameStart.getWidth() - this.img_comboNumStart.getWidth() / 10;
            this.combo_y = 65;
        }
        if (this.getColRect(gameTime, 3) != null && this.canMove(gameTime, 2, 0)) {
            this.setX(this.getX() + 2);
        }
        if (this.processKey(gameTime)) {
            this.setCurState((byte)0, gameTime);
        }
    }

    public void reduceLife(int reducePoint, int type, ColRect rc, long gametime) {
        if (this.getLife() <= 0 || this.isPlayerDead() || this.getCurState() == 9 || this.getCurState() == 7 || this.getCurState() == 2 || this.getCurState() == 3 || this.getCurState() == 4 || this.getCurState() == 5 || this.getCurState() == 6) {
            return;
        }
        this.setLastHitTime(0L);
        this.is_comboFly = true;
        if (reducePoint > 1) {
            reducePoint = type == 0 ? (reducePoint -= this.player_point_DefFarAway) : (reducePoint -= this.player_point_DefClose);
            if (reducePoint < 1) {
                reducePoint = 1;
            }
        }
        if (Player.getInvincibleTime() <= 0L) {
            if (this.IsHaveShield()) {
                this.reduceShieldLife(reducePoint);
            } else {
                this.setLife(this.getLife() - reducePoint);
                Player.setInvincibleTime(1000L);
            }
        } else {
            return;
        }
        if (this.getLife() <= 0) {
            this.setLife(0);
            this.setCurState((byte)13, gametime);
        } else if ((type == 8 || type == 9) && this.getRelatePlayer() == null) {
            if (this.getCurState() != 8) {
                this.setCurState((byte)8, gametime);
                this.setSubType(2);
            }
            if (type == 9) {
                this.setSubType(4);
            } else {
                this.setSubType(2);
            }
        } else if (type == 11) {
            if (this.getCurState() != 8) {
                this.setCurState((byte)8, gametime);
            }
            this.setSubType(4);
        } else if (type == 13) {
            this.setPoisonTime(3000L);
        } else if (this.getCurState() != 7) {
            state_headIconShow = 1;
            this.setCurState((byte)7, gametime);
        }
    }

    public void beginNotify(long gameTime, int type) {
        if (type == 2 || type == 6 || type == 1 || type == 5 || type == 0) {
            this.game.setStopScrollBG(true);
            if (this.getContinuousHits() > 0) {
                this.setLastHitTime(gameTime);
            }
        }
    }

    public void endNotify(long gameTime, int type) {
        this.game.setStopScrollBG(false);
    }

    private void processKeyMove(long gameTime) {
        if (KeySystem.IsKeyPressed(4) || KeySystem.IsKeyHold(4)) {
            if (this.canMove(gameTime, -this.player_FlySpeed, 0)) {
                this.setX(this.getX() - this.player_FlySpeed);
            }
        } else if (KeySystem.IsKeyPressed(8) || KeySystem.IsKeyHold(8)) {
            if (this.canMove(gameTime, this.player_FlySpeed, 0)) {
                this.setX(this.getX() + this.player_FlySpeed);
            }
        } else if (KeySystem.IsKeyPressed(1) || KeySystem.IsKeyHold(1)) {
            if (this.canMove(gameTime, 0, -this.player_FlySpeed)) {
                this.setY(this.getY() - this.player_FlySpeed);
            }
        } else if ((KeySystem.IsKeyPressed(2) || KeySystem.IsKeyHold(2)) && this.canMove(gameTime, 0, this.player_FlySpeed)) {
            this.setY(this.getY() + this.player_FlySpeed);
        }
    }

    private boolean processKey(long gameTime) {
        boolean ret = false;
        if (this.getCurState() == 9) {
            return false;
        }
        if (KeySystem.IsKeyPressed(4) || KeySystem.IsKeyHold(4)) {
            if (this.getLureTime() > 0L) {
                if (this.canMove(gameTime, this.player_FlySpeed, 0)) {
                    this.setX(this.getX() + this.player_FlySpeed);
                    ret = true;
                }
            } else if (this.canMove(gameTime, -this.player_FlySpeed, 0)) {
                this.setX(this.getX() - this.player_FlySpeed);
                ret = true;
            }
        } else if (KeySystem.IsKeyPressed(8) || KeySystem.IsKeyHold(8)) {
            if (this.getLureTime() > 0L) {
                if (this.canMove(gameTime, -this.player_FlySpeed, 0)) {
                    this.setX(this.getX() - this.player_FlySpeed);
                    ret = true;
                }
            } else if (this.canMove(gameTime, this.player_FlySpeed, 0)) {
                this.setX(this.getX() + this.player_FlySpeed);
                ret = true;
            }
        } else if (KeySystem.IsKeyPressed(1) || KeySystem.IsKeyHold(1)) {
            if (this.getLureTime() > 0L) {
                if (this.canMove(gameTime, 0, this.player_FlySpeed)) {
                    this.setY(this.getY() + this.player_FlySpeed);
                    ret = true;
                }
            } else if (this.canMove(gameTime, 0, -this.player_FlySpeed)) {
                this.setY(this.getY() - this.player_FlySpeed);
                ret = true;
            }
        } else if (KeySystem.IsKeyPressed(2) || KeySystem.IsKeyHold(2)) {
            if (this.getLureTime() > 0L) {
                if (this.canMove(gameTime, 0, -this.player_FlySpeed)) {
                    this.setY(this.getY() - this.player_FlySpeed);
                    ret = true;
                }
            } else if (this.canMove(gameTime, 0, this.player_FlySpeed)) {
                this.setY(this.getY() + this.player_FlySpeed);
                ret = true;
            }
        } else if (KeySystem.IsKeyPressed(2048)) {
            this.is_inEatItem = this.player_ItemBag.useItem(0);
            this.animID_eatItem = 0;
            this.player_eatItem.setAnimation(this.animID_eatItem);
            this.player_eatItem.setLoopOffset(-1);
            ret = false;
        } else if (KeySystem.IsKeyPressed(8192)) {
            this.is_inEatItem = this.player_ItemBag.useItem(1);
            this.animID_eatItem = 1;
            this.player_eatItem.setAnimation(this.animID_eatItem);
            this.player_eatItem.setLoopOffset(-1);
            ret = false;
        } else if (KeySystem.IsKeyPressed(16) && this.getLureTime() <= 0L) {
            if (player_useMagic_0 != -1 && Player.getMana() >= magic_ManaCost[player_useMagic_0]) {
                state_headIconShow = (byte)2;
                this.setCurState((byte)(2 + player_useMagic_0), gameTime);
                Player.setMana(Player.getMana() - magic_ManaCost[player_useMagic_0]);
            }
            ret = false;
        } else if (KeySystem.IsKeyPressed(16384) && this.getLureTime() <= 0L) {
            if (player_useMagic_star != -1 && Player.getMana() >= magic_ManaCost[player_useMagic_star]) {
                state_headIconShow = (byte)2;
                this.setCurState((byte)(2 + player_useMagic_star), gameTime);
                Player.setMana(Player.getMana() - magic_ManaCost[player_useMagic_star]);
            }
            ret = false;
        } else if (KeySystem.IsKeyPressed(32768) && this.getLureTime() <= 0L) {
            if (player_useMagic_pound != -1 && Player.getMana() >= magic_ManaCost[player_useMagic_pound]) {
                state_headIconShow = (byte)2;
                this.setCurState((byte)(2 + player_useMagic_pound), gameTime);
                Player.setMana(Player.getMana() - magic_ManaCost[player_useMagic_pound]);
            }
            ret = false;
        } else if (KeySystem.IsKeyPressed(32)) {
            this.is_freezeBullet = !this.is_freezeBullet;
            ret = false;
        }
        if (KeySystem.IsKeyPressed(262144) && this.getCurState() != 7 && this.getCurState() != 1) {
            this.setCurState((byte)1, gameTime);
            ret = false;
        }
        return ret;
    }

    private boolean canMove(long gameTime, int offsetX, int offsetY) {
        boolean ret = true;
        ColRect crHero = this.getColRect(gameTime, 0);
        if (this.getX() - (crHero.w >> 1) <= 0 && offsetX < 0 || this.getX() + (crHero.w >> 1) >= 240 && offsetX > 0 || this.getY() - crHero.h <= 55 && offsetY < 0 || this.getY() >= 295 && offsetY > 0) {
            ret = false;
        }
        return ret;
    }

    public void adjustPosition(long time, GameActor[] actorPool) {
        ColRect crHero = this.getColRect(time, 0);
        if (!this.isPlayerDead() && this.getCurState() != 10 && this.getCurState() != 12) {
            for (int i = 0; i < actorPool.length; ++i) {
                if (actorPool[i] == null || !actorPool[i].inUse() || actorPool[i] == this || actorPool[i].getType() != 1 || actorPool[i].getCurState() == 7 || !this.isCollide(time, actorPool[i], 0, 0) || this.getCurState() == 3) continue;
                this.setX(this.getX() - this.player_FlySpeed);
            }
            if (this.getX() - (crHero.w >> 1) < 0) {
                this.setX(0 + (crHero.w >> 1));
            } else if (this.getX() + (crHero.w >> 1) > 240) {
                this.setX(240 - (crHero.w >> 1));
            }
            if (this.getY() - crHero.h < 55) {
                this.setY(55 + crHero.h);
            } else if (this.getY() > 295) {
                this.setY(295);
            }
        } else if (this.getCurState() == 13) {
            boolean outOfScren = false;
            if (this.getX() + (crHero.w >> 1) < 0) {
                outOfScren = true;
            } else if (this.getX() - (crHero.w >> 1) > 240) {
                outOfScren = true;
            }
            if (this.getY() < 55) {
                outOfScren = true;
            } else if (this.getY() - crHero.h > 295) {
                outOfScren = true;
            }
            if (outOfScren) {
                this.game.is_deadMenu = true;
            }
        } else if (this.getCurState() == 14) {
            boolean outOfScreen = false;
            if (this.getX() + (crHero.w >> 1) < 0) {
                outOfScreen = true;
            } else if (this.getX() - (crHero.w >> 1) > 240) {
                outOfScreen = true;
            }
            if (this.getY() < 55) {
                outOfScreen = true;
            } else if (this.getY() - crHero.h > 295) {
                outOfScreen = true;
            }
            if (!outOfScreen) {
                this.invokeEndIncident(time, 6);
                this.game.setStopScrollBG(false);
                this.setCurState((byte)0, time);
                Player.setInvincibleTime(3000L);
            }
        }
    }

    private GameActor getABullet(long gameTime, ColRect bulletRect) {
        GameActor[] bulletPool = GameScene.bulletPool;
        for (int i = 0; i < bulletPool.length; ++i) {
            if (bulletPool[i] != null && bulletPool[i].inUse()) continue;
            if (bulletPool[i] == null) {
                bulletPool[i] = new GameBullet(this.canvas);
            }
            return bulletPool[i];
        }
        return null;
    }

    private void adjustBullet(long gameTime, ColRect bulletRect, GameActor bullet2, int subType) {
        bullet2.setAnimation(this.hero_bullet_pif);
        bullet2.initGameActor(gameTime, 0);
        bullet2.setSubType(subType);
        bullet2.setCurState((byte)0, gameTime);
        bullet2.setX(this.getX() + bulletRect.x + (bulletRect.w >> 1));
        bullet2.setY(this.getY() + bulletRect.y + (bulletRect.h >> 1));
        bullet2.setVx(10);
        bullet2.setVy(0);
    }

    public int getPlayerATS(int hitLevel) {
        switch (hitLevel) {
            default: {
                return this.player_point_AtkClose;
            }
            case 1: {
                return this.player_point_AtkClose * 11 / 10;
            }
            case 2: {
                return this.player_point_AtkClose * 6 / 5;
            }
            case 3: {
                return this.player_point_AtkClose * 13 / 10;
            }
            case 4: {
                return this.player_point_AtkClose * 7 / 5;
            }
            case 5: 
        }
        return this.player_point_AtkClose * 3 / 2;
    }

    public int getPlayerATL() {
        return this.player_point_AtkFarAway;
    }

    public static final void setBulletLevel(int bulletLevelPara) {
        player_bulletLevel = bulletLevelPara;
    }

    public void increaseBulletLevel(long gameTime) {
        this.setRenderPowerUpTime(gameTime);
        if (player_bulletLevel < 4) {
            ++player_bulletLevel;
        }
    }

    public static final int getBulletLevel() {
        return player_bulletLevel;
    }

    private void setRenderPowerUpTime(long renderPowerUpTime) {
        this.time_renderPowerUp = renderPowerUpTime;
    }

    private long getRenderPowerUpTime() {
        return this.time_renderPowerUp;
    }

    public static boolean isMagicLocked(int magic) {
        return Player.getPlayerPropertyArray()[8] < magic_LevelRequirement[magic][0];
    }

    public static int getMagicLevel(int magic) {
        int level = 0;
        if ((short)Player.getPlayerPropertyArray()[13 + magic] >= Player.getMagicLevelRequirement()[magic][2]) {
            level = 1;
        }
        if ((short)Player.getPlayerPropertyArray()[13 + magic] >= Player.getMagicLevelRequirement()[magic][3]) {
            level = 2;
        }
        if ((short)Player.getPlayerPropertyArray()[13 + magic] >= Player.getMagicLevelRequirement()[magic][4]) {
            level = 3;
        }
        if ((short)Player.getPlayerPropertyArray()[13 + magic] >= Player.getMagicLevelRequirement()[magic][5]) {
            level = 4;
        }
        return level;
    }

    public void setAllRoleStopProcessing(boolean stop, long gameTime) {
        for (int i = 0; i < GameScene.actorPool.length; ++i) {
            if (GameScene.actorPool[i] == null || !GameScene.actorPool[i].inUse()) continue;
            GameScene.actorPool[i].setStopProcessing(stop, gameTime);
        }
    }

    public void loadMagicRes() {
        if (this.god_pif == null && (player_useMagic_0 == 1 || player_useMagic_star == 1 || player_useMagic_pound == 1)) {
            this.god_pif = new PWPifLifeAnimations(MainCanvas.stream.getResDate("/Animation/wk_at11.aej"), 0, true);
        }
        if (this.fireeye_pif == null && (player_useMagic_0 == 2 || player_useMagic_star == 2 || player_useMagic_pound == 2)) {
            this.fireeye_pif = new PWPifLifeAnimations(MainCanvas.stream.getResDate("/Animation/wk_eyes.trans"));
        }
        if (this.invincible_Pif == null && (player_useMagic_0 == 3 || player_useMagic_star == 3 || player_useMagic_pound == 3)) {
            this.invincible_Pif = new PWPifLifeAnimations(MainCanvas.stream.getResDate("/Animation/invincible.aej"), 0, true);
        }
        if (this.kingAdvent_Pif == null && (player_useMagic_0 == 4 || player_useMagic_star == 4 || player_useMagic_pound == 4)) {
            this.kingAdvent_Pif = new PWPifLifeAnimations(MainCanvas.stream.getResDate("/Animation/kingAdvent.aej"), 0, true);
        }
    }

    public static void makeSomeStorePlayerProperty() {
        Player.getPlayerPropertyArray()[10] = player_Souls;
        Player.getPlayerPropertyArray()[12] = player_Point;
        Player.getPlayerPropertyArray()[18] = player_bulletLevel;
    }

    public void resetPlayerData() {
        player_Property = new int[this.player_PropertyData.length];
        for (int i = 0; i < player_Property.length; ++i) {
            Player.player_Property[i] = this.player_PropertyData[i];
        }
    }

    public void calculatePlayerProperty(boolean is_setCurValue) {
        this.player_point_Life = Player.getPlayerPropertyArray()[0] + this.player_useWeapon.weapon_hp;
        this.setMaxlife(this.player_point_Life);
        player_point_Mana = Player.getPlayerPropertyArray()[1] + this.player_useWeapon.weapon_mana;
        this.player_point_AtkClose = Player.getPlayerPropertyArray()[2] + this.player_useWeapon.weapon_attack + this.player_useWeapon.weapon_base_damage;
        this.player_point_AtkFarAway = Player.getPlayerPropertyArray()[3] + this.player_useWeapon.weapon_far_attack;
        this.player_point_DefClose = Player.getPlayerPropertyArray()[4] + this.player_useWeapon.weapon_defend;
        this.player_point_DefFarAway = Player.getPlayerPropertyArray()[5] + this.player_useWeapon.weapon_far_defend;
        this.player_FlySpeed = 7 + (Player.getPlayerPropertyArray()[6] + this.player_useWeapon.weapon_mov_speed) / 10;
        this.player_LeanFlySpeed = (short)((this.player_FlySpeed * 10 + 7) / 14);
        this.player_point_Spirit = 1 + (Player.getPlayerPropertyArray()[7] + this.player_useWeapon.weapon_spirite) / 10;
        if (is_setCurValue) {
            Player.setPlayerSouls(Player.getPlayerPropertyArray()[10]);
            Player.setPlayerLevel(Player.getPlayerPropertyArray()[8]);
            Player.setPlayerHP(Player.getPlayerPropertyArray()[0]);
            Player.setPlayerPoint(Player.getPlayerPropertyArray()[12]);
            this.setLife(this.player_point_Life);
            Player.setMana(player_point_Mana);
        }
    }

    public boolean isPlayerDead() {
        return this.getCurState() >= 13;
    }

    public static final short[][] getMagicLevelRequirement() {
        return magic_LevelRequirement;
    }

    public static final int[] getPlayerPropertyArray() {
        return player_Property;
    }

    public static final void setPlayerLevel(int playerLevelPara) {
        player_Level = playerLevelPara;
    }

    public static final int getPlayerLevel() {
        return player_Level;
    }

    public static final void setPlayerHP(int playerHPPara) {
        player_HP = playerHPPara;
    }

    public static final int getPlayerHP() {
        return player_HP;
    }

    public static void setMana(int mana) {
        player_mana = mana;
    }

    public static int getMana() {
        return player_mana;
    }

    public static int getMaxMana() {
        return player_point_Mana;
    }

    public static final void setPlayerSouls(int playerSouls) {
        player_Souls = playerSouls > 9999 ? 9999 : playerSouls;
    }

    public static final int getPlayerSouls() {
        return player_Souls;
    }

    public static final int getKilledEnemy() {
        return player_totalKilledEnemy;
    }

    public static final void setKilledEnemy(int killedEnemy) {
        player_totalKilledEnemy = killedEnemy > 9999 ? 9999 : killedEnemy;
    }

    public void increaseKilledEnemy(int exp) {
        ++player_totalKilledEnemy;
        if (!this.isPlayerDead()) {
            if (Player.getPlayerPropertyArray()[9] > exp) {
                int[] nArray = Player.getPlayerPropertyArray();
                nArray[9] = nArray[9] - exp;
            } else {
                int val;
                int score = exp - Player.getPlayerPropertyArray()[9];
                int level = 1;
                while (score > 0 && (val = score - (experience[Player.getPlayerLevel() + level] - experience[Player.getPlayerLevel() + level - 1])) >= 0) {
                    score = val;
                    ++level;
                }
                if (Player.getPlayerLevel() < experience.length - 1) {
                    this.setCurState((byte)9, this.game.getCurGameTime());
                    Player.setPlayerLevel(Player.getPlayerLevel() + level);
                    Player.getPlayerPropertyArray()[8] = Player.getPlayerLevel();
                    Player.getPlayerPropertyArray()[9] = experience[Player.getPlayerLevel()] - experience[Player.getPlayerLevel() - 1] - score;
                    Player.setPlayerHP(Player.getPlayerHP() + 6);
                    this.setMaxlife(this.getMaxlife() + 6);
                    Player.getPlayerPropertyArray()[0] = this.getMaxlife();
                    this.setLife(this.getMaxlife());
                    player_point_Mana += 3;
                    int[] nArray = Player.getPlayerPropertyArray();
                    nArray[1] = nArray[1] + 3;
                    Player.setMana(Player.getMaxMana());
                    Player.setPlayerPoint(Player.getPlayerPoint() + 2);
                }
            }
        }
    }

    public static final void setPlayerPoint(int playerPointPara) {
        player_Point = playerPointPara;
    }

    public static final int getPlayerPoint() {
        return player_Point;
    }

    public void setPoisonTime(long poisonTime) {
        this.time_poison = poisonTime;
    }

    public long getPoisonTime() {
        return this.time_poison;
    }

    private void setPalsyTime(long palsyTime) {
        this.time_palsy = palsyTime;
    }

    private long getPalsyTime() {
        return this.time_palsy;
    }

    public void setLureTime(long lureTime) {
        this.time_lure = lureTime;
    }

    public long getLureTime() {
        return this.time_lure;
    }

    public static final void setDeadCount(int dead) {
        player_deadCount = dead;
    }

    public static final int getDeadCount() {
        return player_deadCount;
    }

    public static final void increaseDeadCount() {
        ++player_deadCount;
    }

    public void setLastHitTime(long lastHitTime) {
        this.time_lastHit = lastHitTime;
    }

    public long getLastHitTime() {
        return this.time_lastHit;
    }

    public int getContinuousHits() {
        return this.continuousHits;
    }

    public void setContinuousHits(int continuousHits) {
        this.continuousHits = continuousHits;
    }

    public void increaseContinuousHits() {
        ++this.continuousHits;
        if (this.continuousHits > Player.getMaxContinuousHits()) {
            Player.setMaxContinuousHits(this.continuousHits);
        }
    }

    public static final void setMaxContinuousHits(int maxHits) {
        player_maxContinuousHits = maxHits;
    }

    public static final int getMaxContinuousHits() {
        return player_maxContinuousHits;
    }

    public static final void setTotalPlayedTime(long totalTime) {
        player_totalPlayedTime = totalTime;
    }

    public static final long getTotalPlayedTime() {
        return player_totalPlayedTime;
    }

    public static final void increaseTotalTime(long time) {
        player_totalPlayedTime += time;
    }

    public static void setInvincibleTime(long invincible) {
        time_invincible = invincible;
    }

    public static long getInvincibleTime() {
        return time_invincible;
    }

    public void clearGameActor() {
        this.img_MagicIcon = null;
        this.img_missionItem = null;
        this.img_comboNumStart = null;
        this.img_comboNumEnd = null;
        this.img_comboNameStart = null;
        this.img_comboNameEnd = null;
        this.player_eatItem = null;
        this.levelUP = null;
        this.icon_superAtk = null;
        this.splitterInfo = null;
        this.splitterShadowInfo = null;
        this.hero_bullet_pif = null;
        this.levelUP_pif = null;
        this.player_Confuse = null;
        this.player_Dizzy = null;
        this.god_pif = null;
        this.fireeye_pif = null;
        this.invincible_Pif = null;
        this.kingAdvent_Pif = null;
    }

    public int[] getPlayerData() {
        return this.player_PropertyData;
    }

    public static void changePlayerWeapon(int id) {
        switch (id) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                player_WeaponType = 0;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                player_WeaponType = 1;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                player_WeaponType = 1;
                break;
            }
            default: {
                System.out.println("\u6839\u672c\u6ca1\u6709\u8fd9\u628a\u6b66\u5668\uff0cID\u9519\u8bef\uff01\uff01\uff01\uff01");
            }
        }
    }

    private void invokeBeginIncident(long time, int type) {
        int i;
        for (i = 0; i < GameScene.actorPool.length; ++i) {
            if (GameScene.actorPool[i] == null || !GameScene.actorPool[i].inUse()) continue;
            GameScene.actorPool[i].beginNotify(time, type);
        }
        for (i = 0; i < GameScene.bonusPool.length; ++i) {
            if (GameScene.bonusPool[i] == null || !GameScene.bonusPool[i].inUse()) continue;
            GameScene.bonusPool[i].beginNotify(time, type);
        }
    }

    private void invokeEndIncident(long gameTime, int type) {
        int i;
        for (i = 0; i < GameScene.actorPool.length; ++i) {
            if (GameScene.actorPool[i] == null || !GameScene.actorPool[i].inUse()) continue;
            GameScene.actorPool[i].endNotify(gameTime, type);
        }
        for (i = 0; i < GameScene.bonusPool.length; ++i) {
            if (GameScene.bonusPool[i] == null || !GameScene.bonusPool[i].inUse()) continue;
            GameScene.bonusPool[i].endNotify(gameTime, type);
        }
    }

    private void initSplitterShadowInfo() {
        for (int i = 0; i < this.splitterShadowInfo.length; ++i) {
            for (int j = 0; j < this.splitterShadowInfo[i].length; ++j) {
                for (int k = 0; k < this.splitterShadowInfo[i][j].length; ++k) {
                    this.splitterShadowInfo[i][j][k] = -1;
                }
            }
        }
    }

    private void pushSplitterShadowInfo(int splitterIndex, int frameID, int x, int y) {
        for (int i = this.splitterShadowInfo[splitterIndex].length - 1; i > 0; --i) {
            for (int j = 0; j < this.splitterShadowInfo[splitterIndex][i].length; ++j) {
                this.splitterShadowInfo[splitterIndex][i][j] = this.splitterShadowInfo[splitterIndex][i - 1][j];
            }
        }
        this.splitterShadowInfo[splitterIndex][0][0] = frameID;
        this.splitterShadowInfo[splitterIndex][0][1] = x;
        this.splitterShadowInfo[splitterIndex][0][2] = y;
    }

    private void initSplitterInfo(long gameTime, GameActor[] actorPool) {
        for (int i = 0; i < this.splitterInfo.length; ++i) {
            this.splitterInfo[i][0] = 1 + player_WeaponType * 13;
            this.splitterInfo[i][1] = (int)gameTime;
            this.splitterInfo[i][2] = this.getX();
            this.splitterInfo[i][3] = this.getY();
            this.splitterInfo[i][4] = -1;
        }
        int splitterIndex = 0;
        for (int i = 0; i < actorPool.length; ++i) {
            if (actorPool[i] == null || !actorPool[i].inUse() || actorPool[i].getType() != 1 || actorPool[i].getSubType() == 29 || actorPool[i].getSubType() == 20) continue;
            this.splitterInfo[splitterIndex][4] = i;
            ++splitterIndex;
        }
    }

    private void processSplitter(long gameTime, GameActor[] actorPool) {
        if (this.animID == 11 + player_WeaponType * 13) {
            if (this.isAnimationOver(gameTime)) {
                this.initSplitterInfo(gameTime, actorPool);
                this.invokeBeginIncident(gameTime, 0);
                this.game.setShakeScreen(true);
                this.setRenderContent(++this.animID, false, gameTime);
            }
        } else if (this.isAnimationOver(gameTime)) {
            int i;
            boolean superAttackEnd = true;
            for (i = 0; i < this.splitterInfo.length; ++i) {
                if (this.splitterInfo[i][4] == -1 || this.splitterInfo[i][0] > 9 + player_WeaponType * 13) continue;
                superAttackEnd = false;
            }
            if (superAttackEnd) {
                this.game.setDarkScreen(false);
                state_headIconShow = 0;
                this.setCurState((byte)0, gameTime);
                this.invokeEndIncident(gameTime, 0);
            } else {
                for (i = 0; i < this.splitterInfo.length; ++i) {
                    if (this.splitterInfo[i][4] == -1) continue;
                    if (this.splitterInfo[i][0] == 1 + player_WeaponType * 13) {
                        crSelf.Copy(this.getX(), this.getY(), this.getAnimation().GetColRect(this.splitterInfo[i][0], gameTime - (long)this.splitterInfo[i][1], true, 0));
                        crOther.Copy(actorPool[this.splitterInfo[i][4]].getX(), actorPool[this.splitterInfo[i][4]].getY(), actorPool[this.splitterInfo[i][4]].getColRect(gameTime, 0));
                        int diffX = Player.crOther.x - (Player.crOther.w >> 1) - this.splitterInfo[i][2] - (Player.crSelf.w >> 1);
                        int diffY = Player.crOther.y + Player.crOther.h - this.splitterInfo[i][3];
                        if (diffX == 0 && diffY == 0) {
                            this.splitterInfo[i][0] = 4 + player_WeaponType * 13;
                            this.splitterInfo[i][1] = (int)gameTime;
                            continue;
                        }
                        int absDiffX = Math.abs(diffX);
                        int absDiffY = Math.abs(diffY);
                        if (absDiffX > 10 || absDiffY > 10) {
                            if (absDiffX > absDiffY) {
                                int[] nArray = this.splitterInfo[i];
                                nArray[2] = nArray[2] + (diffX > 0 ? 10 : -10);
                                int[] nArray2 = this.splitterInfo[i];
                                nArray2[3] = nArray2[3] + (diffY > 0 ? 10 * absDiffY / absDiffX : -10 * absDiffY / absDiffX);
                                continue;
                            }
                            int[] nArray = this.splitterInfo[i];
                            nArray[2] = nArray[2] + (diffX > 0 ? 10 * absDiffX / absDiffY : -10 * absDiffX / absDiffY);
                            int[] nArray3 = this.splitterInfo[i];
                            nArray3[3] = nArray3[3] + (diffY > 0 ? 10 : -10);
                            continue;
                        }
                        int[] nArray = this.splitterInfo[i];
                        nArray[2] = nArray[2] + diffX;
                        int[] nArray4 = this.splitterInfo[i];
                        nArray4[3] = nArray4[3] + diffY;
                        continue;
                    }
                    if (!this.getAnimation().animationIsOver(this.splitterInfo[i][0], (int)(gameTime - (long)this.splitterInfo[i][1]))) continue;
                    crOther.Copy(actorPool[this.splitterInfo[i][4]].getX(), actorPool[this.splitterInfo[i][4]].getY(), actorPool[this.splitterInfo[i][4]].getColRect(gameTime, 0));
                    int hitLevel = this.splitterInfo[i][0] - 4 - player_WeaponType * 13;
                    int damage = this.getPlayerATS(hitLevel) + magic_Damage[0][Player.getMagicLevel(0)];
                    actorPool[this.splitterInfo[i][4]].reduceLife(damage, 1, crOther, gameTime);
                    int[] nArray = this.splitterInfo[i];
                    nArray[0] = nArray[0] + 1;
                    this.splitterInfo[i][1] = (int)gameTime;
                }
            }
        }
    }

    private void processSuperGod(long gameTime, GameActor[] actorPool) {
        if (KeySystem.IsKeyPressed(4) || KeySystem.IsKeyHold(4)) {
            if (this.animID != 13 + player_WeaponType * 13) {
                this.setRenderContent(13 + player_WeaponType * 13, true, gameTime);
            }
        } else if (this.animID != 1 + player_WeaponType * 13) {
            this.setRenderContent(1 + player_WeaponType * 13, true, gameTime);
        }
        this.processKeyMove(gameTime);
        crSelf.Copy(this.getX(), this.getY(), this.god_pif.GetColRect(0, gameTime - this.time_godhit, true, 3));
        for (int i = 0; i < actorPool.length; ++i) {
            if (actorPool[i] == null || !actorPool[i].inUse || actorPool[i].getType() != 1) continue;
            crOther.Copy(actorPool[i].getX(), actorPool[i].getY(), actorPool[i].getColRect(gameTime, 0));
            if (!ColRect.RectIntersect(crSelf, crOther)) continue;
            short damage = magic_Damage[1][Player.getMagicLevel(1)];
            actorPool[i].reduceLife(damage, 10, crOther, gameTime);
        }
    }

    private void processFireEyes(long gameTime, GameActor[] actorPool) {
        if (KeySystem.IsKeyPressed(4) || KeySystem.IsKeyHold(4)) {
            if (this.animID != 13 + player_WeaponType * 13) {
                this.setRenderContent(13 + player_WeaponType * 13, true, gameTime);
            }
        } else if (this.animID != 1 + player_WeaponType * 13) {
            this.setRenderContent(1 + player_WeaponType * 13, true, gameTime);
        }
        this.processKeyMove(gameTime);
        ++this.frame_fireeye;
        this.frame_fireeye %= 5;
        ColRect crHero = this.getColRect(gameTime, 0);
        crSelf.Copy(this.getX() + (crHero.w >> 2) + 128, this.getY() - crHero.h + 15, this.fireeye_pif.GetColRect(this.animID_fireeye, gameTime - this.time_fireeye, true, 0));
        for (int i = 0; i < actorPool.length; ++i) {
            if (actorPool[i] == null || !actorPool[i].inUse || actorPool[i].getType() != 1) continue;
            crOther.Copy(actorPool[i].getX(), actorPool[i].getY(), actorPool[i].getColRect(gameTime, 0));
            if (!ColRect.RectIntersect(crSelf, crOther) || this.frame_fireeye != 0) continue;
            short damage = magic_Damage[2][Player.getMagicLevel(1)];
            actorPool[i].reduceLife(damage, 10, crOther, gameTime);
        }
    }
}

