/*
 * Decompiled with CFR 0.152.
 */
package HG.Main;

import HG.Main.Midlet;
import HG.Scene.SceneManage;
import HG.Tool.FontManager;
import HG.Tool.GraphicsTool;
import HG.Tool.StreamTool;
import HG.Tool.TextTool;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class MainCanvas
extends Canvas {
    public Midlet midlet = null;
    public TextTool text = null;
    public static StreamTool stream = null;
    public static FontManager fontManger = null;
    public SceneManage sceneMgr = null;
    public boolean is_paint = true;
    private int key_PressedStore = 1024;
    private int key_RelessedStore = 1024;
    private int mouse_x = -1;
    private int mouse_y = -1;
    private static final int TIME_TO_ENTER_PAUSE_STATE = 10000;
    private static final int TIME_INTERVAL = 100;
    public static long time_InitSound = 0L;
    public static long time_Statistics = 0L;
    public static long time_last = 0L;
    public static String[] lang = null;
    public static String str_debug = "";
    private static int m_nPointX = -1;
    private static int m_nPointY = -1;

    public MainCanvas(Midlet mlet) {
        this.setFullScreenMode(true);
        this.midlet = mlet;
    }

    public void loadCanvasRes() {
        this.text = new TextTool();
        stream = new StreamTool();
        fontManger = new FontManager("/txt/font.dat");
        this.sceneMgr = new SceneManage(this);
        lang = stream.loadLangUnicode("/txt/lang.data");
    }

    protected void paint(Graphics g) {
        if (this.sceneMgr != null) {
            this.text.setFont(g);
            this.sceneMgr.render(g);
        } else {
            GraphicsTool.restScreen(g, 0);
        }
    }

    protected synchronized void keyPressed(int key) {
        this.key_PressedStore = key;
    }

    protected synchronized void keyReleased(int key) {
        this.key_RelessedStore = key;
    }

    public void run() {
        long currentTime = System.currentTimeMillis();
        long time_delay = currentTime - time_last;
        time_last = currentTime;
        time_Statistics += time_delay;
        if (time_last > 10000L) {
            // empty if block
        }
        if (this.is_paint) {
            this.refresh();
        }
        if (this.key_PressedStore != 1024) {
            this.sceneMgr.keyPressed(this.key_PressedStore);
            this.key_PressedStore = 1024;
        }
        if (this.key_RelessedStore != 1024) {
            this.sceneMgr.keyReleased(this.key_RelessedStore);
            this.key_RelessedStore = 1024;
        }
        if (this.mouse_x != -1 && this.mouse_y != -1) {
            this.sceneMgr.pointerPressed(this.mouse_x, this.mouse_y);
        }
        this.mouse_x = -1;
        this.mouse_y = -1;
        this.sceneMgr.run();
        if (time_delay < 100L) {
            MainCanvas.sleep(100L - time_delay);
        }
    }

    protected void pointerPressed(int x, int y) {
        if (y >= 300) {
            int tmp_nW = 60;
            if (x < tmp_nW) {
                this.keyPressed(-6);
            } else if (x > tmp_nW * 3) {
                this.keyPressed(-7);
            } else {
                this.mouse_x = x;
                this.mouse_y = y;
            }
        } else {
            this.mouse_x = x;
            this.mouse_y = y;
        }
    }

    protected void pointerDragged(int x, int y) {
    }

    protected void pointerReleased(int x, int y) {
        if (y >= 300) {
            if (x < 120) {
                this.keyReleased(-6);
            } else {
                this.keyReleased(-7);
            }
        } else {
            this.sceneMgr.pointerReleased(x, y);
        }
    }

    protected void showNotify() {
        this.sceneMgr.showNotify();
    }

    protected void hideNotify() {
        this.sceneMgr.hideNotify();
    }

    public void resetKeyValue() {
        this.key_PressedStore = 1024;
        this.key_RelessedStore = 1024;
        this.mouse_x = -1;
        this.mouse_y = -1;
    }

    public void refresh() {
        this.repaint();
        this.serviceRepaints();
    }

    public static void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            System.out.println("Thread sleep error!");
        }
    }

    public static void exitApplication() {
        Midlet.is_gamerun = false;
    }

    public static void debug(long test) {
        System.out.println("" + test);
    }

    public static void debug(boolean test) {
        System.out.println("" + test);
    }

    public static void debug(String test) {
        System.out.println(test);
    }

    public static void drawXY(Graphics g) {
        int tmp_nL = 50;
        GraphicsTool.restClip(g);
        g.setColor(0xFF0000);
        g.drawRect(0, 0, 239, 319);
        g.drawLine(m_nPointX - tmp_nL, m_nPointY, m_nPointX + tmp_nL, m_nPointY);
        g.drawLine(m_nPointX, m_nPointY - tmp_nL, m_nPointX, m_nPointY + tmp_nL);
        g.drawString("X\u8f74:" + m_nPointX, 0, 0, 20);
        g.drawString("Y\u8f74:" + m_nPointY, 240, 0, 24);
    }
}

