/*
 * Decompiled with CFR 0.152.
 */
package HG.MotionWelder;

import HG.MotionWelder.MSpriteData;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class MPlayer {
    private MSpriteData data;
    private int animation;
    private int frame;
    private int frameCount;
    private int loopOffset;
    private int delayCount;
    private int framePoolPointer;
    private int[] rect = new int[4];
    private final byte IMAGE_FLAG_NONE;
    private final byte IMAGE_FLAG_HFLIP = (byte)2;
    private final byte IMAGE_FLAG_VFLIP = (byte)4;
    private final byte ELLIPSE_FLAG_NONE;
    private final byte ELLIPSE_FLAG_FILLED = (byte)3;
    private final byte LINE_FLAG = (byte)5;
    private final byte RECTANGLE_FLAG_NONE = (byte)7;
    private final byte RECTANGLE_FLAG_FILLED = (byte)9;
    private final byte ROUNDEDRECTANGLE_FLAG_NONE = (byte)11;
    private final byte ROUNDEDRECTANGLE_FLAG_FILLED = (byte)13;
    private final byte POSITIONERRECTANGLE_FLAG = (byte)15;

    public MPlayer(MSpriteData data) {
        this.IMAGE_FLAG_NONE = 0;
        this.ELLIPSE_FLAG_NONE = 1;
        this.data = data;
    }

    public void setAnimation(int id) {
        this.animation = id;
        int pos = this.animation << 1;
        this.frameCount = this.data.animationTable[pos + 1] - this.data.animationTable[pos] + 1;
        this.setFrame(0);
        this.notifyStartOfAnimation();
    }

    public int getAnimation() {
        return this.animation;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public int getCurrentFrame() {
        return this.frame;
    }

    public void setFrame(int frame) {
        this.frame = frame;
        this.delayCount = 0;
        int frameIndex = this.data.animationTable[this.animation << 1] + frame;
        this.framePoolPointer = this.data.frameTable[frameIndex << 2];
    }

    public void setLoopOffset(int val) {
        this.loopOffset = val;
    }

    public int getAnimationCount() {
        return this.data.animationTable.length >>> 1;
    }

    public int getNumberOfCollisionRect() {
        int count = 0;
        int startIndex = this.data.frameTableIndex[this.framePoolPointer << 1];
        short endIndex = this.data.frameTableIndex[(this.framePoolPointer << 1) + 1];
        while (startIndex < endIndex) {
            startIndex += 3;
            if ((byte)this.data.framePoolTable[startIndex++] != 15) continue;
            ++count;
        }
        return count;
    }

    public int[] getCollisionRect(int index) {
        int count = -1;
        int startIndex = this.data.frameTableIndex[this.framePoolPointer << 1];
        short endIndex = this.data.frameTableIndex[(this.framePoolPointer << 1) + 1];
        while (startIndex < endIndex) {
            int clipIndex = this.data.framePoolTable[startIndex++];
            int x = this.data.framePoolTable[startIndex++];
            int y = this.data.framePoolTable[startIndex++];
            if ((byte)this.data.framePoolTable[startIndex++] != 15 || ++count != index) continue;
            this.rect[2] = this.data.positionerRectangleClipPool[clipIndex <<= 1];
            this.rect[3] = this.data.positionerRectangleClipPool[clipIndex + 1];
            byte spriteOrientation = this.getSpriteOrientation();
            if (spriteOrientation == 1) {
                x = -x - this.rect[2];
            } else if (spriteOrientation == 2) {
                y = -y - this.rect[3];
            }
            this.rect[0] = x;
            this.rect[1] = y;
            return this.rect;
        }
        return null;
    }

    public void update() {
        int frameIndex = this.data.animationTable[this.animation << 1] + this.frame;
        if (this.delayCount < this.data.frameTable[(frameIndex << 2) + 1]) {
            ++this.delayCount;
            return;
        }
        if (this.frame >= this.frameCount - 1) {
            if (this.loopOffset < 0) {
                this.notifyEndOfAnimation();
                return;
            }
            this.frame = this.loopOffset - 1;
        }
        this.setFrame(this.frame + 1);
        frameIndex = this.data.animationTable[this.animation << 1] + this.frame;
        short xInc = this.data.frameTable[(frameIndex << 2) + 2];
        short yInc = this.data.frameTable[(frameIndex << 2) + 3];
        this.updateSpritePositionBy(this.getSpriteOrientation() == 1 ? -xInc : xInc, this.getSpriteOrientation() == 2 ? -yInc : yInc);
        ++this.delayCount;
    }

    public void drawFrame(Graphics g) {
        int startIndex = this.data.frameTableIndex[this.framePoolPointer << 1];
        short endIndex = this.data.frameTableIndex[(this.framePoolPointer << 1) + 1];
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        while (startIndex < endIndex) {
            short clipIndex = this.data.framePoolTable[startIndex++];
            short x = this.data.framePoolTable[startIndex++];
            short y = this.data.framePoolTable[startIndex++];
            byte flag = (byte)this.data.framePoolTable[startIndex++];
            this.drawClip(g, x, y, clipIndex, flag);
            g.setClip(clipX, clipY, clipW, clipH);
        }
    }

    protected void drawClip(Graphics g, int x, int y, int clipIndex, byte flag) {
        if ((flag & 1) == 0) {
            byte imageId = (byte)((flag & 0xF8) >> 3);
            byte orientation = (byte)(flag & 7);
            orientation = (byte)(orientation >> 1);
            this.drawImageClip(g, x, y, imageId, clipIndex, orientation);
        } else if (flag == 1 || flag == 3) {
            int index = clipIndex * 5;
            this.drawEllipseClip(g, x, y, this.data.ellipseClipPool[index], this.data.ellipseClipPool[index + 1], this.data.ellipseClipPool[index + 2], this.data.ellipseClipPool[index + 3], this.data.ellipseClipPool[index + 4], flag == 3);
        } else if (flag == 5) {
            int index = clipIndex * 3;
            this.drawLineClip(g, x, y, this.data.lineClipPool[index], this.data.lineClipPool[index + 1], this.data.lineClipPool[index + 2]);
        } else if (flag == 7 || flag == 9) {
            int index = clipIndex * 3;
            this.drawRectangleClip(g, x, y, this.data.rectangleClipPool[index], this.data.rectangleClipPool[index + 1], this.data.rectangleClipPool[index + 2], flag == 9);
        } else if (flag == 11 || flag == 13) {
            int index = clipIndex * 5;
            this.drawRoundedRectangleClip(g, x, y, this.data.roundedRectangleClipPool[index], this.data.roundedRectangleClipPool[index + 1], this.data.roundedRectangleClipPool[index + 2], this.data.roundedRectangleClipPool[index + 3], this.data.roundedRectangleClipPool[index + 4], flag == 13);
        }
    }

    protected void drawImageClip(Graphics g, int x, int y, byte imageId, int clipIndex, byte orientation) {
        int index = clipIndex * 4;
        int clipX = this.data.imageClipPool[index++];
        int clipY = this.data.imageClipPool[index++];
        short clipW = this.data.imageClipPool[index++];
        short clipH = this.data.imageClipPool[index++];
        byte spriteOrientation = this.getSpriteOrientation();
        if (orientation == spriteOrientation) {
            orientation = 0;
        } else if (orientation == 0 || spriteOrientation == 0) {
            orientation = (byte)(orientation + spriteOrientation);
        } else {
            System.out.println("FLIP H and FLIP V, cannot be used at a same time, use your own implementation");
            return;
        }
        if (spriteOrientation == 1) {
            x = -x - clipW;
        } else if (spriteOrientation == 2) {
            y = -y - clipH;
        }
        if (this.data.splitImageClips) {
            Image img = ((Image[][])this.data.imageVector.elementAt(imageId))[clipIndex - this.data.imageIndexTable[imageId]][orientation];
            int xPos = x + this.getSpriteDrawX();
            int yPos = y + this.getSpriteDrawY();
            g.drawImage(img, xPos, yPos, 20);
        } else {
            Image[] imageArr = (Image[])this.data.imageVector.elementAt(imageId);
            int xPos = x + this.getSpriteDrawX();
            int yPos = y + this.getSpriteDrawY();
            g.clipRect(xPos, yPos, (int)clipW, (int)clipH);
            if (orientation == 1) {
                clipX = imageArr[0].getWidth() - clipW - clipX;
            } else if (orientation == 1) {
                clipY = imageArr[0].getHeight() - clipH - clipY;
            }
            g.drawImage(imageArr[orientation], xPos - clipX, yPos - clipY, 20);
        }
    }

    protected void drawEllipseClip(Graphics g, int x, int y, int width, int height, int startAngle, int endAngle, int color, boolean isFilled) {
        byte spriteOrientation = this.getSpriteOrientation();
        if (spriteOrientation == 1) {
            x = -x - width;
        } else if (spriteOrientation == 2) {
            y = -y - height;
        }
        int xPos = x + this.getSpriteDrawX();
        int yPos = y + this.getSpriteDrawY();
        g.setColor(color);
        if (isFilled) {
            g.fillArc(xPos, yPos, width, height, startAngle, endAngle);
        } else {
            g.drawArc(xPos, yPos, width, height, startAngle, endAngle);
        }
    }

    protected void drawLineClip(Graphics g, int x1, int y1, int x2, int y2, int color) {
        byte spriteOrientation = this.getSpriteOrientation();
        if (spriteOrientation == 1) {
            x1 = -x1;
            x2 = -x2;
        } else if (spriteOrientation == 2) {
            y1 = -y1;
            y2 = -y2;
        }
        int xPos1 = x1 + this.getSpriteDrawX();
        int xPos2 = x2 + this.getSpriteDrawX();
        int yPos1 = y1 + this.getSpriteDrawY();
        int yPos2 = y2 + this.getSpriteDrawY();
        g.setColor(color);
        g.drawLine(xPos1, yPos1, xPos2, yPos2);
    }

    protected void drawRectangleClip(Graphics g, int x, int y, int width, int height, int color, boolean isFilled) {
        g.setColor(color);
        byte spriteOrientation = this.getSpriteOrientation();
        if (spriteOrientation == 1) {
            x = -x - width;
        } else if (spriteOrientation == 2) {
            y = -y - height;
        }
        int xPos = x + this.getSpriteDrawX();
        int yPos = y + this.getSpriteDrawY();
        if (isFilled) {
            g.fillRect(xPos, yPos, width, height);
        } else {
            g.drawRect(xPos, yPos, width, height);
        }
    }

    protected void drawRoundedRectangleClip(Graphics g, int x, int y, int width, int height, int arcWidth, int arcHeight, int color, boolean isFilled) {
        byte spriteOrientation = this.getSpriteOrientation();
        if (spriteOrientation == 1) {
            x = -x - width;
        } else if (spriteOrientation == 2) {
            y = -y - height;
        }
        int xPos = x + this.getSpriteDrawX();
        int yPos = y + this.getSpriteDrawY();
        g.setColor(color);
        if (isFilled) {
            g.fillRoundRect(xPos, yPos, width, height, arcWidth, arcHeight);
        } else {
            g.drawRoundRect(xPos, yPos, width, height, arcWidth, arcHeight);
        }
    }

    protected abstract int getSpriteDrawX();

    protected abstract int getSpriteDrawY();

    protected abstract void updateSpritePositionBy(int var1, int var2);

    protected abstract byte getSpriteOrientation();

    protected abstract void notifyStartOfAnimation();

    protected abstract void notifyEndOfAnimation();
}

