/*
 * Decompiled with CFR 0.152.
 */
package HG.MotionWelder;

import HG.MotionWelder.MSpriteData;
import HG.MotionWelder.MSpriteImageLoader;
import HG.Tool.GraphicsTool;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class MSpriteLoader {
    public static final boolean NOT_SPLIT = false;
    private static Vector m_vTmpImg = new Vector();
    private static Vector m_vTmpImgName = new Vector();

    public static MSpriteData loadMSprite(String spriteName, boolean splitImageClips, MSpriteImageLoader imageloader) throws Exception {
        short[] positionerRectangleClipPool;
        int[] roundedRectangleClipPool;
        int[] rectangleClipPool;
        int[] lineClipPool;
        int[] ellipseClipPool;
        short[] imageIndex;
        short[] imageClipPool;
        short[] frameTableIndex;
        short[] framePoolTable;
        short[] frameTable;
        short[] animationTable;
        if (imageloader == null) {
            throw new IllegalArgumentException("Image Loader cannot be null");
        }
        MSpriteData data = new MSpriteData(splitImageClips);
        DataInputStream dstrm = new DataInputStream(new String().getClass().getResourceAsStream(spriteName));
        try {
            dstrm.readShort();
            dstrm.readUTF();
            int noOfAnimation = dstrm.readByte();
            animationTable = new short[noOfAnimation << 1];
            for (int i = 0; i < noOfAnimation; ++i) {
                animationTable[2 * i] = dstrm.readShort();
                animationTable[2 * i + 1] = dstrm.readShort();
            }
            int totalNoOfFrame = dstrm.readShort();
            frameTable = new short[totalNoOfFrame * 4];
            for (int i = 0; i < totalNoOfFrame; ++i) {
                frameTable[4 * i] = dstrm.readShort();
                frameTable[4 * i + 1] = dstrm.readByte();
                frameTable[4 * i + 2] = dstrm.readShort();
                frameTable[4 * i + 3] = dstrm.readShort();
            }
            short length = dstrm.readShort();
            int totalNumberOfClips = length >> 2;
            framePoolTable = new short[length];
            int noOfFrameInPool = dstrm.readShort();
            short index = 0;
            frameTableIndex = new short[noOfFrameInPool << 1];
            for (int i = 0; i < noOfFrameInPool; ++i) {
                frameTableIndex[2 * i] = index;
                int noOfClips = dstrm.readShort();
                for (int j = 0; j < noOfClips; ++j) {
                    short s = index;
                    index = (short)(index + 1);
                    framePoolTable[s] = dstrm.readShort();
                    short s2 = index;
                    index = (short)(index + 1);
                    framePoolTable[s2] = dstrm.readShort();
                    short s3 = index;
                    index = (short)(index + 1);
                    framePoolTable[s3] = dstrm.readShort();
                    short s4 = index;
                    index = (short)(index + 1);
                    framePoolTable[s4] = dstrm.readByte();
                }
                frameTableIndex[2 * i + 1] = (short)(index - 1);
            }
            short noOfImagesClips = dstrm.readShort();
            int noOfImages = dstrm.readByte();
            imageClipPool = new short[noOfImagesClips << 2];
            index = 0;
            imageIndex = new short[noOfImages];
            short noOfClipsRead = 0;
            for (int i = 0; i < noOfImages; ++i) {
                imageIndex[i] = noOfClipsRead;
                int noOfClipsInThisImage = dstrm.readShort();
                Image[][] imageArrayForClips = new Image[noOfClipsInThisImage][];
                for (int j = 0; j < noOfClipsInThisImage; ++j) {
                    short s = index;
                    index = (short)(index + 1);
                    short s5 = dstrm.readShort();
                    imageClipPool[s] = s5;
                    short x = s5;
                    short s6 = index;
                    index = (short)(index + 1);
                    short s7 = dstrm.readShort();
                    imageClipPool[s6] = s7;
                    short y = s7;
                    short s8 = index;
                    index = (short)(index + 1);
                    short s9 = dstrm.readShort();
                    imageClipPool[s8] = s9;
                    short w = s9;
                    short s10 = index;
                    index = (short)(index + 1);
                    short s11 = dstrm.readShort();
                    imageClipPool[s10] = s11;
                    short h = s11;
                    if (!splitImageClips) continue;
                    int orientationUsedInStudio = 0;
                    for (int k = 0; k < totalNumberOfClips; ++k) {
                        int pos = k << 2;
                        int clipIndex = framePoolTable[pos];
                        short flag = framePoolTable[pos + 3];
                        byte imageId = (byte)((flag & 0xF8) >> 3);
                        if ((clipIndex -= imageIndex[imageId]) != j || (flag & 1) != 0 || imageId != i) continue;
                        orientationUsedInStudio = (byte)(orientationUsedInStudio | (byte)(flag & 7));
                    }
                    imageArrayForClips[j] = imageloader.loadImageClip(spriteName, i, x, y, w, h, (byte)(orientationUsedInStudio >> 1));
                }
                noOfClipsRead = (short)(noOfClipsRead + noOfClipsInThisImage);
                if (splitImageClips) {
                    data.imageVector.addElement(imageArrayForClips);
                    continue;
                }
                int orientationUsedInStudio = 0;
                for (int k = 0; k < totalNumberOfClips; ++k) {
                    short flag = framePoolTable[(k << 2) + 3];
                    byte imageId = (byte)((flag & 0xF8) >> 3);
                    if ((flag & 1) != 0 || imageId != i) continue;
                    orientationUsedInStudio = (byte)(orientationUsedInStudio | (byte)(flag & 7));
                }
                data.imageVector.addElement(imageloader.loadImage(spriteName, i, (byte)(orientationUsedInStudio >> 1)));
            }
            int noOfEllipseClip = dstrm.readShort();
            ellipseClipPool = new int[noOfEllipseClip * 5];
            for (int i = 0; i < noOfEllipseClip; ++i) {
                ellipseClipPool[5 * i] = dstrm.readShort();
                ellipseClipPool[5 * i + 1] = dstrm.readShort();
                ellipseClipPool[5 * i + 2] = dstrm.readShort();
                ellipseClipPool[5 * i + 3] = dstrm.readShort();
                ellipseClipPool[5 * i + 4] = dstrm.readInt();
            }
            int noOfLineClip = dstrm.readShort();
            lineClipPool = new int[noOfLineClip * 3];
            for (int i = 0; i < noOfLineClip; ++i) {
                lineClipPool[3 * i] = dstrm.readShort();
                lineClipPool[3 * i + 1] = dstrm.readShort();
                lineClipPool[3 * i + 2] = dstrm.readInt();
            }
            int noOfRectangleClip = dstrm.readShort();
            rectangleClipPool = new int[noOfRectangleClip * 3];
            for (int i = 0; i < noOfRectangleClip; ++i) {
                rectangleClipPool[3 * i] = dstrm.readShort();
                rectangleClipPool[3 * i + 1] = dstrm.readShort();
                rectangleClipPool[3 * i + 2] = dstrm.readInt();
            }
            int noOfRoundedRectangleClip = dstrm.readShort();
            roundedRectangleClipPool = new int[noOfRoundedRectangleClip * 5];
            for (int i = 0; i < noOfRoundedRectangleClip; ++i) {
                roundedRectangleClipPool[5 * i] = dstrm.readShort();
                roundedRectangleClipPool[5 * i + 1] = dstrm.readShort();
                roundedRectangleClipPool[5 * i + 2] = dstrm.readShort();
                roundedRectangleClipPool[5 * i + 3] = dstrm.readShort();
                roundedRectangleClipPool[5 * i + 4] = dstrm.readInt();
            }
            int noOfPositionerRectangleClip = dstrm.readShort();
            positionerRectangleClipPool = new short[noOfPositionerRectangleClip << 1];
            for (int i = 0; i < noOfPositionerRectangleClip; ++i) {
                positionerRectangleClipPool[2 * i] = dstrm.readShort();
                positionerRectangleClipPool[2 * i + 1] = dstrm.readShort();
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (dstrm != null) {
                dstrm.close();
            }
        }
        data.animationTable = animationTable;
        data.frameTable = frameTable;
        data.frameTableIndex = frameTableIndex;
        data.framePoolTable = framePoolTable;
        data.imageClipPool = imageClipPool;
        data.ellipseClipPool = ellipseClipPool;
        data.lineClipPool = lineClipPool;
        data.rectangleClipPool = rectangleClipPool;
        data.roundedRectangleClipPool = roundedRectangleClipPool;
        data.positionerRectangleClipPool = positionerRectangleClipPool;
        data.imageIndexTable = imageIndex;
        return data;
    }

    public static Image[] loadImageClip(String sImgName, int x, int y, int w, int h, int orientationUsedInStudio) {
        int idx;
        boolean doYouNeedHFlippedSpriteInYourgame = false;
        boolean doYouNeedVFlippedSpriteInYourgame = false;
        Image baseImage = null;
        if (!sImgName.startsWith("/")) {
            sImgName = "/" + sImgName;
        }
        if ((idx = MSpriteLoader.getTmpImageIdx(sImgName)) != -1) {
            baseImage = (Image)m_vTmpImg.elementAt(idx);
        } else {
            try {
                baseImage = GraphicsTool.loadImage(sImgName);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            m_vTmpImgName.addElement(sImgName);
            m_vTmpImg.addElement(baseImage);
        }
        Image[] image = new Image[3];
        image[0] = Image.createImage((Image)baseImage, (int)x, (int)y, (int)w, (int)h, (int)0);
        image[0] = MSpriteLoader.createTransparencyImage(image[0], 0, 0xFFFFFF);
        if (orientationUsedInStudio == 1 || orientationUsedInStudio == 3 || doYouNeedHFlippedSpriteInYourgame) {
            image[1] = Image.createImage((Image)baseImage, (int)x, (int)y, (int)w, (int)h, (int)2);
        }
        if (orientationUsedInStudio == 2 || orientationUsedInStudio == 3 || doYouNeedVFlippedSpriteInYourgame) {
            image[2] = Image.createImage((Image)baseImage, (int)x, (int)y, (int)w, (int)h, (int)1);
        }
        return image;
    }

    private static int getTmpImageIdx(String sImgName) {
        for (int i = 0; i < m_vTmpImgName.size(); ++i) {
            if (!sImgName.equals(m_vTmpImgName.elementAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static void releaseTmpImage() {
        m_vTmpImgName.removeAllElements();
        m_vTmpImg.removeAllElements();
    }

    private static Image createTransparencyImage(Image img, int nAlpha, int nColor) {
        int[] argb = new int[img.getWidth() * img.getHeight()];
        img.getRGB(argb, 0, img.getWidth(), 0, 0, img.getWidth(), img.getHeight());
        for (int i = 0; i < argb.length; ++i) {
            if ((argb[i] & 0xFFFFFF) != nColor) continue;
            argb[i] = nAlpha << 24 | argb[i] & 0xFFFFFF;
        }
        return Image.createRGBImage((int[])argb, (int)img.getWidth(), (int)img.getHeight(), (boolean)true);
    }

    public static Image[] loadImage(String sImgName, int orientationUsedInStudio) {
        Image baseImage = null;
        if (!sImgName.startsWith("/")) {
            sImgName = "/" + sImgName;
        }
        try {
            baseImage = Image.createImage((String)sImgName);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Image[] image = new Image[3];
        image[0] = baseImage;
        if (orientationUsedInStudio == 1 || orientationUsedInStudio == 3) {
            image[1] = Image.createImage((Image)baseImage, (int)0, (int)0, (int)baseImage.getWidth(), (int)baseImage.getHeight(), (int)2);
        }
        if (orientationUsedInStudio == 2 || orientationUsedInStudio == 3) {
            image[2] = Image.createImage((Image)baseImage, (int)0, (int)0, (int)baseImage.getWidth(), (int)baseImage.getHeight(), (int)1);
        }
        return image;
    }
}

