/*
 * Decompiled with CFR 0.152.
 */
package HG.Tool;

import HG.Main.MainCanvas;
import HG.Scene.ScenePublic;
import HG.Tool.GraphicsTool;
import HG.Tool.TextTool;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DialogAnimation {
    MainCanvas canvas = null;
    private Image img_edge = null;
    private String[] str_tip = null;
    private int border_x = 0;
    private int border_y = 0;
    private int border_width = 0;
    private int border_height = 0;
    private int border_vcenter = 0;
    private int border_hcenter = 0;
    public int border_ftcolor = 0;
    public static boolean is_borderover = true;
    public static final int EDGE_W = 4;
    public static final int EDGE_H = 4;
    public static final int DIALOG_LINE_WH = 5;
    private final int BORDER_SPEED;
    public static final int COLOUR_DIALOG = 0;
    private static final int DIALOG_ROLLTIME = 100;
    private static final int DIALOG_ROLLSPEED = 4;
    public static final byte DIVISION_H_NONE = 0;
    public static final byte DIVISION_V_NONE = 1;
    public static final byte DIVISION_H_UP = 2;
    public static final byte DIVISION_H_DOWN = 3;
    public static final byte DIVISION_V_UP = 4;
    public static final byte DIVISION_V_DOWN = 5;
    private String dialog_name = null;
    private int dialog_h = 0;
    private int dialog_text_x = 0;
    private int dialog_text_y = 0;
    private int dialog_text_w = 0;
    public boolean is_dialogevent = false;
    private boolean is_show_rolltip = false;
    private byte time_show_rolltip = 0;
    private int pos_show_rolltip = 0;
    private boolean is_init_rollframe = false;
    private int colour_num = 0;
    private int colour_creak = 0;
    private byte color_symbol = 1;
    private final byte COLOUR_FLOOR = (byte)4;

    public DialogAnimation(MainCanvas mc) {
        this.BORDER_SPEED = 30;
        this.canvas = mc;
        try {
            this.img_edge = GraphicsTool.loadImage("/menu/dialog_edge.png");
        }
        catch (IOException ex) {
            System.out.println("Dialog image error");
            ex.printStackTrace();
        }
    }

    public void initDialogBorderAnimation(int x, int y, int width, int height) {
        this.resetAnimationColor();
        this.resetDialogBorderAnimation();
        if (width < 4) {
            width = 4;
        }
        if (height < 4) {
            height = 4;
        }
        this.border_x = 4;
        this.border_y = 4;
        this.border_width = width >> 1;
        this.border_height = height >> 1;
        this.border_vcenter = x + (width >> 1);
        this.border_hcenter = y + (height >> 1);
        is_borderover = false;
    }

    public void initOpaqueDialogBorderAnimation(int color, int opaque, int x, int y, int width, int height) {
        this.resetDialogBorderAnimation();
        if (width < 4) {
            width = 4;
        }
        if (height < 4) {
            height = 4;
        }
        this.border_x = 4;
        this.border_y = 4;
        this.border_width = width >> 1;
        this.border_height = height >> 1;
        this.border_vcenter = x + (width >> 1);
        this.border_hcenter = y + (height >> 1);
        GraphicsTool.createOpaqueData(color, opaque, width, height);
        is_borderover = false;
    }

    public void drawOpaqueDialogBorder(Graphics g) {
    }

    public void resetOpaqueDialogBorder() {
        this.resetDialogBorderAnimation();
        GraphicsTool.clearOpaque();
    }

    public void resetDialogBorderAnimation() {
        this.border_x = 0;
        this.border_y = 0;
        this.border_width = 0;
        this.border_height = 0;
        this.border_vcenter = 0;
        this.border_hcenter = 0;
        this.border_ftcolor = 0;
        is_borderover = true;
    }

    public void drawDialogBorderAnimation(Graphics g, int colour) {
        this.drawDialogBorder(g, colour, this.border_vcenter - this.border_x, this.border_hcenter - this.border_y, this.border_x << 1, this.border_y << 1);
    }

    public void runDialogBorderAnimation() {
        while (this.border_y < this.border_height - 30) {
            this.border_y += 30;
            this.canvas.refresh();
        }
        this.border_y = this.border_height;
        while (this.border_x < this.border_width - 30) {
            this.border_x += 30;
            this.canvas.refresh();
        }
        this.border_x = this.border_width;
        this.canvas.refresh();
        is_borderover = true;
    }

    public void resetAnimationColor() {
        this.border_ftcolor = 0;
    }

    public void setAnimationColor(Graphics g) {
        this.border_ftcolor = this.border_ftcolor > 0xDDDDDD ? 0xFFFFFF : this.border_ftcolor + 0x222222;
        g.setColor(this.border_ftcolor);
    }

    public void initDialogTip() {
        this.initDialogBorderAnimation(0, 160 - (TextTool.getCharDistance() >> 1) - 5, 240, TextTool.getCharDistance() + 10);
    }

    public void initDialogTip(boolean is_animation) {
        if (is_animation) {
            this.initDialogBorderAnimation(0, 160 - (TextTool.getCharDistance() >> 1) - 5, 240, TextTool.getCharDistance() + 10);
        }
    }

    public void drawDialogTip(Graphics g, boolean is_animation, String content, boolean is_left, boolean is_right) {
        if (is_animation) {
            this.drawDialogBorderAnimation(g, 0);
            if (is_borderover) {
                this.setAnimationColor(g);
                this.canvas.text.drawString(g, content, 120, 160, 3);
                ScenePublic.drawBottomIcon(g, is_left, is_right);
            }
        } else {
            this.drawDialogBorder(g, 0, 0, 160 - TextTool.getCharDistance(), 240, TextTool.getCharDistance() << 1);
            g.setColor(-1);
            this.canvas.text.drawString(g, content, 120, 160, 3);
            ScenePublic.drawBottomIcon(g, is_left, is_right);
        }
    }

    public void drawDialogTip(Graphics g, boolean is_animation, String content, int colour, boolean is_left, byte left_state, boolean is_right, byte right_state) {
        if (is_animation) {
            this.drawDialogBorderAnimation(g, 0);
            if (is_borderover) {
                this.setAnimationColor(g);
                this.canvas.text.drawString(g, content, 120, 160, 3);
                ScenePublic.drawBottomIconCN(g, colour, is_left, left_state, is_right, right_state);
            }
        } else {
            this.drawDialogBorder(g, 0, 0, 160 - TextTool.getCharDistance(), 240, TextTool.getCharDistance() << 1);
            g.setColor(-1);
            this.canvas.text.drawString(g, content, 120, 160, 3);
            ScenePublic.drawBottomIconCN(g, colour, is_left, left_state, is_right, right_state);
        }
    }

    public void initDialogTip(String[] content, boolean is_animation) {
        this.str_tip = content;
        if (is_animation) {
            this.initDialogBorderAnimation(0, 160 - (TextTool.getCharDistance() >> 1) * this.str_tip.length, 240, TextTool.getCharDistance() * this.str_tip.length);
        }
    }

    public void resetDialogTip() {
        this.str_tip = null;
    }

    public void drawDialogTip(Graphics g, boolean is_animation, boolean is_left, boolean is_right) {
        if (is_animation) {
            this.drawDialogBorderAnimation(g, 0);
            if (is_borderover) {
                this.setAnimationColor(g);
                for (int i = 0; i < this.str_tip.length; ++i) {
                    this.canvas.text.drawString(g, this.str_tip[i], 120, 160 - (TextTool.getCharDistance() >> 1) * (this.str_tip.length - 1) + i * TextTool.getCharDistance(), 3);
                }
                ScenePublic.drawBottomIcon(g, is_left, is_right);
            }
        } else {
            this.drawDialogBorder(g, 0, 0, 160 - (TextTool.getCharDistance() >> 1) * this.str_tip.length, 240, TextTool.getCharDistance() * this.str_tip.length);
            this.setAnimationColor(g);
            for (int i = 0; i < this.str_tip.length; ++i) {
                this.canvas.text.drawString(g, this.str_tip[i], 120, 160 - (TextTool.getCharDistance() >> 1) * (this.str_tip.length - 1) + i * TextTool.getCharDistance(), 3);
            }
            ScenePublic.drawBottomIcon(g, is_left, is_right);
        }
    }

    public void drawDialogTip(Graphics g, boolean is_animation, int colour, boolean is_left, byte left_state, boolean is_right, byte right_state) {
        if (is_animation) {
            this.drawDialogBorderAnimation(g, 0);
            if (is_borderover) {
                this.setAnimationColor(g);
                for (int i = 0; i < this.str_tip.length; ++i) {
                    this.canvas.text.drawString(g, this.str_tip[i], 120, 160 - (TextTool.getCharDistance() >> 1) * (this.str_tip.length - 1) + i * TextTool.getCharDistance(), 3);
                }
                ScenePublic.drawBottomIconCN(g, colour, is_left, left_state, is_right, right_state);
            }
        } else {
            this.drawDialogBorder(g, 0, 0, 160 - (TextTool.getCharDistance() >> 1) * this.str_tip.length, 240, TextTool.getCharDistance() * this.str_tip.length);
            this.setAnimationColor(g);
            for (int i = 0; i < this.str_tip.length; ++i) {
                this.canvas.text.drawString(g, this.str_tip[i], 120, 160 - (TextTool.getCharDistance() >> 1) * (this.str_tip.length - 1) + i * TextTool.getCharDistance(), 3);
            }
            ScenePublic.drawBottomIconCN(g, colour, is_left, left_state, is_right, right_state);
        }
    }

    public void drawDialogRollTip(Graphics g, String str, int y) {
        if (this.is_show_rolltip) {
            this.drawDialogBorder(g, 85, 0, y - (TextTool.getCharDistance() >> 1), 240, TextTool.getCharDistance());
            this.canvas.text.drawString(g, str, -1, this.pos_show_rolltip, y, 3);
            if (this.pos_show_rolltip + TextTool.stringWidth(str) < 0) {
                this.pos_show_rolltip = 240;
                this.is_show_rolltip = false;
            } else {
                this.pos_show_rolltip -= 2;
            }
        } else if (this.time_show_rolltip > 100) {
            this.is_show_rolltip = true;
            this.time_show_rolltip = 0;
            this.pos_show_rolltip = 240;
        } else {
            this.time_show_rolltip = (byte)(this.time_show_rolltip + 4);
        }
    }

    public void drawRollTip(Graphics g, String str, int x, int y, int width) {
        if (this.is_show_rolltip) {
            g.setColor(0);
            g.setClip(x, y, width, TextTool.getCharDistance());
            g.drawString(str, this.pos_show_rolltip, y, 20);
            if (this.pos_show_rolltip + TextTool.stringWidth(str) < x) {
                this.pos_show_rolltip = x + width;
                this.is_show_rolltip = false;
            } else {
                this.pos_show_rolltip -= 2;
            }
        } else if (this.time_show_rolltip > 100) {
            this.is_show_rolltip = true;
            this.time_show_rolltip = 0;
            this.pos_show_rolltip = x + width;
        } else {
            this.time_show_rolltip = (byte)(this.time_show_rolltip + 4);
        }
    }

    public void drawDialogRollFrame(Graphics g, String str, int colour, int x, int y, int w, int h) {
        if (!this.is_init_rollframe) {
            this.is_init_rollframe = true;
            this.time_show_rolltip = 0;
            this.pos_show_rolltip = 0;
            this.canvas.text.initText(str, 5 + x, 5 + y, w - 10, TextTool.getShowLine(h));
        }
        if (this.time_show_rolltip > 100) {
            this.time_show_rolltip = 0;
            if (this.canvas.text.PageEnd()) {
                this.canvas.text.resetPage();
            } else {
                this.canvas.text.keyPageDown(false);
            }
        } else {
            this.time_show_rolltip = (byte)(this.time_show_rolltip + 4);
        }
        this.drawDialogBorder(g, 0, x, y, w, h);
        g.setColor(colour);
        this.canvas.text.drawText(g, 0);
    }

    public void drawDialogNoBorderRollFrame(Graphics g, String str, int colour, int x, int y, int w, int h) {
        if (!this.is_init_rollframe) {
            this.is_init_rollframe = true;
            this.time_show_rolltip = 0;
            this.pos_show_rolltip = 0;
            this.canvas.text.initText(str, x, y, w, TextTool.getShowLine(h));
        }
        if (this.time_show_rolltip > 100) {
            this.time_show_rolltip = 0;
            if (this.canvas.text.PageEnd()) {
                this.canvas.text.resetPage();
            } else {
                this.canvas.text.keyPageDown(false);
            }
        } else {
            this.time_show_rolltip = (byte)(this.time_show_rolltip + 4);
        }
        g.setColor(colour);
        this.canvas.text.drawText(g, 0);
    }

    public void resetDialogRollFrame() {
        this.is_init_rollframe = false;
        this.canvas.text.resetText();
    }

    public void drawDialogBorder(Graphics g, int colour, int x, int y, int width, int height) {
        GraphicsTool.drawAlphaImageBK(g, x, y, width, height);
        DialogAnimation.drawBedeckForEdge(g, x, y, width, height);
        this.drawEdge(g, x, y, width, height);
    }

    public void drawDialogNoEdgeBorder(Graphics g, int colour, int x, int y, int width, int height) {
        DialogAnimation.drawBedeckForEdge(g, x, y, width, height);
        GraphicsTool.fillRect(g, colour, x + 5 - 1, y + 5 - 1, width - 5, height - 5);
    }

    public void drawDialogBorder(Graphics g, int start_colour, int end_colour, int x, int y, int width, int height) {
        this.colour_num = (height - 4) / 4;
        this.colour_creak = 0;
        if (start_colour > end_colour) {
            this.color_symbol = (byte)-1;
            this.colour_creak = start_colour - end_colour;
        } else {
            this.color_symbol = 1;
            this.colour_creak = end_colour - start_colour;
        }
        this.colour_creak = (this.colour_creak >> 16 & 0xFF) / this.colour_num << 16 | (this.colour_creak >> 8 & 0xFF) / this.colour_num << 8 | (this.colour_creak & 0xFF) / this.colour_num;
        DialogAnimation.drawBedeckForEdge(g, x, y, width, height);
        for (int i = 0; i < this.colour_num; ++i) {
            GraphicsTool.fillRect(g, start_colour + this.color_symbol * (this.colour_creak * i), x + 4, y + 4 + i * 4, width - 8, 4);
        }
        this.drawEdge(g, x, y, width, height);
    }

    public void drawDivisionLine(Graphics g, byte type, int x, int y, int width) {
        switch (type) {
            case 0: {
                GraphicsTool.drawLine(g, 5516308, x, y, x + width, y);
                GraphicsTool.drawLine(g, 10248460, x, y + 1, x + width, y + 1);
                GraphicsTool.drawLine(g, 15512971, x, y + 2, x + width, y + 2);
                GraphicsTool.drawLine(g, 16569530, x, y + 3, x + width, y + 3);
                GraphicsTool.drawLine(g, 5516308, x, y + 4, x + width, y + 4);
                break;
            }
            case 2: {
                GraphicsTool.drawLine(g, 5516308, x, y, x + width, y);
                GraphicsTool.drawLine(g, 16569530, x, y + 1, x + width, y + 1);
                GraphicsTool.drawLine(g, 15512971, x, y + 2, x + width, y + 2);
                GraphicsTool.drawLine(g, 10248460, x, y + 3, x + width, y + 3);
                GraphicsTool.drawLine(g, 5516308, x, y + 4, x + width, y + 4);
                g.setClip(x, y - 4 + 5, 4, 4);
                GraphicsTool.drawRegion(g, this.img_edge, 0, 4, 4, 4, 2, x, y - 4 + 5, 20);
                g.setClip(x + width - 4, y - 4 + 5, 4, 4);
                g.drawImage(this.img_edge, x + width - 4, y - 8 + 5, 20);
                break;
            }
            case 3: {
                GraphicsTool.drawLine(g, 5516308, x, y, x + width, y);
                GraphicsTool.drawLine(g, 10248460, x, y + 1, x + width, y + 1);
                GraphicsTool.drawLine(g, 15512971, x, y + 2, x + width, y + 2);
                GraphicsTool.drawLine(g, 16569530, x, y + 3, x + width, y + 3);
                GraphicsTool.drawLine(g, 5516308, x, y + 4, x + width, y + 4);
                g.setClip(x, y, 4, 4);
                g.drawImage(this.img_edge, x, y, 20);
                g.setClip(x + width - 4, y, 4, 4);
                GraphicsTool.drawRegion(g, this.img_edge, 0, 0, 4, 4, 2, x + width - 4, y, 20);
            }
        }
    }

    public static void drawBedeckForEdge(Graphics g, int x, int y, int width, int height) {
        GraphicsTool.drawLine(g, 4724752, x + 1, y, x + width - 2, y);
        GraphicsTool.drawRect(g, 4724752, x + 2, y + 2, width - 4, height - 4);
        GraphicsTool.drawRect(g, 4724752, x, y + 2, width, height - 4);
        GraphicsTool.drawLine(g, 4724752, x + 2, y + height - 1, x + width - 4, y + height - 1);
        GraphicsTool.drawRect(g, 16306288, x + 1, y + 1, width - 2, height - 2);
        GraphicsTool.drawRect(g, 4724752, x + 2, y + 2, width - 4, height - 4);
        GraphicsTool.drawRect(g, 9998456, x + 3, y + 3, width - 6, height - 5);
        GraphicsTool.drawLine(g, 0x882820, x + 3, y + height - 3, x + width - 3, y + height - 3);
    }

    public void drawEdge(Graphics g, int x, int y, int width, int height) {
        g.setClip(x, y, 4, 4);
        g.drawImage(this.img_edge, x, y, 20);
        g.setClip(x + width - 4, y, 4, 4);
        GraphicsTool.drawRegion(g, this.img_edge, 0, 0, 4, 4, 2, x + width - 4, y, 20);
        g.setClip(x, y + height - 4, 4, 4);
        g.drawImage(this.img_edge, x, y + height - 8, 20);
        g.setClip(x + width - 4, y + height - 4, 4, 4);
        GraphicsTool.drawRegion(g, this.img_edge, 0, 4, 4, 4, 2, x + width - 4, y + height - 4, 20);
    }
}

