/*
 * Decompiled with CFR 0.152.
 */
package HG.Tool;

import java.util.Random;

public class MathTool {
    private static Random random = new Random();
    public static final int[] ANGLE = new int[]{0, 175, 349, 523, 698, 872, 1045, 1219, 1392, 1564, 1736, 1908, 2079, 2250, 2419, 2588, 2756, 2924, 3090, 3256, 3420, 3584, 3746, 3907, 4067, 4226, 4384, 4540, 4695, 4848, 5000, 5150, 5299, 5446, 5592, 5736, 5878, 6018, 6157, 6293, 6428, 6561, 6691, 6820, 6947, 7071, 7193, 7314, 7431, 7547, 7660, 7771, 7880, 7986, 8090, 8192, 8290, 8387, 8480, 8572, 8660, 8746, 8829, 8910, 8988, 9063, 9135, 9205, 9272, 9336, 9397, 9455, 9511, 9563, 9613, 9659, 9703, 9744, 9781, 9816, 9848, 9877, 9903, 9925, 9945, 9962, 9976, 9986, 9994, 9998, 10000};

    public static final int getRandom(int min, int max) {
        int temp = 0;
        try {
            if (max == min) {
                return min;
            }
            if (max < min) {
                temp = min;
                min = max;
                max = temp;
            }
            temp = max - min + 1;
            temp = (random.nextInt() >>> 1) % temp;
            return temp += min;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static final int getRandom(int max) {
        return MathTool.getRandom(0, max - 1);
    }

    public static int I2F(int x) {
        return x << 16;
    }

    public static int F2I(int x) {
        return x >> 16;
    }

    public static final int getDistance(int x1, int y1, int x2, int y2) {
        int x = Math.abs(x2 - x1);
        int y = Math.abs(y2 - y1);
        int mn = Math.min(x, y);
        return x + y - (mn >> 1) - (mn >> 2) + (mn >> 3);
    }

    public static final int sqrt(int value) {
        int sqrt = 0;
        for (int k = 0x100000; k != 0; k >>= 2) {
            int tmp = sqrt + k;
            sqrt >>= 1;
            if (tmp > value) continue;
            value -= tmp;
            sqrt += k;
        }
        return sqrt;
    }

    public static void sort(int[] array, boolean isSmalltoLarge) {
        int temp = 0;
        if (isSmalltoLarge) {
            for (int i = 0; i < array.length; ++i) {
                for (int j = i + 1; j < array.length; ++j) {
                    if (array[i] <= array[j]) continue;
                    temp = array[i];
                    array[i] = array[j];
                    array[j] = temp;
                }
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                for (int j = i + 1; j < array.length; ++j) {
                    if (array[i] >= array[j]) continue;
                    temp = array[i];
                    array[i] = array[j];
                    array[j] = temp;
                }
            }
        }
    }

    public static void sort(int[][] array, int in) {
        MathTool.qsort(array, in, 0, array[in].length - 1);
    }

    private static void swap(int[][] array, int in, int i, int j) {
        int temp = 0;
        for (int k = 0; k < array.length; ++k) {
            temp = array[k][i];
            array[k][i] = array[k][j];
            array[k][j] = temp;
        }
    }

    private static int partition(int[][] array, int in, int begin, int end) {
        int index = MathTool.getRandom(begin, end);
        int pivot = array[in][index];
        MathTool.swap(array, in, index, end);
        for (int i = index = begin; i < end; ++i) {
            if (array[in][i] > pivot) continue;
            MathTool.swap(array, in, index++, i);
        }
        MathTool.swap(array, in, index, end);
        return index;
    }

    private static void qsort(int[][] array, int in, int begin, int end) {
        if (end > begin) {
            int index = MathTool.partition(array, in, begin, end);
            MathTool.qsort(array, in, begin, index - 1);
            MathTool.qsort(array, in, index + 1, end);
        }
    }

    public static final void quickSort(int[] data, boolean smallToBig) {
        int low = 0;
        int high = data.length - 1;
        MathTool.quickSort(data, low, high, smallToBig);
    }

    private static final void quickSort(int[] data, int low, int high, boolean smallToBig) {
        if (low < high) {
            int pivot = MathTool.partition(data, low, high, smallToBig);
            MathTool.quickSort(data, low, pivot - 1, smallToBig);
            MathTool.quickSort(data, pivot + 1, high, smallToBig);
        }
    }

    private static final int partition(int[] data, int low, int high, boolean smallToBig) {
        int pos = low;
        int pivot = data[pos];
        for (int i = low + 1; i <= high; ++i) {
            if (smallToBig) {
                if (data[i] >= pivot) continue;
                MathTool.swapData(data, ++pos, i);
                continue;
            }
            if (data[i] <= pivot) continue;
            MathTool.swapData(data, ++pos, i);
        }
        MathTool.swapData(data, low, pos);
        return pos;
    }

    private static final void swapData(int[] data, int i, int j) {
        int tmp = data[i];
        data[i] = data[j];
        data[j] = tmp;
    }

    public static int sin(int value) {
        if (value < 0) {
            value *= -1;
            value %= 360;
            value = 360 - value;
        }
        if (value >= 360) {
            value %= 360;
        }
        if (value <= 90) {
            return ANGLE[value];
        }
        if (value > 90 && value <= 180) {
            return ANGLE[90 - (value - 90)];
        }
        if (value > 180 && value <= 270) {
            return -ANGLE[value - 180];
        }
        return -ANGLE[360 - value];
    }

    public static int cos(int value) {
        if (value < 0) {
            value *= -1;
            value %= 360;
            value = 360 - value;
        }
        if (value >= 360) {
            value %= 360;
        }
        if (value <= 90) {
            return MathTool.sin(90 - value);
        }
        if (value > 90 && value <= 180) {
            return -MathTool.sin(value - 90);
        }
        if (value > 180 && value <= 270) {
            return MathTool.sin(270 - (value - 180));
        }
        return -MathTool.sin(360 - (value - 270));
    }

    public static int tan(int value) {
        return MathTool.sin(value) / MathTool.cos(value);
    }
}

