/*
 * Decompiled with CFR 0.152.
 */
package HG.Tool;

import HG.Game.Item;
import HG.Game.Player;
import HG.Game.Weapon;
import HG.Main.MainCanvas;
import HG.Public.Constant;
import HG.Public.Function;
import HG.Scene.GameScene;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.rms.RecordStore;

public class StreamTool {
    public String[] loadLangUnicode(String name) {
        InputStream is = this.getClass().getResourceAsStream(name);
        DataInputStream dis = new DataInputStream(is);
        String[] lang = null;
        try {
            int numLines = dis.readShort();
            lang = new String[numLines];
            for (int i = 0; i < numLines; ++i) {
                lang[i] = dis.readUTF();
            }
            dis.close();
            is.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return lang;
    }

    public static String loadTxt(Object obj, String sTxtFile) {
        try {
            InputStream is = obj.getClass().getResourceAsStream(sTxtFile);
            DataInputStream dis = new DataInputStream(is);
            int nSize = dis.available();
            if (nSize <= 0) {
                nSize = 10240;
            }
            byte[] ab = new byte[nSize];
            int temp = 0;
            int pos = 0;
            while ((temp = dis.read()) != -1) {
                ab[pos] = (byte)(temp & 0xFF);
                ++pos;
            }
            nSize = pos;
            String s = Function.decodeBytes(ab, 0, nSize);
            s = s.substring(1);
            return s;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static String loadUtf8Txt(Object obj, String sTxtFile) {
        try {
            InputStream is = obj.getClass().getResourceAsStream(sTxtFile);
            DataInputStream dis = new DataInputStream(is);
            int nSize = dis.available();
            if (nSize <= 0) {
                nSize = 10240;
            }
            byte[] ab = new byte[nSize];
            int temp = 0;
            int pos = 0;
            while ((temp = dis.read()) != -1) {
                ab[pos] = (byte)(temp & 0xFF);
                ++pos;
            }
            nSize = pos;
            String s = new String(ab);
            return s;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public short[][] loadShort(String name, int line, int col) {
        InputStream is = this.getClass().getResourceAsStream("/map/" + name);
        DataInputStream dis = new DataInputStream(is);
        short[][] res = new short[line][col];
        for (int i = 0; i < line; ++i) {
            for (int j = 0; j < col; ++j) {
                try {
                    res[i][j] = dis.readShort();
                    continue;
                }
                catch (IOException e) {
                    System.out.println("map data error");
                }
            }
        }
        return res;
    }

    public byte[][] loadByte(String name, int line, int col) {
        InputStream is = this.getClass().getResourceAsStream(name);
        DataInputStream dis = new DataInputStream(is);
        byte[][] res = new byte[line][col];
        for (int i = 0; i < line; ++i) {
            for (int j = 0; j < col; ++j) {
                try {
                    res[i][j] = dis.readByte();
                    System.out.print(res[i][j] + "\t");
                    continue;
                }
                catch (IOException e) {
                    System.out.println("map data error");
                }
            }
            System.out.println();
        }
        return res;
    }

    public byte[] loadByte(String name, int number) {
        InputStream is = this.getClass().getResourceAsStream("/map/" + name);
        DataInputStream dis = new DataInputStream(is);
        byte[] res = new byte[number];
        for (int i = 0; i < number; ++i) {
            try {
                res[i] = dis.readByte();
                continue;
            }
            catch (IOException e) {
                System.out.println("map data error");
            }
        }
        return res;
    }

    public short[][] loadEnemyAttribute(String name) {
        byte[] data = this.getResDate(name);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data, 0, data.length);
            DataInputStream dis = new DataInputStream(bais);
            int length = dis.readShort();
            short[][] mEnemyAttribute = new short[length][];
            for (int i = 0; i < length; ++i) {
                mEnemyAttribute[i] = new short[15];
                for (int j = 0; j < 15; ++j) {
                    mEnemyAttribute[i][j] = dis.readShort();
                }
            }
            return mEnemyAttribute;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public short[][] loadCommands(String name) {
        byte[] data = this.getResDate(name);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data, 0, data.length);
            DataInputStream dis = new DataInputStream(bais);
            int length = dis.readShort();
            short[][] commands = new short[length][];
            for (int i = 0; i < length; ++i) {
                commands[i] = new short[17];
                for (int j = 0; j < 16; ++j) {
                    commands[i][j] = dis.readShort();
                }
                commands[i][16] = 0;
            }
            return commands;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] getResDate(String ResName) {
        try {
            InputStream is = this.getClass().getResourceAsStream(ResName);
            DataInputStream dis = new DataInputStream(is);
            int nSize = dis.available();
            if (nSize <= 0) {
                nSize = 20480;
            }
            byte[] ab = new byte[nSize];
            int temp = 0;
            int len = 0;
            while ((temp = dis.read()) != -1) {
                ab[len] = (byte)(temp & 0xFF);
                ++len;
            }
            if (nSize != len) {
                byte[] ab2 = new byte[len];
                System.arraycopy(ab, 0, ab2, 0, len);
                ab = ab2;
            }
            return ab;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void SaveGame(MainCanvas mc) {
        try {
            int i;
            RecordStore record = RecordStore.openRecordStore((String)"GoWest", (boolean)true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(Constant.index_story);
            dos.writeInt(Constant.index_newLevel);
            dos.writeInt(Constant.index_newLevelStart);
            dos.writeInt(Constant.index_newHideLevel);
            dos.writeInt(Constant.index_newHideLevelStart);
            Player.makeSomeStorePlayerProperty();
            for (int i2 = 0; i2 < Player.getPlayerPropertyArray().length; ++i2) {
                dos.writeInt(Player.getPlayerPropertyArray()[i2]);
            }
            dos.writeByte(Player.player_useMagic_0);
            dos.writeByte(Player.player_useMagic_star);
            dos.writeByte(Player.player_useMagic_pound);
            dos.writeInt(Player.player_WeaponType);
            dos.writeByte(GameScene.getPlayer().player_useWeapon.weapon_id);
            int size = GameScene.getPlayer().player_WeaponBag.getWeaponBag().size();
            dos.writeInt(size);
            for (int i3 = 0; i3 < size; ++i3) {
                dos.writeByte(GameScene.getPlayer().player_WeaponBag.getIndexOfWeapon((int)i3).weapon_id);
                dos.writeInt(GameScene.getPlayer().player_WeaponBag.getIndexOfWeapon((int)i3).weapon_holdnum);
            }
            Item item = null;
            for (i = 0; i < GameScene.getPlayer().player_ItemBag.getItemBag().length; ++i) {
                item = GameScene.getPlayer().player_ItemBag.getIndexOfItem(i);
                if (item != null) {
                    dos.writeInt(item.item_holdnum);
                    continue;
                }
                dos.writeInt(0);
            }
            size = Player.player_MissionItem.length;
            dos.writeInt(size);
            for (i = 0; i < size; ++i) {
                dos.writeBoolean(Player.player_MissionItem[i]);
            }
            for (i = 0; i < Constant.LEVEL_ZONE_STATE.length; ++i) {
                for (int j = 0; j < Constant.LEVEL_ZONE_STATE[0].length; ++j) {
                    dos.writeBoolean(Constant.LEVEL_ZONE_STATE[i][j]);
                }
            }
            Constant.is_haveSave = true;
            byte[] saveGame = baos.toByteArray();
            if (record.getNumRecords() == 0) {
                record.addRecord(saveGame, 0, saveGame.length);
            } else {
                record.setRecord(1, saveGame, 0, saveGame.length);
            }
            dos.close();
            baos.close();
            record.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("save score error");
        }
    }

    public int LoadGame() {
        try {
            int i;
            RecordStore record = RecordStore.openRecordStore((String)"GoWest", (boolean)false);
            if (record.getNumRecords() == 0) {
                record.closeRecordStore();
                return 0;
            }
            byte[] loadGame = record.getRecord(1);
            ByteArrayInputStream bais = new ByteArrayInputStream(loadGame);
            DataInputStream dis = new DataInputStream(bais);
            Constant.index_story = dis.readInt();
            Constant.index_newLevel = dis.readInt();
            Constant.index_newLevelStart = dis.readInt();
            Constant.index_newHideLevel = dis.readInt();
            Constant.index_newHideLevelStart = dis.readInt();
            for (int i2 = 0; i2 < GameScene.getPlayer().getPlayerData().length; ++i2) {
                GameScene.getPlayer().getPlayerData()[i2] = dis.readInt();
            }
            Player.player_useMagic_0 = dis.readByte();
            Player.player_useMagic_star = dis.readByte();
            Player.player_useMagic_pound = dis.readByte();
            Player.player_WeaponType = dis.readInt();
            GameScene.getPlayer().player_useWeapon = new Weapon(dis.readByte());
            int size = dis.readInt();
            for (int i3 = 0; i3 < size; ++i3) {
                GameScene.getPlayer().player_WeaponBag.addWeapon(new Weapon(dis.readByte()));
                GameScene.getPlayer().player_WeaponBag.getIndexOfWeapon((int)i3).weapon_holdnum = dis.readInt();
            }
            int item_num = 0;
            for (i = 0; i < GameScene.getPlayer().player_ItemBag.getItemBag().length; ++i) {
                item_num = dis.readInt();
                if (item_num == 0) continue;
                GameScene.getPlayer().player_ItemBag.addItem(i);
                GameScene.getPlayer().player_ItemBag.getIndexOfItem((int)i).item_holdnum = item_num;
            }
            size = dis.readInt();
            for (i = 0; i < size; ++i) {
                Player.player_MissionItem[i] = dis.readBoolean();
            }
            for (i = 0; i < Constant.LEVEL_ZONE_STATE.length; ++i) {
                for (int j = 0; j < Constant.LEVEL_ZONE_STATE[0].length; ++j) {
                    Constant.LEVEL_ZONE_STATE[i][j] = dis.readBoolean();
                }
            }
            dis.close();
            bais.close();
            record.closeRecordStore();
            return 1;
        }
        catch (Exception e) {
            System.out.println("loadgame score error");
            return 0;
        }
    }

    public boolean checkLoad() {
        try {
            RecordStore record = RecordStore.openRecordStore((String)"GoWest", (boolean)false);
            if (record.getNumRecords() == 0) {
                record.closeRecordStore();
                return false;
            }
            byte[] loadGame = record.getRecord(1);
            if (loadGame == null) {
                return false;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(loadGame);
            DataInputStream dis = new DataInputStream(bais);
            dis.close();
            bais.close();
            record.closeRecordStore();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean deleteGameRecord() {
        try {
            RecordStore record = RecordStore.openRecordStore((String)"GoWest", (boolean)false);
            if (record.getNumRecords() == 0) {
                record.closeRecordStore();
                return false;
            }
            record.deleteRecord(1);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

