/*
 * Decompiled with CFR 0.152.
 */
package HG.Animation;

import HG.Main.MainCanvas;
import HG.Tool.GraphicsTool;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Map {
    private MainCanvas canvas = null;
    private int tileWidth;
    private int tileHeight;
    private int tilesWide;
    private int tilesHigh;
    private int[] lgraphicSetsUsedayers;
    private short[][] levelDef;
    private byte[][] levelDefTrans;
    public Image mapBufferImg = null;
    public Graphics gMapBuffer = null;
    public int mapBufferWidth = 0;
    public int mapBufferHeight = 0;
    public int mapBufferOffsetX = -1;
    public int mapBufferStartX = -1;
    private Image[] tileImages = null;
    public static final int LAYERS = 2;
    private static Image[] img_tileLib = null;

    public void gainBufferFromOtherMap(Map map) {
        this.mapBufferImg = map.mapBufferImg;
        this.gMapBuffer = map.gMapBuffer;
        this.mapBufferWidth = map.mapBufferWidth;
        this.mapBufferHeight = map.mapBufferHeight;
        this.mapBufferOffsetX = -1;
        this.mapBufferStartX = -1;
    }

    public Map(MainCanvas mc, int mapID) {
        this(mc, mapID, false);
    }

    public Map(MainCanvas mc, int mapID, boolean useBuffer) {
        this(mc, "/map/level", "/map", mapID, useBuffer);
    }

    public Map(MainCanvas mc, String path, String folder, int mapID, boolean useBuffer) {
        this.canvas = mc;
        if (img_tileLib == null) {
            img_tileLib = new Image[11];
        }
        try {
            ByteArrayInputStream bytes = new ByteArrayInputStream(MainCanvas.stream.getResDate(path + mapID));
            DataInputStream dis = new DataInputStream(bytes);
            this.tilesWide = dis.readShort();
            this.tilesHigh = dis.readShort();
            this.tileWidth = dis.readByte();
            this.tileHeight = dis.readByte();
            this.lgraphicSetsUsedayers = new int[2];
            for (int i = 0; i < 2; ++i) {
                this.lgraphicSetsUsedayers[i] = dis.readByte();
            }
            int tilesLen = this.tilesWide * this.tilesHigh;
            this.levelDef = new short[2][tilesLen];
            this.levelDefTrans = new byte[2][tilesLen];
            for (int i = 0; i < 2; i = (int)((byte)(i + 1))) {
                for (int j = 0; j < tilesLen; ++j) {
                    short levelInfo = dis.readShort();
                    this.levelDef[i][j] = (short)((levelInfo & 0xFFF) - 1);
                    this.levelDefTrans[i][j] = (byte)(levelInfo >> 12 & 0xF);
                }
            }
            dis.close();
            System.gc();
            this.extractTiles(folder);
            if (useBuffer) {
                this.mapBufferWidth = (240 / this.tileWidth + 1) * this.tileWidth;
                this.mapBufferHeight = 320;
                this.mapBufferImg = Image.createImage((int)this.mapBufferWidth, (int)this.mapBufferHeight);
                this.gMapBuffer = this.mapBufferImg.getGraphics();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTilesWide() {
        return this.tilesWide;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    private void extractTiles(String folder) {
        this.tileImages = new Image[2];
        try {
            for (int i = 0; i < 2; ++i) {
                this.tileImages[i] = this.loadLibIamge(folder, this.lgraphicSetsUsedayers[i]);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private Image loadLibIamge(String folder, int id) throws IOException {
        if (img_tileLib[id] == null) {
            Map.img_tileLib[id] = GraphicsTool.loadImage(folder + "/tileSet0" + id + "_" + this.tileWidth + "X" + this.tileHeight + ".png");
        }
        return img_tileLib[id];
    }

    public static void clearMapLib() {
        if (img_tileLib != null) {
            for (int i = 0; i < img_tileLib.length; ++i) {
                Map.img_tileLib[i] = null;
            }
        }
    }

    public void drawMap(Graphics g, int offsetX, int offsetY) {
        if (this.mapBufferImg != null) {
            offsetX *= -1;
            offsetY *= -1;
            if (this.mapBufferStartX == -1) {
                this.initBuffer(offsetX, offsetY);
            } else {
                int newTilePosX = offsetX / this.tileWidth;
                int oldTilePosX = this.mapBufferOffsetX / this.tileWidth;
                if (newTilePosX < oldTilePosX) {
                    newTilePosX += this.tilesWide;
                }
                if (oldTilePosX != newTilePosX) {
                    int startX = this.mapBufferStartX / this.tileWidth * this.tileWidth;
                    for (int i = oldTilePosX + 1; i <= newTilePosX; ++i) {
                        int posIndex = i % this.tilesWide;
                        for (int j = 0; j < this.tilesHigh; ++j) {
                            for (int k = 0; k < 2; ++k) {
                                short info = this.levelDef[k][j * this.tilesWide + posIndex];
                                if (info < 0) continue;
                                int src_width = this.tileImages[k].getWidth() / this.tileWidth;
                                int x_src = info % src_width * this.tileWidth;
                                int y_src = info / src_width * this.tileHeight;
                                GraphicsTool.drawRegion(this.gMapBuffer, this.tileImages[k], x_src, y_src, this.tileWidth, this.tileHeight, this.levelDefTrans[k][j * this.tilesWide + posIndex], startX, j * this.tileHeight, 0);
                            }
                        }
                        startX += this.tileWidth;
                        startX %= this.mapBufferWidth;
                    }
                }
                this.mapBufferStartX += (offsetX >= this.mapBufferOffsetX ? offsetX : offsetX + this.tileWidth * this.tilesWide) - this.mapBufferOffsetX;
                this.mapBufferStartX %= this.mapBufferWidth;
                this.mapBufferOffsetX = offsetX;
            }
            GraphicsTool.drawRegion(g, this.mapBufferImg, this.mapBufferStartX, 0, this.mapBufferWidth - this.mapBufferStartX, this.mapBufferHeight, 0, 0, 0, 20);
            GraphicsTool.drawRegion(g, this.mapBufferImg, 0, 0, this.mapBufferStartX, this.mapBufferHeight, 0, this.mapBufferWidth - this.mapBufferStartX, 0, 20);
        } else {
            for (int i = 0; i < this.tilesWide; ++i) {
                for (int j = 0; j < this.tilesHigh; ++j) {
                    int x = i * this.tileWidth + offsetX;
                    int y = j * this.tileHeight + offsetY;
                    if (x + this.tileWidth < 0 || x > 240 || y + this.tileHeight < 0 || y > 320) continue;
                    for (int k = 0; k < 2; ++k) {
                        short info = this.levelDef[k][j * this.tilesWide + i];
                        if (info < 0) continue;
                        int src_width = this.tileImages[k].getWidth() / this.tileWidth;
                        int x_src = info % src_width * this.tileWidth;
                        int y_src = info / src_width * this.tileHeight;
                        GraphicsTool.drawRegion(g, this.tileImages[k], x_src, y_src, this.tileWidth, this.tileHeight, this.levelDefTrans[k][j * this.tilesWide + i], x, y, 0);
                    }
                }
            }
        }
    }

    public void initBuffer(int offsetX, int offsetY) {
        this.mapBufferStartX = 0;
        this.mapBufferOffsetX = offsetX;
        for (int i = 0; i < this.tilesWide; ++i) {
            for (int j = 0; j < this.tilesHigh; ++j) {
                int x = i * this.tileWidth + offsetX;
                int y = j * this.tileHeight + offsetY;
                if (x + this.tileWidth < 0 || x > this.mapBufferWidth || y + this.tileHeight < 0 || y > this.mapBufferHeight) continue;
                for (int k = 0; k < 2; ++k) {
                    short info = this.levelDef[k][j * this.tilesWide + i];
                    if (info < 0) continue;
                    int src_width = this.tileImages[k].getWidth() / this.tileWidth;
                    int x_src = info % src_width * this.tileWidth;
                    int y_src = info / src_width * this.tileHeight;
                    this.gMapBuffer.drawRegion(this.tileImages[k], x_src, y_src, this.tileWidth, this.tileHeight, (int)this.levelDefTrans[k][j * this.tilesWide + i], x, y, 0);
                }
            }
        }
    }
}

