/*
 * Decompiled with CFR 0.152.
 */
package HG.Animation;

import HG.Animation.ColRect;
import HG.Tool.GraphicsTool;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PWPifLifeAnimations {
    public static final byte TRANSFORM_NONE = 0;
    public static final byte TRANSFORM_FLIP_HORIZONTAL = 1;
    public Vector mColRects = new Vector();
    public static final int POOL_DEFAULT_SIZE = 220;
    public static final int POOL_FONT_SIZE = 50;
    int m_precalImagesOffset;
    int m_precalImagesPoolID = -1;
    public static final int POOL_DEFAULT = 0;
    public static final int POOL_FONT = 1;
    public static final int POOLS_COUNT = 2;
    static Image[][] s_precalcImages = new Image[2][];
    static short[][] s_precalcImageId = new short[2][];
    static short[][] s_precalcStack = new short[2][];
    static short[] s_precalcImagesCount = new short[2];
    static short[] s_precalcImageLast = new short[2];
    boolean staticCache = false;
    int bufferSize;
    int[] bufferTmp = null;
    int[] bufferTmpStatic = null;
    int[] bufferToUse;
    int[] beginSprite;
    static int lastPositionBufferStatic;
    int lastPositionBuffer;
    int[] palettes;
    int[] pixelsStartIndex;
    byte[] pixels;
    byte numBitsIndex;
    int indexMask;
    public int paletteNumColors;
    public int numBitsPalette;
    public int numRepetitions;
    byte[] cachePalettes = null;
    public Image[] images;
    public byte numPalettes;
    public byte currentPalette = 0;
    public int numSprites;
    short[] spritesXYDim;
    byte[] spritesDim;
    short[] frameBegins;
    byte[] frames;
    public short[] animationsBegins;
    public int[] animations;
    public int[] animationLengths;
    public short numAnimations;
    boolean animFinish;
    int framePainted;
    public static final int PIF = 0;
    public static final int PNG = 1;
    public static final int FOREIGN_PNG = 2;
    byte pngMode;
    boolean isLongFormatted;
    Image[] sprImg;
    boolean isNMSF = false;
    Image imgSrc;
    public Image imgScrAlpha;
    private static int[] crc_table;

    private Vector ReadDataChunk(DataInputStream dis, Vector vec, int v) {
        try {
            int col_rect_num = dis.readByte();
            for (int n = 0; n < col_rect_num; ++n) {
                ColRect col_rect = new ColRect();
                col_rect.line_or_rect = (byte)v;
                col_rect.ReadData(dis);
                if (col_rect.w > 0 && col_rect.h > 0) {
                    vec.addElement(col_rect);
                    continue;
                }
                col_rect = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vec;
    }

    private void ReadColData(DataInputStream dis) {
        try {
            if (dis.available() == 0) {
                return;
            }
            int num_frms = dis.readShort();
            for (int m = 0; m < num_frms; ++m) {
                Vector v_buf = new Vector();
                v_buf = this.ReadDataChunk(dis, v_buf, 1);
                v_buf = this.ReadDataChunk(dis, v_buf, 0);
                this.mColRects.addElement(v_buf);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void SetPrecalcImagePoolSize(int poolID) {
        PWPifLifeAnimations.s_precalcStack[poolID] = new short[s_precalcImagesCount[poolID]];
        for (int i = 0; i < s_precalcStack[poolID].length; ++i) {
            PWPifLifeAnimations.s_precalcStack[poolID][i] = -1;
        }
        switch (poolID) {
            case 1: {
                PWPifLifeAnimations.s_precalcImages[1] = new Image[50];
                PWPifLifeAnimations.s_precalcImageId[1] = new short[50];
                break;
            }
            default: {
                PWPifLifeAnimations.s_precalcImages[0] = new Image[220];
                PWPifLifeAnimations.s_precalcImageId[0] = new short[220];
            }
        }
    }

    public static void FreePrecalcImagePool(int poolID) {
        int i;
        PWPifLifeAnimations.s_precalcImageLast[poolID] = 0;
        switch (poolID) {
            default: 
        }
        if (s_precalcStack[0] != null) {
            for (i = 0; i < s_precalcStack[0].length; ++i) {
                PWPifLifeAnimations.s_precalcStack[0][i] = -1;
            }
        }
        if (s_precalcImages[0] != null) {
            for (i = 0; i < s_precalcImages[0].length; ++i) {
                PWPifLifeAnimations.s_precalcImages[0][i] = null;
            }
        }
        PWPifLifeAnimations.s_precalcImagesCount[poolID] = 0;
        System.gc();
    }

    public void EnablePrecalcImage(int poolID) {
        this.m_precalImagesOffset = s_precalcImagesCount[poolID];
        int n = poolID;
        s_precalcImagesCount[n] = (short)(s_precalcImagesCount[n] + this.numPalettes * this.numSprites);
        this.m_precalImagesPoolID = poolID;
    }

    public Image buildSprImage(int sprIndex, int palIndex) {
        int bitsCount = 0;
        int width = this.getSpriteW(sprIndex);
        int height = this.getSpriteH(sprIndex);
        if (width == 1 && height == 1) {
            return null;
        }
        int[] bufferSpr = new int[width * height];
        for (int i = this.pixelsStartIndex[sprIndex]; i < this.pixelsStartIndex[sprIndex + 1]; ++i) {
            int index = this.indexMask & this.pixels[i];
            int rep = ((0xFF & this.pixels[i]) >>> this.numBitsIndex) + 1;
            System.arraycopy(this.palettes, palIndex * this.numRepetitions * this.paletteNumColors + index * this.numRepetitions, bufferSpr, bitsCount, rep);
            bitsCount += rep;
        }
        return Image.createRGBImage((int[])bufferSpr, (int)width, (int)height, (boolean)true);
    }

    public PWPifLifeAnimations(byte[] data, boolean staticCache) {
        this(data, 0, null, false, -1, false, false, staticCache);
    }

    public PWPifLifeAnimations(byte[] data, int PoolID, boolean staticCache) {
        this(data, 0, null, false, -1, false, false, staticCache);
        if (!staticCache) {
            this.EnablePrecalcImage(PoolID);
        }
    }

    public PWPifLifeAnimations(byte[] data, int offset, int[] palettesToLoad, boolean cachePalettes, int sizeBuffer, boolean staticCache) {
        this(data, offset, palettesToLoad, cachePalettes, sizeBuffer, false, false, staticCache);
    }

    public PWPifLifeAnimations(byte[] data, int offset, int[] palettesToLoad, boolean cachePalettes, int sizeBuffer, boolean groupMode, boolean isNMSF, boolean staticCache) {
        this.isNMSF = isNMSF;
        this.staticCache = staticCache;
        try {
            int k;
            int j;
            int elementId;
            ByteArrayInputStream bais = new ByteArrayInputStream(data, offset, data.length - offset);
            DataInputStream dis = new DataInputStream(bais);
            this.pngMode = 0;
            int minBufferSize = 0;
            byte version = dis.readByte();
            if (version == 1) {
                this.isLongFormatted = dis.readByte() == 1;
            }
            int numSprites = dis.readShort();
            this.numSprites = numSprites;
            this.spritesDim = this.isLongFormatted ? new byte[numSprites << 2] : new byte[numSprites << 1];
            for (int j2 = 0; j2 < numSprites; ++j2) {
                elementId = j2 << 1;
                this.updateArray(dis, this.spritesDim, elementId);
                this.updateArray(dis, this.spritesDim, elementId + 1);
                int dim = this.getUnsignedIntValueFromArray(this.spritesDim, elementId) * this.getUnsignedIntValueFromArray(this.spritesDim, elementId + 1);
                minBufferSize = dim > minBufferSize ? dim : minBufferSize;
            }
            int maxPalettes = dis.readByte();
            this.paletteNumColors = 0xFF & dis.readByte();
            this.numBitsPalette = 0xFF & dis.readByte();
            int n = this.numRepetitions = this.numBitsPalette == 0 ? 1 : 2 << this.numBitsPalette - 1;
            if (palettesToLoad == null) {
                palettesToLoad = new int[maxPalettes];
                for (int k2 = 0; k2 < maxPalettes; ++k2) {
                    palettesToLoad[k2] = k2;
                }
            }
            this.numPalettes = (byte)palettesToLoad.length;
            this.palettes = new int[this.numPalettes * this.paletteNumColors * this.numRepetitions];
            this.sprImg = new Image[(numSprites + 1) * this.numPalettes];
            byte[] arrayAux = new byte[maxPalettes * this.paletteNumColors * 2];
            dis.read(arrayAux);
            if (palettesToLoad != null) {
                for (int pal = 0; pal < palettesToLoad.length; ++pal) {
                    int pos = palettesToLoad[pal] * this.paletteNumColors * 2;
                    int c = 0;
                    while (c < this.paletteNumColors) {
                        int color = PWPifLifeAnimations.toIntRGBA(arrayAux, pos);
                        for (int k3 = 0; k3 < this.numRepetitions; ++k3) {
                            this.palettes[this.numRepetitions * this.paletteNumColors * pal + this.numRepetitions * c + k3] = color;
                        }
                        ++c;
                        pos += 2;
                    }
                }
            }
            if (cachePalettes) {
                this.cachePalettes = new byte[maxPalettes * (this.paletteNumColors << 1)];
                System.arraycopy(arrayAux, 0, this.cachePalettes, 0, maxPalettes * (this.paletteNumColors << 1));
            }
            this.beginSprite = new int[numSprites * this.numPalettes << 1];
            this.initBeginSpriteArray();
            int numPixels = dis.readInt();
            this.pixelsStartIndex = new int[numSprites + 1];
            for (int n2 = 0; n2 < numSprites; ++n2) {
                this.pixelsStartIndex[n2] = dis.readInt();
            }
            this.pixelsStartIndex[numSprites] = numPixels;
            this.pixels = new byte[numPixels];
            for (int j3 = 0; j3 < numPixels; ++j3) {
                this.pixels[j3] = dis.readByte();
            }
            this.numBitsIndex = (byte)(8 - this.numBitsPalette);
            this.indexMask = 255 >>> this.numBitsPalette;
            int numFrames = dis.readShort();
            this.frameBegins = new short[numFrames + 1];
            this.frameBegins[0] = 0;
            for (j = 0; j < numFrames; ++j) {
                this.frameBegins[j + 1] = (short)(dis.readShort() * 3);
            }
            if (this.isLongFormatted) {
                this.frames = new byte[this.frameBegins[j] << 1];
                for (k = 0; k < this.frames.length / 6; ++k) {
                    elementId = k * 3;
                    this.updateArray(dis, this.frames, elementId);
                    this.updateArray(dis, this.frames, elementId + 1);
                    this.updateArray(dis, this.frames, elementId + 2);
                }
            } else {
                this.frames = new byte[this.frameBegins[j]];
                for (k = 0; k < this.frames.length / 3; ++k) {
                    elementId = k * 3;
                    this.updateArray(dis, this.frames, elementId);
                    this.updateArray(dis, this.frames, elementId + 1);
                    this.updateArray(dis, this.frames, elementId + 2);
                }
            }
            this.numAnimations = dis.readShort();
            this.animationsBegins = new short[this.numAnimations + 1];
            this.animationsBegins[0] = 0;
            for (j = 0; j < this.numAnimations; ++j) {
                this.animationsBegins[j + 1] = (short)(dis.readShort() * 3);
            }
            this.animations = new int[this.animationsBegins[j]];
            byte[] abTmp = new byte[this.animationsBegins[j]];
            dis.read(abTmp);
            for (int i = 0; i < this.animations.length; ++i) {
                this.animations[i] = abTmp[i];
                if (this.animations[i] >= 0) continue;
                int n3 = i;
                this.animations[n3] = this.animations[n3] + 256;
            }
            this.ReadColData(dis);
            this.animationLengths = new int[this.animationsBegins.length - 1];
            for (j = 0; j < this.animationLengths.length; ++j) {
                this.animationLengths[j] = 0;
                int n4 = (this.animationsBegins[j + 1] - this.animationsBegins[j]) / 3;
                for (int k4 = 0; k4 < n4; ++k4) {
                    int n5 = j;
                    this.animationLengths[n5] = this.animationLengths[n5] + (0xFF & this.animations[this.animationsBegins[j] + k4 * 3 + 1]);
                }
            }
            this.bufferSize = minBufferSize;
            if (this.staticCache) {
                for (int palIndex = 0; palIndex < this.numPalettes; ++palIndex) {
                    for (int sprIndex = 0; sprIndex < numSprites; ++sprIndex) {
                        this.sprImg[sprIndex + numSprites * palIndex] = this.buildSprImage(sprIndex, palIndex);
                    }
                }
                this.pixels = null;
                this.beginSprite = null;
                this.pixelsStartIndex = null;
                this.palettes = null;
            }
            this.beginSprite = null;
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static final int isPaletteToLoad(int[] palettesToLoad, int palette) {
        for (int i = 0; i < palettesToLoad.length; ++i) {
            if (palettesToLoad[i] != palette) continue;
            return i;
        }
        return -1;
    }

    public void resetBeginSpriteArray() {
        this.initBeginSpriteArray();
        this.lastPositionBuffer = 0;
    }

    public void initBeginSpriteArray() {
        int numSprites = this.beginSprite.length;
        for (int i = 0; i < numSprites; ++i) {
            this.beginSprite[i] = -1;
        }
    }

    public void setPalette(int palette) {
        if (palette >= this.numPalettes) {
            return;
        }
        this.currentPalette = (byte)palette;
    }

    public int getPalette() {
        return this.currentPalette;
    }

    final void changePaletteColors(short[] colors, int paletteID) {
        if (paletteID < this.palettes.length / (this.paletteNumColors * this.numRepetitions)) {
            for (int j = 0; j < this.paletteNumColors; ++j) {
                int color = 0;
                if (colors.length <= j + 1) {
                    color = colors[j];
                }
                for (int k = 0; k < this.numRepetitions; ++k) {
                    this.palettes[this.paletteNumColors * this.numRepetitions * paletteID + this.numRepetitions * j + k] = color;
                }
            }
        }
    }

    public final void changePalettes(int[] palettesToLoad) {
        if (this.palettes == null || this.palettes.length < palettesToLoad.length * this.paletteNumColors * this.numRepetitions) {
            this.palettes = new int[palettesToLoad.length * this.paletteNumColors * this.numRepetitions];
        }
        for (int pal = 0; pal < palettesToLoad.length; ++pal) {
            int i = palettesToLoad[pal] * this.paletteNumColors << 1;
            for (int j = 0; j < this.paletteNumColors; ++j) {
                int color = PWPifLifeAnimations.toIntRGBA(this.cachePalettes, i);
                i += 2;
                for (int k = 0; k < this.numRepetitions; ++k) {
                    this.palettes[pal * this.numRepetitions * this.paletteNumColors + j * this.numRepetitions + k] = color;
                }
            }
        }
        this.numPalettes = (byte)palettesToLoad.length;
        this.setPalette(0);
        this.initBeginSpriteArray();
    }

    public int getPaletteColor(int palette, int colorIndex) {
        int color = this.palettes[palette * this.paletteNumColors * this.numRepetitions + this.numRepetitions * colorIndex];
        return color;
    }

    public void changePaletteColor(int palette, int colorIndex, int newColor) {
        for (int i = 0; i < this.numRepetitions; ++i) {
            this.palettes[palette * this.paletteNumColors * this.numRepetitions + this.numRepetitions * colorIndex + i] = newColor;
        }
    }

    public final void drawSpritePIF(Graphics g, int sprite, int x, int y, byte transformation) {
        this.drawSpritePIF(g, sprite, x, y, transformation, 0, 0);
    }

    public final void drawSpritePIF(Graphics g, int sprite, int x, int y, byte transformation, int alpha, int noting) {
        Image img = null;
        if (this.staticCache) {
            img = this.sprImg[sprite + this.currentPalette * this.numSprites];
        } else {
            try {
                int stackId = sprite;
                if (this.m_precalImagesPoolID >= 0) {
                    stackId += this.m_precalImagesOffset;
                    short imagePos = s_precalcStack[this.m_precalImagesPoolID][stackId += this.currentPalette * this.numSprites];
                    if (imagePos < 0) {
                        imagePos = s_precalcImageLast[this.m_precalImagesPoolID];
                        if (s_precalcImages[this.m_precalImagesPoolID][imagePos] != null) {
                            PWPifLifeAnimations.s_precalcImages[this.m_precalImagesPoolID][imagePos] = null;
                            PWPifLifeAnimations.s_precalcStack[this.m_precalImagesPoolID][PWPifLifeAnimations.s_precalcImageId[this.m_precalImagesPoolID][imagePos]] = -1;
                        }
                        PWPifLifeAnimations.s_precalcStack[this.m_precalImagesPoolID][stackId] = imagePos;
                        PWPifLifeAnimations.s_precalcImageId[this.m_precalImagesPoolID][imagePos] = (short)stackId;
                        PWPifLifeAnimations.s_precalcImages[this.m_precalImagesPoolID][imagePos] = this.buildSprImage(sprite, this.currentPalette);
                        PWPifLifeAnimations.s_precalcImageLast[this.m_precalImagesPoolID] = (short)((imagePos + 1) % s_precalcImages[this.m_precalImagesPoolID].length);
                    }
                    img = s_precalcImages[this.m_precalImagesPoolID][imagePos];
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("load build image error");
            }
        }
        if (transformation == 0) {
            g.drawImage(img, x, y, 0);
        } else {
            g.drawRegion(img, 0, 0, this.getSpriteW(sprite), this.getSpriteH(sprite), (int)transformation, x, y, 0);
        }
    }

    public void drawSpritePIF(Graphics g, int sprite, int x, int y, byte transformation, int anchor) {
        int width = this.getSpriteW(sprite);
        int height = this.getSpriteH(sprite);
        if ((1 & anchor) != 0) {
            x -= width >> 1;
        } else if ((8 & anchor) != 0) {
            x -= width;
        }
        if ((2 & anchor) != 0) {
            y -= height >> 1;
        } else if ((0x20 & anchor) != 0) {
            y -= height;
        }
        this.drawSpritePIF(g, sprite, x, y, transformation);
    }

    public PWPifLifeAnimations(byte[] data) {
        int i = 0;
        this.pngMode = (byte)2;
        try {
            int j;
            ByteArrayInputStream bais = new ByteArrayInputStream(data, 0, data.length);
            DataInputStream dis = new DataInputStream(bais);
            byte version = dis.readByte();
            if (version == 1) {
                boolean bl = this.isLongFormatted = dis.readByte() == 1;
            }
            if (version == 2) {
                byte srcImgNameLength = dis.readByte();
                byte[] srcImgName = new byte[srcImgNameLength];
                dis.read(srcImgName);
                String strImgName = new String(srcImgName);
                this.imgSrc = GraphicsTool.loadImage("/Animation/" + strImgName + ".png");
                strImgName = null;
                srcImgName = null;
            } else {
                System.out.println("wrong format!!!!!!!!!!!");
            }
            this.numSprites = dis.readShort();
            if (this.isLongFormatted) {
                this.spritesDim = new byte[this.numSprites << 3];
            } else {
                this.spritesDim = new byte[this.numSprites << 1];
                this.spritesXYDim = new short[this.numSprites << 1];
            }
            int elementId = 0;
            for (int j2 = 0; j2 < this.numSprites; ++j2) {
                elementId = j2 << 1;
                this.spritesXYDim[elementId] = dis.readShort();
                this.spritesXYDim[elementId + 1] = dis.readShort();
                this.updateArray(dis, this.spritesDim, elementId);
                this.updateArray(dis, this.spritesDim, elementId + 1);
            }
            int numFrames = dis.readShort();
            i += 2;
            this.frameBegins = new short[numFrames + 1];
            this.frameBegins[0] = 0;
            for (j = 0; j < numFrames; ++j) {
                this.frameBegins[j + 1] = (short)(dis.readShort() * 3);
                i += 2;
            }
            this.frames = this.isLongFormatted ? new byte[this.frameBegins[j] << 1] : new byte[this.frameBegins[j]];
            dis.read(this.frames);
            this.numAnimations = dis.readShort();
            i += 2;
            this.animationsBegins = new short[this.numAnimations + 1];
            this.animationsBegins[0] = 0;
            for (j = 0; j < this.numAnimations; ++j) {
                this.animationsBegins[j + 1] = (short)(dis.readShort() * 3);
                i += 2;
            }
            byte[] abTmp = new byte[this.animationsBegins[j]];
            this.animations = new int[this.animationsBegins[j]];
            dis.read(abTmp);
            for (int m = 0; m < this.animations.length; ++m) {
                this.animations[m] = abTmp[m];
                if (this.animations[m] >= 0) continue;
                int n = m;
                this.animations[n] = this.animations[n] + 256;
            }
            this.ReadColData(dis);
            i += this.animations.length;
            this.animationLengths = new int[this.animationsBegins.length - 1];
            for (j = 0; j < this.animationLengths.length; ++j) {
                this.animationLengths[j] = 0;
                int n = (this.animationsBegins[j + 1] - this.animationsBegins[j]) / 3;
                for (int k = 0; k < n; ++k) {
                    int n2 = j;
                    this.animationLengths[n2] = this.animationLengths[n2] + (0xFF & this.animations[this.animationsBegins[j] + k * 3 + 1]);
                }
            }
            this.numPalettes = 1;
            this.currentPalette = 0;
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PWPifLifeAnimations(byte[] data, int offset) {
        int i = 0;
        this.pngMode = 1;
        try {
            int j;
            ByteArrayInputStream bais = new ByteArrayInputStream(data, offset, data.length - offset);
            DataInputStream dis = new DataInputStream(bais);
            byte version = dis.readByte();
            if (version == 1) {
                this.isLongFormatted = dis.readByte() == 1;
            }
            this.numSprites = dis.readShort();
            this.spritesDim = this.isLongFormatted ? new byte[this.numSprites << 2] : new byte[this.numSprites << 1];
            int elementId = 0;
            for (int j2 = 0; j2 < this.numSprites; ++j2) {
                elementId = j2 << 1;
                this.updateArray(dis, this.spritesDim, elementId);
                this.updateArray(dis, this.spritesDim, elementId + 1);
            }
            this.images = new Image[this.numSprites << 1];
            byte[] header = new byte[dis.readInt()];
            dis.read(header);
            byte[] palette = new byte[dis.readInt()];
            dis.read(palette);
            byte[] end = new byte[dis.readInt()];
            dis.read(end);
            byte[] tempArrayImage = new byte[dis.readInt() + header.length + palette.length + end.length];
            System.arraycopy(header, 0, tempArrayImage, 0, header.length);
            System.arraycopy(palette, 0, tempArrayImage, header.length, palette.length);
            for (int j3 = 0; j3 < this.numSprites; ++j3) {
                elementId = j3 << 1;
                this.images[j3] = this.readImageDat(dis, tempArrayImage, header, palette, end, this.getUnsignedIntValueFromArray(this.spritesDim, elementId), this.getUnsignedIntValueFromArray(this.spritesDim, elementId + 1));
            }
            int numMirrors = 0xFF & dis.readByte();
            for (int j4 = 0; j4 < numMirrors; ++j4) {
                int id = 0xFF & dis.readByte();
                this.images[id + this.numSprites] = this.readImageDat(dis, tempArrayImage, header, palette, end, this.getSpriteW(id), this.getSpriteH(id));
            }
            tempArrayImage = null;
            int numFrames = dis.readShort();
            i += 2;
            this.frameBegins = new short[numFrames + 1];
            this.frameBegins[0] = 0;
            for (j = 0; j < numFrames; ++j) {
                this.frameBegins[j + 1] = (short)(dis.readShort() * 3);
                i += 2;
            }
            this.frames = this.isLongFormatted ? new byte[this.frameBegins[j] << 1] : new byte[this.frameBegins[j]];
            dis.read(this.frames);
            this.numAnimations = dis.readShort();
            i += 2;
            this.animationsBegins = new short[this.numAnimations + 1];
            this.animationsBegins[0] = 0;
            for (j = 0; j < this.numAnimations; ++j) {
                this.animationsBegins[j + 1] = (short)(dis.readShort() * 3);
                i += 2;
            }
            byte[] abTmp = new byte[this.animationsBegins[j]];
            this.animations = new int[this.animationsBegins[j]];
            dis.read(abTmp);
            for (int m = 0; m < this.animations.length; ++m) {
                this.animations[m] = abTmp[m];
                if (this.animations[m] >= 0) continue;
                int n = m;
                this.animations[n] = this.animations[n] + 256;
            }
            this.ReadColData(dis);
            i += this.animations.length;
            this.animationLengths = new int[this.animationsBegins.length - 1];
            for (j = 0; j < this.animationLengths.length; ++j) {
                this.animationLengths[j] = 0;
                int n = (this.animationsBegins[j + 1] - this.animationsBegins[j]) / 3;
                for (int k = 0; k < n; ++k) {
                    int n2 = j;
                    this.animationLengths[n2] = this.animationLengths[n2] + (0xFF & this.animations[this.animationsBegins[j] + k * 3 + 1]);
                }
            }
            this.numPalettes = 1;
            this.currentPalette = 0;
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Image readImageDat(DataInputStream dis, byte[] tempArrayImage, byte[] header, byte[] palette, byte[] end, int w, int h) throws IOException {
        int posData = header.length + palette.length;
        int length = dis.readInt();
        dis.read(tempArrayImage, posData, length);
        System.arraycopy(end, 0, tempArrayImage, posData + length, end.length);
        PWPifLifeAnimations.toBytes(w, tempArrayImage, 16);
        PWPifLifeAnimations.toBytes(h, tempArrayImage, 20);
        long crc = PWPifLifeAnimations.getCRC32(tempArrayImage, 12, 17);
        PWPifLifeAnimations.toBytes((int)crc, tempArrayImage, 29);
        return Image.createImage((byte[])tempArrayImage, (int)0, (int)(length + posData + end.length));
    }

    public void drawSpritePNG(Graphics g, int sprite, int x, int y, byte transformation, int alpha) {
        if (transformation == 1 && this.images[sprite + this.numSprites] != null) {
            sprite += this.numSprites;
        }
        g.drawImage(this.images[sprite], x, y, 20);
    }

    public static Image getAlphaImage(Image img, int nAlpha) {
        nAlpha = 100 - nAlpha;
        if (img == null) {
            return null;
        }
        if (nAlpha < 0) {
            nAlpha = 0;
        } else if (nAlpha > 100) {
            nAlpha = 10;
        }
        int imgW = img.getWidth();
        int imgH = img.getHeight();
        int[] RGBData = new int[imgW * imgH];
        img.getRGB(RGBData, 0, imgW, 0, 0, imgW, imgH);
        int tmp = nAlpha * 255 / 100 << 24 | 0xFFFFFF;
        int i = 0;
        while (i < RGBData.length) {
            int n = i++;
            RGBData[n] = RGBData[n] & tmp;
        }
        Image o_Img = Image.createRGBImage((int[])RGBData, (int)imgW, (int)imgH, (boolean)true);
        return o_Img;
    }

    public void drawSpriteForeignPNG(Graphics g, int sprite, int x, int y, byte transformation) {
        if (transformation == 1) {
            // empty if block
        }
        int[] clip = new int[4];
        GraphicsTool.restClip(g);
        int spriteX = this.getSpriteX(sprite);
        int spriteY = this.getSpriteY(sprite);
        int spriteW = this.getSpriteW(sprite);
        int spriteH = this.getSpriteH(sprite);
        g.setClip(x, y, spriteW, spriteH);
        g.drawImage(this.imgSrc, x - spriteX, y - spriteY, 20);
    }

    public void drawSpriteForeignPNG(Graphics g, int sprite, int x, int y, byte transformation, int alpha) {
        if (transformation == 1) {
            // empty if block
        }
        int[] clip = new int[4];
        GraphicsTool.restClip(g);
        int spriteX = this.getSpriteX(sprite);
        int spriteY = this.getSpriteY(sprite);
        int spriteW = this.getSpriteW(sprite);
        int spriteH = this.getSpriteH(sprite);
        g.setClip(x, y, spriteW, spriteH);
        if (alpha == 0) {
            g.drawImage(this.imgSrc, x - spriteX, y - spriteY, 20);
            return;
        }
        if (this.imgScrAlpha == null) {
            this.imgScrAlpha = PWPifLifeAnimations.getAlphaImage(this.imgSrc, alpha);
        }
        g.drawImage(this.imgScrAlpha, x - spriteX, y - spriteY, 20);
    }

    public void drawSpritePNG2(Graphics g, int sprite, int x, int y, byte transformation, int anchor) {
        if ((1 & anchor) != 0) {
            x -= this.images[sprite].getWidth() >> 1;
        } else if ((8 & anchor) != 0) {
            x -= this.images[sprite].getWidth();
        }
        if ((2 & anchor) != 0) {
            y -= this.images[sprite].getHeight() >> 1;
        } else if ((0x20 & anchor) != 0) {
            y -= this.images[sprite].getHeight();
        }
        this.drawSpritePNG(g, sprite, x, y, transformation, 0);
    }

    public static long getCRC32(byte[] buf, int off, int len) {
        int c;
        if (crc_table == null) {
            crc_table = new int[256];
            for (int n = 0; n < 256; ++n) {
                c = n;
                int k = 8;
                while (--k >= 0) {
                    if ((c & 1) != 0) {
                        c = 0xEDB88320 ^ c >>> 1;
                        continue;
                    }
                    c >>>= 1;
                }
                PWPifLifeAnimations.crc_table[n] = c;
            }
        }
        int crc = 0;
        c = ~crc;
        while (--len >= 0) {
            c = crc_table[(c ^ buf[off++]) & 0xFF] ^ c >>> 8;
        }
        crc = ~c;
        return (long)crc & 0xFFFFFFFFL;
    }

    static final short toShort(byte[] data, int i) {
        return (short)((0xFF & data[i]) << 8 | 0xFF & data[i + 1]);
    }

    final int updateArray(DataInputStream dis, byte[] array, int idx) {
        try {
            if (this.isLongFormatted) {
                array[idx <<= 1] = dis.readByte();
                array[idx + 1] = dis.readByte();
                return 2;
            }
            array[idx] = dis.readByte();
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    static final int toInt(byte[] data, int start) {
        return (0xFF & data[start]) << 24 | (0xFF & data[start + 1]) << 16 | (0xFF & data[start + 2]) << 8 | 0xFF & data[start + 3];
    }

    static final void toBytes(int num, byte[] data, int start) {
        data[start] = (byte)((num & 0xFF000000) >> 24);
        data[start + 1] = (byte)((num & 0xFF0000) >> 16);
        data[start + 2] = (byte)((num & 0xFF00) >> 8);
        data[start + 3] = (byte)(num & 0xFF);
    }

    static final short intColortoShortColor(int color) {
        short a = (short)((0xFF & color >> 24) / 16);
        short r = (short)((0xFF & color >> 16) / 16);
        short g = (short)((0xFF & color >> 8) / 16);
        short b = (short)((0xFF & color) / 16);
        return (short)(a << 12 | r << 8 | g << 4 | b);
    }

    static final int shortColorToIntColor(short color) {
        int a = (0xF & color >> 12) * 16;
        int r = (0xF & color >> 8) * 16;
        int g = (0xF & color >> 4) * 16;
        int b = (0xF & color) * 16;
        return a << 24 | r << 16 | g << 8 | b;
    }

    static final int toIntRGBA(byte[] data, int start) {
        return (0xF0 & data[start]) * 17 << 20 | (0xF & data[start]) * 17 << 16 | (0xF0 & data[start + 1]) * 17 << 4 | (0xF & data[start + 1]) * 17;
    }

    public void arraycopy(int color, int[] dst, int dst_position, int length) {
        switch (length) {
            case 1: {
                dst[dst_position] = color;
                break;
            }
            case 2: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                break;
            }
            case 3: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                break;
            }
            case 4: {
                int n = color;
                dst[dst_position + 1] = n;
                dst[dst_position] = n;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                break;
            }
            case 5: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                break;
            }
            case 6: {
                int n = color;
                dst[dst_position + 1] = n;
                dst[dst_position] = n;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                break;
            }
            case 7: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                break;
            }
            case 8: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                break;
            }
            case 9: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                break;
            }
            case 10: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                break;
            }
            case 11: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                dst[dst_position + 10] = color;
                break;
            }
            case 12: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                dst[dst_position + 10] = color;
                dst[dst_position + 11] = color;
                break;
            }
            case 13: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                dst[dst_position + 10] = color;
                dst[dst_position + 11] = color;
                dst[dst_position + 12] = color;
                break;
            }
            case 14: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                dst[dst_position + 10] = color;
                dst[dst_position + 11] = color;
                dst[dst_position + 12] = color;
                dst[dst_position + 13] = color;
                break;
            }
            case 15: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                dst[dst_position + 10] = color;
                dst[dst_position + 11] = color;
                dst[dst_position + 12] = color;
                dst[dst_position + 13] = color;
                dst[dst_position + 14] = color;
                break;
            }
            case 16: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                dst[dst_position + 10] = color;
                dst[dst_position + 11] = color;
                dst[dst_position + 12] = color;
                dst[dst_position + 13] = color;
                dst[dst_position + 14] = color;
                dst[dst_position + 15] = color;
                break;
            }
            default: {
                this.arraycopy(color, dst, dst_position, 16);
                this.arraycopy(color, dst, dst_position + 16, length - 16);
            }
        }
    }

    public final int getSpriteX(int sprite) {
        if (this.pngMode == 2) {
            return this.spritesXYDim[sprite << 1];
        }
        return -1;
    }

    public final int getSpriteY(int sprite) {
        if (this.pngMode == 2) {
            return this.spritesXYDim[(sprite << 1) + 1];
        }
        return -1;
    }

    public final int getSpriteW(int sprite) {
        return this.getUnsignedIntValueFromArray(this.spritesDim, sprite << 1);
    }

    public final int getSpriteH(int sprite) {
        return this.getUnsignedIntValueFromArray(this.spritesDim, (sprite << 1) + 1);
    }

    public int getFrameWidth(int frame) {
        int p0X = Integer.MAX_VALUE;
        int p1X = Integer.MIN_VALUE;
        for (int i = this.frameBegins[frame]; i < this.frameBegins[frame + 1]; i += 3) {
            int despX = this.getIntValueFromArray(this.frames, i + 1);
            int w = this.getSpriteW(this.getUnsignedIntValueFromArray(this.frames, i));
            p0X = Math.min(p0X, despX);
            p1X = Math.max(p1X, despX + w);
        }
        return p1X - p0X;
    }

    private int getIntValueFromArray(byte[] array, int offset) {
        if (this.isLongFormatted) {
            return array[offset <<= 1] << 8 | array[offset + 1];
        }
        return array[offset];
    }

    private int getUnsignedIntValueFromArray(byte[] array, int offset) {
        if (this.isLongFormatted) {
            return 0xFFFF & (array[offset <<= 1] << 8 | array[offset + 1]);
        }
        return 0xFF & array[offset];
    }

    public int getFrameHeight(int frame) {
        int p0Y = Integer.MAX_VALUE;
        int p1Y = Integer.MIN_VALUE;
        for (int i = this.frameBegins[frame]; i < this.frameBegins[frame + 1]; i += 3) {
            int despY = this.getIntValueFromArray(this.frames, i + 2);
            int h = this.getSpriteH(this.getUnsignedIntValueFromArray(this.frames, i));
            p0Y = Math.min(p0Y, despY);
            p1Y = Math.max(p1Y, despY + h);
        }
        return p1Y - p0Y;
    }

    public void drawSprite(Graphics g, int sprite, int x, int y, byte transformation, int alpha) {
        if (this.pngMode == 1) {
            this.drawSpritePNG(g, sprite, x, y, transformation, alpha);
        }
        if (this.pngMode == 2) {
            this.drawSpriteForeignPNG(g, sprite, x, y, transformation, alpha);
        }
        if (this.pngMode == 0 && this.getSpriteW(sprite) > 1 && this.getSpriteH(sprite) > 1) {
            this.drawSpritePIF(g, sprite, x, y, transformation, alpha, 0);
        }
    }

    public void drawSprite2(Graphics g, int sprite, int x, int y, byte transformation, int anchor) {
        if (this.pngMode == 1) {
            this.drawSpritePNG2(g, sprite, x, y, transformation, anchor);
        }
        if (this.pngMode == 2) {
            this.drawSpriteForeignPNG(g, sprite, x, y, transformation);
        }
        if (this.pngMode == 0) {
            this.drawSpritePIF(g, sprite, x, y, transformation, anchor);
        }
    }

    public final void drawFrame(Graphics g, int frame, int x, int y, byte transformation) {
        for (int i = this.frameBegins[frame]; i < this.frameBegins[frame + 1]; i += 3) {
            int spr = this.getIntValueFromArray(this.frames, i);
            transformation = 0;
            int posX = x + this.getIntValueFromArray(this.frames, i + 1);
            int posY = y + this.getIntValueFromArray(this.frames, i + 2);
            int spriteW = this.getSpriteW(spr);
            int spriteH = this.getSpriteH(spr);
            if (posX < -spriteW || posX > 240 + spriteW || posY < -spriteH || posY > 320 + spriteH) continue;
            this.drawSprite(g, spr, posX, posY, transformation, 0);
        }
    }

    public final void drawFrame(Graphics g, int frame, int x, int y, byte transformation, int alpha) {
        for (int i = this.frameBegins[frame]; i < this.frameBegins[frame + 1]; i += 3) {
            int spr = this.getIntValueFromArray(this.frames, i);
            transformation = 0;
            int posX = x + this.getIntValueFromArray(this.frames, i + 1);
            int posY = y + this.getIntValueFromArray(this.frames, i + 2);
            int spriteW = this.getSpriteW(spr);
            int spriteH = this.getSpriteH(spr);
            if (posX < -spriteW || posX > 240 + spriteW || posY < -spriteH || posY > 320 + spriteH) continue;
            this.drawSprite(g, spr, posX, posY, transformation, alpha);
        }
    }

    public void resetAnimation(int animationID) {
    }

    public final int drawAnimation(Graphics g, int animation, long time, int x, int y, byte globalTransformation, boolean cyclical) {
        int frp = this.getFramePos(animation, time, cyclical);
        this.drawFrame(g, this.animations[frp] & 0xFF, x, y, (byte)0);
        return this.animFinish ? -1 : this.framePainted;
    }

    public int drawAnimation(Graphics g, int animation, long time, int x, int y, byte globalTransformation) {
        return this.drawAnimation(g, animation, time, x, y, globalTransformation, true);
    }

    public int drawAnimation(Graphics g, int animation, int time, int x, int y, boolean cyclical) {
        return this.drawAnimation(g, animation, time, x, y, (byte)0, cyclical);
    }

    public int drawAnimation(Graphics g, int animation, long time, int x, int y, boolean cyclical) {
        return this.drawAnimation(g, animation, time, x, y, (byte)0, cyclical);
    }

    public final int getFramePos(int animId, long time, boolean cyclical) {
        this.animFinish = false;
        time /= 10L;
        if (cyclical) {
            time %= (long)this.animationLengths[animId];
        } else if (time >= (long)this.animationLengths[animId]) {
            this.animFinish = true;
            time = this.animationLengths[animId];
        }
        int t = 0;
        int frame = 0;
        while ((long)t < time) {
            if ((long)(t += this.animations[this.animationsBegins[animId] + frame * 3 + 1] & 0xFF) >= time) continue;
            ++frame;
        }
        this.framePainted = frame;
        return this.animationsBegins[animId] + frame * 3;
    }

    public boolean animationIsOver(int animId, int time) {
        if (animId >= this.animationLengths.length) {
            animId = this.animationLengths.length - 1;
        }
        return time / 10 >= this.animationLengths[animId];
    }

    public final int getFrameId(int animationId, int index) {
        int frp = this.animationsBegins[animationId] + index * 3;
        if (frp >= this.animationsBegins[animationId + 1]) {
            return -1;
        }
        return this.animations[frp];
    }

    public int GetFrameNum(int animationId) {
        int i = 0;
        while (this.getFrameId(animationId, i) != -1) {
            ++i;
        }
        return i;
    }

    public int GetAniFrameWidth(int ani_id, int idx) {
        return this.getFrameWidth(this.getFrameId(ani_id, idx));
    }

    public int GetAniFrameHeight(int ani_id, int idx) {
        return this.getFrameHeight(this.getFrameId(ani_id, idx));
    }

    public Vector GetColRects(int ani_id, int frm_id) {
        return (Vector)this.mColRects.elementAt(this.getFrameId(ani_id, frm_id));
    }

    public Vector GetColRects(int ani_id, long game_time, boolean ani_is_loop) {
        return (Vector)this.mColRects.elementAt(this.animations[this.getFramePos(ani_id, game_time, ani_is_loop)]);
    }

    public Vector GetColRectsByFrameID(int ani_id, int frameID) {
        return (Vector)this.mColRects.elementAt(this.animations[frameID]);
    }

    public ColRect GetColRect(int ani_id, long game_time, boolean ani_is_loop, int val) {
        Vector col_rects = this.GetColRects(ani_id, game_time, ani_is_loop);
        for (int i = 0; i < col_rects.size(); ++i) {
            ColRect cr = (ColRect)col_rects.elementAt(i);
            if (val != cr.GetVal()) continue;
            return cr;
        }
        return null;
    }

    public ColRect GetColRect(int total_frame_id, int val) {
        Vector col_rects = (Vector)this.mColRects.elementAt(total_frame_id);
        for (int i = 0; i < col_rects.size(); ++i) {
            ColRect cr = (ColRect)col_rects.elementAt(i);
            if (val != cr.GetVal()) continue;
            return cr;
        }
        return null;
    }

    public int GetAniFrameWidth(int ani_id, long game_time, boolean ani_is_loop) {
        return this.getFrameWidth(this.animations[this.getFramePos(ani_id, game_time, ani_is_loop)]);
    }

    public int GetAniFrameHeight(int ani_id, long game_time, boolean ani_is_loop) {
        return this.getFrameHeight(this.animations[this.getFramePos(ani_id, game_time, ani_is_loop)]);
    }
}

