/*
 * Decompiled with CFR 0.152.
 */
package HG.Scene;

import HG.Animation.Map;
import HG.Game.GameDialog;
import HG.Game.GameWord;
import HG.Main.MainCanvas;
import HG.MotionWelder.MSimpleAnimationPlayer;
import HG.MotionWelder.MSpriteLoader;
import HG.Public.Function;
import HG.Scene.Scene;
import HG.Scene.SceneManage;
import HG.Tool.DialogAnimation;
import HG.Tool.GraphicsTool;
import HG.Tool.MathTool;
import HG.Tool.MusicPlayer;
import HG.Tool.TextTool;
import javax.microedition.lcdui.Graphics;

public class EndStoryScene
extends Scene {
    private boolean is_dialog = false;
    private DialogAnimation dialog_story = null;
    private GameDialog game_dialog = null;
    private GameWord game_word = null;
    private String[] str_bk = null;
    private int strbk_y = 0;
    private int strbk_speed = 1;
    private int strbk_height = 0;
    private Map map_story = null;
    private MSimpleAnimationPlayer[] building = null;
    private int[] building_pos = null;
    private final byte soul_num = (byte)10;
    private final byte soul_wh = (byte)10;
    private MSimpleAnimationPlayer[] soul = null;
    private int[] soul_type = null;
    private int[] soul_pos_x = null;
    private int[] soul_pos_y = null;
    private int[] soul_dest_x = null;
    private int[] soul_dest_y = null;
    private int[] soul_speed_x = null;
    private int[] soul_speed_y = null;
    private byte[] soul_dir_x = null;
    private byte[] soul_dir_y = null;
    private int ROLE_STAND_LEVEL = 256;
    private MSimpleAnimationPlayer player = null;
    private int player_x = 0;
    private int player_y = 0;
    private MSimpleAnimationPlayer npc = null;
    private int npc_x = 0;
    private int npc_y = 0;
    public int scene_colorChange = 0;
    public int[] scene_colorData = null;
    public boolean is_darkScreen = false;
    private int StepStory_ID = 0;
    private int frame_scene = 0;

    public EndStoryScene(MainCanvas mc) {
        super(mc);
    }

    public void loadScene() {
        switch (320) {
            case 204: 
            case 208: {
                this.ROLE_STAND_LEVEL = 160;
                break;
            }
            case 220: {
                this.ROLE_STAND_LEVEL = 176;
                break;
            }
            case 240: {
                this.ROLE_STAND_LEVEL = 192;
            }
        }
        try {
            int i;
            this.dialog_story = new DialogAnimation(this.Scene_canvas);
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            this.game_dialog = new GameDialog(this, this.dialog_story);
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            this.game_word = new GameWord(this.Scene_canvas);
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            this.building = new MSimpleAnimationPlayer[]{new MSimpleAnimationPlayer(MSpriteLoader.loadMSprite("/village/Fire_Village.anu", false, this), 120, 160), new MSimpleAnimationPlayer(MSpriteLoader.loadMSprite("/village/Fire_Village.anu", false, this), 120, 160)};
            for (i = 0; i < this.building.length; ++i) {
                this.building[i].setAnimation(i);
                this.building[i].setLoopOffset(-1);
            }
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            this.building_pos = new int[]{66, 322, 580, 190, 680};
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            this.soul = new MSimpleAnimationPlayer[2];
            for (i = 0; i < this.soul.length; ++i) {
                this.soul[i] = new MSimpleAnimationPlayer(MSpriteLoader.loadMSprite("/village/Sprite_Village.anu", false, this), 120, 160);
                this.soul[i].setAnimation(i);
                this.soul[i].setLoopOffset(0);
            }
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            this.soul_type = new int[10];
            this.soul_pos_x = new int[10];
            this.soul_pos_y = new int[10];
            this.soul_dest_x = new int[10];
            this.soul_dest_y = new int[10];
            this.soul_speed_x = new int[10];
            this.soul_speed_y = new int[10];
            this.soul_dir_x = new byte[10];
            this.soul_dir_y = new byte[10];
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            for (i = 0; i < 10; ++i) {
                this.soul_type[i] = MathTool.getRandom(0, 1);
                this.soul_pos_x[i] = MathTool.getRandom(10, 700);
                this.soul_pos_y[i] = MathTool.getRandom(30, 150);
                this.soul_dest_x[i] = MathTool.getRandom(10, 700);
                this.soul_dest_y[i] = MathTool.getRandom(30, 150);
            }
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            this.map_story = new Map(this.Scene_canvas, "/village/level", "/village", 0, false);
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            this.player = new MSimpleAnimationPlayer(MSpriteLoader.loadMSprite("/village/player.anu", false, this), this.player_x, this.ROLE_STAND_LEVEL);
            this.player.setAnimation(1);
            this.player.setLoopOffset(-1);
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            this.npc = new MSimpleAnimationPlayer(MSpriteLoader.loadMSprite("/village/Earth.anu", false, this), this.player_x, this.ROLE_STAND_LEVEL);
            this.npc.setAnimation(0);
            this.npc.setLoopOffset(-1);
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            MusicPlayer.getInst().loadMusic("/music/begin_story.mid");
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
            this.StepStory_ID = 0;
            this.scene_colorChange = 0;
            this.scene_colorData = GraphicsTool.createOpaqueData(0, 0, 240, 320);
            this.player_x = 100;
            this.player_y = this.ROLE_STAND_LEVEL;
            this.npc_x = 140;
            this.npc_y = this.ROLE_STAND_LEVEL;
            this.Scene_canvas.sceneMgr.scene_load.refreshLoad();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.Scene_canvas.sceneMgr.scene_load.refreshFullLoad();
    }

    public void render(Graphics g) {
        if (this.StepStory_ID < 5) {
            int i;
            GraphicsTool.restScreen(g, 0);
            this.map_story.drawMap(g, 0, this.ROLE_STAND_LEVEL - 256);
            GraphicsTool.restClip(g);
            for (i = 0; i < 10; ++i) {
                int type = this.soul_type[i];
                this.soul[type].drawFrame(g, this.soul_pos_x[i], this.soul_pos_y[i]);
                this.soul[type].update();
            }
            for (i = 0; i < this.building_pos.length; ++i) {
                GraphicsTool.restClip(g);
                int Temp_animID = 0;
                if (i < 2) {
                    Temp_animID = 1;
                }
                this.building[Temp_animID].drawFrame(g, this.building_pos[i], 320);
                this.building[Temp_animID].update();
                if (this.building[Temp_animID].isPlaying()) continue;
                this.building[Temp_animID].setAnimation(Temp_animID);
                this.building[Temp_animID].setLoopOffset(-1);
            }
            GraphicsTool.restClip(g);
            this.player.drawFrame(g, this.player_x, this.player_y);
            this.player.update();
            if (!this.player.isPlaying()) {
                this.player.setAnimation(1);
                this.player.setLoopOffset(-1);
            }
            this.npc.drawFrame(g, this.npc_x, this.npc_y);
            this.npc.update();
            if (!this.npc.isPlaying()) {
                this.npc.setAnimation(0);
                this.npc.setLoopOffset(-1);
            }
        }
        this.drawSceneStory(g);
        if (this.is_dialog) {
            this.game_dialog.drawDialog(g);
        }
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        if (!this.is_dialog) {
            this.keyReleased(0);
        }
    }

    public void keyPressed(int key) {
        if (SceneManage.is_phone_HangUP) {
            SceneManage.is_phone_HangUP = false;
            MusicPlayer.getInst().playMusic();
            return;
        }
        if (this.is_dialog) {
            this.game_dialog.keyDialog(key);
            if (this.game_dialog.is_dialogOver()) {
                this.is_dialog = false;
                this.game_dialog.clearDialog();
            }
        } else {
            switch (key) {
                case -1: 
                case 50: {
                    this.strbk_speed = 5;
                }
            }
        }
    }

    public void keyReleased(int key) {
        if (!this.is_dialog) {
            this.strbk_speed = 1;
        }
    }

    public void run() {
        MusicPlayer.getInst().checkMusicStat();
        if (this.StepStory_ID < 5) {
            for (int i = 0; i < 10; ++i) {
                if (this.soul_pos_x[i] > this.soul_dest_x[i]) {
                    this.soul_dir_x[i] = -1;
                } else if (this.soul_pos_x[i] < this.soul_dest_x[i]) {
                    this.soul_dir_x[i] = 1;
                }
                if (this.soul_pos_y[i] > this.soul_dest_y[i]) {
                    this.soul_dir_y[i] = -1;
                } else if (this.soul_pos_y[i] < this.soul_dest_y[i]) {
                    this.soul_dir_y[i] = 1;
                }
                int denominator = MathTool.getRandom(8, 15) + 1;
                this.soul_speed_x[i] = Math.abs(this.soul_dest_x[i] - this.soul_pos_x[i]) / denominator;
                this.soul_speed_y[i] = Math.abs(this.soul_dest_y[i] - this.soul_pos_y[i]) / denominator;
                int n = i;
                this.soul_pos_x[n] = this.soul_pos_x[n] + this.soul_speed_x[i] * this.soul_dir_x[i];
                int n2 = i;
                this.soul_pos_y[n2] = this.soul_pos_y[n2] + this.soul_speed_y[i] * this.soul_dir_y[i];
                if (!Function.inRect(this.soul_pos_x[i], this.soul_pos_y[i], this.soul_dest_x[i] - 10, this.soul_dest_y[i] - 10, 20, 20)) continue;
                this.soul_dest_x[i] = MathTool.getRandom(10, 700);
                this.soul_dest_y[i] = MathTool.getRandom(30, 150);
            }
        }
        if (this.is_dialog) {
            this.game_dialog.runDialog();
        }
    }

    public void clearScene() {
        Map.clearMapLib();
        this.map_story = null;
        this.dialog_story = null;
        this.game_dialog = null;
        this.game_word = null;
        this.building = null;
        this.soul = null;
        this.soul_type = null;
        this.soul_pos_x = null;
        this.soul_pos_y = null;
        this.soul_dest_x = null;
        this.soul_dest_y = null;
        this.soul_speed_x = null;
        this.soul_speed_y = null;
        this.soul_dir_x = null;
        this.soul_dir_y = null;
        this.scene_colorData = null;
        MSpriteLoader.releaseTmpImage();
        MusicPlayer.getInst().stopMusic();
        System.gc();
    }

    private void leaveScene() {
        this.Scene_canvas.sceneMgr.setChangeScene((byte)1, (byte)7, false, true);
    }

    private void drawSceneStory(Graphics g) {
        switch (this.StepStory_ID) {
            case 0: {
                this.scene_colorChange += 8;
                if (this.scene_colorChange < 255) {
                    GraphicsTool.changeOpaqueData(this.scene_colorData, this.scene_colorChange, 240, 320);
                    GraphicsTool.drawOpaqueData(g, this.scene_colorData, 0, 0, 240, 320);
                    break;
                }
                this.scene_colorChange = 255;
                GraphicsTool.changeOpaqueData(this.scene_colorData, this.scene_colorChange, 240, 320);
                GraphicsTool.restScreen(g, 0);
                this.str_bk = this.Scene_canvas.text.spliteString(this.game_word.str_gamelang[155], 220);
                this.strbk_y = 320;
                this.strbk_height = TextTool.getCharDistance() * this.str_bk.length;
                this.dialog_story.resetAnimationColor();
                this.is_darkScreen = true;
                this.strbk_speed = 1;
                ++this.StepStory_ID;
                break;
            }
            case 1: {
                GraphicsTool.restScreen(g, 0);
                g.setColor(-1);
                g.setClip(0, 0, 240, 300);
                for (int i = 0; i < this.str_bk.length; ++i) {
                    g.drawString(this.str_bk[i], 10, this.strbk_y + i * TextTool.getCharDistance(), 20);
                }
                this.strbk_y -= this.strbk_speed;
                if (this.strbk_y + this.strbk_height > 0) break;
                this.strbk_speed = 1;
                ++this.StepStory_ID;
                break;
            }
            case 2: {
                this.scene_colorChange -= 8;
                if (this.scene_colorChange > 0) {
                    GraphicsTool.changeOpaqueData(this.scene_colorData, this.scene_colorChange, 240, 320);
                    GraphicsTool.drawOpaqueData(g, this.scene_colorData, 0, 0, 240, 320);
                    break;
                }
                this.scene_colorChange = 0;
                GraphicsTool.changeOpaqueData(this.scene_colorData, this.scene_colorChange, 240, 320);
                this.is_darkScreen = false;
                this.is_dialog = true;
                this.game_word.loadGameLang(29);
                this.game_dialog.initDialog(this.game_word.data_gamelang[GameWord.index_gamelang], this.game_word.str_gamelang, this.game_word.imgicon_gamelang);
                ++this.StepStory_ID;
                break;
            }
            case 3: {
                if (!this.game_dialog.is_dialogOver()) break;
                ++this.StepStory_ID;
                break;
            }
            case 4: {
                this.scene_colorChange += 6;
                if (this.scene_colorChange < 255) {
                    GraphicsTool.changeOpaqueData(this.scene_colorData, this.scene_colorChange, 240, 320);
                    GraphicsTool.drawOpaqueData(g, this.scene_colorData, 0, 0, 240, 320);
                    break;
                }
                this.scene_colorChange = 255;
                GraphicsTool.changeOpaqueData(this.scene_colorData, this.scene_colorChange, 240, 320);
                GraphicsTool.restScreen(g, 0);
                this.str_bk = this.Scene_canvas.text.spliteString(this.game_word.str_gamelang[156], 220);
                this.strbk_y = 320;
                this.strbk_height = TextTool.getCharDistance() * this.str_bk.length;
                this.dialog_story.resetAnimationColor();
                this.is_darkScreen = true;
                this.strbk_speed = 1;
                ++this.StepStory_ID;
                break;
            }
            case 5: {
                GraphicsTool.restScreen(g, 0);
                g.setColor(-1);
                g.setClip(0, 0, 240, 300);
                for (int i = 0; i < this.str_bk.length; ++i) {
                    g.drawString(this.str_bk[i], 10, this.strbk_y + i * TextTool.getCharDistance(), 20);
                }
                this.strbk_y -= this.strbk_speed;
                if (this.strbk_y + this.strbk_height > 0) break;
                this.str_bk = this.Scene_canvas.text.spliteString(this.game_word.str_gamelang[157], 220);
                this.strbk_y = 320;
                this.strbk_height = TextTool.getCharDistance() * this.str_bk.length;
                this.strbk_speed = 1;
                ++this.StepStory_ID;
                break;
            }
            case 6: {
                GraphicsTool.restScreen(g, 0);
                g.setColor(-1);
                g.setClip(0, 0, 240, 300);
                for (int i = 0; i < this.str_bk.length; ++i) {
                    g.drawString(this.str_bk[i], 120, this.strbk_y + i * TextTool.getCharDistance(), 17);
                }
                this.strbk_y -= this.strbk_speed;
                if (this.strbk_y + this.strbk_height > 0) break;
                this.str_bk = this.Scene_canvas.text.spliteString(this.game_word.str_gamelang[158], 220);
                this.strbk_y = 320;
                this.strbk_height = TextTool.getCharDistance() * this.str_bk.length;
                this.strbk_speed = 1;
                ++this.StepStory_ID;
                break;
            }
            case 7: {
                GraphicsTool.restScreen(g, 0);
                g.setColor(-1);
                g.setClip(0, 0, 240, 300);
                for (int i = 0; i < this.str_bk.length; ++i) {
                    g.drawString(this.str_bk[i], 120, this.strbk_y + i * TextTool.getCharDistance(), 17);
                }
                this.strbk_y -= this.strbk_speed;
                if (this.strbk_y + this.strbk_height > 0) break;
                this.leaveScene();
            }
        }
    }

    private void drawEndStory(Graphics g) {
        switch (this.StepStory_ID) {
            case 0: {
                GraphicsTool.restScreen(g, 0);
                this.str_bk = this.Scene_canvas.text.spliteString(this.game_word.str_gamelang[155], 220);
                this.strbk_y = 320;
                this.strbk_height = TextTool.getCharDistance() * this.str_bk.length;
                this.strbk_speed = 1;
                ++this.StepStory_ID;
                break;
            }
            case 1: {
                GraphicsTool.restScreen(g, 0);
                g.setColor(-1);
                g.setClip(0, 0, 240, 300);
                for (int i = 0; i < this.str_bk.length; ++i) {
                    g.drawString(this.str_bk[i], 10, this.strbk_y + i * TextTool.getCharDistance(), 20);
                }
                this.strbk_y -= this.strbk_speed;
                if (this.strbk_y + this.strbk_height > 0) break;
                this.str_bk = this.Scene_canvas.text.spliteString(this.game_word.str_gamelang[157], 220);
                this.strbk_y = 320;
                this.strbk_height = TextTool.getCharDistance() * this.str_bk.length;
                this.strbk_speed = 1;
                ++this.StepStory_ID;
                break;
            }
            case 2: {
                GraphicsTool.restScreen(g, 0);
                g.setColor(-1);
                g.setClip(0, 0, 240, 300);
                for (int i = 0; i < this.str_bk.length; ++i) {
                    g.drawString(this.str_bk[i], 120, this.strbk_y + i * TextTool.getCharDistance(), 17);
                }
                this.strbk_y -= this.strbk_speed;
                if (this.strbk_y + this.strbk_height > 0) break;
                this.str_bk = this.Scene_canvas.text.spliteString(this.game_word.str_gamelang[158], 220);
                this.strbk_y = 320;
                this.strbk_height = TextTool.getCharDistance() * this.str_bk.length;
                this.strbk_speed = 1;
                ++this.StepStory_ID;
                break;
            }
            case 3: {
                GraphicsTool.restScreen(g, 0);
                g.setColor(-1);
                g.setClip(0, 0, 240, 300);
                for (int i = 0; i < this.str_bk.length; ++i) {
                    g.drawString(this.str_bk[i], 120, this.strbk_y + i * TextTool.getCharDistance(), 17);
                }
                this.strbk_y -= this.strbk_speed;
                if (this.strbk_y + this.strbk_height > 0) break;
                this.leaveScene();
            }
        }
    }

    public void showNotify() {
    }

    public void hideNotify() {
        MusicPlayer.getInst().pauseMusic();
    }

    public String getClipImgName(String spriteName, int imageId) {
        String sImgName = null;
        if (spriteName.equals("/village/player.anu")) {
            sImgName = "/village/Ani_WK_Run.png";
        } else if (spriteName.equals("/village/building_0.anu")) {
            switch (imageId) {
                case 0: {
                    sImgName = "/village/building_0.png";
                    break;
                }
                case 1: {
                    sImgName = "/village/building_1.png";
                }
            }
        } else if (spriteName.equals("/village/Sprite_Village.anu")) {
            sImgName = "/village/sprite_Village.png";
        } else if (spriteName.equals("/menu/dialog.anu")) {
            sImgName = "/menu/dialog_material.png";
        } else if (spriteName.equals("/village/Fire_Village.anu")) {
            sImgName = "/village/Fire_Village.png";
        } else if (spriteName.equals("/menu/DialogPush5.anu")) {
            sImgName = "/menu/UI_PhoneKey.png";
        } else if (spriteName.equals("/village/Earth.anu")) {
            sImgName = "/village/Earth.png";
        } else if (spriteName.equals("/menu/Text_skip.anu")) {
            switch (imageId) {
                case 0: {
                    sImgName = "/menu/text_skip.png";
                    break;
                }
                case 1: {
                    sImgName = "/menu/dialog_material.png";
                }
            }
        } else {
            MainCanvas.debug("error! villageScene sImgName null");
        }
        return sImgName;
    }
}

