/*
 * Decompiled with CFR 0.152.
 */
package HG.Tool;

import HG.Tool.TextTool;

public class KeyWordSystem {
    public static final long TIME_REPEAT_KEY = 1000L;
    public static final char LEFT_BUTTON = '\u0000';
    public static final char RIGHT_BUTTON = '\u0001';
    public static final char FIRE_BUTTON = '\u0002';
    public static final char LEFT_ARROW = '\u0003';
    public static final char RIGHT_ARROW = '\u0004';
    public static final char UP_ARROW = '\u0005';
    public static final char DOWN_ARROW = '\u0006';
    public static final char ACTION_KEY_LIMIT = '\u0006';
    public static final char NO_KEY = '\b';
    public static final char DELETE = '\t';
    public static final char NO_PRINTABLE_LIMIT = '\n';
    public static final String EMPTY_CHARSET = "^^^^^^^^^^^";
    public static final String FULL_CHARSET_STRING = " 0^.-?!\\@:;/()1^abc\u8c292^def\u83053^ghi\u94c64^jkl5^mno\u5e3d\u8d386^pqrs7^tuv8^wxyz9^*^#";
    public static final String FULL_UPPERCASE_CHARSET_STRING = " 0^.-?!\\@:;/()1^ABC\u81152^DEF\u81213^GHI\u81254^JKL5^MNO\u8129\u812b6^PQRS7^TUV8^WXYZ9^*^#";
    public static final String EMAIL_UPPERCASE_CHARSET_STRING = "0^.@-_1^ABC2^DEF3^GHI4^JKL5^MNO6^PQRS7^TUV8^WXYZ9^*^#";
    public static final String REDUCED_CHARSET_STRING = "^^abc^def^ghi^jkl^mno\u5e3d^pqrs^tuv^wxyz^*^#";
    public static final String REDUCED_CHARSET_ANGLO_SAXON_STRING = "^^abc^def^ghi^jkl^mno^pqrs^tuv^wxyz^*^#";
    public static final String REDUCED_UPPERCASE_CHARSET_ANGLO_SAXON_WITHDIGITS_STRING = "0^1^ABC2^DEF3^GHI4^JKL5^MNO6^PQRS7^TUV8^WXYZ9";
    public static final String REDUCED_UPPERCASE_CHARSET_STRING = "^^ABC^DEF^GHI^JKL^MNO\u8129^PQRS^TUV^WXYZ^*^#";
    public static final String REDUCED_UPPERCASE_CHARSET_WITHDIGITS_STRING = "0^1^ABC2^DEF3^GHI4^JKL5^MNO\u81296^PQRS7^TUV8^WXYZ9^*^#";
    public static final String NUMBERS_CHARSET_STRING = "0^1^2^3^4^5^6^7^8^9^*^#";
    public static final String REDUCED_CHARSET_ANGLO_SAXON_WITHDIGITS_STRING = "0^1^abc2^def3^ghi4^jkl5^mno6^pqrs7^tuv8^wxyz9^*^#";
    public boolean acceptKeyPressed = true;
    public boolean acceptKeyReleased = true;
    public StringBuffer text;
    private String actualCharset;
    private char[][] charset;
    private int maxTextSize = 0;
    private int multitapChar = 0;
    private int multitapLastKey = -1;
    private long multitapLastTime;

    public KeyWordSystem(String charsetString, int maxTextSize) {
        this.init(charsetString, maxTextSize);
    }

    public void init(String charsetString, int maxTextSize) {
        this.actualCharset = charsetString;
        char[][] charSet = new char[10][];
        String[] pwt = TextTool.spliteString(charsetString, '^');
        for (int i = 0; i < charSet.length; ++i) {
            String key = pwt[i];
            if (key != null) {
                charSet[i] = new char[key.length()];
                for (int j = 0; j < key.length(); ++j) {
                    charSet[i][j] = key.charAt(j);
                }
                continue;
            }
            charSet[i] = new char[0];
        }
        this.charset = charSet;
        this.maxTextSize = maxTextSize;
        this.text = new StringBuffer();
        this.multitapChar = 0;
        this.acceptKeyPressed = true;
        this.acceptKeyReleased = true;
    }

    public KeyWordSystem(String[] charsetString, int maxTextSize) {
        this.init(charsetString, maxTextSize);
    }

    public void init(String[] pwt, int maxTextSize) {
        char[][] charSet = new char[10][];
        for (int i = 0; i < charSet.length; ++i) {
            String key = pwt[i];
            if (key != null) {
                charSet[i] = new char[key.length()];
                for (int j = 0; j < key.length(); ++j) {
                    charSet[i][j] = key.charAt(j);
                }
                continue;
            }
            charSet[i] = new char[0];
        }
        this.charset = charSet;
        this.maxTextSize = maxTextSize;
        this.text = new StringBuffer();
        this.multitapChar = 0;
        this.acceptKeyPressed = true;
        this.acceptKeyReleased = true;
    }

    public void removeAllElements() {
        int len = this.text.length();
        this.text.delete(0, len);
    }

    public void keyPressed(int keyCode) {
        if (!this.acceptKeyPressed) {
            return;
        }
        this.addMultitap(keyCode);
    }

    public void keyReleased(int keyCode) {
        char action;
        if (!this.acceptKeyReleased) {
            return;
        }
        int keyNumber = this.getNumericKeyNumberForKeycode(keyCode);
        if (keyNumber != -1 || (action = this.getActionByKeycode(keyCode)) != '\b') {
            // empty if block
        }
    }

    private void addMultitap(int keycode) {
        int keyNumber = this.getNumericKeyNumberForKeycode(keycode);
        if (keyNumber != -1) {
            this.addMultitapKey(keyNumber);
        } else {
            char action = this.getActionByKeycode(keycode);
            if (action != '\b') {
                switch (action) {
                    case '\u0003': 
                    case '\t': {
                        this.multitapDeleteLastChar();
                        break;
                    }
                    case '\u0000': 
                    case '\u0002': {
                        this.acceptKeyPressed = false;
                        break;
                    }
                }
            }
        }
    }

    private void addMultitapKey(int keyPressed) {
        long time = System.currentTimeMillis();
        if (keyPressed >= 0 && keyPressed < this.charset.length && this.charset[keyPressed].length > 0) {
            if (keyPressed == this.multitapLastKey && this.multitapLastTime + 1000L > time && this.charset[keyPressed].length > 1) {
                this.multitapDeleteLastChar();
                this.multitapChar = (this.multitapChar + 1) % this.charset[keyPressed].length;
            } else {
                this.multitapChar = 0;
                if (this.text.length() >= this.maxTextSize) {
                    this.text.deleteCharAt(this.maxTextSize - 1);
                }
            }
            this.text.append(this.charset[keyPressed][this.multitapChar]);
            this.multitapLastTime = time;
            this.multitapLastKey = keyPressed;
        }
    }

    public void multitapDeleteLastChar() {
        if (this.text.length() > 0) {
            this.text.deleteCharAt(this.text.length() - 1);
        }
    }

    private int getNumericKeyNumberForKeycode(int keycode) {
        switch (keycode) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 42: {
                return 10;
            }
            case 35: {
                return 11;
            }
        }
        return -1;
    }

    private char getActionByKeycode(int keycode) {
        switch (keycode) {
            case -6: {
                return '\u0000';
            }
            case -7: {
                return '\u0001';
            }
            case -5: {
                return '\u0002';
            }
            case -3: {
                return '\u0003';
            }
            case -4: {
                return '\u0004';
            }
            case -1: {
                return '\u0005';
            }
            case -2: {
                return '\u0006';
            }
            case -8: {
                return '\t';
            }
        }
        return '\b';
    }
}

