/*
 * Decompiled with CFR 0.152.
 */
package com.allinone.bf.tool;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SpriteX {
    public static final int SPX_HEADER = 1397772888;
    public static final int SPX_VERSION = 34;
    public static final int SPX_BYTE_SEQUENCE_JAVA = 1;
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    public static final int ANTICLOCKWISE_90 = 0;
    public static final int DEASIL_90 = 1;
    public static final int HORIZONTAL = 2;
    public static final int VERTICAL = 3;
    public static final int DIRECTION_NONE = 0;
    public static final int DIRECTION_UP = 1;
    public static final int DIRECTION_DOWN = 2;
    public static final int DIRECTION_LEFT = 3;
    public static final int DIRECTION_RIGHT = 4;
    public static final int FRAME_HEADER_SIZE = 8;
    public static final int FRAME_TILE_COUNT_BIT = 1;
    public static final int FRAME_COLLISION_COUNT_BIT = 2;
    public static final int FRAME_REFERENCE_POINT_COUNT_BIT = 3;
    public static final int FRAME_TOP_POS_BIT = 4;
    public static final int FRAME_BOTTOM_POS_BIT = 5;
    public static final int FRAME_LEFT_POS_BIT = 6;
    public static final int FRAME_RIGHT_POS_BIT = 7;
    public static final int ACTION_HEADER_SIZE = 4;
    public static final int ACTION_SEQUENCE_LENGTH_BIT = 1;
    public static final int ACTION_SEQUENCE_DELAY_BIT = 2;
    public static final int ACTION_TRANSFORM_BIT = 3;
    public static final int COLLISION_INTERSECT = 1;
    public static final int COLLISION_INCLUSION = 2;
    public static final int COLLISION_INCLUSION_ = 3;
    public static final int INVERTED_AXES = 4;
    public static final int[][] TRANSFORM_TABLE;
    public static final int[][] ROTATE_TABLE;
    String spxName;
    String imageName;
    short[][] actionData;
    int actionCount;
    short[][] frameData;
    int frameCount;
    short[][] tileData;
    int tileCount;
    int actionIndex;
    int sequenceIndex;
    Image image;
    Image[] tiles;
    int[] tileUseCounter;
    boolean tileMode;
    String spxFileName;
    String spxFileExt;
    int delay;
    int width;
    int height;
    int x;
    int y;
    boolean visible;
    long lastTime;
    boolean firstUpdate;
    boolean disableUpdate;
    boolean isLoop;
    boolean loopFinished;
    int originOffsetX;
    int originOffsetY;
    private static Vector spxManager;

    static {
        int[][] nArrayArray = new int[8][];
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 1;
        nArray2[2] = 3;
        nArray2[3] = 2;
        nArray2[4] = 5;
        nArray2[5] = 4;
        nArray2[6] = 7;
        nArray2[7] = 6;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[8];
        nArray3[0] = 2;
        nArray3[1] = 3;
        nArray3[3] = 1;
        nArray3[4] = 6;
        nArray3[5] = 7;
        nArray3[6] = 4;
        nArray3[7] = 5;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[8];
        nArray4[0] = 3;
        nArray4[1] = 2;
        nArray4[2] = 1;
        nArray4[4] = 7;
        nArray4[5] = 6;
        nArray4[6] = 5;
        nArray4[7] = 4;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[8];
        nArray5[0] = 4;
        nArray5[1] = 6;
        nArray5[2] = 5;
        nArray5[3] = 7;
        nArray5[5] = 2;
        nArray5[6] = 1;
        nArray5[7] = 3;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[8];
        nArray6[0] = 5;
        nArray6[1] = 7;
        nArray6[2] = 4;
        nArray6[3] = 6;
        nArray6[4] = 1;
        nArray6[5] = 3;
        nArray6[7] = 2;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[8];
        nArray7[0] = 6;
        nArray7[1] = 4;
        nArray7[2] = 7;
        nArray7[3] = 5;
        nArray7[4] = 2;
        nArray7[6] = 3;
        nArray7[7] = 1;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[8];
        nArray8[0] = 7;
        nArray8[1] = 5;
        nArray8[2] = 6;
        nArray8[3] = 4;
        nArray8[4] = 3;
        nArray8[5] = 1;
        nArray8[6] = 2;
        nArrayArray[7] = nArray8;
        TRANSFORM_TABLE = nArrayArray;
        int[][] nArrayArray2 = new int[8][];
        nArrayArray2[0] = new int[]{6, 5, 2, 1};
        int[] nArray9 = new int[4];
        nArray9[0] = 7;
        nArray9[1] = 4;
        nArray9[2] = 3;
        nArrayArray2[1] = nArray9;
        int[] nArray10 = new int[4];
        nArray10[0] = 4;
        nArray10[1] = 7;
        nArray10[3] = 3;
        nArrayArray2[2] = nArray10;
        nArrayArray2[3] = new int[]{5, 6, 1, 2};
        nArrayArray2[4] = new int[]{1, 2, 5, 6};
        int[] nArray11 = new int[4];
        nArray11[1] = 3;
        nArray11[2] = 4;
        nArray11[3] = 7;
        nArrayArray2[5] = nArray11;
        int[] nArray12 = new int[4];
        nArray12[0] = 3;
        nArray12[2] = 7;
        nArray12[3] = 4;
        nArrayArray2[6] = nArray12;
        nArrayArray2[7] = new int[]{2, 1, 6, 5};
        ROTATE_TABLE = nArrayArray2;
        spxManager = new Vector();
    }

    public void setLoop(boolean loop) {
        this.isLoop = loop;
        this.loopFinished = false;
    }

    public boolean isLoopFinished() {
        return this.loopFinished;
    }

    public boolean getLoop() {
        return this.isLoop;
    }

    public static void removeAllSpx() {
        spxManager.removeAllElements();
    }

    public static void addSpxToManage(SpriteX spx) {
        spxManager.addElement(spx);
    }

    public SpriteX(String spxName, Image image) {
        this.loadSpx(spxName, image);
    }

    public SpriteX(String spxName, Image[] tiles) {
        this.loadSpx(spxName, this.image);
        this.tiles = tiles;
        this.tileMode = true;
    }

    public SpriteX(String spxName, String imageName) {
        this.spxName = spxName;
        this.imageName = imageName;
        boolean data = false;
        boolean image = false;
        int i = 0;
        while (i < spxManager.size()) {
            if (data && image) break;
            SpriteX spx = (SpriteX)spxManager.elementAt(i);
            if (!data && spx.spxName.equals(spxName)) {
                data = true;
                this.actionData = spx.actionData;
                this.actionCount = spx.actionCount;
                this.frameData = spx.frameData;
                this.frameCount = spx.frameCount;
                this.tileData = spx.tileData;
                this.tileCount = spx.tileCount;
                this.tiles = spx.tiles;
                this.tileUseCounter = spx.tileUseCounter;
                this.tileMode = spx.tileMode;
                this.spxFileName = spx.spxFileName;
                this.spxFileExt = spx.spxFileExt;
                this.delay = spx.delay;
            }
            if (!image && spx.imageName.equals(imageName)) {
                image = true;
                if (this.tileMode) {
                    this.spxFileName = spx.spxFileName;
                    this.spxFileExt = spx.spxFileExt;
                    this.tiles = spx.tiles;
                    this.tileUseCounter = spx.tileUseCounter;
                } else {
                    this.image = spx.image;
                }
            }
            ++i;
        }
        if (!image || !data) {
            SpriteX.addSpxToManage(this);
        }
        if (!data) {
            this.loadSpx(spxName, null);
        }
        if (!image) {
            if (this.tileMode) {
                int namelen = imageName.length();
                int i2 = namelen - 1;
                while (i2 >= 0) {
                    char ch = imageName.charAt(i2);
                    if (ch == '.') {
                        this.spxFileExt = imageName.substring(i2);
                        this.spxFileName = imageName.substring(0, i2);
                        break;
                    }
                    --i2;
                }
                if (this.spxFileExt == null) {
                    this.spxFileName = imageName;
                    this.spxFileExt = "";
                }
                this.tiles = new Image[this.tileCount];
                this.tileUseCounter = new int[this.tileCount];
            } else {
                Image spximg = null;
                try {
                    spximg = Image.createImage((String)imageName);
                }
                catch (IOException ex) {
                    System.out.println("can't load spx image\n" + imageName);
                }
                this.loadSpx(spxName, spximg);
            }
        }
    }

    public SpriteX(SpriteX spx) {
        int length;
        this.actionCount = spx.actionCount;
        this.frameCount = spx.frameCount;
        this.tileCount = spx.tileCount;
        this.actionData = new short[this.actionCount][];
        this.frameData = new short[this.frameCount][];
        this.tileData = new short[this.tileCount][];
        int i = 0;
        while (i < this.actionCount) {
            length = spx.actionData[i][0];
            this.actionData[i] = new short[length];
            System.arraycopy(spx.actionData[i], 0, this.actionData[i], 0, length);
            ++i;
        }
        i = 0;
        while (i < this.frameCount) {
            length = spx.frameData[i][0];
            this.frameData[i] = new short[length];
            System.arraycopy(spx.frameData[i], 0, this.frameData[i], 0, length);
            ++i;
        }
        i = 0;
        while (i < this.tileCount) {
            length = 4;
            this.tileData[i] = new short[length];
            System.arraycopy(spx.tileData[i], 0, this.tileData[i], 0, length);
            ++i;
        }
        this.actionIndex = spx.actionIndex;
        this.sequenceIndex = spx.sequenceIndex;
        this.image = spx.image;
        this.x = spx.x;
        this.y = spx.y;
        this.visible = spx.visible;
        this.lastTime = spx.lastTime;
        this.firstUpdate = spx.firstUpdate;
        this.disableUpdate = spx.disableUpdate;
    }

    public void loadSpx(String spxName, Image image) {
        try {
            int j;
            int offset;
            int length;
            int i;
            InputStream is = spxName.getClass().getResourceAsStream(spxName);
            DataInputStream data = new DataInputStream(is);
            int header = data.readInt();
            if (header != 1397772888) {
                throw new Exception("invalid SpriteX format\n");
            }
            byte version = data.readByte();
            if (version != 34) {
                throw new Exception("version no matching\n");
            }
            byte byteSequence = data.readByte();
            if ((byteSequence & 1) != 1) {
                throw new Exception("byte sequence error\n");
            }
            if ((byteSequence & 2) != 0) {
                this.tileMode = true;
            }
            this.tileCount = data.readInt();
            if (!this.tileMode) {
                this.tileData = new short[this.tileCount][4];
                i = 0;
                while (i < this.tileCount) {
                    this.tileData[i][0] = data.readShort();
                    this.tileData[i][1] = data.readShort();
                    this.tileData[i][2] = data.readShort();
                    this.tileData[i][3] = data.readShort();
                    ++i;
                }
            }
            this.frameCount = data.readInt();
            this.frameData = new short[this.frameCount][];
            i = 0;
            while (i < this.frameCount) {
                int frameTileCount = data.readInt();
                int collisionCount = data.readInt();
                int referencePointCount = data.readInt();
                length = 8 + frameTileCount * 4 + collisionCount * 4 + referencePointCount * 2;
                this.frameData[i] = new short[length];
                this.frameData[i][0] = (short)length;
                this.frameData[i][1] = (short)frameTileCount;
                this.frameData[i][2] = (short)collisionCount;
                this.frameData[i][3] = (short)referencePointCount;
                this.frameData[i][4] = data.readShort();
                this.frameData[i][5] = data.readShort();
                this.frameData[i][6] = data.readShort();
                this.frameData[i][7] = data.readShort();
                offset = 8;
                j = 0;
                while (j < frameTileCount) {
                    this.frameData[i][0 + offset] = data.readShort();
                    this.frameData[i][1 + offset] = data.readShort();
                    this.frameData[i][2 + offset] = data.readShort();
                    this.frameData[i][3 + offset] = data.readShort();
                    offset += 4;
                    ++j;
                }
                j = 0;
                while (j < collisionCount) {
                    this.frameData[i][0 + offset] = data.readShort();
                    this.frameData[i][1 + offset] = data.readShort();
                    this.frameData[i][2 + offset] = data.readShort();
                    this.frameData[i][3 + offset] = data.readShort();
                    offset += 4;
                    ++j;
                }
                j = 0;
                while (j < referencePointCount) {
                    this.frameData[i][0 + offset] = data.readShort();
                    this.frameData[i][1 + offset] = data.readShort();
                    offset += 2;
                    ++j;
                }
                ++i;
            }
            this.actionCount = data.readInt();
            this.actionData = new short[this.actionCount][];
            i = 0;
            while (i < this.actionCount) {
                int sequenceLength = data.readInt();
                byte delay = data.readByte();
                length = delay == 1 ? 4 + sequenceLength * 2 : 4 + sequenceLength;
                this.actionData[i] = new short[length];
                this.actionData[i][0] = (short)length;
                this.actionData[i][1] = (short)sequenceLength;
                this.actionData[i][2] = delay;
                this.actionData[i][3] = (short)data.readInt();
                offset = 4;
                if (delay == 1) {
                    j = 0;
                    while (j < sequenceLength) {
                        this.actionData[i][offset] = data.readShort();
                        this.actionData[i][offset + 1] = data.readShort();
                        offset += 2;
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < sequenceLength) {
                        this.actionData[i][offset] = data.readShort();
                        ++offset;
                        ++j;
                    }
                }
                ++i;
            }
            this.setImage(image);
            this.visible = true;
            is.close();
        }
        catch (Exception ex) {
            System.out.println("\u6ca1\u6709\u8bfb\u53d6\u5230\u8d44\u6e90" + spxName);
            ex.printStackTrace();
        }
    }

    public void initAction(int nAction) {
        short tile;
        int j;
        int frameDataOffset;
        int frameTileCount;
        short frame;
        int i;
        if (!this.tileMode) {
            return;
        }
        int[] tileUse = new int[this.tiles.length];
        int sequenceLength = this.actionData[nAction][1];
        short isDelay = this.actionData[nAction][2];
        int actionDataOffset = 4;
        if (isDelay == 1) {
            i = 0;
            while (i < sequenceLength) {
                frame = this.actionData[nAction][actionDataOffset];
                frameTileCount = this.frameData[frame][1];
                frameDataOffset = 8;
                j = 0;
                while (j < frameTileCount) {
                    tile = this.frameData[frame][frameDataOffset];
                    frameDataOffset += 4;
                    tileUse[tile] = 1;
                    ++j;
                }
                actionDataOffset += 2;
                ++i;
            }
        } else {
            i = 0;
            while (i < sequenceLength) {
                frame = this.actionData[nAction][actionDataOffset];
                frameTileCount = this.frameData[frame][1];
                frameDataOffset = 8;
                j = 0;
                while (j < frameTileCount) {
                    tile = this.frameData[frame][frameDataOffset];
                    frameDataOffset += 4;
                    tileUse[tile] = 1;
                    ++j;
                }
                ++actionDataOffset;
                ++i;
            }
        }
        int i2 = 0;
        while (i2 < this.tileCount) {
            if (tileUse[i2] == 1) {
                if (this.tiles[i2] == null) {
                    String fullName = String.valueOf(this.spxFileName) + i2 + this.spxFileExt;
                    Image spximg = null;
                    try {
                        spximg = Image.createImage((String)fullName);
                    }
                    catch (IOException ex) {
                        System.out.println("can't load spx image\n");
                    }
                    this.tiles[i2] = spximg;
                }
                int n = i2;
                this.tileUseCounter[n] = this.tileUseCounter[n] + 1;
            }
            ++i2;
        }
    }

    public void releaseAction(int nAction) {
        short tile;
        int j;
        int frameDataOffset;
        int frameTileCount;
        short frame;
        int i;
        if (!this.tileMode) {
            return;
        }
        int[] tileUse = new int[this.tiles.length];
        int sequenceLength = this.actionData[nAction][1];
        short isDelay = this.actionData[nAction][2];
        int actionDataOffset = 4;
        if (isDelay == 1) {
            i = 0;
            while (i < sequenceLength) {
                frame = this.actionData[nAction][actionDataOffset];
                frameTileCount = this.frameData[frame][1];
                frameDataOffset = 8;
                j = 0;
                while (j < frameTileCount) {
                    tile = this.frameData[frame][frameDataOffset];
                    frameDataOffset += 4;
                    tileUse[tile] = 1;
                    ++j;
                }
                actionDataOffset += 2;
                ++i;
            }
        } else {
            i = 0;
            while (i < sequenceLength) {
                frame = this.actionData[nAction][actionDataOffset];
                frameTileCount = this.frameData[frame][1];
                frameDataOffset = 8;
                j = 0;
                while (j < frameTileCount) {
                    tile = this.frameData[frame][frameDataOffset];
                    frameDataOffset += 4;
                    tileUse[tile] = 1;
                    ++j;
                }
                ++actionDataOffset;
                ++i;
            }
        }
        i = 0;
        while (i < this.tileCount) {
            if (this.tiles[i] != null) {
                int n = i;
                this.tileUseCounter[n] = this.tileUseCounter[n] - 1;
                if (this.tileUseCounter[i] <= 0) {
                    this.tiles[i] = null;
                }
            }
            ++i;
        }
    }

    public void initAllAction() {
        if (!this.tileMode) {
            return;
        }
        int i = 0;
        while (i < this.tileCount) {
            if (this.tiles[i] == null) {
                String fullName = String.valueOf(this.spxFileName) + i + this.spxFileExt;
                Image spximg = null;
                try {
                    spximg = Image.createImage((String)fullName);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.tiles[i] = spximg;
            }
            this.tileUseCounter[i] = 1;
            ++i;
        }
    }

    public void releaseAllAction() {
        if (!this.tileMode) {
            return;
        }
        int i = 0;
        while (i < this.tileCount) {
            this.tiles[i] = null;
            this.tileUseCounter[i] = 0;
            ++i;
        }
    }

    public String getSpxName() {
        return this.spxName;
    }

    public String getImageName() {
        return this.imageName;
    }

    public void enableUpdate(boolean enable) {
        if (this.disableUpdate && enable) {
            this.lastTime = System.currentTimeMillis();
        }
        this.disableUpdate = !enable;
    }

    public boolean isEnableUpdate() {
        return !this.disableUpdate;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Image getImage() {
        return this.image;
    }

    public Image getImage(int index) {
        return this.tiles[index];
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void move(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public boolean setAction(int actionIndex) {
        if (actionIndex == this.actionIndex) {
            this.setLoop(true);
            return true;
        }
        if (actionIndex < 0 || actionIndex >= this.actionCount) {
            return false;
        }
        this.actionIndex = actionIndex;
        this.sequenceIndex = 0;
        this.firstUpdate = false;
        this.setLoop(true);
        return true;
    }

    public void setAction(int actionIndex, boolean loop) {
        if (actionIndex == this.actionIndex) {
            this.setLoop(loop);
            return;
        }
        if (actionIndex < 0 || actionIndex >= this.actionCount) {
            throw new IndexOutOfBoundsException();
        }
        this.actionIndex = actionIndex;
        this.sequenceIndex = 0;
        this.firstUpdate = false;
        this.setLoop(loop);
    }

    public int getAction() {
        return this.actionIndex;
    }

    public int getActionCount() {
        return this.actionCount;
    }

    public void setFrame(int sequenceIndex) {
        if (sequenceIndex < 0 || sequenceIndex >= this.getSequenceLength()) {
            return;
        }
        this.sequenceIndex = sequenceIndex;
        this.firstUpdate = false;
    }

    public int getFrame() {
        return this.sequenceIndex;
    }

    public void setTransform(int transform) {
        if (transform < 0 || transform > 7) {
            throw new IllegalArgumentException();
        }
        this.actionData[this.actionIndex][3] = (short)transform;
    }

    public int getTransform() {
        return this.actionData[this.actionIndex][3];
    }

    public void deasilRotate90() {
        this.setTransform(ROTATE_TABLE[this.getTransform()][1]);
    }

    void anticlockwiseRotate90() {
        this.setTransform(ROTATE_TABLE[this.getTransform()][0]);
    }

    public void horizontalMirror() {
        this.setTransform(ROTATE_TABLE[this.getTransform()][2]);
    }

    public void verticalMirror() {
        this.setTransform(ROTATE_TABLE[this.getTransform()][3]);
    }

    public void nextFrame() {
        if (this.isLoop) {
            this.sequenceIndex = (this.sequenceIndex + 1) % this.getSequenceLength();
            this.firstUpdate = false;
            this.loopFinished = false;
        } else if (this.sequenceIndex < this.getSequenceLength() - 1) {
            ++this.sequenceIndex;
            this.loopFinished = false;
        } else {
            this.loopFinished = true;
        }
    }

    public void prevFrame() {
        this.sequenceIndex = this.sequenceIndex == 0 ? this.getSequenceLength() - 1 : --this.sequenceIndex;
        this.firstUpdate = false;
    }

    public void update(long time) {
        if (!this.isEnableUpdate()) {
            return;
        }
        if (this.isDelay()) {
            if (!this.firstUpdate) {
                this.firstUpdate = true;
                this.lastTime = time;
            }
            int dms = this.getDelayTime();
            if (time - this.lastTime >= (long)(dms -= 50)) {
                this.nextFrame();
                this.lastTime = time;
            }
        } else {
            int dms;
            if (!this.firstUpdate) {
                this.firstUpdate = true;
                this.lastTime = time;
            }
            if (time - this.lastTime >= (long)(dms = this.delay)) {
                this.nextFrame();
                this.lastTime = time;
            }
        }
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getDelay() {
        return this.delay;
    }

    public void update() {
        if (!this.isEnableUpdate()) {
            return;
        }
        this.update(System.currentTimeMillis());
    }

    public int getSequenceFrame(int sequenceIndex) {
        if (this.isDelay()) {
            return this.actionData[this.actionIndex][4 + sequenceIndex * 2];
        }
        return this.actionData[this.actionIndex][4 + sequenceIndex];
    }

    public int getSequenceFrame() {
        if (this.isDelay()) {
            return this.actionData[this.actionIndex][4 + this.sequenceIndex * 2];
        }
        return this.actionData[this.actionIndex][4 + this.sequenceIndex];
    }

    public int getSequenceLength() {
        return this.actionData[this.actionIndex][1];
    }

    public boolean isDelay() {
        return this.actionData[this.actionIndex][2] == 1;
    }

    public int getDelayTime() {
        return this.actionData[this.actionIndex][4 + this.sequenceIndex * 2 + 1];
    }

    public int getReferencePointX(int index) {
        int frameIndex = this.getSequenceFrame();
        short frameTileCount = this.frameData[frameIndex][1];
        short frameCollisionCount = this.frameData[frameIndex][2];
        int offset = 8 + frameTileCount * 4 + frameCollisionCount * 4 + index * 2;
        short refX = this.frameData[frameIndex][offset];
        short refY = this.frameData[frameIndex][offset + 1];
        return this.getTransformedReferenceX(refX, refY, this.getTransform()) + this.x;
    }

    public int getReferencePointY(int index) {
        int frameIndex = this.getSequenceFrame();
        short frameTileCount = this.frameData[frameIndex][1];
        short frameCollisionCount = this.frameData[frameIndex][2];
        int offset = 8 + frameTileCount * 4 + frameCollisionCount * 4 + index * 2;
        short refX = this.frameData[frameIndex][offset];
        short refY = this.frameData[frameIndex][offset + 1];
        return this.getTransformedReferenceY(refX, refY, this.getTransform()) + this.y;
    }

    public int getReferencePointCount(int frameIndex) {
        if (frameIndex < 0 && frameIndex >= this.frameCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        short frameReferencePointCount = this.frameData[frameIndex][3];
        return frameReferencePointCount;
    }

    public int getReferencePointCount() {
        int frameIndex = this.getSequenceFrame();
        return this.getReferencePointCount(frameIndex);
    }

    int getTransformedReferenceX(int x, int y, int transform) {
        int t_x = 0;
        switch (transform) {
            case 0: {
                t_x = x;
                break;
            }
            case 2: {
                t_x = -x;
            }
        }
        return t_x;
    }

    int getTransformedReferenceY(int x, int y, int transform) {
        int t_y = 0;
        switch (transform) {
            case 0: {
                t_y = y;
                break;
            }
            case 2: {
                t_y = y;
            }
        }
        return t_y;
    }

    public int getCollidesX(int index) {
        int frameIndex = this.getSequenceFrame();
        return this.getCollidesX(frameIndex, index);
    }

    public int getCollidesY(int index) {
        int frameIndex = this.getSequenceFrame();
        return this.getCollidesY(frameIndex, index);
    }

    public int getCollidesX(int frame, int index) {
        if (index < 0 || index >= this.frameData[frame][2]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int offset = 8 + this.frameData[frame][1] * 4 + index * 4;
        return this.frameData[frame][offset] + this.x;
    }

    public int getCollidesY(int frame, int index) {
        if (index < 0 || index >= this.frameData[frame][2]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int offset = 8 + this.frameData[frame][1] * 4 + index * 4 + 1;
        return this.frameData[frame][offset] + this.y;
    }

    public int getCollidesWidth(int index) {
        int frameIndex = this.getSequenceFrame();
        return this.getCollidesWidth(frameIndex, index);
    }

    public int getCollidesHeight(int index) {
        int frameIndex = this.getSequenceFrame();
        return this.getCollidesHeight(frameIndex, index);
    }

    public int getCollidesWidth(int frame, int index) {
        if (index < 0 || index >= this.frameData[frame][2]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int offset = 8 + this.frameData[frame][1] * 4 + index * 4 + 2;
        return this.frameData[frame][offset];
    }

    public int getCollidesHeight(int frame, int index) {
        if (index < 0 || index >= this.frameData[frame][2]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int offset = 8 + this.frameData[frame][1] * 4 + index * 4 + 3;
        return this.frameData[frame][offset];
    }

    public int getCollidesCount(int frame) {
        return this.frameData[frame][2];
    }

    public int getCollidesCount() {
        return this.frameData[this.getSequenceFrame()][2];
    }

    public boolean collidesWith(SpriteX spx, int spxCollides, int thisCollides, int type) {
        if (!spx.visible || !this.visible) {
            return false;
        }
        int x = spx.getCollidesX(spxCollides);
        int y = spx.getCollidesY(spxCollides);
        int width = spx.getCollidesWidth(spxCollides);
        int height = spx.getCollidesHeight(spxCollides);
        return this.collidesWith(x, y, width, height, thisCollides, type);
    }

    public boolean collidesWith(Image image, int x, int y, int collides, int type) {
        return this.collidesWith(x, y, image.getWidth(), image.getHeight(), collides, type);
    }

    public boolean collidesWith(int x, int y, int width, int height, int collides, int type) {
        if (!this.visible) {
            return false;
        }
        int x1 = this.getCollidesX(collides);
        int y1 = this.getCollidesY(collides);
        int w1 = this.getCollidesWidth(collides);
        int h1 = this.getCollidesHeight(collides);
        if (type == 1) {
            return SpriteX.intersectRect(x1, y1, w1, h1, x, y, width, height);
        }
        if (type == 2) {
            return SpriteX.inclusionRect(x1, y1, w1, h1, x, y, width, height);
        }
        if (type == 3) {
            return SpriteX.inclusionRect(x, y, width, height, x1, y1, w1, h1);
        }
        throw new ArithmeticException();
    }

    public boolean collidesWith(SpriteX spx) {
        if (!spx.visible || !this.visible) {
            return false;
        }
        if (this.getCollidesCount() == 0 || spx.getCollidesCount() == 0) {
            return false;
        }
        return this.collidesWith(spx, 0, 0, 1);
    }

    public boolean collidesWith(SpriteX spx, int thisId, int spxId) {
        if (!spx.visible || !this.visible) {
            return false;
        }
        if (this.getCollidesCount() == 0 || spx.getCollidesCount() == 0) {
            return false;
        }
        if (thisId >= this.getCollidesCount() || spxId >= spx.getCollidesCount()) {
            return false;
        }
        return this.collidesWith(spx, spxId, thisId, 1);
    }

    public boolean collidesWith(Image image, int x, int y) {
        if (!this.visible) {
            return false;
        }
        if (this.getCollidesCount() == 0) {
            return false;
        }
        return this.collidesWith(image, x, y, 0, 1);
    }

    public boolean collidesWith(int x, int y, int width, int height) {
        if (!this.visible) {
            return false;
        }
        if (this.getCollidesCount() == 0) {
            return false;
        }
        return this.collidesWith(x, y, width, height, 0, 1);
    }

    public static boolean intersectRect(int x1, int y1, int width1, int height1, int x2, int y2, int width2, int height2) {
        return y2 + height2 >= y1 && y2 <= y1 + height1 && x2 + width2 >= x1 && x2 <= x1 + width1;
    }

    public static boolean inclusionRect(int x1, int y1, int width1, int height1, int x2, int y2, int width2, int height2) {
        return y2 >= y1 && y2 + height2 <= y1 + height1 && x2 >= x1 && x2 + width2 <= x1 + width1;
    }

    public void originOffset(int x, int y) {
        this.originOffsetX = x;
        this.originOffsetY = y;
    }

    public int getFrameTopPos() {
        return this.frameData[this.getSequenceFrame()][4] + this.y;
    }

    public int getFrameBottomPos() {
        return this.frameData[this.getSequenceFrame()][5] + this.y;
    }

    public int getFrameLeftPos() {
        return this.frameData[this.getSequenceFrame()][6] + this.x;
    }

    public int getFrameRightPos() {
        return this.frameData[this.getSequenceFrame()][7] + this.x;
    }

    public int getFrameWidth() {
        return this.getFrameRightPos() - this.getFrameLeftPos();
    }

    public int getFrameHeight() {
        return this.getFrameBottomPos() - this.getFrameTopPos();
    }

    public void paint(Graphics g, int x, int y) {
        block45: {
            if (g == null) {
                throw new NullPointerException();
            }
            if (!this.visible) break block45;
            x -= this.originOffsetX;
            y -= this.originOffsetY;
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipWidth = g.getClipWidth();
            int clipHeight = g.getClipHeight();
            int actionTransform = this.getTransform();
            if (actionTransform == 0) {
                int frameIndex = this.getSequenceFrame();
                int tileCount = this.frameData[frameIndex][1];
                int offset = 8;
                int i = 0;
                while (i < tileCount) {
                    int dh;
                    int dw;
                    int th;
                    int tw;
                    short ty;
                    short tx;
                    short transform;
                    int dy;
                    int dx;
                    short tileIndex;
                    if (this.tileMode) {
                        tileIndex = this.frameData[frameIndex][0 + offset];
                        dx = this.frameData[frameIndex][1 + offset] + x;
                        dy = this.frameData[frameIndex][2 + offset] + y;
                        transform = this.frameData[frameIndex][3 + offset];
                        tx = 0;
                        ty = 0;
                        tw = this.tiles[tileIndex].getWidth();
                        th = this.tiles[tileIndex].getHeight();
                        if ((transform & 4) != 0) {
                            dw = th;
                            dh = tw;
                        } else {
                            dw = tw;
                            dh = th;
                        }
                        if (SpriteX.intersectRect(dx, dy, dw, dh, clipX, clipY, clipWidth, clipHeight)) {
                            SpriteX.drawRegion(g, this.tiles[tileIndex], tx, ty, tw, th, transform, dx, dy, 20);
                        }
                    } else {
                        tileIndex = this.frameData[frameIndex][0 + offset];
                        dx = this.frameData[frameIndex][1 + offset] + x;
                        dy = this.frameData[frameIndex][2 + offset] + y;
                        transform = this.frameData[frameIndex][3 + offset];
                        tx = this.tileData[tileIndex][0];
                        ty = this.tileData[tileIndex][1];
                        tw = this.tileData[tileIndex][2];
                        th = this.tileData[tileIndex][3];
                        if ((transform & 4) != 0) {
                            dw = th;
                            dh = tw;
                        } else {
                            dw = tw;
                            dh = th;
                        }
                        if (SpriteX.intersectRect(dx, dy, dw, dh, clipX, clipY, clipWidth, clipHeight)) {
                            SpriteX.drawRegion(g, this.image, tx, ty, tw, th, transform, dx, dy, 20);
                        }
                    }
                    offset += 4;
                    ++i;
                }
            } else {
                int frameIndex = this.getSequenceFrame();
                int tileCount = this.frameData[frameIndex][1];
                int offset = 8;
                int i = 0;
                while (i < tileCount) {
                    int cy;
                    int cx;
                    int dh;
                    int dw;
                    int th;
                    int tw;
                    short ty;
                    short tx;
                    int transform;
                    int dy;
                    int dx;
                    short tileIndex;
                    if (this.tileMode) {
                        tileIndex = this.frameData[frameIndex][0 + offset];
                        dx = this.frameData[frameIndex][1 + offset] + x;
                        dy = this.frameData[frameIndex][2 + offset] + y;
                        transform = this.frameData[frameIndex][3 + offset];
                        tx = 0;
                        ty = 0;
                        tw = this.tiles[tileIndex].getWidth();
                        th = this.tiles[tileIndex].getHeight();
                        if ((transform & 4) != 0) {
                            dw = th;
                            dh = tw;
                        } else {
                            dw = tw;
                            dh = th;
                        }
                        cx = x - dx;
                        cy = y - dy;
                        transform = TRANSFORM_TABLE[transform][actionTransform];
                        switch (actionTransform) {
                            case 0: {
                                break;
                            }
                            case 5: {
                                dx = x - (dh - cy);
                                dy = y - cx;
                                break;
                            }
                            case 3: {
                                dx = x - (dw - cx);
                                dy = y - (dh - cy);
                                break;
                            }
                            case 6: {
                                dx = x - cy;
                                dy = y - (dw - cx);
                                break;
                            }
                            case 2: {
                                dx = x - (dw - cx);
                                break;
                            }
                            case 7: {
                                dx = x - (dh - cy);
                                dy = y - (dw - cx);
                                break;
                            }
                            case 1: {
                                dy = y - (dh - cy);
                                break;
                            }
                            case 4: {
                                dx = x - cy;
                                dy = y - cx;
                            }
                        }
                        if ((transform & 4) != 0) {
                            dw = th;
                            dh = tw;
                        } else {
                            dw = tw;
                            dh = th;
                        }
                        if (SpriteX.intersectRect(dx, dy, dw, dh, clipX, clipY, clipWidth, clipHeight)) {
                            SpriteX.drawRegion(g, this.tiles[tileIndex], tx, ty, tw, th, transform, dx, dy, 20);
                        }
                        offset += 4;
                    } else {
                        tileIndex = this.frameData[frameIndex][0 + offset];
                        dx = this.frameData[frameIndex][1 + offset] + x;
                        dy = this.frameData[frameIndex][2 + offset] + y;
                        transform = this.frameData[frameIndex][3 + offset];
                        tx = this.tileData[tileIndex][0];
                        ty = this.tileData[tileIndex][1];
                        tw = this.tileData[tileIndex][2];
                        th = this.tileData[tileIndex][3];
                        if ((transform & 4) != 0) {
                            dw = th;
                            dh = tw;
                        } else {
                            dw = tw;
                            dh = th;
                        }
                        cx = x - dx;
                        cy = y - dy;
                        transform = TRANSFORM_TABLE[transform][actionTransform];
                        switch (actionTransform) {
                            case 0: {
                                break;
                            }
                            case 5: {
                                dx = x - (dh - cy);
                                dy = y - cx;
                                break;
                            }
                            case 3: {
                                dx = x - (dw - cx);
                                dy = y - (dh - cy);
                                break;
                            }
                            case 6: {
                                dx = x - cy;
                                dy = y - (dw - cx);
                                break;
                            }
                            case 2: {
                                dx = x - (dw - cx);
                                break;
                            }
                            case 7: {
                                dx = x - (dh - cy);
                                dy = y - (dw - cx);
                                break;
                            }
                            case 1: {
                                dy = y - (dh - cy);
                                break;
                            }
                            case 4: {
                                dx = x - cy;
                                dy = y - cx;
                            }
                        }
                        if ((transform & 4) != 0) {
                            dw = th;
                            dh = tw;
                        } else {
                            dw = tw;
                            dh = th;
                        }
                        if (SpriteX.intersectRect(dx, dy, dw, dh, clipX, clipY, clipWidth, clipHeight)) {
                            SpriteX.drawRegion(g, this.image, tx, ty, tw, th, transform, dx, dy, 20);
                        }
                        offset += 4;
                    }
                    ++i;
                }
            }
        }
    }

    public void paint(Graphics g) {
        this.paint(g, this.x, this.y);
    }

    public static void drawRegionMIDP1(Graphics g, Image src, int x_src, int y_src, int width, int height, int transform, int x_dest, int y_dest, int anchor) {
        if (g == null || src == null) {
            throw new NullPointerException();
        }
        if (!SpriteX.checkAnchor(anchor, 64)) {
            throw new IllegalArgumentException();
        }
        if (transform < 0 || transform > 7) {
            throw new IllegalArgumentException();
        }
        if (width < 0 || height < 0 || x_src < 0 || y_src < 0 || x_src + width > src.getWidth() || y_src + height > src.getHeight()) {
            throw new IllegalArgumentException();
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        if ((4 & transform) != 0) {
            if (anchor != 0) {
                if ((anchor & 0x20) != 0) {
                    y_dest -= width;
                }
                if ((anchor & 8) != 0) {
                    x_dest -= height;
                }
                if ((anchor & 1) != 0) {
                    x_dest -= height / 2;
                }
                if ((anchor & 2) != 0) {
                    y_dest -= width / 2;
                }
            }
            g.clipRect(x_dest, y_dest, height, width);
        } else {
            if (anchor != 0) {
                if ((anchor & 0x20) != 0) {
                    y_dest -= height;
                }
                if ((anchor & 8) != 0) {
                    x_dest -= width;
                }
                if ((anchor & 1) != 0) {
                    x_dest -= width / 2;
                }
                if ((anchor & 2) != 0) {
                    y_dest -= height / 2;
                }
            }
            g.clipRect(x_dest, y_dest, width, height);
        }
        int x_offset = 0;
        int y_offset = 0;
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        switch (transform) {
            case 0: {
                g.drawImage(src, x_dest - x_src, y_dest - y_src, 20);
                g.setClip(clipX, clipY, clipWidth, clipHeight);
                return;
            }
            case 5: {
                x_offset = srcHeight - (y_src + height);
                y_offset = x_src;
                break;
            }
            case 3: {
                x_offset = srcWidth - (x_src + width);
                y_offset = srcHeight - (y_src + height);
                break;
            }
            case 6: {
                x_offset = y_src;
                y_offset = srcWidth - (x_src + width);
                break;
            }
            case 2: {
                x_offset = srcWidth - (x_src + width);
                y_offset = y_src;
                break;
            }
            case 7: {
                x_offset = srcHeight - (y_src + height);
                y_offset = srcWidth - (x_src + width);
                break;
            }
            case 1: {
                x_offset = x_src;
                y_offset = srcHeight - (y_src + height);
                break;
            }
            case 4: {
                x_offset = y_src;
                y_offset = x_src;
            }
        }
        x_dest -= x_offset;
        y_dest -= y_offset;
        int clipX1 = g.getClipX();
        int clipY1 = g.getClipY();
        int clipX2 = g.getClipX() + g.getClipWidth();
        int clipY2 = g.getClipY() + g.getClipHeight();
        if ((4 & transform) != 0) {
            int temp = srcWidth;
            srcWidth = srcHeight;
            srcHeight = temp;
        }
        int src_start_x = Math.max(0, clipX1 - x_dest);
        int src_start_y = Math.max(0, clipY1 - y_dest);
        int dest_start_x = Math.max(clipX1, x_dest);
        int dest_start_y = Math.max(clipY1, y_dest);
        int dest_right = x_dest + srcWidth;
        int dest_bottom = y_dest + srcHeight;
        int copy_width = srcWidth - src_start_x;
        int copy_height = srcHeight - src_start_y;
        copy_width -= Math.max(0, dest_right - clipX2);
        copy_height -= Math.max(0, dest_bottom - clipY2);
        int px = 0;
        int py = 0;
        int i = 0;
        while (i < copy_height) {
            int j = 0;
            while (j < copy_width) {
                switch (transform) {
                    case 5: {
                        px = src_start_y + i;
                        py = srcWidth - 1 - j - src_start_x;
                        break;
                    }
                    case 3: {
                        px = srcWidth - 1 - j - src_start_x;
                        py = srcHeight - 1 - i - src_start_y;
                        break;
                    }
                    case 6: {
                        px = srcHeight - 1 - i - src_start_y;
                        py = src_start_x + j;
                        break;
                    }
                    case 2: {
                        px = srcWidth - 1 - j - src_start_x;
                        py = src_start_y + i;
                        break;
                    }
                    case 7: {
                        px = srcHeight - 1 - i - src_start_y;
                        py = srcWidth - 1 - j - src_start_x;
                        break;
                    }
                    case 1: {
                        px = src_start_x + j;
                        py = srcHeight - 1 - i - src_start_y;
                        break;
                    }
                    case 4: {
                        px = src_start_y + i;
                        py = src_start_x + j;
                    }
                }
                g.setClip(dest_start_x + j, dest_start_y + i, 1, 1);
                g.drawImage(src, dest_start_x + j - px, dest_start_y + i - py, 20);
                ++j;
            }
            ++i;
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    public static boolean checkAnchor(int anchor, int illegal_vpos) {
        int n;
        boolean right;
        if (anchor == 0) {
            return true;
        }
        boolean bl = right = anchor > 0 && anchor < 128 && (anchor & illegal_vpos) == 0;
        if (right) {
            n = anchor & 0x72;
            boolean bl2 = right = n != 0 && (n & n - 1) == 0;
        }
        if (right) {
            n = anchor & 0xD;
            right = n != 0 && (n & n - 1) == 0;
        }
        return right;
    }

    public static void drawRegion(Graphics g, Image src, int x_src, int y_src, int width, int height, int transform, int x_dest, int y_dest, int anchor) {
        g.drawRegion(src, x_src, y_src, width, height, transform, x_dest, y_dest, anchor);
    }
}

