/*
 * Decompiled with CFR 0.152.
 */
package com.bf.canvas;

import com.allinone.bf.tool.T;
import com.bf.i.ICanvas;
import com.bf.i.IConstance;
import com.bf.midlet.TW_MIDlet;
import com.bf.tool.StrData;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LoadingCanvas
extends ICanvas
implements IConstance {
    private String path1 = "/pic/loading/";
    private String path2 = "/pic/other/";
    private static Image imageSrc1;
    private static Image imageSrc2;
    private static Image imageSrc3;
    private static Image imageSrc4;
    private final String imgSrc1Path;
    private final String imgSrc2Path;
    private final String imgSrc3Path;
    private final String imgSrc4Path;
    public final int LOGO;
    public final int MENU;
    public final int GAME;
    public final int NONE;
    public int status;
    private int progressc = 0;
    private int progressTemp = 0;
    private int progresso = 100;
    private int waitDelay = 500;
    private long waitTime;
    private long waitTimeLast;
    private int rdLoadingTipNum = 0;

    public LoadingCanvas() {
        this.imgSrc1Path = "loadingbg.png";
        this.imgSrc2Path = "loadingline.png";
        this.imgSrc3Path = "loadingword.png";
        this.imgSrc4Path = "num_1.png";
        this.LOGO = 1;
        this.MENU = 2;
        this.GAME = 3;
        this.NONE = 0;
        this.loadingImage();
        this.initData();
        this.status = 0;
    }

    private void loadingImage() {
        if (imageSrc1 == null) {
            imageSrc1 = T.TP.createImg(this.path1, "loadingbg.png");
        }
        if (imageSrc2 == null) {
            imageSrc2 = T.TP.createImg(this.path1, "loadingline.png");
        }
        if (imageSrc3 == null) {
            imageSrc3 = T.TP.createImg(this.path1, "loadingword.png");
        }
        if (imageSrc4 == null) {
            imageSrc4 = T.TP.createImg(this.path2, "num_1.png");
        }
    }

    private void initData() {
    }

    public void paint(Graphics g) {
        T.cls(g);
        T.TP.paintImageX(g, imageSrc1, ICanvas.sWidth / 2, ICanvas.sHeight / 2 - imageSrc1.getHeight(), 3);
        T.TP.paintImageX(g, imageSrc3, ICanvas.sWidth / 2, ICanvas.sHeight / 2 - 12, 3);
        int x = (ICanvas.sWidth - imageSrc2.getWidth()) / 2;
        int y = (ICanvas.sHeight - imageSrc2.getHeight()) / 2 - 37;
        g.setClip(x, y, this.progressTemp * imageSrc2.getWidth() / this.progresso, imageSrc2.getHeight());
        T.TP.paintImageX(g, imageSrc2, x, y, 20);
        if (this.progressTemp < this.progressc) {
            this.progressTemp = this.progressc - this.progressTemp >= 10 ? (this.progressTemp += 10) : (this.progressc - this.progressTemp >= 5 ? (this.progressTemp += 5) : ++this.progressTemp);
        }
        T.TP.paintNumberX(g, imageSrc4, this.progressTemp, ICanvas.sWidth / 2 - 14, ICanvas.sHeight / 2 - 66, 3, 0);
        g.setColor(0, 255, 0);
        switch (this.status) {
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                T.TS.paintStringX(g, StrData.loadingTip[this.rdLoadingTipNum], 5, ICanvas.sHeight / 2, ICanvas.sWidth - 10, ICanvas.sHeight / 2 - 5, 1, 0);
            }
        }
    }

    public void show() {
        this.initShowData();
        super.show();
    }

    private void initShowData() {
        this.progressc = 0;
        this.progressTemp = 0;
        this.rdLoadingTipNum = T.getRandom(StrData.loadingTip.length);
    }

    private void logic() {
        if (!TW_MIDlet.isLoading && this.progressTemp == this.progresso) {
            switch (this.status) {
                case 1: {
                    TW_MIDlet.showImpl1();
                    break;
                }
                case 2: {
                    TW_MIDlet.showImpl2();
                    break;
                }
                case 3: {
                    TW_MIDlet.showImpl3();
                }
            }
        }
        if (!TW_MIDlet.isLoading) {
            this.progressc = this.progresso;
        } else if (this.progressc <= this.progresso - 10) {
            this.waitTimeLast = System.currentTimeMillis();
            if (this.waitTimeLast - this.waitTime >= (long)this.waitDelay) {
                this.waitTime = this.waitTimeLast;
                this.progressc += T.getRandom(2) + 9;
            }
        }
    }

    public void keyAction() {
    }

    public void run() {
        this.logic();
    }
}

