/*
 * Decompiled with CFR 0.152.
 */
package com.bf.sound;

import com.bf.sound.AudioPlay;

public class PlayThread
implements Runnable {
    boolean isRunning = true;
    boolean isPlay = false;
    int playIndex;
    private AudioPlay audio = new AudioPlay();
    int volume = 0;

    public synchronized void notifyStop() {
        this.isPlay = false;
        this.audio.stopAllSound();
    }

    public synchronized void notifyCloseThread() {
        this.audio.shutdown();
        this.isPlay = false;
        this.isRunning = false;
    }

    public synchronized void notifyPlay(int playIndex, int volume) {
        this.volume = volume;
        this.playIndex = playIndex;
        this.isPlay = true;
    }

    public final void run() {
        long sleepRate = 50L;
        while (this.isRunning) {
            long time = System.currentTimeMillis();
            if (this.isPlay) {
                try {
                    this.audio.playSound(this.playIndex, this.volume);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                this.isPlay = false;
            }
            time = System.currentTimeMillis() - time;
            try {
                if (time >= sleepRate) continue;
                Thread.sleep(sleepRate - time);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public int getStatus() {
        return this.audio.getStatus(this.playIndex);
    }
}

