/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class SoundEffects {
    private static SoundEffects a;
    private String[] a = new String[]{"audio/x-wav", "audio/midi", "audio/mpeg"};

    private SoundEffects() {
    }

    public static SoundEffects getInstance() {
        if (a == null) {
            a = new SoundEffects();
        }
        return a;
    }

    public Player createPlayer(String string, int n) {
        Player player = null;
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            string = string.substring(string.indexOf(46) + 1, string.length());
            if (string.equals("mid")) {
                player = Manager.createPlayer((InputStream)inputStream, (String)this.a[1]);
            } else if (string.equals("wav")) {
                player = Manager.createPlayer((InputStream)inputStream, (String)this.a[0]);
            } else if (string.equals("mp3")) {
                player = Manager.createPlayer((InputStream)inputStream, (String)this.a[2]);
            } else {
                return null;
            }
            player.realize();
            player.prefetch();
            player.setLoopCount(n);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return player;
    }

    public void playSound(Player player) {
        if (player == null) {
            return;
        }
        try {
            if (player.getState() != 400) {
                player.prefetch();
                player.start();
            }
            return;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
    }

    public void pauseSound(Player player) {
        if (player == null) {
            return;
        }
        try {
            if (player.getState() == 400) {
                player.stop();
            }
            return;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
    }

    public void stopSound(Player player) {
        this.pauseSound(player);
        try {
            player.setMediaTime(-1L);
            return;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
    }

    public void closeSound(Player player) {
        if (player == null) {
            return;
        }
        try {
            player.close();
            System.gc();
            return;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
    }

    public void setVolumeLevel(Player player, int n) {
        if (player == null) {
            return;
        }
        player = (VolumeControl)player.getControl("VolumeControl");
        player.setLevel(n);
    }
}

