/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class GameMap {
    static int screenWidth;
    static int screenHeight;
    static byte tileWidth;
    static byte tileHight;
    static int[] mapSize;
    short[][] tileProperties = new short[2][];
    int w;
    int h;
    String[][] name = new String[2][];
    static int setOffX;
    static int setOffY;
    static byte[][] mapData;
    static GameEngine engine;
    public static short[][] itemData;
    public static final short L_TILE = 20;
    public static final short L_ROLESD = 30;
    public static final short L_HIGH = 2000;
    public static final short L_TALK = 5000;
    public static final short L_MAX = 9000;
    public static final short L_BBG = 10;
    public static final short L_OVERBBG = 20;
    public static final short L_BFLASH = 350;
    static boolean isBuffer;
    static boolean isTile;
    static boolean isMoto;
    static boolean isZhong;
    byte mapID;
    String mapName;
    String fileName;
    int music;
    byte[] enemys;
    byte[] herbs;
    short battleBg;
    public static final byte ITEM_TYPE = 0;
    public static final byte ITEM_X = 1;
    public static final byte ITEM_Y = 2;
    public static final byte ITEM_TR = 3;
    public static final byte OBJ_ID = 0;
    public static final byte OBJ_IMG = 1;
    public static final byte OBJ_ADDX = 2;
    public static final byte OBJ_ADDY = 3;
    public static final byte OBJ_W = 4;
    public static final byte OBJ_H = 5;
    public static final byte OBJ_DL = 6;
    static byte gameRankType;
    short[][] objData;
    static short[][] decData;
    short[][] mapArrow;
    byte dec = (byte)-1;
    short[][] YeLine = new short[][]{{134, 0, 98, 8}, {77, 9, 156, 9}, {50, 19, 184, 10}, {15, 30, 219, 8}, {0, 39, 238, 19}};
    boolean isFirst = false;
    short[][] starPos = GameEngine.starPos;
    short VSNUM = (short)30;
    public static boolean isShowCG;
    public static byte CGId;
    static byte index;
    static short indexTime;
    boolean isStart;
    static boolean isBlack;
    byte areaIndex;
    static boolean isShowName;
    public static final byte CLOSE = 0;
    public static final byte OPEN = 1;
    public static final byte READY = 2;
    public static byte SCEEN_MOVE;
    int adjustX;
    int adjustY;
    static boolean isMoveScreen;
    Event event;
    String command;
    static short[][] herbsData;
    byte gatherIndex;
    static short[][] moveDecortion;
    public static final byte MD_I_GC = 0;
    public static final byte MD_I_GCKONG = 1;
    public static final byte MD_MAISHEN = 2;
    public static final byte MD_JIGUAN = 3;
    public static final byte MD_MIDAO = 4;
    public static final byte MD_LEITAI = 5;
    public static final byte MD_HUO = 6;
    public static final byte MD_TYPE = 0;
    public static final byte MD_X = 1;
    public static final byte MD_Y = 2;
    public static final byte MD_TR = 3;
    public static final byte MD_ST = 4;
    static byte spriteId2;
    static byte spriteId;
    static byte faceType;
    Image mapBuff;
    int buffWidth;
    int buffHeight;
    boolean isBuffNull;
    int lastStartX;
    int lastStartY;
    int lastEndX;
    int lastEndY;

    public void free() {
        mapData = new byte[2][];
        if (isBuffer) {
            this.mapBuff = null;
        }
        System.gc();
    }

    public void init(String dat) {
        block7: {
            String[] param;
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block6: {
                                            param = Event.splitString(dat, " ");
                                            if (!param[0].equals("id")) break block6;
                                            this.mapID = (byte)Event.sToi(param[1]);
                                            break block7;
                                        }
                                        if (!param[0].equals("name")) break block8;
                                        this.mapName = param[1];
                                        break block7;
                                    }
                                    if (!param[0].equals("dat")) break block9;
                                    this.fileName = param[1];
                                    break block7;
                                }
                                if (!param[0].equals("Decdat")) break block10;
                                this.dec = (byte)Event.sToi(param[1]);
                                break block7;
                            }
                            if (!param[0].equals("weather")) break block11;
                            gameRankType = (byte)Event.sToi(param[1]);
                            break block7;
                        }
                        if (!param[0].equals("BGM")) break block12;
                        this.music = Event.sToi(param[1]);
                        break block7;
                    }
                    if (!param[0].equals("enemys")) break block13;
                    if (param[1].equals("null")) {
                        this.enemys = null;
                    } else {
                        String[] s = Event.splitString(param[1], ",");
                        this.enemys = new byte[s.length];
                        int j = 0;
                        while (j < this.enemys.length) {
                            this.enemys[j] = (byte)Event.sToi(s[j]);
                            ++j;
                        }
                    }
                    break block7;
                }
                if (!param[0].equals("battleBg")) break block14;
                this.battleBg = (short)Event.sToi(param[1]);
                break block7;
            }
            if (!param[0].equals("enemyLevel")) break block7;
            if (param[1].equals("null")) {
                this.herbs = null;
            } else {
                String[] s = Event.splitString(param[1], ",");
                this.herbs = new byte[s.length];
                int j = 0;
                while (j < this.herbs.length) {
                    this.herbs[j] = (byte)Event.sToi(s[j]);
                    ++j;
                }
            }
        }
    }

    public GameMap(GameEngine en, int sw, int sh) {
        screenWidth = sw;
        screenHeight = sh;
        GameMap.setOff(0, 0);
        engine = en;
    }

    public static void setOff(int x, int y) {
        setOffX = x;
        setOffY = y;
    }

    void initObjData() {
        this.objData = new short[][]{{0, 114, 0, 0, 32, 32}, {1, 116, -9, 0, 16, 16}, {2, 117, -3, 0, 16, 16}, {3, 118, 0, 0, 48, 48}, {4, 119, 0, 0, 64, 96}, {5, 120, 0, 0, 112, 48}, {6, 121, -3, 0, 128, 64}, {7, 122, -18, 5, 32, 16}, {8, 123, -20, 2, 32, 16}, {9, 124, 0, 0, 0, 0}, {10, 125, 0, 0, 0, 0}, {11, 126, 0, 0, 0, 0}, {12, 127, -7, 2, 48, 32}, {13, 128, 0, 0, 0, 0}, {14, 129, 0, 0, 32, 48}, {15, 132, 0, 0, 0, 0}, {16, 133, 0, 0, 64, 48}, {17, 134, 0, 0, 48, 16}, {18, 135, 0, 0, 0, 0}, {19, 136, 3, 0, 48, 16}, {20, 138, -5, 4, 16, 16}, {21, 139, 0, 0, 112, 48}, {22, 140, -17, 4, 32, 16}, {23, 141, -15, 0, 48, 32}, {24, 142, 2, 0, 48, 16}, {25, 143, 0, 0, 0, 0}, {26, 144, 0, 0, 16, 16}, {27, 145, 0, 0, 32, 32}, {28, 146, 0, 0, 0, 0}, {29, 147, 2, 0, 16, 16}, {30, 148, 0, 0, 16, 16}, {31, 149, -9, 0, 0, 0}, {32, 151, -3, 0, 16, 16}, {33, 152, -8, 0, 64, 32}, {34, 153, -2, 0, 16, 16}, {35, 154, 0, 0, 0, 0}, {36, 155, 0, 0, 0, 0}, {37, 150, 3, 0, 0, 0}, {38, 115, 0, 0, 58, 58}};
    }

    public void drawDecorations() {
        if (decData == null) {
            return;
        }
        int i = 0;
        while (i < decData.length) {
            short type = decData[i][0];
            short x = decData[i][1];
            int y = decData[i][2];
            byte trans = (byte)decData[i][3];
            int id = this.getObjIndex(type);
            if (id != -1) {
                short addx = this.objData[id][2];
                short addy = this.objData[id][3];
                short img = this.objData[id][1];
                int dl = 0;
                if (id == 15) {
                    dl = -1;
                }
                int drawLevel = y;
                switch (dl) {
                    case -1: {
                        drawLevel = 20;
                        break;
                    }
                    case 0: {
                        drawLevel = (short)(y + 30 - 8);
                        break;
                    }
                    case 1: {
                        drawLevel = 2000;
                    }
                }
                switch (id) {
                    case 0: 
                    case 3: 
                    case 4: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 27: 
                    case 28: 
                    case 33: 
                    case 35: 
                    case 37: {
                        Tools.addObject(img, x + addx, y + addy, 36, (byte)0, drawLevel);
                        Tools.addObject(img, x + addx + Tools.getImage(img).getWidth(), y + addy, 36, (byte)1, drawLevel);
                        break;
                    }
                    case 18: {
                        Tools.addObject(img, x + addx, y + addy, 36, (byte)0, 9000);
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 36: {
                        Tools.addObject(img, x + addx, y + addy, 36, (byte)0, 20);
                        break;
                    }
                    case 31: {
                        Tools.addObject(img, x + addx, y + addy, 36, (byte)0, drawLevel);
                        Tools.addObject(img, x + Tools.getImage(img).getWidth() - 9, y + addy, 36, (byte)1, drawLevel);
                        break;
                    }
                    case 6: {
                        Tools.addObject(img, x + addx, y + addy, 36, (byte)0, drawLevel);
                        Tools.addObject(img, x + Tools.getImage(img).getWidth() - 3, y + addy, 36, (byte)1, drawLevel);
                        break;
                    }
                    case 9: {
                        Tools.addObject(124, x + addx - 2, y + addy, MyGameCanvas.gameTime % 6 / 2 * 15, 0, 15, 20, 36, trans, drawLevel + 30);
                        break;
                    }
                    case 38: {
                        Tools.addObject(img, x + addx, y + addy, 36, trans, drawLevel);
                        if (MyGameCanvas.gameTime % 8 != GameEngine.nextInt(8)) break;
                        Effect.AddEffectList(x + 25, y - 33, 32, 0, 2000);
                        break;
                    }
                    default: {
                        Tools.addObject(img, x + addx, y + addy, 36, trans, drawLevel);
                    }
                }
            }
            ++i;
        }
    }

    void drawMapArrow() {
        if (this.mapArrow == null) {
            return;
        }
        int i = 0;
        while (i < this.mapArrow.length) {
            short type = this.mapArrow[i][0];
            short x = this.mapArrow[i][1];
            short y = this.mapArrow[i][2];
            short trans = this.mapArrow[i][3];
            int mIndex = MyGameCanvas.gameTime % 4;
            int Jindex = MyGameCanvas.gameTime % 3;
            if (type == 0) {
                switch (trans) {
                    case 0: 
                    case 2: {
                        Tools.addObject(167, x, y, Jindex * 17, 0, 17, 16, 36, trans == 0 ? (byte)0 : 2, trans == 0 ? y + 30 - 8 : 30);
                        break;
                    }
                    case 1: 
                    case 3: {
                        Tools.addObject(166, x, y, Jindex * 16, 0, 16, 17, 36, trans == 3 ? (byte)0 : 1, 30);
                    }
                }
            }
            ++i;
        }
    }

    void initDecorationData(String fName) {
        decData = null;
        this.mapArrow = null;
        decData = engine.readItemData("/data/map" + this.dec + ".bin");
        this.mapArrow = engine.readItemData("/data/ck" + this.mapID + ".bin");
    }

    void initMoveDecorationData(String fileName) {
        moveDecortion = null;
        String txtName = "/data/md_" + this.mapID + ".bin";
        moveDecortion = engine.readItemData(txtName);
    }

    void loadMap() {
        this.loadMap(this.fileName + "b", 0);
        Tools.createImage(this.name[0], 1);
        this.loadMap(this.fileName + "a", 1);
        Tools.createImage(this.name[1], 2);
    }

    public void initMap() {
        this.free();
        if (isBuffer) {
            this.initMapBuff();
        }
        this.initObjData();
        itemData = null;
        decData = null;
        this.adjustX = screenWidth / 2;
        this.adjustY = screenHeight / 2 + 20;
        this.loadMap();
        this.initDecorationData(this.fileName);
        this.initMoveDecorationData(this.fileName);
        this.initHerbs();
    }

    public void drawMapBG(Graphics g) {
        g.setColor(0);
        g.fillRect(setOffX, setOffY, 240, 320);
    }

    public void drawVS() {
        if (!this.isFirst) {
            this.starPos = new short[this.VSNUM][3];
            int i = 0;
            while (i < this.VSNUM) {
                this.starPos[i][0] = (short)(setOffX + GameEngine.nextInt(240));
                this.starPos[i][1] = (short)(setOffY + GameEngine.nextInt(320));
                this.starPos[i][2] = (short)GameEngine.nextInt(4);
                ++i;
            }
            this.isFirst = true;
        } else {
            int i = 0;
            while (i < this.VSNUM) {
                short[] sArray = this.starPos[i];
                sArray[0] = (short)(sArray[0] - 100);
                Tools.addObject(275, (int)this.starPos[i][0], (int)this.starPos[i][1], this.YeLine[this.starPos[i][2]], 36, (byte)0, 2000);
                if (this.starPos[i][0] < setOffX - 100) {
                    this.starPos[i][0] = (short)(setOffX + GameEngine.nextInt(240));
                    this.starPos[i][1] = (short)(setOffY + GameEngine.nextInt(320));
                    this.starPos[i][2] = (short)GameEngine.nextInt(4);
                }
                ++i;
            }
        }
    }

    void drawCG() {
        int CGImgIndex = 17;
        switch (CGId) {
            case 0: {
                CGImgIndex = 17;
                break;
            }
            case 1: {
                CGImgIndex = 18;
                break;
            }
            case 2: {
                CGImgIndex = 19;
                break;
            }
            case 5: {
                CGImgIndex = 22;
            }
        }
        engine.drawColorScreenBG(0, 2000);
        if (CGId != -1) {
            if (CGId == 3) {
                short[][] addX = new short[][]{{10, (short)(screenWidth - 108)}, {40, (short)(screenWidth - 138)}, {(short)(screenWidth / 2 - 49), (short)(screenWidth / 2 - 49)}, {30, (short)(screenWidth - 128)}, {10, (short)(screenWidth - 108)}};
                Tools.addObject(21, setOffX, setOffY + 75, 20, (byte)0, 2000);
                Tools.addObject(20, setOffX + addX[index / 2][0], setOffY + 125, 0, index / 2 != 0 && index / 2 != 4 ? 51 : 0, 98, 50, 20, (byte)0, 2000);
                Tools.addObject(20, setOffX + addX[index / 2][1], setOffY + 125, 0, index / 2 != 0 && index / 2 != 4 ? 51 : 0, 98, 50, 20, (byte)0, 2000);
                indexTime = (short)(indexTime + 1);
                if (indexTime > 30 && (index = (byte)(index + 1)) > 8) {
                    index = (byte)8;
                }
            } else if (CGId == 4) {
                if (index <= 20) {
                    this.drawVS();
                    if (index >= 10) {
                        Tools.addObject(106, setOffX + (index - 10) * 24 - 100, setOffY + screenHeight, 36, (byte)0, 2000);
                        Tools.addObject(100, setOffX + screenWidth - (index - 9) * 24, setOffY + 160, 36, (byte)0, 2000);
                    }
                } else if (index <= 40) {
                    Tools.addObject(106, setOffX + 140, setOffY + screenHeight, 36, (byte)0, 2000);
                    Tools.addObject(100, setOffX - 24, setOffY + 160, 36, (byte)0, 2000);
                    if (index <= 30 && index > 25) {
                        Tools.addObject(274, setOffX + 32, setOffY + 222, 36, (byte)0, 2000);
                    } else if (index <= 40 && index > 30) {
                        if (index > 35) {
                            Tools.addObject(276, setOffX + 42, setOffY + 198, 36, (byte)0, 2000);
                        }
                        Tools.addObject(273, setOffX + 80, setOffY + 190, 36, (byte)0, 2000);
                    }
                }
                if ((index = (byte)(index + 1)) > 40) {
                    index = (byte)40;
                }
            } else {
                Tools.addObject(CGImgIndex, setOffX, setOffY + (CGImgIndex == 19 ? 45 : 12), 20, (byte)0, 2000);
            }
        }
    }

    public void setMap(Graphics g) {
        if (mapData != null) {
            if (isShowCG) {
                this.drawCG();
            } else {
                if (isBuffer) {
                    this.drawMap(g, setOffX, setOffY);
                } else {
                    this.setTile(g);
                }
                if (isMoto) {
                    Tools.addObject((byte)1, setOffX, setOffY + screenWidth, screenWidth, 60, true, 20, 0, 1999);
                }
                this.drawMapFG();
                this.drawMapArrow();
            }
        }
    }

    void drawWorld() {
        short[][] xAndY = new short[][]{{96, 304}, {272, 320}, {240, 256}, {112, 240}, {176, 192}, {272, 192}, {128, 144}, {192, 96}, {256, 80}, {272, 128}, {16, 208}, {64, 80}, {48, 144}};
        String[] name = new String[]{"\u674f\u82b1\u6751", "\u9b3c\u5c71", "\u77f3\u9f13\u9053", "\u82cf\u6c0f\u9556\u5c40", "\u91ce\u732a\u6797", "\u843d\u9a6c\u5761", "\u6c5f\u5357\u5c0f\u9547", "\u8881\u5bb6", "\u76df\u4e3b\u5b85\u90b8", "\u6bd2\u96fe\u6797", "\u4e0a\u53e4\u7687\u9675", "\u85cf\u5b9d\u6d1e", "\u5c06\u519b\u5c71"};
        if (this.mapID == 75) {
            Tools.addObject(277, 0, 0, 20, (byte)0, 29);
            int x = GameEngine.sprite[GameEngine.spriteIndex].x;
            int y = GameEngine.sprite[GameEngine.spriteIndex].y;
            int i = 0;
            while (i < xAndY.length) {
                if (Tools.hit(x, y, 16, 16, xAndY[i][0], xAndY[i][1], 32, 32) && isShowName) {
                    this.drawWorldName(setOffX, setOffY, name[i]);
                }
                ++i;
            }
            if (GameEngine.sprite[GameEngine.spriteIndex].nextStates == -2) {
                isShowName = true;
                this.areaIndex = 0;
            }
        }
    }

    void drawWorldName(int x, int y, String str) {
        byte[] areaNameY = new byte[]{-30, -24, -20, -16, -12, -8, -4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -4, -8, -12, -16, -20, -24, -30};
        GameEngine.canvas.drawBar((short)264, GameEngine.canvas.bar1Data, x + (screenWidth - 176) / 2 + 43, y + 2 + areaNameY[this.areaIndex], 90, 24, 15062383, 9999, false);
        Tools.addObject((byte)4, str, x + screenWidth / 2, y + 15 + areaNameY[this.areaIndex], 33, 7208956, 9999);
        this.areaIndex = (byte)(this.areaIndex + 1);
        if (this.areaIndex >= areaNameY.length) {
            this.areaIndex = 0;
            isShowName = false;
        }
    }

    public void drawMapFG() {
        block5: {
            block4: {
                this.drawDecorations();
                this.drawWorld();
                this.drawMoveDecoration();
                this.drawHerbs();
                this.drawMapArrow();
                this.drawChangeFire();
                if (GameEngine.gameRank == 24) break block4;
                if (GameEngine.gameRank != 56) break block5;
            }
            this.drawSpecFace();
        }
        if (MyGameCanvas.isJump) {
            GameEngine.canvas.drawJump();
        }
    }

    public int getSetOffX(int x) {
        short dx = (short)(x - this.adjustX);
        dx = (short)Math.max(dx, 0);
        dx = (short)Math.min(dx, mapSize[0] * tileWidth - screenWidth);
        return dx;
    }

    public int getSetOffY(int y) {
        short dy = (short)(y - this.adjustY);
        dy = (short)Math.max(dy, 0);
        dy = (short)Math.min(dy, mapSize[1] * tileHight - screenHeight);
        return dy;
    }

    public void AdjustSrceen(int x, int y) {
        setOffX = Math.abs(x - setOffX - this.adjustX) > SCEEN_MOVE ? (x - setOffX - this.adjustX >= SCEEN_MOVE ? (setOffX += SCEEN_MOVE) : (setOffX -= SCEEN_MOVE)) : (int)((short)(x - this.adjustX));
        setOffX = (short)Math.max(setOffX, 0);
        setOffX = (short)Math.min(setOffX, mapSize[0] * tileWidth - screenWidth);
        setOffY = Math.abs(y - setOffY - this.adjustY) > SCEEN_MOVE ? (y - setOffY - this.adjustY >= SCEEN_MOVE ? (setOffY += SCEEN_MOVE) : (setOffY -= SCEEN_MOVE)) : (int)((short)(y - this.adjustY));
        setOffY = (short)Math.max(setOffY, 0);
        setOffY = (short)Math.min(setOffY, mapSize[1] * tileHight - screenHeight);
        if (isMoveScreen && this.checkMoveScreen(x, y)) {
            isMoveScreen = false;
            this.finish();
        }
    }

    public boolean checkMoveScreen(int x, int y) {
        int range = 6;
        short dx = (short)(x - this.adjustX);
        dx = (short)Math.max(dx, 0);
        dx = (short)Math.min(dx, mapSize[0] * tileWidth - screenWidth);
        short dy = (short)(y - this.adjustY);
        dy = (short)Math.max(dy, 0);
        dy = (short)Math.min(dy, mapSize[1] * tileHight - screenHeight);
        return Math.abs(setOffX - dx) < range && Math.abs(setOffY - dy) < range;
    }

    public void sender(Event event, String command) {
        this.event = event;
        this.command = command;
    }

    public void finish() {
        if (this.event != null) {
            this.event.setEnd(this.command);
            this.event = null;
            this.command = null;
        }
    }

    public boolean canRun(int x, int y) {
        if (mapData == null) {
            return true;
        }
        if (x < 0 || x > mapSize[0] * tileHight || y < 0 || y > mapSize[1] * tileHight) {
            return false;
        }
        if (GameMap.inMapData(x, y, 1) == -1) {
            return false;
        }
        if (Tools.getProperties(this.tileProperties[1][GameMap.getLow(GameMap.inMapData(x, y, 1))], (byte)15)) {
            if (GameMap.inMapData(x, y, 0) == -1) {
                return true;
            }
            if (Tools.getProperties(this.tileProperties[0][GameMap.getLow(GameMap.inMapData(x, y, 0))], (byte)15)) {
                return true;
            }
        }
        return false;
    }

    public static byte inMapData(int x, int y, int index) {
        int n = x / tileWidth * mapSize[1] + y / tileHight;
        if (n < 0 || n >= mapData[index].length) {
            return -1;
        }
        return mapData[index][n];
    }

    public static int getTrans(int v) {
        return v >> 6 & 3;
    }

    public static int get2nd(int v) {
        return v << 1 >> 7 & 1;
    }

    public static int getLow(int v) {
        return v & 0x3F;
    }

    static int bToi(byte byte0) {
        int i = byte0;
        if (byte0 < 0) {
            i += 256;
        }
        return i;
    }

    public void initBattleMap() {
        switch (Battle.imgbattleBgImgs[this.battleBg]) {
            case 0: {
                Tools.getImage(0);
                break;
            }
            case 2: {
                Tools.getImage(2);
            }
        }
    }

    public static void drawFullScreenBG(int imgIndex, int height, int speed, int level) {
        int imgW = Tools.getImage(imgIndex).getWidth();
        int imgH = Tools.getImage(imgIndex).getHeight();
        int times = screenWidth / imgW + 2;
        int startPos = setOffX * speed * 10 / 1000;
        while (setOffX - startPos >= imgW) {
            startPos += imgW;
        }
        int i = 0;
        while (i < times) {
            Tools.addObject(imgIndex, startPos + i * imgW, height, 0, 0, imgW, imgH, 20, (byte)0, level);
            ++i;
        }
    }

    int getObjIndex(int id) {
        int i = 0;
        while (i < this.objData.length) {
            if (this.objData[i][0] == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int hitDecorations(int x, int y) {
        if (decData == null) {
            return -1;
        }
        int i = 0;
        while (i < decData.length) {
            short id = decData[i][0];
            int objIndex = this.getObjIndex(id);
            if (objIndex != -1) {
                short w = this.objData[objIndex][4];
                short h = this.objData[objIndex][5];
                if (w != 0 && h != 0 && x >= decData[i][1] && x < decData[i][1] + w && y < decData[i][2] && y > decData[i][2] - h) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static int getIndex(int v) {
        return v & 0x3F;
    }

    public int getIndex(int x, int y, int index) {
        return GameMap.getIndex(GameMap.inMapData(x, y, index));
    }

    public void loadMap(String file, int index) {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(Tools.getMapData(file)));
        try {
            GameMap.mapSize[0] = Tools.bToi(in.readByte());
            GameMap.mapSize[1] = Tools.bToi(in.readByte());
            tileWidth = in.readByte();
            tileHight = in.readByte();
            int size = mapSize[0] * mapSize[1];
            GameMap.mapData[index] = new byte[size];
            in.read(mapData[index]);
            int len = in.readShort();
            this.name[index] = new String[len];
            this.tileProperties[index] = new short[len];
            int i = 0;
            while (i < len) {
                byte nameLen = in.readByte();
                byte[] names = new byte[nameLen];
                in.read(names);
                this.name[index][i] = new String(names);
                this.tileProperties[index][i] = in.readShort();
                ++i;
            }
        }
        catch (Exception ex) {
            System.out.println("map error:" + index);
            ex.printStackTrace();
        }
    }

    public void setTile(Graphics g) {
        int n = setOffX / tileWidth * mapSize[1] + setOffY / tileHight;
        int nw = screenWidth / tileWidth + 2;
        int nh = screenHeight / tileHight + 2;
        int j = 0;
        while (j < nw) {
            int s;
            int i = s = n + j * mapSize[1];
            while (i < s + nh) {
                if (i < mapData[1].length && i >= 0) {
                    int dataTemp = GameMap.getLow(mapData[1][i]);
                    int x = i / mapSize[1] * tileHight;
                    int y = i % mapSize[1] * tileWidth;
                    if (mapData[1][i] == -1) {
                        g.setColor(0);
                        g.fillRect(x - setOffX, y - setOffY, (int)tileWidth, (int)tileHight);
                    } else {
                        Tools.drawClipImage(g, 600 + dataTemp, x - setOffX, y - setOffY, 0, 0, tileWidth, tileHight, 20, GameMap.getTrans(mapData[1][i]));
                    }
                }
                ++i;
            }
            int i2 = s;
            while (i2 < s + nh) {
                if (i2 < mapData[0].length && i2 >= 0 && mapData[0][i2] != -1) {
                    int dataTemp = GameMap.getLow(mapData[0][i2]);
                    int x = i2 / mapSize[1] * tileHight;
                    int y = i2 % mapSize[1] * tileWidth;
                    Tools.drawClipImage(g, 300 + dataTemp, x - setOffX, y - setOffY, 0, 0, tileWidth, tileHight, 20, GameMap.getTrans(mapData[0][i2]));
                }
                ++i2;
            }
            ++j;
        }
    }

    void initHerbs() {
        herbsData = null;
        String txtName = "/data/yaoc_" + this.mapID + ".bin";
        herbsData = engine.readItemData(txtName);
    }

    void drawHerbs() {
        if (herbsData == null) {
            return;
        }
        int i = 0;
        while (i < herbsData.length) {
            short x = herbsData[i][1];
            short y = herbsData[i][2];
            byte dis = (byte)herbsData[i][3];
            if (dis != 1) {
                Tools.addObject(279, x - 4, y, MyGameCanvas.gameTime % 8 / 4 * 23, 0, 23, 20, 36, (byte)0, y + 30);
            }
            ++i;
        }
        byte id = this.checkRoleHitHerbs();
        if (id != -1) {
            Tools.addObject(199, herbsData[id][1], herbsData[id][2] - 25, MyGameCanvas.gameTime % 4 / 2 * 17, 0, 17, 16, 36, (byte)0, 2000);
        }
    }

    byte checkRoleHitHerbs() {
        if (GameEngine.sprite[GameEngine.spriteIndex].curStates != -1) {
            return -1;
        }
        switch (GameEngine.sprite[GameEngine.spriteIndex].dir) {
            case 0: {
                return this.hitHerbs(GameEngine.sprite[GameEngine.spriteIndex].x + 8, GameEngine.sprite[GameEngine.spriteIndex].y - 24);
            }
            case 1: {
                return this.hitHerbs(GameEngine.sprite[GameEngine.spriteIndex].x + 24, GameEngine.sprite[GameEngine.spriteIndex].y - 8);
            }
            case 2: {
                return this.hitHerbs(GameEngine.sprite[GameEngine.spriteIndex].x + 8, GameEngine.sprite[GameEngine.spriteIndex].y + 8);
            }
            case 3: {
                return this.hitHerbs(GameEngine.sprite[GameEngine.spriteIndex].x - 8, GameEngine.sprite[GameEngine.spriteIndex].y - 8);
            }
        }
        return -1;
    }

    void drawGather() {
        Tools.addObject(16, setOffX + (screenWidth - 94) / 2, setOffY + (screenHeight - 11) / 2, 0, 0, 94, 11, 36, (byte)0, 9000);
        Tools.addObject(16, setOffX + (screenWidth - 94) / 2 + 7, setOffY + (screenHeight - 11) / 2 - 4, 7, 11, this.gatherIndex, 3, 36, (byte)0, 9000);
        this.gatherIndex = (byte)(this.gatherIndex + 2);
        if (this.gatherIndex >= 82) {
            this.getMat();
        }
    }

    void getMat() {
        byte id = this.checkRoleHitHerbs();
        GameMap.herbsData[id][3] = 1;
        byte type = this.herbs[GameEngine.nextInt(this.herbs.length - 1)];
        if (this.mapID == 5) {
            if (id <= 2) {
                byte[] dat = new byte[]{18, 19, 20, 21, 22, 23, 32, 33};
                type = dat[GameEngine.nextInt(dat.length - 1)];
            } else if (id <= 7) {
                byte[] dat = new byte[]{17, 18, 20, 20, 21, 21, 23, 29, 30, 31};
                type = dat[GameEngine.nextInt(dat.length - 1)];
            } else {
                byte[] dat = new byte[]{0, 0, 0, 1, 1, 1, 4, 4, 6, 6, 5, 5, 8, 14, 14, 27, 28};
                type = dat[GameEngine.nextInt(dat.length - 1)];
            }
        }
        GameEngine.getMat(type, 1);
    }

    byte hitHerbs(int x, int y) {
        if (herbsData == null) {
            return -1;
        }
        int i = 0;
        while (i < herbsData.length) {
            short type = herbsData[i][0];
            short sx = herbsData[i][1];
            short sy = herbsData[i][2];
            byte dis = (byte)herbsData[i][3];
            if (dis != 1) {
                int w = 16;
                int h = 16;
                if (x >= sx && x < sx + w && y < sy && y > sy - h) {
                    return (byte)i;
                }
            }
            ++i;
        }
        return -1;
    }

    void drawMoveDecoration() {
        if (moveDecortion == null) {
            return;
        }
        int i = 0;
        while (i < moveDecortion.length) {
            short x = moveDecortion[i][1];
            short y = moveDecortion[i][2];
            byte trans = (byte)moveDecortion[i][3];
            switch (moveDecortion[i][0]) {
                case 0: {
                    if (moveDecortion[i][4] == 0) {
                        Tools.addObject(130, x + 2, y, 36, trans, y + 30);
                        break;
                    }
                    Tools.addObject(131, x + 2, y, 36, (byte)0, 30);
                    break;
                }
                case 2: {
                    if (moveDecortion[i][4] != 1) break;
                    Tools.addObject(137, x, y, 36, (byte)0, 20);
                }
            }
            ++i;
        }
    }

    byte hitMoveDectoration(int x, int y) {
        if (moveDecortion == null) {
            return -1;
        }
        int i = 0;
        while (i < moveDecortion.length) {
            short type = moveDecortion[i][0];
            short sx = moveDecortion[i][1];
            short sy = moveDecortion[i][2];
            short st = moveDecortion[i][4];
            short w = 0;
            short h = 0;
            switch (type) {
                case 0: 
                case 1: {
                    if (st != 1) break;
                    w = 0;
                    h = 0;
                    break;
                }
                case 2: {
                    w = 0;
                    h = 0;
                }
            }
            if (w != 0 && h != 0 && x >= sx && x < sx + w && y < sy && y > sy - h) {
                return (byte)i;
            }
            ++i;
        }
        return -1;
    }

    private void drawChangeFire() {
        if (spriteId2 == -1) {
            return;
        }
        GameSprite s = GameEngine.sprite[spriteId2];
        if (MyGameCanvas.gameTime % 6 == 0) {
            Effect.AddEffectList(s.x + 6, s.y - 16, 24, 0, s.y);
        }
    }

    void drawSpecFace() {
        if (spriteId == -1) {
            return;
        }
        GameSprite s = GameEngine.sprite[spriteId];
        if (MyGameCanvas.gameTime % 60 < 40) {
            Tools.addObject(24, s.x - 16, s.y - 40, 0, 0, 40, 20, 36, (byte)0, 2000);
            Tools.addObject(24, s.x - 16, s.y - 46, 0, faceType == 0 ? 20 : 32, 40, 12, 36, (byte)0, 2000);
        }
    }

    void initMapBuff() {
        this.mapBuff = null;
        this.isBuffNull = true;
        tileWidth = (byte)16;
        tileHight = (byte)16;
        this.buffWidth = screenWidth - screenWidth % tileWidth + tileWidth * 2;
        this.buffHeight = screenHeight - screenHeight % tileHight + tileHight * 2;
        this.mapBuff = Image.createImage((int)this.buffWidth, (int)this.buffHeight);
    }

    void drawBuff(Graphics g, int clipX, int clipY, int clipW, int clipH, int x, int y) {
        g.setClip(x, y, clipW, clipH);
        g.drawImage(this.mapBuff, x - clipX, y - clipY, 20);
        g.setClip(0, 0, screenWidth, screenHeight);
    }

    void drawMap(Graphics g, int setOffX, int setOffY) {
        Graphics g1 = this.mapBuff.getGraphics();
        int startX = setOffX / tileWidth;
        int endX = startX + screenWidth / tileWidth + 1;
        int startY = setOffY / tileHight;
        int endY = startY + screenHeight / tileHight + 1;
        if (this.isBuffNull) {
            this.isBuffNull = false;
            this.updateBuff(g1, startX, startY, endX, endY);
            this.lastStartX = startX;
            this.lastStartY = startY;
            this.lastEndX = endX;
            this.lastEndY = endY;
        }
        if (this.lastStartX != startX) {
            int tmp2;
            int tmp1;
            if (this.lastStartX < startX) {
                tmp1 = this.lastEndX + 1;
                tmp2 = endX;
            } else {
                tmp1 = startX;
                tmp2 = this.lastStartX - 1;
            }
            this.updateBuff(g1, tmp1, startY, tmp2, endY);
            this.lastStartX = startX;
            this.lastEndX = endX;
        }
        if (this.lastStartY != startY) {
            int tmp4;
            int tmp3;
            if (this.lastStartY < startY) {
                tmp3 = this.lastEndY + 1;
                tmp4 = endY;
            } else {
                tmp3 = startY;
                tmp4 = this.lastStartY - 1;
            }
            this.updateBuff(g1, startX, tmp3, endX, tmp4);
            this.lastStartY = startY;
            this.lastEndY = endY;
        }
        int t1 = setOffX % this.buffWidth;
        int t2 = setOffY % this.buffHeight;
        int t3 = (setOffX + screenWidth) % this.buffWidth;
        int t4 = (setOffY + screenHeight) % this.buffHeight;
        if (t3 > t1) {
            if (t4 > t2) {
                this.drawBuff(g, t1, t2, screenWidth, screenHeight, 0, 0);
            } else {
                this.drawBuff(g, t1, t2, screenWidth, screenHeight - t4, 0, 0);
                this.drawBuff(g, t1, 0, screenWidth, t4, 0, screenHeight - t4);
            }
        } else if (t4 > t2) {
            this.drawBuff(g, t1, t2, screenWidth - t3, screenHeight, 0, 0);
            this.drawBuff(g, 0, t2, t3, screenHeight, screenWidth - t3, 0);
        } else {
            this.drawBuff(g, t1, t2, screenWidth - t3, screenHeight - t4, 0, 0);
            this.drawBuff(g, t1, 0, screenWidth - t3, t4, 0, screenHeight - t4);
            this.drawBuff(g, 0, t2, t3, screenHeight - t4, screenWidth - t3, 0);
            this.drawBuff(g, 0, 0, t3, t4, screenWidth - t3, screenHeight - t4);
        }
    }

    void updateBuff(Graphics g, int startX, int startY, int endX, int endY) {
        int y = startY * tileHight % this.buffHeight;
        int i = startY;
        while (i <= endY) {
            int x = startX * tileWidth % this.buffWidth;
            int j = startX;
            while (j <= endX) {
                byte mapIndex2 = GameMap.inMapData(j * tileWidth, i * tileHight, 1);
                int dataTemp2 = GameMap.getIndex(mapIndex2);
                int transData2 = GameMap.getTrans(mapIndex2);
                if ((byte)mapIndex2 != -1) {
                    g.setClip(x, y, (int)tileWidth, (int)tileHight);
                    Tools.drawClipImage(g, 600 + dataTemp2, x, y, 0, 0, tileWidth, tileHight, 20, transData2);
                    g.setClip(setOffX, setOffY, 240, 350);
                } else {
                    g.setClip(x, y, (int)tileWidth, (int)tileHight);
                    g.setColor(0);
                    g.fillRect(x, y, (int)tileWidth, (int)tileHight);
                    g.setClip(setOffX, setOffY, 240, 350);
                }
                byte mapIndex1 = GameMap.inMapData(j * tileWidth, i * tileHight, 0);
                int dataTemp1 = GameMap.getIndex(mapIndex1);
                int transData = GameMap.getTrans(mapIndex1);
                if ((byte)mapIndex1 != -1) {
                    g.setClip(x, y, (int)tileWidth, (int)tileHight);
                    Tools.drawClipImage(g, 300 + dataTemp1, x, y, 0, 0, tileWidth, tileHight, 20, transData);
                    g.setClip(setOffX, setOffY, 240, 350);
                }
                if ((x += tileWidth) >= this.buffWidth) {
                    x -= this.buffWidth;
                }
                ++j;
            }
            if ((y += tileHight) >= this.buffHeight) {
                y -= this.buffHeight;
            }
            ++i;
        }
    }

    static {
        mapSize = new int[2];
        mapData = new byte[2][];
        isBuffer = false;
        isTile = false;
        isMoto = false;
        isZhong = false;
        gameRankType = 0;
        isShowCG = false;
        index = 0;
        indexTime = 0;
        isBlack = false;
        SCEEN_MOVE = (byte)10;
        spriteId2 = (byte)-1;
        spriteId = (byte)-1;
        faceType = (byte)-1;
    }
}

