/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Background {
    public byte type;
    public int color;
    public int tileW;
    public int tileH;
    public int columns;
    public int rows;
    public int layerCount;
    public int viewW;
    public int viewH;
    public int viewX;
    public int viewY;
    public int frameCount = 0;
    public Layer[] layers;
    public Layer phylayer;
    public boolean updateBg = true;
    public boolean isUseBuffer = false;
    private static Image bufImage;
    private static Graphics bufG;
    private int bufImageWidth;
    private int bufImageHeight;
    private int prevX0;
    private int prevY0;
    private int prevX1;
    private int prevY1;

    private Background(int w, int h) {
        this.viewW = w;
        this.viewH = h;
    }

    public static Background loadBackground(int level, int w, int h) {
        Background bg = new Background(w, h);
        try {
            String bgFile = "/b0";
            DataInputStream dis = null;
            UI.drawLoading(71);
            dis = new DataInputStream(bgFile.getClass().getResourceAsStream(bgFile));
            UI.drawLoading(72);
            int count = dis.readByte();
            UI.drawLoading(73);
            int[] tmp_pfBlockLengths = new int[count];
            for (int i = 0; i < count; ++i) {
                tmp_pfBlockLengths[i] = dis.readShort();
            }
            if (level > 0) {
                int temp_p = 0;
                for (int i = 0; i < level; ++i) {
                    temp_p += tmp_pfBlockLengths[i];
                }
                dis.skip(temp_p);
            }
            bg.type = dis.readByte();
            bg.color = dis.readInt();
            bg.tileW = dis.readByte();
            bg.tileH = dis.readByte();
            bg.columns = dis.readByte();
            bg.rows = dis.readByte();
            bg.layerCount = dis.readShort();
            bg.layers = new Layer[bg.layerCount];
            for (int i = 0; i < bg.layerCount; ++i) {
                bg.layers[i] = new Layer(bg);
                bg.layers[i].load(dis);
                if (bg.layers[i].type != 3) continue;
                bg.phylayer = bg.layers[i];
            }
            dis.close();
            dis = null;
            UI.drawLoading(73);
        }
        catch (Exception e) {
            World.showErrorMessage("loadBackground", e);
        }
        return bg;
    }

    public void initResource() {
        if (this.isUseBuffer) {
            this.updateBg = true;
            this.bufImageWidth = (this.viewW + (this.tileW << 1) - 1) / this.tileW * this.tileW;
            this.bufImageHeight = (this.viewH + (this.tileH << 1) - 1) / this.tileH * this.tileH;
            if (bufImage == null) {
                bufImage = Image.createImage((int)this.bufImageWidth, (int)this.bufImageHeight);
                if (bufG == null) {
                    bufG = bufImage.getGraphics();
                }
            }
        }
        for (int i = 0; i < this.layerCount; ++i) {
            this.layers[i].initResource();
        }
    }

    public void releaseResource() {
        bufG = null;
        bufImage = null;
        for (int i = 0; i < this.layerCount; ++i) {
            this.layers[i].releaseResource();
        }
    }

    public void dispose() {
        for (int i = 0; i < this.layerCount; ++i) {
            this.layers[i].dispose();
            this.layers[i] = null;
        }
        this.layers = null;
        this.phylayer = null;
        bufG = null;
        bufImage = null;
    }

    public void tick() {
        for (int i = 0; i < this.layerCount; ++i) {
            this.layers[i].tick();
        }
        ++this.frameCount;
    }

    public void setViewPort(int viewX, int viewY) {
        if (Math.abs(viewX - this.viewX) > this.tileW) {
            this.updateBg = true;
        }
        if (Math.abs(viewY - this.viewY) > this.tileH) {
            this.updateBg = true;
        }
        this.viewX = viewX;
        this.viewY = viewY;
    }

    public void draw(Graphics g, int layerIndex) {
        if (layerIndex < 0 || layerIndex >= this.layerCount) {
            return;
        }
        this.layers[layerIndex].drawLayer(g, this.viewX, this.viewY);
    }

    public void draw(Graphics g, int startLayerIndex, int endLayerIndex) {
        if (endLayerIndex < startLayerIndex) {
            int tempIndex = startLayerIndex;
            startLayerIndex = endLayerIndex;
            endLayerIndex = tempIndex;
        }
        if (startLayerIndex >= this.layerCount) {
            return;
        }
        if (endLayerIndex >= this.layerCount) {
            endLayerIndex = this.layerCount - 1;
        }
        for (int i = startLayerIndex; i <= endLayerIndex; ++i) {
            this.layers[i].drawLayer(g, this.viewX, this.viewY);
        }
    }

    public void drawBuffer(Graphics g, int startLayerIndex, int endLayerIndex) {
        if (endLayerIndex < startLayerIndex) {
            int tempIndex = startLayerIndex;
            startLayerIndex = endLayerIndex;
            endLayerIndex = tempIndex;
        }
        if (startLayerIndex >= this.layerCount || !this.isUseBuffer) {
            return;
        }
        if (endLayerIndex >= this.layerCount) {
            endLayerIndex = this.layerCount - 1;
        }
        this.drawBgFast(g, startLayerIndex, endLayerIndex, this.viewX, this.viewY);
    }

    private void drawBgFast(Graphics g, int startIndex, int endIndex, int camX, int camY) {
        int currX0 = camX / this.tileW;
        int currY0 = camY / this.tileH;
        int currX1 = (camX + this.viewW) / this.tileW;
        int currY1 = (camY + this.viewH) / this.tileH;
        if (this.updateBg) {
            this.updateBg = false;
            this.drawBgPart(startIndex, endIndex, currX0, currY0, currX1, currY1);
            this.prevX0 = currX0;
            this.prevY0 = currY0;
            this.prevX1 = currX1;
            this.prevY1 = currY1;
        } else {
            int end;
            int start;
            if (this.prevX0 != currX0 || this.prevX1 != currX1) {
                if (this.prevX0 < currX0 || this.prevX1 < currX1) {
                    start = this.prevX1 + 1;
                    end = currX1;
                } else {
                    start = currX0;
                    end = this.prevX0 - 1;
                }
                this.drawBgPart(startIndex, endIndex, start, currY0, end, currY1);
                this.prevX0 = currX0;
                this.prevX1 = currX1;
            }
            if (this.prevY0 != currY0 || this.prevY1 != currY1) {
                if (this.prevY0 < currY0 || this.prevY1 < currY1) {
                    start = this.prevY1 + 1;
                    end = currY1;
                } else {
                    start = currY0;
                    end = this.prevY0 - 1;
                }
                this.drawBgPart(startIndex, endIndex, currX0, start, currX1, end);
                this.prevY0 = currY0;
                this.prevY1 = currY1;
            }
        }
        int modX0 = camX % this.bufImageWidth;
        int modY0 = camY % this.bufImageHeight;
        int modX1 = (camX + this.viewW) % this.bufImageWidth;
        int modY1 = (camY + this.viewH) % this.bufImageHeight;
        g.setClip(0, 0, this.viewW, this.viewH);
        g.clipRect(0, 0, this.viewW, this.viewH);
        if (modX1 > modX0) {
            if (modY1 > modY0) {
                this.copyFromBgImage(g, modX0, modY0, this.viewW, this.viewH, 0, 0);
            } else {
                this.copyFromBgImage(g, modX0, modY0, this.viewW, this.viewH - modY1, 0, 0);
                this.copyFromBgImage(g, modX0, 0, this.viewW, modY1, 0, this.viewH - modY1);
            }
        } else if (modY1 > modY0) {
            this.copyFromBgImage(g, modX0, modY0, this.viewW - modX1, this.viewH, 0, 0);
            this.copyFromBgImage(g, 0, modY0, modX1, this.viewH, this.viewW - modX1, 0);
        } else {
            this.copyFromBgImage(g, modX0, modY0, this.viewW - modX1, this.viewH - modY1, 0, 0);
            this.copyFromBgImage(g, modX0, 0, this.viewW - modX1, modY1, 0, this.viewH - modY1);
            this.copyFromBgImage(g, 0, modY0, modX1, this.viewH - modY1, this.viewW - modX1, 0);
            this.copyFromBgImage(g, 0, 0, modX1, modY1, this.viewW - modX1, this.viewH - modY1);
        }
    }

    private void copyFromBgImage(Graphics g, int srcX, int srcY, int width, int height, int destX, int destY) {
        bufG.setClip(destX, destY, width, height);
        bufG.clipRect(destX, destY, width, height);
        g.drawImage(bufImage, destX - srcX, destY - srcY, 0);
    }

    private void drawBgPart(int startIndex, int endIndex, int tileX0, int tileY0, int tileX1, int tileY1) {
        int originDestX = tileX0 * this.tileW % this.bufImageWidth;
        for (int k = startIndex; k <= endIndex; ++k) {
            if (this.layers[k].type != 2) continue;
            for (int j = tileY0; j <= tileY1; ++j) {
                if (j >= this.rows) continue;
                int destX = originDestX;
                int destY = j * this.tileH % this.bufImageHeight;
                if (destY >= this.bufImageHeight) {
                    destY -= this.bufImageHeight;
                }
                for (int i = tileX0; i <= tileX1; ++i) {
                    if (i >= this.columns) continue;
                    short data1 = this.layers[k].data[j * this.columns + i];
                    if (data1 != -1) {
                        int flag = GameCanvas.trans((data1 & 0x4000) != 0, (data1 & 0x2000) != 0);
                        data1 = (short)(data1 & 0xFFF);
                        int tileCountPerLine = this.layers[k].image.getWidth() / this.tileW;
                        int srcX = data1 % tileCountPerLine * this.tileW;
                        int srcY = data1 / tileCountPerLine * this.tileH;
                        bufG.setClip(destX, destY, this.tileW, this.tileH);
                        bufG.clipRect(destX, destY, this.tileW, this.tileH);
                        if (flag == 0) {
                            bufG.drawImage(this.layers[k].image, destX - srcX, destY - srcY, 20);
                        } else {
                            bufG.drawRegion(this.layers[k].image, srcX, srcY, this.tileW, this.tileH, flag, destX, destY, 0);
                        }
                    }
                    if ((destX += this.tileW) < this.bufImageWidth) continue;
                    destX -= this.bufImageWidth;
                }
            }
        }
    }
}

