/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Layer {
    public static final byte TYPE_IMAGECLIP = 0;
    public static final byte TYPE_SCROLLIMAGE = 1;
    public static final byte TYPE_TILEDLAYER = 2;
    public static final byte TYPE_PHYSICALLAYER = 3;
    public static final byte MOVETYPE_NOMOVE = 0;
    public static final byte MOVETYPE_LINE = 1;
    public static final byte MOVETYPE_CIRCLE = 2;
    public static final byte MOVETYPE_PARABOLA = 3;
    public static final byte CYCLETYPE_NOCYCLE = 0;
    public static final byte CYCLETYPE_CYCLE = 1;
    public static final byte CYCLETYPE_REPEAT = 2;
    public static final byte IC_PARAM_COUNT = 6;
    public static final byte IC_PARAM_FLAG = 0;
    public static final byte IC_PARAM_MOVETYPE = 1;
    public static final byte IC_PARAM_MOVEPARAM1 = 2;
    public static final byte IC_PARAM_MOVEPARAM2 = 3;
    public static final byte IC_PARAM_MOVEPARAM3 = 4;
    public static final byte IC_PARAM_MOVEPARAM4 = 5;
    public static final byte SI_PARAM_COUNT = 2;
    public static final byte SI_PARAM_FLAG = 0;
    public static final byte SI_PARAM_SPEED = 1;
    public Background bg;
    public byte type;
    public String imageFile;
    public Image image;
    public boolean hasPalette = false;
    public int paletteStart;
    public byte[] paletteData;
    public int x;
    public int y;
    public int tempX;
    public int tempY;
    public int moveFrame;
    public boolean isLineGo = true;
    public int flashInterval;
    public int flashDuration;
    public short[] data;
    public short[] data0;
    public short[] data1;
    public byte[] phydata;
    public byte[] bydata;

    public Layer(Background bg) {
        this.bg = bg;
    }

    public void load(DataInputStream dis) throws Exception {
        this.type = dis.readByte();
        this.imageFile = dis.readUTF();
        if (this.imageFile.startsWith("/b_1")) {
            UI.bat_bg = 1;
        } else if (this.imageFile.startsWith("/b_2")) {
            UI.bat_bg = 1;
        } else if (this.imageFile.startsWith("/b_3")) {
            UI.bat_bg = 3;
        } else if (this.imageFile.startsWith("/b_0")) {
            UI.bat_bg = 2;
        } else if (this.imageFile.startsWith("/b_5")) {
            UI.bat_bg = 2;
        } else if (this.imageFile.startsWith("/b_4")) {
            UI.bat_bg = 2;
        }
        this.hasPalette = dis.readBoolean();
        short changelength = 0;
        if (this.hasPalette) {
            changelength = dis.readShort();
        }
        switch (this.type) {
            case 0: 
            case 1: {
                this.x = dis.readShort();
                this.y = dis.readShort();
                this.tempX = this.x;
                this.tempY = this.y;
                this.flashInterval = dis.readShort();
                this.flashDuration = dis.readShort();
                int parameterCount = this.type == 0 ? 6 : 2;
                this.data = new short[parameterCount];
                for (int i = 0; i < parameterCount; ++i) {
                    this.data[i] = dis.readShort();
                }
                break;
            }
            case 2: {
                if (this.hasPalette) {
                    this.data = new short[this.bg.columns * this.bg.rows];
                    if (changelength != 0) {
                        short[] s_data = new short[changelength];
                        int s_tmp = 0;
                        this.bydata = changelength % 8 == 0 ? new byte[changelength + changelength / 8] : new byte[changelength + changelength / 8 + 1];
                        for (int i = 0; i < this.bydata.length; ++i) {
                            if (i == 0 || (i + 1) % 9 != 0 && this.bydata.length - 1 != i) {
                                s_data[s_tmp] = dis.readShort();
                                ++s_tmp;
                            }
                            this.bydata[i] = dis.readByte();
                        }
                        this.data = Tools.getDateShort(s_data, this.bydata, this.data.length);
                        break;
                    }
                    this.data = new short[this.bg.columns * this.bg.rows];
                    for (int i = 0; i < this.data.length; ++i) {
                        this.data[i] = -1;
                    }
                    break;
                }
                this.bydata = this.bg.columns * this.bg.rows % 8 == 0 ? new byte[this.bg.columns * this.bg.rows + this.bg.columns * this.bg.rows / 8] : new byte[this.bg.columns * this.bg.rows + this.bg.columns * this.bg.rows / 8 + 1];
                this.data = new short[this.bg.columns * this.bg.rows];
                for (int i = 0; i < this.bydata.length; ++i) {
                    this.bydata[i] = dis.readByte();
                }
                this.data = Tools.getDateShort(this.bydata, this.data.length);
                break;
            }
            case 3: {
                this.phydata = new byte[this.bg.columns * this.bg.rows];
                for (int i = 0; i < this.phydata.length; ++i) {
                    this.phydata[i] = dis.readByte();
                }
                break;
            }
        }
    }

    public void initResource() {
        if (this.type != 3) {
            this.image = World.getSceneImage(this.imageFile);
        }
    }

    public void releaseResource() {
        if (this.hasPalette) {
            World.removeImage(this.imageFile, this.paletteStart, this.paletteData);
        } else {
            World.removeImage(this.imageFile);
        }
        this.image = null;
    }

    public void dispose() {
        World.removeImage(this.imageFile);
        this.imageFile = null;
        this.image = null;
        this.data = null;
        this.phydata = null;
    }

    public void drawLayer(Graphics g, int viewX, int viewY) {
        if (this.flashInterval > 0 && this.flashDuration > 0 && this.bg.frameCount % (this.flashInterval + this.flashDuration) >= this.flashDuration) {
            return;
        }
        if (this.type == 0) {
            this.drawImageClip(g, viewX, viewY);
        } else if (this.type == 1) {
            this.drawScrollImage(g, viewX, viewY);
        } else if (this.type == 2) {
            this.drawTiledLayer(g, viewX, viewY);
        }
    }

    public void drawImageClip(Graphics g, int viewX, int viewY) {
        int startX = this.x - viewX;
        int startY = this.y - viewY;
        boolean isDraw = GameCanvas.collide(this.x, this.y, this.x + this.image.getWidth(), this.y + this.image.getHeight(), viewX, viewY, viewX + this.bg.viewW, viewY + this.bg.viewH);
        if (isDraw) {
            boolean flipY;
            boolean flipX = (this.data[0] & 1) != 0;
            int flag = GameCanvas.trans(flipX, flipY = (this.data[0] & 2) != 0);
            if (flag == 0) {
                g.drawImage(this.image, startX, startY, 0);
            } else {
                g.drawRegion(this.image, 0, 0, this.image.getWidth(), this.image.getHeight(), flag, startX, startY, 0);
            }
        }
    }

    public void drawScrollImage(Graphics g, int viewX, int viewY) {
        block5: {
            int height;
            int width;
            short speed;
            boolean scrollY;
            boolean scrollX;
            block4: {
                scrollX = (this.data[0] & 1) != 0;
                scrollY = (this.data[0] & 2) != 0;
                speed = this.data[1];
                width = this.image.getWidth();
                height = this.image.getHeight();
                if (!scrollX && !scrollY) {
                    this.drawImageClip(g, viewX, viewY);
                    return;
                }
                if (!scrollX) break block4;
                int startY = -((viewY - this.y) % (height * speed / 100));
                for (int startX = -((viewX - this.x) % (width * speed / 100)); startX < this.bg.viewW; startX += width) {
                    g.drawImage(this.image, startX, startY, 0);
                    if (!scrollY) continue;
                    startY += height;
                    while (startY < this.bg.viewH) {
                        g.drawImage(this.image, startX, startY, 0);
                        startY += height;
                    }
                }
                break block5;
            }
            if (scrollX || !scrollY) break block5;
            int startX = -((viewX - this.x) % (width * speed / 100));
            for (int startY = -((viewY - this.y) % (height * speed / 100)); startY < this.bg.viewH; startY += height) {
                g.drawImage(this.image, startX, startY, 0);
            }
        }
    }

    public void drawTiledLayer(Graphics g, int viewX, int viewY) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        int startX = viewX % this.bg.tileW != 0 ? -(viewX % this.bg.tileW) : 0;
        int startY = viewY % this.bg.tileH != 0 ? -(viewY % this.bg.tileH) : 0;
        for (int j = viewY / this.bg.tileH; j <= (viewY + this.bg.viewH) / this.bg.tileH; ++j) {
            if (j >= this.bg.rows) continue;
            startX = viewX % this.bg.tileW != 0 ? -(viewX % this.bg.tileW) : 0;
            for (int i = viewX / this.bg.tileW; i <= (viewX + this.bg.viewW) / this.bg.tileW; ++i) {
                if (i >= this.bg.columns) continue;
                short data1 = this.data[j * this.bg.columns + i];
                if (data1 != -1) {
                    int flag = GameCanvas.trans((data1 & 0x4000) != 0, (data1 & 0x2000) != 0);
                    data1 = (short)(data1 & 0xFFF);
                    int tileCountPerLine = this.image.getWidth() / this.bg.tileW;
                    int srcX = data1 % tileCountPerLine * this.bg.tileW;
                    int srcY = data1 / tileCountPerLine * this.bg.tileH;
                    g.setClip(startX, startY, this.bg.tileW, this.bg.tileH);
                    g.clipRect(startX, startY, this.bg.tileW, this.bg.tileH);
                    if (flag == 0) {
                        g.drawImage(this.image, startX - srcX, startY - srcY, 20);
                    } else {
                        g.drawRegion(this.image, srcX, srcY, this.bg.tileW, this.bg.tileH, flag, startX, startY, 0);
                    }
                }
                startX += this.bg.tileW;
            }
            startY += this.bg.tileH;
        }
        g.setClip(clipX, clipY, clipW, clipH);
        g.clipRect(clipX, clipY, clipW, clipH);
    }

    public void tick() {
        if (this.type == 0) {
            if (this.data[1] == 1) {
                ++this.moveFrame;
                if (this.moveFrame == this.data[4]) {
                    if (this.data[5] == 0) {
                        --this.moveFrame;
                    } else if (this.data[5] == 1) {
                        this.moveFrame = 0;
                        this.isLineGo = !this.isLineGo;
                    } else if (this.data[5] == 2) {
                        this.moveFrame = 0;
                    }
                }
                this.x = this.tempX + (this.isLineGo ? this.moveFrame * this.data[2] : (this.data[4] - this.moveFrame) * this.data[2]);
                this.y = this.tempY + (this.isLineGo ? this.moveFrame * this.data[3] : (this.data[4] - this.moveFrame) * this.data[3]);
            } else if (this.data[1] == 2) {
                int angle = this.moveFrame > 0 ? this.moveFrame : this.moveFrame + 360;
                this.x = (short)((this.tempX << 8) + this.data[2] * Tools.sineTimes256(angle) >> 8);
                this.y = (short)((this.tempY << 8) + this.data[2] * Tools.cosineTimes256(angle) >> 8);
                this.moveFrame += this.data[4];
            }
        }
    }
}

