/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class OwnTeam
extends Team {
    public static final int MAX_FRIEND = 4;
    public static final int MAX_BATTLE_NUM = 4;
    public int gold = 0;
    public short[] item;
    public short[] itemcount;
    public short[] arm;
    public short[] armcount;
    public short t_gold;
    public short[] t_items;
    public short[] t_arms;
    public static final int MAX_ART_NUM = 99;
    public Mate[] mates;
    public int existcount;
    public short battleLeft;
    public short battleRight;
    public short currbattle;

    public void init(int[][] MATE_POS) {
        super.init(MATE_POS);
        this.t_gold = 0;
        this.t_items = null;
        this.t_arms = null;
    }

    public void addPrice(Monster mon, Mate killer) {
        if (this.t_items == null) {
            this.t_items = new short[0];
        }
        short[] tmp = new short[this.t_items.length + mon.items.length];
        Tools.arraycopy(this.t_items, 0, tmp, 0, this.t_items.length);
        int count = 0;
        for (int i = 0; i < mon.items.length; ++i) {
            if (Tools.random(99) >= mon.itemodd[i]) continue;
            tmp[this.t_items.length + count] = mon.items[i];
            count = (short)(count + 1);
        }
        int len = this.t_items.length + count;
        this.t_items = new short[len];
        Tools.arraycopy(tmp, 0, this.t_items, 0, len);
        if (this.t_arms == null) {
            this.t_arms = new short[0];
        }
        tmp = new short[this.t_arms.length + mon.arms.length];
        Tools.arraycopy(this.t_arms, 0, tmp, 0, this.t_arms.length);
        count = 0;
        for (int i = 0; i < mon.arms.length; ++i) {
            if (Tools.random(99) >= mon.armodd[i]) continue;
            tmp[this.t_arms.length + count] = mon.arms[i];
            count = (short)(count + 1);
        }
        len = this.t_arms.length + count;
        this.t_arms = new short[len];
        Tools.arraycopy(tmp, 0, this.t_arms, 0, len);
        int gold = mon.gold;
        if (this.teamLevel > mon.level) {
            gold -= mon.gold * (this.teamLevel - mon.level) * World.GOLD_LIMIT / 100;
        }
        this.t_gold = (short)(this.t_gold + (gold *= World.GOLD_MANY));
        Mate[] livingMate = this.getBattleMates(true);
        int allExp = mon.exp * World.EXP_MANY;
        if (killer != null) {
            int priceexp = allExp * World.EXP_PRICE / 100;
            killer.t_exp += priceexp;
            allExp -= priceexp;
        }
        allExp /= livingMate.length;
        for (int i = 0; i < livingMate.length; ++i) {
            livingMate[i].t_exp += allExp;
        }
    }

    public void dealWinPrice() {
        int j;
        int i;
        int i2;
        if (this.t_arms == null) {
            this.t_arms = new short[0];
        }
        if (this.t_items == null) {
            this.t_items = new short[0];
        }
        Mate[] bat = this.getBattleMates(true);
        StringBuffer sb = new StringBuffer();
        for (i2 = 0; i2 < bat.length; ++i2) {
            sb.append(bat[i2].name);
            sb.append("\u83b7\u5f97:");
            sb.append(bat[i2].t_exp);
            sb.append('|');
        }
        UI.showInfoPanel(World.g, "\u6218\u6597\u83b7\u5f97\u7ecf\u9a8c", sb.toString(), true);
        UI.showBattle(1);
        for (i2 = 0; i2 < bat.length; ++i2) {
            bat[i2].addExp(bat[i2].t_exp);
            bat[i2].t_exp = 0;
        }
        StringBuffer info = new StringBuffer();
        if (this.t_gold < 0) {
            this.t_gold = 1;
        }
        if (this.t_gold > 0) {
            this.gold += this.t_gold;
            info.append("\u83b7\u5f97\u91d1:");
            info.append(this.t_gold);
            info.append('|');
        }
        short[] tmp = Tools.upArrayIndex(this.t_arms, false);
        short[] artsID = Tools.upArrayIndex(this.t_arms, true);
        short[] artsCount = new short[artsID.length];
        for (i = 0; i < tmp.length; ++i) {
            for (j = 0; j < artsID.length; ++j) {
                if (tmp[i] != artsID[j]) continue;
                int n = j;
                artsCount[n] = (short)(artsCount[n] + 1);
            }
        }
        for (i = 0; i < artsID.length; ++i) {
            info.append("\u83b7\u5f97:");
            info.append(Data.STRING_ARM[artsID[i]][0]);
            info.append('X');
            info.append(artsCount[i]);
            info.append('|');
            this.addArm(artsID[i], artsCount[i]);
        }
        tmp = Tools.upArrayIndex(this.t_items, false);
        artsID = Tools.upArrayIndex(this.t_items, true);
        artsCount = new short[artsID.length];
        for (i = 0; i < tmp.length; ++i) {
            for (j = 0; j < artsID.length; ++j) {
                if (tmp[i] != artsID[j]) continue;
                int n = j;
                artsCount[n] = (short)(artsCount[n] + 1);
            }
        }
        for (i = 0; i < artsID.length; ++i) {
            info.append("\u83b7\u5f97:");
            info.append(Data.STRING_ITEM[artsID[i]][0]);
            info.append('X');
            info.append(artsCount[i]);
            info.append('|');
            this.addItem(artsID[i], artsCount[i]);
        }
        if (info.length() > 0) {
            UI.showInfoPanel(World.g, "\u6218\u6597\u5956\u52b1", info.toString(), true);
        }
        UI.showBattle(1);
    }

    public Mate[] getBattleMates(boolean noDead) {
        Vector<Mate> vec = new Vector<Mate>(4);
        for (int i = 0; i < this.existcount; ++i) {
            if (!World.myteam.mates[i].isallowbattle || noDead && !World.myteam.mates[i].isLiving) continue;
            vec.addElement(World.myteam.mates[i]);
        }
        Mate[] battleMates = new Mate[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            battleMates[i] = (Mate)vec.elementAt(i);
        }
        this.fighterCount = (short)battleMates.length;
        return battleMates;
    }

    public void loadFighters() {
        this.fighters = this.getBattleMates(false);
    }

    public void load(DataInputStream dis) {
        super.load(dis);
        try {
            dis.readShort();
            short count = dis.readShort();
            dis.skip(2 * count);
            count = dis.readShort();
            dis.skip(2 * count);
            this.item = World.INIT_ARTICAL;
            this.itemcount = World.INIT_ARTCOUNT;
            count = dis.readShort();
            dis.skip(2 * count);
            count = dis.readShort();
            dis.skip(2 * count);
            this.arm = World.INIT_ARM;
            this.armcount = World.INIT_ARM_COUNT;
            this.existcount = 1;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public Role selectActFighter(int flag) {
        Vector<Role> vecRoles = new Vector<Role>(4);
        for (int i = 0; i < this.fighters.length; ++i) {
            if (this.fighters[i].hasAction || !this.fighters[i].matchRole(flag)) continue;
            int n = i;
            this.fighters[i].MJ[n] = this.fighters[i].MJ[n] + 1;
            vecRoles.addElement(this.fighters[i]);
        }
        Role[] roles = new Role[vecRoles.size()];
        for (int i = 0; i < vecRoles.size(); ++i) {
            roles[i] = (Role)vecRoles.elementAt(i);
        }
        if (vecRoles.size() <= 0) {
            return null;
        }
        UI.setBattleInfo1("\u9009\u62e9\u51fa\u624b\u4eba\u7269");
        roles = UI.selectRoles(roles, 1, false);
        if (roles == null) {
            return null;
        }
        if (roles.length > 0) {
            return roles[0];
        }
        return null;
    }

    public void addItem(int itemid, int count) {
        int i;
        if (count <= 0) {
            return;
        }
        for (i = 0; i < this.item.length; ++i) {
            if (itemid != this.item[i]) continue;
            int n = i;
            this.itemcount[n] = (short)(this.itemcount[n] + count);
            this.itemcount[i] = (short)Tools.limit(this.itemcount[i], 0, 99);
            return;
        }
        System.out.println("item count " + this.item.length);
        for (i = 0; i < this.item.length; ++i) {
            System.out.println("item " + i + " " + this.item[i] + "  itemcount " + this.itemcount.length);
        }
        short[] newitem = new short[this.item.length + 1];
        short[] newitemcount = new short[newitem.length];
        for (int i2 = 0; i2 < newitemcount.length; ++i2) {
            System.out.println("newitemcount " + i2 + " " + newitemcount[i2]);
        }
        System.out.println("arraycopy   " + this.itemcount.length + "  " + newitemcount.length);
        Tools.arraycopy(this.itemcount, 0, newitemcount, 0, this.itemcount.length);
        newitemcount[newitem.length - 1] = (short)count;
        newitemcount[newitem.length - 1] = (short)Tools.limit(newitemcount[newitem.length - 1], 0, 99);
        Tools.arraycopy(this.item, 0, newitem, 0, this.item.length);
        newitem[newitem.length - 1] = (short)itemid;
        this.item = newitem;
        this.itemcount = newitemcount;
    }

    public void delItem(int itemid, int count) {
        for (int i = 0; i < this.item.length; ++i) {
            if (itemid != this.item[i]) continue;
            int n = i;
            this.itemcount[n] = (short)(this.itemcount[n] - count);
            if (this.itemcount[i] <= 0) {
                for (int j = i; j < this.item.length - 1; ++j) {
                    this.item[j] = this.item[j + 1];
                    this.itemcount[j] = this.itemcount[j + 1];
                }
                short[] newarm = new short[this.item.length - 1];
                short[] newarmcount = new short[newarm.length];
                Tools.arraycopy(this.itemcount, 0, newarmcount, 0, newarmcount.length);
                Tools.arraycopy(this.item, 0, newarm, 0, newarm.length);
                this.itemcount = newarmcount;
                this.item = newarm;
            }
            return;
        }
    }

    public void addArm(int armid, int count) {
        if (count <= 0 || armid < 0) {
            return;
        }
        int swordid = armid - 44;
        for (int i = 0; i < this.arm.length; ++i) {
            if (armid != this.arm[i]) continue;
            int n = i;
            this.armcount[n] = (short)(this.armcount[n] + count);
            this.armcount[i] = (short)Tools.limit(this.armcount[i], 0, 99);
            return;
        }
        short[] newarm = new short[this.arm.length + 1];
        short[] newarmcount = new short[newarm.length];
        Tools.arraycopy(this.armcount, 0, newarmcount, 0, this.armcount.length);
        newarmcount[newarm.length - 1] = (short)count;
        newarmcount[newarm.length - 1] = (short)Tools.limit(newarmcount[newarm.length - 1], 0, 99);
        Tools.arraycopy(this.arm, 0, newarm, 0, this.arm.length);
        newarm[newarm.length - 1] = (short)armid;
        this.arm = newarm;
        this.armcount = newarmcount;
    }

    public void delArm(int armid, int count) {
        for (int i = 0; i < this.arm.length; ++i) {
            if (armid != this.arm[i]) continue;
            int n = i;
            this.armcount[n] = (short)(this.armcount[n] - count);
            if (this.armcount[i] <= 0) {
                for (int j = i; j < this.arm.length - 1; ++j) {
                    this.arm[j] = this.arm[j + 1];
                    this.armcount[j] = this.armcount[j + 1];
                }
                short[] newarm = new short[this.arm.length - 1];
                short[] newarmcount = new short[newarm.length];
                Tools.arraycopy(this.armcount, 0, newarmcount, 0, newarmcount.length);
                Tools.arraycopy(this.arm, 0, newarm, 0, newarm.length);
                this.armcount = newarmcount;
                this.arm = newarm;
            }
            return;
        }
    }

    public int getArticalCount(int type, int id) {
        block3: {
            block2: {
                if (type != 0) break block2;
                for (int i = 0; i < this.arm.length; ++i) {
                    if (this.arm[i] != id) continue;
                    return this.armcount[i];
                }
                break block3;
            }
            if (type != 1) break block3;
            for (int i = 0; i < this.item.length; ++i) {
                if (this.item[i] != id) continue;
                return this.itemcount[i];
            }
        }
        return 0;
    }

    public int getArticalCount(int id, int type, boolean issale) {
        int existcount = 0;
        block0 : switch (type) {
            case 0: {
                for (int i = 0; i < this.arm.length; ++i) {
                    if (id != this.arm[i]) continue;
                    existcount = this.armcount[i];
                    break block0;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.item.length; ++i) {
                    if (id != this.item[i]) continue;
                    existcount = this.itemcount[i];
                    break block0;
                }
                break;
            }
        }
        return issale ? existcount : 99 - existcount;
    }

    public void saveRecord(DataOutputStream dos) {
        try {
            int i;
            short count = (short)this.item.length;
            dos.writeShort(count);
            for (i = 0; i < this.item.length; ++i) {
                dos.writeShort(this.item[i]);
                dos.writeShort(this.itemcount[i]);
            }
            dos.writeShort(this.arm.length);
            for (i = 0; i < this.arm.length; ++i) {
                dos.writeShort(this.arm[i]);
                dos.writeShort(this.armcount[i]);
            }
            dos.writeInt(this.gold);
            dos.writeByte(this.existcount);
            for (i = 0; i < this.mates.length; ++i) {
                dos.writeByte(this.mates[i].id);
            }
            for (i = 0; i < this.mates.length; ++i) {
                this.mates[i].saveRecord(dos);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadRecord(DataInputStream dis) {
        try {
            int i;
            int i2;
            short count = dis.readShort();
            this.item = new short[count];
            this.itemcount = new short[this.item.length];
            for (i2 = 0; i2 < this.item.length; ++i2) {
                this.item[i2] = dis.readShort();
                this.itemcount[i2] = dis.readShort();
            }
            this.arm = new short[dis.readShort()];
            this.armcount = new short[this.arm.length];
            for (i2 = 0; i2 < this.arm.length; ++i2) {
                this.arm[i2] = dis.readShort();
                this.armcount[i2] = dis.readShort();
            }
            this.gold = dis.readInt();
            this.existcount = dis.readByte();
            short[] id = new short[4];
            for (i = 0; i < id.length; ++i) {
                id[i] = dis.readByte();
            }
            this.mates = new Mate[4];
            for (i = 0; i < this.mates.length; ++i) {
                this.mates[i] = World.human[id[i]];
                this.mates[i].loadRecord(dis);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addTeamMate(int id) {
        for (int i = 0; i < this.existcount; ++i) {
            if (this.mates[i].id != id) continue;
            return;
        }
        int idx = id;
        if (id != this.mates[this.existcount].id) {
            for (int i = this.existcount; i < this.mates.length; ++i) {
                if (id != this.mates[i].id) continue;
                idx = (byte)i;
                break;
            }
            Mate tmp = this.mates[this.existcount];
            this.mates[this.existcount] = this.mates[idx];
            this.mates[idx] = tmp;
        }
        ++this.existcount;
        World.human[id].isallowbattle = this.getBattleMates(false).length < 4;
    }

    public void delTeamMate(short id) {
        int index = this.getIndexFromTeam(id);
        if (index < 0) {
            return;
        }
        Mate mate = this.mates[index];
        for (int i = index; i < this.existcount; ++i) {
            if (i == this.mates.length - 1) continue;
            this.mates[i] = this.mates[i + 1];
        }
        this.mates[Math.min((int)this.existcount, (int)(this.mates.length - 1))] = mate;
        --this.existcount;
    }

    public int getIndexFromTeam(short id) {
        int index = -1;
        for (int i = 0; i < this.existcount; ++i) {
            if (this.mates[i].id != id) continue;
            index = i;
            break;
        }
        return index;
    }

    public Unit[] getArms(int[] type) {
        Vector<Unit> vector = new Vector<Unit>();
        block0: for (int i = 0; i < this.arm.length; ++i) {
            Unit unit = Data.getUnitValue(0, this.arm[i]);
            unit.count = this.armcount[i];
            for (int j = 0; j < type.length; ++j) {
                if (type[j] != unit.armtype) continue;
                vector.addElement(unit);
                continue block0;
            }
        }
        Unit[] list = new Unit[vector.size()];
        for (int i = 0; i < list.length; ++i) {
            list[i] = (Unit)vector.elementAt(i);
        }
        return list;
    }

    public Unit[] getArms(int[] type, int mateIndex) {
        Vector<Unit> vector = new Vector<Unit>();
        block0: for (int i = 0; i < this.arm.length; ++i) {
            Unit unit = Data.getUnitValue(0, this.arm[i]);
            unit.count = this.armcount[i];
            for (int j = 0; j < type.length; ++j) {
                if (!(type[j] == unit.armtype & mateIndex == unit.zhuanshu)) continue;
                vector.addElement(unit);
                continue block0;
            }
        }
        Unit[] list = new Unit[vector.size()];
        for (int i = 0; i < list.length; ++i) {
            list[i] = (Unit)vector.elementAt(i);
        }
        return list;
    }

    public Unit[] getItem(int[] type, boolean showSpecialItem, int Gemttype) {
        Vector<Unit> vector = new Vector<Unit>();
        for (int i = 0; i < this.item.length; ++i) {
            Unit unit = Data.getUnitValue(1, this.item[i]);
            if (!showSpecialItem && (unit.datatype == 0 || unit.datatype == 1 || unit.datatype == 2) && !unit.costround) continue;
            unit.count = this.itemcount[i];
            if (Tools.getIndexFromArray((int)unit.datatype, type) < 0 || Gemttype != unit.Gemtype) continue;
            vector.addElement(unit);
        }
        Unit[] list = new Unit[vector.size()];
        for (int i = 0; i < list.length; ++i) {
            list[i] = (Unit)vector.elementAt(i);
        }
        return list;
    }

    public Unit[] getItem(int[] type, boolean showSpecialItem) {
        Vector<Unit> vector = new Vector<Unit>();
        for (int i = 0; i < this.item.length; ++i) {
            Unit unit = Data.getUnitValue(1, this.item[i]);
            if (!showSpecialItem && (unit.datatype == 0 || unit.datatype == 1 || unit.datatype == 2) && !unit.costround) continue;
            unit.count = this.itemcount[i];
            if (Tools.getIndexFromArray((int)unit.datatype, type) < 0) continue;
            vector.addElement(unit);
        }
        Unit[] list = new Unit[vector.size()];
        for (int i = 0; i < list.length; ++i) {
            list[i] = (Unit)vector.elementAt(i);
        }
        return list;
    }

    public Unit getItem(short id) {
        int index = Tools.getIndexFromArray((int)id, this.item);
        if (index <= -1) {
            return null;
        }
        if (this.itemcount[index] > 0) {
            int n = index;
            this.itemcount[n] = (short)(this.itemcount[n] - 1);
            Unit unit = Data.getUnitValue(1, this.item[index]);
            return unit;
        }
        return null;
    }

    public Mate[] getTeamMates() {
        Mate[] mateList = new Mate[World.myteam.existcount];
        for (int i = 0; i < mateList.length; ++i) {
            mateList[i] = World.myteam.mates[i];
        }
        return mateList;
    }
}

