/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class Scene {
    public static String name;
    public long[] loadAnimMask;
    public byte[] actorLayers;
    public String[] texts;
    public Animation[] anims;
    public int bgIndex;
    public int bgWidth = Integer.MAX_VALUE;
    public int bgHeight = Integer.MAX_VALUE;
    public Background bg;
    public int actorCount;
    public Actor[] actors;
    public int activeCount;
    public Actor[] activeList;
    public int drawCount;
    public Actor[] drawList;
    public static final byte ACTIVE_RANGE = 40;
    public static final byte TEMP_COUNT = 10;
    public static boolean BiBai;
    public int frameCount = 0;
    public boolean isRunning = true;
    private boolean start = true;
    private int trailerModeHeight = 0;
    public int drawAddressCount = 0;
    public boolean isDrawAddress = false;
    public static int npcNameTextID;
    public boolean isDrawCurtain = false;
    public static final int EFFECT_BLACK = 0;
    public static final int EFFECT_RAIN = 1;
    public static final int EFFECT_SNOW = 2;
    public static final int EFFECT_BLACK2 = 3;
    public static final int EFFECT_LINE = 4;
    private boolean effectOn = false;
    private int effectId = 0;
    public static final int WEATHER_SNOW = 1;
    public static final int WEATHER_RAIN = 2;
    public static final short SNOW_PIXEL_NUMBER = 120;
    public static final short RAIN_PIXEL_NUMBER = 20;
    private static final int SNOWPIXELNUMBER = 120;
    private static int[] s_snowX;
    private static int[] s_snowY;
    private static int[] s_snowSpeedY;
    private static int[] s_snowSpeedX;
    private static byte[] s_snowBulk;
    private static int s_snowWind;
    private static int s_snowWindCount;
    private static boolean s_isInitSnow;
    private static boolean s_isInitRain;
    static boolean s_isChangeSnow;
    static int s_frameCountOfChangeSnow;
    static int s_frameCircle;
    static final int BASE_NUMBER_SPEED_Y = 10;
    static final int BASE_NUMBER_SPEED_X = 3;
    static final int BASE_NUMBER_SNOW_WIND_DURATION = 20;
    static int RAINPIXELNUMBER;
    public int viewX;
    public int viewY;
    public int viewW;
    public int viewH;
    public int destViewX;
    public int destViewY;
    public int viewSpeed = 8;
    public int viewLimitX = 0;
    public int viewLimitW = Integer.MAX_VALUE;
    public int viewLimitY = 0;
    public int viewLimitH = Integer.MAX_VALUE;
    public boolean forceView = true;
    public boolean smoothView = false;
    public Actor viewActor;
    public Actor oldViewActor;
    public static final int THREAD_ACTOR_ID = 0;
    public static final int THREAD_ACTOR_ID_FLAG_SKIP = 32768;
    public static final int KEYFRAME_DATA_BEGIN = 1;
    public static final int KEYFRAME_DATA_SIZE = 5;
    public static final int KEYFRAME_FRAME = 0;
    public static final int KEYFRAME_X = 1;
    public static final int KEYFRAME_Y = 2;
    public static final int KEYFRAME_ACTION = 3;
    public static final int KEYFRAME_ACTION_MASK = 255;
    public static final int KEYFRAME_FLAG = 3;
    public static final int KEYFRAME_FLAG_HIDE = 32768;
    public static final int KEYFRAME_FLAG_DELETEME = 16384;
    public static final int KEYFRAME_FLAG_FLIPX = 8192;
    public static final int KEYFRAME_FLAG_FLIPY = 4096;
    public static final int KEYFRAME_COMMAND = 4;
    public short[][][] trailerData;
    public short[][] curTrailer;
    public short[][] trailerActionData;
    public int curTrailerFrameId = -1;
    public boolean trailerEnd = true;
    public static final int COND_FINAL = 0;
    public static final int COND_AND = 1;
    public static final int COND_OR = 2;
    public static final int TYPE_NUMBER = 0;
    public static final int TYPE_FUNCTION = 1;
    public static final int TYPE_VARIABLE = 2;
    public static final int TYPE_CONDITION = 3;
    public static final int TYPE_ACTION = 4;
    public static final int TYPE_OPERATOR = 5;
    public static final int OP_EQ = 0;
    public static final int OP_NE = 1;
    public static final int OP_LT = 2;
    public static final int OP_GT = 3;
    public static final int OP_LE = 4;
    public static final int OP_GE = 5;
    public static final int COM_PLUS = 0;
    public static final int COM_MINUS = 1;
    public static final int COM_MULTI = 2;
    public static final int COM_DIVIDE = 3;
    public byte[][] triggerEventList;
    public short[][] triggerData;
    public short[] curTriggerData;
    public int curDataIndex;
    public boolean triggerEnd = true;
    public short[][] recursionTriggerData = new short[8][];
    public int[] recursionDataIndex = new int[8];
    public byte recursionLevel = 0;
    public static int oldMode;
    public int eventActorClass = -1;
    public int eventActorId = -1;
    public int eventActorAction = -1;
    public int collideActorClass = -1;
    public int collideActorId = -1;
    public int collideActorAction = -1;
    public int activateActorClass = -1;
    public int activateActorId = -1;
    public int activateActorAction = -1;
    public Actor player;
    public Actor[] followTeam = new Actor[4];
    public Actor face;

    public static Scene loadScene(int level, int viewW, int viewH) {
        World.TIP_ID = Tools.random(0, World.LOAD_TIP.length - 1);
        UI.drawLoading(15);
        Scene scene = new Scene();
        try {
            String sceneFile = "/b1";
            DataInputStream dis = new DataInputStream(sceneFile.getClass().getResourceAsStream(sceneFile));
            int count = dis.readByte();
            int[] tmp_pfBlockLengths = new int[count];
            for (int i = 0; i < count; ++i) {
                tmp_pfBlockLengths[i] = dis.readShort();
            }
            if (level > 0) {
                int temp_p = 0;
                for (int i = 0; i < level; ++i) {
                    temp_p += tmp_pfBlockLengths[i];
                }
                dis.skip(temp_p);
            }
            UI.drawLoading(20);
            scene.load(dis);
            scene.viewW = viewW;
            scene.viewH = viewH;
            dis.close();
            dis = null;
        }
        catch (Exception e) {
            // empty catch block
        }
        scene.loadDepend();
        UI.drawLoading(99);
        return scene;
    }

    public void load(DataInputStream dis) throws Exception {
        short size;
        int j;
        int i;
        name = dis.readUTF();
        if (name.equals("\u6bd5\u6797\u8f69\u51fa\u4e16")) {
            name = "\u6c11\u5c45";
        }
        if (name.equals("\u51b3\u6218\u9b54\u5e1d")) {
            name = "\u72f1\u9b54\u5bab\u540e";
        }
        if (name.equals("\u518d\u89c1\u5929\u9999")) {
            name = "\u72f1\u9b54\u5bab\u524d";
        }
        if (name.equals("\u67e5\u770b\u5a49\u745c")) {
            name = "\u6708\u6b8b\u6d1e\u5e95";
        }
        if (name.equals("\u5deb\u5996\u5973")) {
            name = "\u7d2b\u9b54\u6797\u4e1c";
        }
        if (name.equals("\u7b49\u5f85")) {
            name = "\u6708\u6b8b\u6d1e\u5e95";
        }
        if (name.equals("\u518d\u6218\u9b54\u5e1d")) {
            name = "\u8840\u9b54\u7a9f\u540e";
        }
        if (name.equals("\u9047\u9b54\u5e1d")) {
            name = "\u6708\u6b8b\u6d1e\u5e95";
        }
        if (name.equals("\u6708\u6b8b\u6d1e3")) {
            name = "\u6708\u6b8b\u6d1e\u4e2d";
        }
        if (name.equals("\u5929\u754c\u5ba4\u5185")) {
            name = "\u5929\u754c\u5bdd\u5bab";
        }
        if (name.equals("\u6740\u8fdb\u7687\u57ce1")) {
            name = "\u7687\u5bab";
        }
        if (name.equals("\u6740\u8fdb\u7687\u57ce2")) {
            name = "\u5bdd\u5bab";
        }
        if (name.equals("\u9047\u5230\u795e\u517d")) {
            name = "\u6708\u6b8b\u6d1e\u53e3";
        }
        if (name.equals("\u6218\u8d25\u9ed1\u718a\u517d")) {
            name = "\u5929\u82cd\u5c71\u9876";
        }
        if (name.equals("\u5f97\u5230\u795e\u5668")) {
            name = "\u7a7a\u7075\u5c9b";
        }
        if (name.equals("\u7a7a\u7075\u5c9b2")) {
            name = "\u7a7a\u7075\u5c9b\u4e2d";
        }
        if (name.equals("\u7a7a\u7075\u5c9b3")) {
            name = "\u7a7a\u7075\u5c9b\u5185";
        }
        if (name.equals("\u88ab\u98ce\u522e\u5230")) {
            name = "\u6708\u6b8b\u6d1e\u5e95";
        }
        if (name.equals("\u527f\u532a1")) {
            name = "\u5929\u82cd\u5c71\u811a";
        }
        if (name.equals("\u527f\u532a2")) {
            name = "\u5929\u82cd\u5c71\u8170";
        }
        if (name.equals("\u5c06\u519b\u5e9c\u9662 \u6284\u5bb6")) {
            name = "\u5c06\u519b\u5e9c";
        }
        if (name.equals("\u5c06\u519b\u5e9c\u9662")) {
            name = "\u5c06\u519b\u5e9c";
        }
        if (name.equals("\u5c06\u519b\u5e9c\u5ba2\u5385")) {
            name = "\u5ba2\u5385";
        }
        if (name.equals("\u7a7a\u7075\u5c9b\u9047\u82e5\u4f9d")) {
            name = "\u7a7a\u7075\u5c9b\u5916";
        }
        if (name.equals("\u5c0f\u59d0\u95fa\u623f")) {
            name = "\u95fa\u623f";
        }
        if (name.equals("\u5a49\u745c\u964d\u751f")) {
            name = "\u5c06\u519b\u5e9c";
        }
        if (name.equals("\u5c06\u519b\u5e9c\u5185")) {
            name = "\u5c06\u519b\u5e9c";
        }
        if (name.equals("\u5ba4\u51851")) {
            name = "\u5ba4\u5185";
        }
        if (name.equals("\u5ba4\u51852")) {
            name = "\u5ba4\u5185";
        }
        if (name.equals("\u5ba4\u51853")) {
            name = "\u5ba4\u5185";
        }
        if (name.equals("\u5929\u754c\u5ba1\u5224")) {
            name = "\u5929\u754c\u5927\u6bbf";
        }
        if (name.equals("\u6708\u6b8b\u6d1e2")) {
            name = "\u6708\u6b8b\u6d1e\u5185";
        }
        if (name.equals("\u8840\u9b54\u7a9f1")) {
            name = "\u8840\u9b54\u7a9f\u524d";
        }
        if (name.equals("\u8840\u9b54\u7a9f2")) {
            name = "\u8840\u9b54\u7a9f\u4e2d";
        }
        if (name.equals("\u7d2b\u9b54\u67971")) {
            name = "\u7d2b\u9b54\u6797\u5357";
        }
        if (name.equals("\u7d2b\u9b54\u67972")) {
            name = "\u7d2b\u9b54\u6797\u5317";
        }
        if (name.equals("\u72f1\u9b54\u5bab2")) {
            name = "\u72f1\u9b54\u5bab\u4e2d";
        }
        UI.drawLoading(20);
        int count = dis.readShort();
        this.trailerData = new short[count][][];
        for (i = 0; i < count; ++i) {
            int actorNum = dis.readByte();
            this.trailerData[i] = new short[actorNum][];
            for (j = 0; j < actorNum; ++j) {
                int size2 = dis.readShort();
                this.trailerData[i][j] = new short[size2];
                for (int n = 0; n < size2; ++n) {
                    this.trailerData[i][j][n] = dis.readShort();
                }
            }
        }
        UI.drawLoading(25);
        this.trailerActionData = new short[count][];
        for (i = 0; i < count; ++i) {
            size = dis.readShort();
            this.trailerActionData[i] = new short[size];
            for (j = 0; j < size; ++j) {
                this.trailerActionData[i][j] = dis.readShort();
            }
        }
        UI.drawLoading(28);
        count = dis.readByte();
        this.loadAnimMask = new long[count];
        for (i = 0; i < count; ++i) {
            this.loadAnimMask[i] = dis.readLong();
        }
        UI.drawLoading(30);
        count = dis.readShort();
        this.triggerEventList = new byte[count][];
        this.triggerData = new short[count][];
        for (i = 0; i < count; ++i) {
            size = dis.readByte();
            this.triggerEventList[i] = new byte[size];
            for (j = 0; j < size; ++j) {
                this.triggerEventList[i][j] = dis.readByte();
            }
            size = dis.readShort();
            this.triggerData[i] = new short[size];
            for (j = 0; j < size; ++j) {
                this.triggerData[i][j] = dis.readShort();
            }
        }
        UI.drawLoading(40);
        count = dis.readByte();
        this.actorLayers = new byte[count];
        for (i = 0; i < count; ++i) {
            this.actorLayers[i] = dis.readByte();
        }
        UI.drawLoading(45);
        this.bgIndex = dis.readShort();
        UI.drawLoading(47);
        count = dis.readShort();
        this.texts = new String[count];
        for (i = 0; i < count; ++i) {
            this.texts[i] = dis.readUTF();
        }
        UI.drawLoading(50);
        this.actorCount = count = (int)dis.readShort();
        this.actors = new Actor[count + 10];
        this.activeList = new Actor[count + 10];
        this.drawList = new Actor[count + 10];
        for (i = 0; i < count; ++i) {
            this.actors[i] = new Actor(this);
            this.actors[i].load(dis);
            this.actors[i].id = (short)i;
        }
        UI.drawLoading(65);
    }

    public void loadDepend() {
        try {
            if (this.bgIndex >= 0) {
                UI.drawLoading(70);
                this.bg = Background.loadBackground(this.bgIndex, this.viewW, this.viewH);
                UI.drawLoading(76);
                this.bgWidth = this.bg.tileW * this.bg.columns;
                this.bgHeight = this.bg.tileH * this.bg.rows;
                this.viewLimitW = Math.max(0, this.bgWidth - this.viewW);
                this.viewLimitH = Math.max(0, this.bgHeight - this.viewH);
                boolean useBuffer = true;
                int firstActorLayer = 0;
                firstActorLayer = this.actorLayers.length > 0 ? this.actorLayers[0] : this.bg.layerCount - 1;
                UI.drawLoading(77);
                if (this.bg.layers != null) {
                    for (int j = 0; j <= firstActorLayer; ++j) {
                        if (this.bg.layers[j] == null || this.bg.layers[j].type == 2 || this.bg.layers[j].type == 3) continue;
                        useBuffer = false;
                        break;
                    }
                    UI.drawLoading(78);
                    this.bg.isUseBuffer = useBuffer;
                }
            }
            UI.drawLoading(82);
            this.anims = Animation.loadAnimation(this.loadAnimMask);
            Actor.boxIndex = 0;
            UI.drawLoading(85);
            for (int i = 0; i < this.actorCount; ++i) {
                this.actors[i].anim = this.anims[this.actors[i].animId];
                this.actors[i].initActor();
                this.actors[i].setAction(this.actors[i].actionIDNow, true);
            }
            UI.drawLoading(87);
            this.followTeamLink();
            UI.drawLoading(90);
        }
        catch (Exception ex) {
            World.showErrorMessage("loadDepend ", ex);
        }
    }

    public void initResource() {
        int i;
        if (this.bg != null) {
            this.bg.initResource();
        }
        try {
            this.anims = Animation.loadAnimation(this.loadAnimMask);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (i = 0; i < this.actorCount; ++i) {
            this.actors[i].anim = this.anims[this.actors[i].animId];
        }
        for (i = 0; i < this.anims.length; ++i) {
            if (this.anims[i] == null) continue;
            this.anims[i].initResource();
        }
    }

    public void initBGResource() {
        if (this.bg != null) {
            this.bg.initResource();
        }
    }

    public void releaseResource() {
        int i;
        if (this.bg != null) {
            this.bg.releaseResource();
        }
        for (i = 0; i < this.anims.length; ++i) {
            if (this.anims[i] == null) continue;
            this.anims[i].releaseResource();
            this.anims[i] = null;
        }
        this.anims = null;
        for (i = 0; i < this.actorCount; ++i) {
            this.actors[i].anim.dispose();
            this.actors[i].anim = null;
        }
    }

    public void releaseBGResource() {
        if (this.bg != null) {
            this.bg.releaseResource();
        }
    }

    public void dispose() {
        if (this.bg != null) {
            this.bg.dispose();
            this.bg = null;
        }
        this.loadAnimMask = null;
        this.actorLayers = null;
        UI.drawLoading(0);
        int i = 0;
        if (this.texts != null) {
            for (i = 0; i < this.texts.length; ++i) {
                this.texts[i] = null;
            }
            this.texts = null;
        }
        if (this.anims != null) {
            for (i = 0; i < this.anims.length; ++i) {
                if (this.anims[i] != null) {
                    this.anims[i].dispose();
                }
                this.anims[i] = null;
            }
            this.anims = null;
        }
        UI.drawLoading(2);
        if (this.actors != null) {
            for (i = 0; i < this.actors.length; ++i) {
                if (this.actors[i] != null) {
                    this.actors[i].dispose();
                }
                this.actors[i] = null;
            }
            this.actors = null;
        }
        if (this.activeList != null) {
            for (i = 0; i < this.activeList.length; ++i) {
                if (this.activeList[i] != null) {
                    this.activeList[i].dispose();
                }
                this.activeList[i] = null;
            }
            this.activeList = null;
        }
        if (this.drawList != null) {
            for (i = 0; i < this.drawList.length; ++i) {
                if (this.drawList[i] != null) {
                    this.drawList[i].dispose();
                }
                this.drawList[i] = null;
            }
            this.drawList = null;
        }
        UI.drawLoading(6);
        if (this.trailerData != null) {
            for (i = 0; i < this.trailerData.length; ++i) {
                if (this.trailerData[i] == null) continue;
                for (int j = 0; j < this.trailerData[i].length; ++j) {
                    this.trailerData[i][j] = null;
                }
                this.trailerData[i] = null;
            }
            this.trailerData = null;
        }
        if (this.curTrailer != null) {
            for (i = 0; i < this.curTrailer.length; ++i) {
                this.curTrailer[i] = null;
            }
            this.curTrailer = null;
        }
        if (this.trailerActionData != null) {
            for (i = 0; i < this.trailerActionData.length; ++i) {
                this.trailerActionData[i] = null;
            }
        }
        UI.drawLoading(10);
        if (this.triggerEventList != null) {
            for (i = 0; i < this.triggerEventList.length; ++i) {
                this.triggerEventList[i] = null;
            }
            this.triggerEventList = null;
        }
        if (this.triggerData != null) {
            for (i = 0; i < this.triggerData.length; ++i) {
                this.triggerData[i] = null;
            }
            this.triggerData = null;
        }
        this.curTriggerData = null;
        if (this.recursionTriggerData != null) {
            for (i = 0; i < this.recursionTriggerData.length; ++i) {
                this.recursionTriggerData[i] = null;
            }
            this.recursionTriggerData = null;
        }
        this.recursionDataIndex = null;
        UI.drawLoading(14);
        this.player = null;
        for (i = 0; i < this.followTeam.length; ++i) {
            this.followTeam[i] = null;
        }
        this.followTeam = null;
    }

    public void run() {
        this.sceneInitialize();
        this.sceneLoaded();
        GameCanvas gc = World.gameCanvas;
        Graphics g = gc.getGraphics();
        this.isDrawAddress = true;
        this.drawAddressCount = 0;
        long startTime = 0L;
        while (this.isRunning) {
            long tick = System.currentTimeMillis() + 80L;
            if (this.start) {
                startTime = System.currentTimeMillis();
                this.start = false;
            }
            GameCanvas.updateKeyBegin();
            this.updateLogic(g);
            this.draw(g);
            this.drawInterface(g);
            GameCanvas.updateKeyEnd();
            gc.flush();
            while (tick > System.currentTimeMillis()) {
                Thread.yield();
            }
            ++this.frameCount;
        }
        this.sceneUnloaded();
        this.dispose();
    }

    public void draw(Graphics g) {
        this.updateView();
        this.updateActorList();
        this.drawScene(g);
        this.drawEffect(g);
        this.drawTrailerMode(g);
    }

    public void drawScene(Graphics g) {
        int startLayer = 0;
        int endLayer = 0;
        if (this.actorLayers.length == 0) {
            if (this.bg != null) {
                g.setColor(this.bg.color);
                g.fillRect(0, 0, this.viewW, this.viewH);
                if (this.bg.isUseBuffer) {
                    this.bg.drawBuffer(g, 0, this.bg.layerCount - 1);
                } else {
                    this.bg.draw(g, 0, this.bg.layerCount - 1);
                }
            }
            this.drawActor(g, 0);
        } else {
            for (int i = 0; i < this.actorLayers.length; ++i) {
                endLayer = this.actorLayers[i];
                if (this.bg != null && endLayer >= startLayer) {
                    if (i == 0) {
                        g.setColor(this.bg.color);
                        g.fillRect(0, 0, this.viewW, this.viewH);
                    }
                    if ((this.effectId & 8) == 0) {
                        if (this.bg.isUseBuffer && i == 0) {
                            this.bg.drawBuffer(g, startLayer, endLayer);
                        } else if (!(World.b_3 & World.b_fly)) {
                            this.bg.draw(g, startLayer, endLayer);
                        }
                    }
                }
                this.drawActor(g, i);
                startLayer = endLayer + 1;
            }
            if (this.bg != null && (this.effectId & 8) == 0) {
                this.bg.draw(g, startLayer, this.bg.layerCount - 1);
            }
        }
    }

    public void drawActor(Graphics g, int layerIndex) {
        for (int i = 0; i < this.drawCount; ++i) {
            Actor a2 = this.drawList[i];
            if (a2 == null || a2.layer != layerIndex) continue;
            a2.draw(g, this.viewX, this.viewY);
        }
    }

    public void drawTrailerMode(Graphics g) {
        if (this.trailerModeHeight <= 0) {
            return;
        }
        g.setColor(0);
        g.fillRect(0, 0, this.viewW, this.trailerModeHeight);
        g.fillRect(0, this.viewH - this.trailerModeHeight, this.viewW, this.trailerModeHeight);
    }

    public void drawInterface(Graphics g) {
        if (npcNameTextID >= 0) {
            UI.drawMessageBox(g, null, this.texts[npcNameTextID], (GameCanvas.SCREEN_WIDTH - 80) / 2, 0, 80, 34, false);
            npcNameTextID = -1;
            this.isDrawAddress = false;
        }
        if (this.isDrawAddress) {
            String address = name;
            if (this.drawAddressCount < 17) {
                UI.drawMessageBox(g, null, address, 0, this.drawAddressCount * 2 - 34, GameCanvas.SCREEN_WIDTH, 34, false);
            } else if (this.drawAddressCount > 33) {
                UI.drawMessageBox(g, null, address, 0, (50 - this.drawAddressCount) * 2 - 34, GameCanvas.SCREEN_WIDTH, 34, false);
            } else {
                UI.drawMessageBox(g, null, address, 0, 0, GameCanvas.SCREEN_WIDTH, 34, false);
            }
            ++this.drawAddressCount;
            if (this.drawAddressCount > 50) {
                this.isDrawAddress = false;
                this.drawAddressCount = 0;
            }
        }
    }

    public void drawEffect(Graphics g) {
        if (!this.effectOn) {
            return;
        }
        if ((this.effectId & 1) != 0) {
            g.setColor(0);
            g.fillRect(0, 0, this.viewW, this.viewH);
        }
        if ((this.effectId & 2) != 0) {
            this.drawRain(g);
        }
        if ((this.effectId & 4) != 0) {
            this.drawSnow(g);
        }
        if ((this.effectId & 0x10) != 0) {
            this.drawLine(g);
        }
    }

    private void drawLine(Graphics g) {
        Random r = new Random();
        if (!s_isInitRain) {
            for (int i = 0; i < 40; ++i) {
                Scene.s_snowX[i] = i * 10;
                Scene.s_snowY[i] = r.nextInt() % 100 * this.viewH / 100 + this.viewY;
                Scene.s_snowBulk[i] = (byte)(r.nextInt() % 6);
            }
            s_isInitRain = true;
            return;
        }
        g.setColor(0xFFFFFF);
        for (int i = 0; i < 40; ++i) {
            if (s_isChangeSnow) {
                if (s_snowBulk[i] == 0) {
                    int n = i;
                    s_snowY[n] = s_snowY[n] - 30;
                } else {
                    int n = i;
                    s_snowY[n] = s_snowY[n] - 40;
                }
                Scene.s_snowY[i] = (s_snowY[i] - this.viewY + this.viewH) % this.viewH + this.viewY;
            }
            if (s_snowBulk[i] == 0) {
                g.drawLine(s_snowX[i] - this.viewX, s_snowY[i] - this.viewY, s_snowX[i] - this.viewX, s_snowY[i] - this.viewY + 16);
                continue;
            }
            g.drawLine(s_snowX[i] - this.viewX, s_snowY[i] - this.viewY, s_snowX[i] - this.viewX, s_snowY[i] - this.viewY + 16);
        }
    }

    private void drawSnow(Graphics g) {
        Random r = new Random();
        if (!s_isInitSnow) {
            for (int i = 0; i < 120; ++i) {
                Scene.s_snowX[i] = r.nextInt() % 100 * this.viewW / 100 + this.viewX;
                Scene.s_snowY[i] = r.nextInt() % 100 * this.viewH / 100 + this.viewY;
                Scene.s_snowSpeedX[i] = r.nextInt() % 2;
                Scene.s_snowBulk[i] = (byte)(r.nextInt() % 2);
            }
            s_isInitSnow = true;
            return;
        }
        g.setColor(255, 255, 255);
        if (s_isChangeSnow) {
            if (s_snowWindCount > 1) {
                --s_snowWindCount;
            } else {
                s_snowWindCount = 20 + r.nextInt() % 8;
                s_snowWind = r.nextInt() % 2;
                while (s_snowWind == 0) {
                    s_snowWind = r.nextInt() % 2;
                }
            }
        }
        for (int i = 0; i < 120; ++i) {
            if (s_isChangeSnow) {
                int n = i;
                s_snowX[n] = s_snowX[n] + s_snowSpeedX[i];
                int n2 = i;
                s_snowY[n2] = s_snowY[n2] + 1;
                Scene.s_snowX[i] = (s_snowX[i] - this.viewX + this.viewW) % this.viewW + this.viewX;
                Scene.s_snowY[i] = (s_snowY[i] - this.viewY + this.viewH) % this.viewH + this.viewY;
            }
            if (s_snowBulk[i] != 0) {
                g.drawLine(s_snowX[i] - this.viewX, s_snowY[i] - this.viewY, s_snowX[i] - this.viewX, s_snowY[i] - this.viewY);
                continue;
            }
            g.drawRect(s_snowX[i] - this.viewY, s_snowY[i] - this.viewY, 1, 1);
        }
    }

    private void drawRain(Graphics g) {
        Random r = new Random();
        if (!s_isInitRain) {
            for (int i = 0; i < RAINPIXELNUMBER * 2; ++i) {
                Scene.s_snowX[i] = i * 8;
                Scene.s_snowY[i] = r.nextInt() % 100 * this.viewH / 100 + this.viewY;
                Scene.s_snowSpeedY[i] = 10 + r.nextInt() % 6;
                Scene.s_snowSpeedX[i] = Math.abs(3 + r.nextInt() % 5);
                Scene.s_snowBulk[i] = (byte)(r.nextInt() % 6);
            }
            s_isInitRain = true;
            return;
        }
        g.setColor(0xE6E6E6);
        if (s_isChangeSnow && s_snowWindCount <= 1) {
            s_snowWindCount = 20 + r.nextInt() % 80;
            s_snowWind = Math.abs(r.nextInt() % 5);
        }
        for (int i = 0; i < RAINPIXELNUMBER * 2; ++i) {
            if (s_isChangeSnow) {
                if (s_snowBulk[i] == 0) {
                    int n = i;
                    s_snowY[n] = s_snowY[n] + 5;
                    int n2 = i;
                    s_snowX[n2] = s_snowX[n2] - 3;
                } else {
                    int n = i;
                    s_snowY[n] = s_snowY[n] + 7;
                    int n3 = i;
                    s_snowX[n3] = s_snowX[n3] - 5;
                }
                Scene.s_snowY[i] = (s_snowY[i] - this.viewY + this.viewH) % this.viewH + this.viewY;
                Scene.s_snowX[i] = (s_snowX[i] - this.viewX + this.viewW) % this.viewW + this.viewX;
                int rnd = r.nextInt() % 10;
                if (rnd > 8) {
                    int n = i;
                    s_snowSpeedX[n] = s_snowSpeedX[n] + 1;
                }
                if (rnd < 2) {
                    int n = i;
                    s_snowSpeedX[n] = s_snowSpeedX[n] - 1;
                }
                if (s_snowSpeedX[i] < 0) {
                    Scene.s_snowSpeedX[i] = 0;
                }
                if (s_snowSpeedX[i] > 5) {
                    Scene.s_snowSpeedX[i] = 4;
                }
            }
            if (s_snowBulk[i] == 0) {
                g.drawLine(s_snowX[i] - this.viewX, s_snowY[i] - this.viewY, s_snowX[i] - this.viewX - 1, s_snowY[i] - this.viewY + 1);
                continue;
            }
            g.drawLine(s_snowX[i] - this.viewX, s_snowY[i] - this.viewY, s_snowX[i] - this.viewX - 7, s_snowY[i] - this.viewY + 13);
        }
    }

    public void updateView() {
        if (this.viewActor != null) {
            this.destViewX = this.viewActor.posX - (this.viewW >> 1);
            this.destViewY = this.viewActor.posY - (this.viewH >> 1);
        }
        if (this.viewX < this.destViewX) {
            this.viewX += this.viewSpeed;
            if (this.viewX > this.destViewX) {
                this.viewX = this.destViewX;
            }
        }
        if (this.viewX > this.destViewX) {
            this.viewX -= this.viewSpeed;
            if (this.viewX < this.destViewX) {
                this.viewX = this.destViewX;
            }
        }
        if (this.viewY < this.destViewY) {
            this.viewY += this.viewSpeed;
            if (this.viewY > this.destViewY) {
                this.viewY = this.destViewY;
            }
        }
        if (this.viewY > this.destViewY) {
            this.viewY -= this.viewSpeed;
            if (this.viewY < this.destViewY) {
                this.viewY = this.destViewY;
            }
        }
        if (this.forceView || !this.smoothView) {
            this.viewX = this.destViewX;
            this.viewY = this.destViewY;
            this.forceView = false;
        }
        this.setViewPort(this.viewX, this.viewY);
    }

    public void updateLogic(Graphics g) {
        if (this.bg != null) {
            this.bg.tick();
        }
        this.keyLogic();
        this.sceneLogic();
        for (int i = this.actorCount - 1; i >= 0; --i) {
            Actor a2 = this.actors[i];
            if (!a2.enabled) continue;
            a2.updatePos();
            a2.doAI();
            a2.nextFrame();
        }
    }

    public void updateFrame() {
        if (this.bg != null) {
            this.bg.tick();
        }
        for (int i = this.actorCount - 1; i >= 0; --i) {
            Actor a2 = this.actors[i];
            if (!a2.enabled) continue;
            a2.nextFrame();
        }
    }

    public void updateActorList() {
        Actor a2;
        this.activeCount = 0;
        for (int i = 0; i < this.actorCount; ++i) {
            a2 = this.actors[i];
            if (a2 == null || !a2.needDraw || !a2.enabled) continue;
            this.activeList[this.activeCount++] = a2;
        }
        this.drawCount = 0;
        for (int i = 0; i < this.activeCount; ++i) {
            int insertPos;
            a2 = this.activeList[i];
            if (!a2.needDraw || !a2.visible) continue;
            for (insertPos = 0; insertPos < this.drawCount && this.drawList[insertPos].posY < a2.posY; ++insertPos) {
            }
            for (int ii = this.drawCount; ii > insertPos; --ii) {
                this.drawList[ii] = this.drawList[ii - 1];
            }
            this.drawList[insertPos] = a2;
            ++this.drawCount;
        }
    }

    public void setViewActor(Actor viewActor) {
        this.oldViewActor = this.viewActor;
        this.viewActor = viewActor;
    }

    public void setViewPort(int viewX, int viewY) {
        this.viewX = Tools.limit(viewX, this.viewLimitX, this.viewLimitW);
        this.viewY = Tools.limit(viewY, this.viewLimitY, this.viewLimitH);
        if (this.bg != null) {
            this.bg.setViewPort(this.viewX, this.viewY);
        }
    }

    public Actor getActor(int animId, boolean isIdle) {
        Actor objectActor = null;
        for (int i = this.actorCount - 1; i >= 0; --i) {
            if (this.actors[i] == null || this.actors[i].animId != animId || isIdle && this.actors[i].enabled) continue;
            objectActor = this.actors[i];
            break;
        }
        return objectActor;
    }

    public void setActor(Actor actor, int actionId, int x, int y) {
        if (actor == null) {
            return;
        }
        actor.enabled = true;
        actor.visible = true;
        actor.needDraw = true;
        actor.setAction(actionId, true);
        actor.prevPosX = actor.posX;
        actor.prevPosY = actor.posY;
        actor.posX = x;
        actor.posY = y;
        this.followTeamLink();
        if (actor.landingActor()) {
            actor.layer = 1;
        }
        if (actor == this.player) {
            if (actionId < 8) {
                Actor.followMode = 0;
                actor.layer = 1;
                this.followTeamLink();
            } else {
                Actor.followMode = 2;
                actor.layer = 2;
                this.followTeamLink();
            }
        }
    }

    public Actor addActor(Actor actor, int actionId, int x, int y) {
        Actor a2 = this.getActor(actor.animId, true);
        if (a2 == null) {
            a2 = actor.clone();
            if (this.actors.length == this.actorCount) {
                Actor[] newActors = new Actor[this.actorCount + 10];
                System.arraycopy(this.actors, 0, newActors, 0, this.actors.length);
                this.actors = null;
                this.actors = newActors;
            }
            a2.id = (short)this.actorCount;
            this.actors[this.actorCount] = a2;
            ++this.actorCount;
        }
        this.setActor(a2, actionId, x, y);
        return a2;
    }

    public void runTrailer(int trailerMode, int trailerId) {
        GameCanvas gc = World.gameCanvas;
        Graphics g = gc.getGraphics();
        int oldfm = Actor.followMode;
        int oldAction = this.player.actionIDNow;
        Actor.followMode = 0;
        this.player.landingActor();
        if (this.player.landingActor()) {
            this.player.layer = 1;
            Actor.followMode = 0;
        }
        this.curTrailer = this.trailerData[trailerId];
        this.curTrailerFrameId = 0;
        this.trailerEnd = false;
        this.initTrailer(this.curTrailer);
        this.initTrigger();
        this.curTriggerData = this.trailerActionData[trailerId];
        this.curDataIndex = 1;
        if (trailerMode == 1) {
            this.beginTrailer(g, trailerMode);
        } else if (trailerMode == 2) {
            this.beginTrailer(g, trailerMode);
        }
        while (!this.trailerEnd) {
            long tick = System.currentTimeMillis() + 80L;
            this.updateTrailer(this.curTrailer, this.curTrailerFrameId++);
            this.draw(g);
            gc.flush();
            while (tick > System.currentTimeMillis()) {
                Thread.yield();
            }
        }
        if (World.gameStatus == 1) {
            return;
        }
        if (trailerMode == 1) {
            this.endTrailer(g, trailerMode);
        } else if (trailerMode == 2) {
            this.endTrailer(g, trailerMode);
        }
        this.endTrigger();
        Actor.followMode = oldMode;
        if (oldMode == 2) {
            this.player.actionIDNow = (this.player.actionIDNow + 8) % 12;
        }
        if (this.player != null) {
            this.player.phylayer = 0;
            this.player.landingActor();
            Actor.followMode = 0;
            this.player.actionIDNow %= 8;
        }
        this.followTeamLink();
        this.setViewActor(this.oldViewActor);
        GameCanvas.updateKeyEnd();
    }

    public void initTrailer(short[][] trailer) {
        for (int i = 0; i < trailer.length; ++i) {
            short[] sArray = trailer[i];
            sArray[0] = (short)(sArray[0] & 0xFFFF7FFF);
            Actor actor = this.actors[trailer[i][0]];
            if (i == 0) {
                this.setViewActor(actor);
            }
            trailer[i][2] = (short)actor.posX;
            trailer[i][3] = (short)actor.posY;
            if ((actor.flag & 0x20) == 0) continue;
            actor.layer = 1;
            actor.landingActor();
        }
    }

    public void beginTrailer(Graphics g, int cover_up) {
        if (cover_up == 2) {
            this.trailerModeHeight = this.viewH / 6;
            this.draw(g);
            World.gameCanvas.flush();
        } else {
            this.trailerModeHeight = 0;
            while (this.trailerModeHeight < this.viewH / 6) {
                this.trailerModeHeight += 2;
                if (this.trailerModeHeight > this.viewH / 6) {
                    this.trailerModeHeight = this.viewH / 6;
                }
                this.draw(g);
                World.gameCanvas.flush();
                World.waitAnyTime(60L);
            }
        }
    }

    public void endTrailer(Graphics g, int cover_up) {
        if (cover_up == 2) {
            this.trailerModeHeight = 0;
            this.draw(g);
            World.gameCanvas.flush();
        } else {
            while (this.trailerModeHeight > 0) {
                this.trailerModeHeight -= 2;
                if (this.trailerModeHeight < 0) {
                    this.trailerModeHeight = 0;
                }
                this.draw(g);
                World.gameCanvas.flush();
                World.waitAnyTime(60L);
            }
        }
    }

    public void updateTrailer(short[][] trailer, int frame) {
        if (this.bg != null) {
            this.bg.tick();
        }
        for (int i = 0; i < trailer.length; ++i) {
            boolean isCamera = i == 0;
            this.updateTrailerActor(trailer[i], frame, isCamera);
        }
    }

    public void updateTrailerActor(short[] thread, int frame, boolean isCamera) {
        short keyframe_flag;
        if ((thread[0] & 0x8000) != 0) {
            return;
        }
        Actor actor = this.actors[thread[0]];
        int keyframe = -1;
        int nextkeyframe = -1;
        for (int k = 1; k < thread.length; k += 5) {
            if (frame < thread[k + 0]) {
                nextkeyframe = k;
                break;
            }
            keyframe = k;
        }
        if (((keyframe_flag = thread[keyframe + 3]) & 0x4000) != 0) {
            actor.enabled = false;
        }
        if ((keyframe_flag & 0x8000) != 0) {
            actor.visible = false;
        } else {
            actor.visible = true;
            actor.needDraw = true;
        }
        actor.flipX = (keyframe_flag & 0x2000) != 0;
        actor.flipY = (keyframe_flag & 0x1000) != 0;
        int posX = actor.posX;
        int posY = actor.posY;
        if (nextkeyframe > 0) {
            posX += (thread[nextkeyframe + 1] - posX) / (thread[nextkeyframe + 0] - frame);
            posY += (thread[nextkeyframe + 2] - posY) / (thread[nextkeyframe + 0] - frame);
        }
        int actionId = thread[keyframe + 3] & 0xFF;
        int frameId = frame - thread[keyframe + 0];
        actor.setActionFrame(actionId, frameId);
        actor.posX = posX;
        actor.posY = posY;
        short command = thread[keyframe + 4];
        if (command > -1 && frame == thread[keyframe + 0]) {
            short size = this.curTriggerData[this.curDataIndex++];
            short commandId = this.curTriggerData[this.curDataIndex++];
            this.executeAction(commandId);
        }
        if (isCamera) {
            if (nextkeyframe < 0) {
                this.trailerEnd = true;
            } else if (thread[nextkeyframe + 0] - thread[keyframe + 0] <= 1) {
                this.bg.updateBg = true;
            }
        }
    }

    public void fireEvent(int eventId) {
        if (this.triggerEventList == null) {
            return;
        }
        for (int i = 0; i < this.triggerEventList.length; ++i) {
            for (int j = 0; j < this.triggerEventList[i].length; ++j) {
                if (eventId != this.triggerEventList[i][j]) continue;
                this.initTrigger();
                this.curTriggerData = this.triggerData[i];
                this.curDataIndex = 0;
                this.triggerEnd = false;
                this.runTrigger();
                this.endTrigger();
            }
        }
    }

    public void initTrigger() {
        this.recursionTriggerData[this.recursionLevel] = this.curTriggerData;
        this.recursionDataIndex[this.recursionLevel] = this.curDataIndex;
        this.recursionLevel = (byte)(this.recursionLevel + 1);
    }

    public void endTrigger() {
        this.recursionLevel = (byte)(this.recursionLevel - 1);
        this.curTriggerData = this.recursionTriggerData[this.recursionLevel];
        this.curDataIndex = this.recursionDataIndex[this.recursionLevel];
    }

    public void runTrigger() {
        boolean canTrigger = this.getCondition();
        if (!canTrigger) {
            return;
        }
        int actionCount = this.curTriggerData[this.curDataIndex++];
        oldMode = Actor.followMode;
        for (int i = 0; i < actionCount && !this.triggerEnd; ++i) {
            short size = this.curTriggerData[this.curDataIndex++];
            short actionId = this.curTriggerData[this.curDataIndex++];
            this.executeAction(actionId);
        }
    }

    public boolean getCondition() {
        boolean result = true;
        int condType = this.getShort();
        if (condType == 0) {
            int leftValue = this.getParameter();
            int operator = this.getShort();
            int rightValue = this.getParameter();
            switch (operator) {
                case 0: {
                    if (leftValue == rightValue) {
                        result = true;
                        break;
                    }
                    result = false;
                    break;
                }
                case 1: {
                    if (leftValue != rightValue) {
                        result = true;
                        break;
                    }
                    result = false;
                    break;
                }
                case 2: {
                    if (leftValue < rightValue) {
                        result = true;
                        break;
                    }
                    result = false;
                    break;
                }
                case 3: {
                    if (leftValue > rightValue) {
                        result = true;
                        break;
                    }
                    result = false;
                    break;
                }
                case 4: {
                    if (leftValue <= rightValue) {
                        result = true;
                        break;
                    }
                    result = false;
                    break;
                }
                case 5: {
                    if (leftValue >= rightValue) {
                        result = true;
                        break;
                    }
                    result = false;
                    break;
                }
                default: {
                    result = false;
                    break;
                }
            }
        } else if (condType == 1) {
            result = true;
            int size = this.getShort();
            for (int i = 0; i < size; ++i) {
                if (this.getCondition()) continue;
                result = false;
            }
        } else {
            result = false;
            int size = this.getShort();
            for (int i = 0; i < size; ++i) {
                if (!this.getCondition()) continue;
                result = true;
            }
        }
        return result;
    }

    public int getShort() {
        return this.curTriggerData[this.curDataIndex++];
    }

    public boolean getBooleanParam() {
        return this.getParameter() == 1;
    }

    public int getParameterValue(int type, int result) {
        switch (type) {
            case 2: {
                return World.vars[result];
            }
            case 1: {
                return this.getFunctionValue(result);
            }
        }
        return result;
    }

    public int getParameter() {
        int type = this.getShort();
        int value = this.getShort();
        return this.getParameterValue(type, value);
    }

    public void setVariable(int value) {
        int type = this.getShort();
        World.vars[this.getShort()] = value;
    }

    public int getFunctionValue(int functionId) {
        switch (functionId) {
            case 0: {
                return this.frameCount;
            }
            case 1: {
                return this.eventActorClass;
            }
            case 2: {
                return this.eventActorId;
            }
            case 3: {
                return this.eventActorAction;
            }
            case 4: {
                return this.collideActorClass;
            }
            case 5: {
                return this.collideActorId;
            }
            case 6: {
                return this.collideActorAction;
            }
            case 7: {
                return this.activateActorClass;
            }
            case 8: {
                return this.activateActorId;
            }
            case 9: {
                return this.activateActorAction;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                int keyPressed = 1 << functionId - 10;
                if (GameCanvas.haveKeyPressed(keyPressed)) {
                    return 1;
                }
                return 0;
            }
            case 24: {
                return GameCanvas.SCREEN_WIDTH;
            }
            case 25: {
                return GameCanvas.SCREEN_HEIGHT;
            }
            case 26: {
                return 0;
            }
            case 27: {
                return 0;
            }
            case 28: {
                return 0;
            }
            case 29: {
                return 0;
            }
        }
        return functionId;
    }

    public void skip(int size) {
        this.curDataIndex += size;
    }

    public void skipAction() {
        this.getShort();
        int count = this.getShort();
        int size = 0;
        for (int i = 0; i < count; ++i) {
            size = this.getShort() >> 1;
            this.skip(size);
        }
    }

    public void executeAction(int actionId) {
        block0 : switch (actionId) {
            case 0: {
                int value = this.getParameter();
                if (value == 0) {
                    return;
                }
                World.waitAnyTime(value);
                break;
            }
            case 1: {
                int type = this.getShort();
                int value = this.getShort();
                if (type == 2) {
                    World.vars[value] = this.getParameter();
                    break;
                }
                this.skip(2);
                break;
            }
            case 2: {
                int type = this.getShort();
                int value = this.getShort();
                if (type == 2) {
                    World.vars[value] = Tools.random(this.getParameter(), this.getParameter());
                    break;
                }
                this.skip(4);
                break;
            }
            case 3: {
                int type = this.getShort();
                int value = this.getShort();
                if (type == 2) {
                    World.vars[value] = this.computeVariable(this.getParameter(), this.getParameter(), this.getParameter());
                    break;
                }
                this.skip(6);
                break;
            }
            case 4: {
                this.getShort();
                boolean cond = this.getCondition();
                int actionCount = 0;
                if (cond) {
                    this.getShort();
                    actionCount = this.getShort();
                    for (int i = 0; i < actionCount; ++i) {
                        this.getShort();
                        int value = this.getShort();
                        this.executeAction(value);
                    }
                    this.skipAction();
                    break;
                }
                this.skipAction();
                this.getShort();
                actionCount = this.getShort();
                for (int i = 0; i < actionCount; ++i) {
                    this.getShort();
                    int value = this.getShort();
                    this.executeAction(value);
                }
                break;
            }
            case 5: {
                this.setViewActor(this.actors[this.getParameter()]);
                break;
            }
            case 6: {
                this.player = this.actors[this.getParameter()];
                this.setViewActor(this.player);
                break;
            }
            case 7: {
                int value = this.getParameter();
                this.setActor(this.actors[value], this.getParameter(), this.getParameter(), this.getParameter());
                break;
            }
            case 8: {
                int value = this.getParameter();
                this.actors[value].enabled = true;
                this.actors[value].visible = true;
                this.actors[value].setAction(this.getParameter(), false);
                break;
            }
            case 9: {
                this.getShort();
                int value = this.getShort();
                World.vars[value] = this.actors[this.getParameter()].actionIDNow;
                break;
            }
            case 10: {
                int value = this.getParameter();
                this.actors[value].prevPosX = this.actors[value].posX;
                this.actors[value].prevPosY = this.actors[value].posY;
                this.actors[value].posX = this.getParameter();
                this.actors[value].posY = this.getParameter();
                break;
            }
            case 11: {
                this.getShort();
                int type = this.getShort();
                this.getShort();
                int value = this.getShort();
                int aId = this.getParameter();
                World.vars[type] = this.actors[aId].posX;
                World.vars[value] = this.actors[aId].posY;
                break;
            }
            case 12: {
                int value = this.getParameter();
                this.actors[value].setFlag(this.getParameter(), this.getParameter() != 0);
                break;
            }
            case 13: {
                this.getShort();
                int value = this.getShort();
                World.vars[value] = this.actors[this.getParameter()].getFlag(this.getParameter()) ? 1 : 0;
                break;
            }
            case 14: {
                this.actors[this.getParameter()].setParameter(this.getParameter(), this.getParameter());
                break;
            }
            case 15: {
                this.getShort();
                int value = this.getShort();
                World.vars[value] = this.actors[this.getParameter()].getParameter(this.getParameter());
                break;
            }
            case 16: {
                int value = this.getParameter();
                this.actors[value].setFlag(1024, true);
                this.actors[value].destX = this.getParameter();
                this.actors[value].destY = this.getParameter();
                this.actors[value].velocity = this.getParameter();
                this.actors[value].vX = this.actors[value].posX < this.actors[value].destX ? Math.abs(this.actors[value].velocity) : -Math.abs(this.actors[value].velocity);
                if (this.actors[value].posY < this.actors[value].destY) {
                    this.actors[value].vY = Math.abs(this.actors[value].velocity);
                    break;
                }
                this.actors[value].vY = -Math.abs(this.actors[value].velocity);
                break;
            }
            case 17: {
                int value = this.getParameter();
                this.actors[value].setFlag(1024, true);
                this.actors[value].destX = this.getParameter();
                this.actors[value].destY = this.getParameter();
                this.actors[value].velocity = this.getParameter();
                this.actors[value].vX = this.actors[value].posX < this.actors[value].destX ? Math.abs(this.actors[value].velocity) : -Math.abs(this.actors[value].velocity);
                this.actors[value].vY = this.actors[value].posY < this.actors[value].destY ? Math.abs(this.actors[value].velocity) : -Math.abs(this.actors[value].velocity);
                this.moveActorTo(this.actors[value]);
                break;
            }
            case 18: {
                int value = this.getParameter();
                this.actors[value].enabled = true;
                this.actors[value].visible = true;
                this.actors[value].setAction(this.getParameter(), true);
                this.playActorAction(this.actors[value]);
                break;
            }
            case 19: {
                this.addActor(this.actors[this.getParameter()], this.getParameter(), this.getParameter(), this.getParameter());
                break;
            }
            case 20: {
                this.addActor(this.actors[this.getParameter()], this.getParameter(), this.getParameter(), this.getParameter());
                break;
            }
            case 21: {
                this.actors[this.getParameter()].setEnabled(false);
                break;
            }
            case 22: {
                this.getShort();
                int value = this.getShort();
                Actor actor = this.getActor(this.actors[this.getParameter()].animId, true);
                World.vars[value] = actor == null ? -1 : (int)actor.id;
                break;
            }
            case 23: {
                this.getShort();
                int value = this.getShort();
                Actor actor = this.getActor(this.getParameter(), true);
                World.vars[value] = actor == null ? -1 : (int)actor.id;
                break;
            }
            case 24: {
                this.runTrailer(this.getParameter(), this.getParameter());
                break;
            }
            case 25: {
                Actor.followMode = 0;
                World.loadLevel(this.getParameter(), this.getParameter(), this.getParameter(), this.getParameter());
                break;
            }
            case 26: {
                this.draw(World.g);
                String name = this.texts[this.getParameter()];
                int face = this.getParameter();
                int facial = this.getParameter();
                String text = this.texts[this.getParameter()];
                this.showDialog(face, facial, name, text);
                break;
            }
            case 27: {
                this.draw(World.g);
                int value = this.getParameter();
                UI.showMessage3(World.g, this.texts[this.getParameter()], value, 1);
                break;
            }
            case 28: {
                this.draw(World.g);
                int value = this.getParameter();
                int w = GameCanvas.SCREEN_WIDTH > 180 ? Math.min(200, GameCanvas.SCREEN_WIDTH) : (GameCanvas.SCREEN_WIDTH > 340 ? Math.min(360, GameCanvas.SCREEN_WIDTH) : (GameCanvas.SCREEN_WIDTH > 260 ? Math.min(280, GameCanvas.SCREEN_WIDTH) : Math.min(140, GameCanvas.SCREEN_WIDTH)));
                UI.showPoem(this, World.g, this.texts[this.getParameter()], 100, value, (this.viewW - w) / 2, (this.viewH - w) / 2, w, w, 18, 18);
                break;
            }
            case 29: {
                this.showFace(this.getParameter(), this.getParameter(), this.getParameter(), this.getParameter(), this.getParameter(), this.getParameter(), this.getParameter(), this.getParameter(), this.getBooleanParam());
                break;
            }
            case 30: {
                this.flashScreen(this.getParameter(), this.getParameter());
                break;
            }
            case 31: 
            case 32: {
                this.screenFade(actionId == 31, this.getParameter());
                break;
            }
            case 33: {
                GameCanvas.shakeFrame = this.getParameter();
                Tools.Vibrate(500);
                break;
            }
            case 34: 
            case 35: {
                int value = this.getParameter();
                if (actionId == 34) {
                    this.effectId |= 1 << value;
                    this.effectOn = true;
                    this.draw(World.g);
                    World.gameCanvas.flush();
                    World.waitAnyTime(50L);
                    break;
                }
                this.effectId &= ~(1 << value);
                if (this.effectId != 0) break;
                this.effectOn = false;
                break;
            }
            case 36: {
                this.getParameter();
                this.triggerEnd = true;
                break;
            }
            case 37: {
                int type = this.getShort();
                int value = this.getShort();
                if (type == 2) {
                    this.skip(2);
                    this.getParameter();
                    this.draw(World.g);
                    World.vars[value] = UI.showSelector(World.gameCanvas.getGraphics(), this.texts[this.getParameter()], Tools.splitString(this.texts[this.getParameter()], '|', GameCanvas.SCREEN_WIDTH), true, false);
                    break;
                }
                this.skip(6);
                break;
            }
            case 38: {
                int type = this.getShort();
                int value = this.getShort();
                if (type == 2) {
                    World.vars[value] = UI.showConfirm(World.g, this.texts[this.getParameter()]) ? 1 : 0;
                    break;
                }
                this.skip(2);
                break;
            }
            case 39: {
                World.soundConfirm();
                if (Tools.soundOn) {
                    Tools.playSound(Tools.currentSoundID, Tools.soundLoop);
                    break;
                }
                Tools.stopSound();
                break;
            }
            case 40: {
                Tools.playSound(this.getParameter(), this.getParameter() == 0);
                break;
            }
            case 41: {
                int armid = this.getParameter();
                String cgmsg = this.texts[this.getParameter()];
                UI.showCG(armid, cgmsg);
                break;
            }
            case 42: {
                int ret;
                this.getShort();
                int value = this.getShort();
                String msg = this.texts[this.getParameter()];
                int msgid = this.getParameter();
                int gutid = 11;
                if (msgid <= World.hasOpenGut) {
                    World.vars[value] = 1;
                    break;
                }
                boolean success = true;
                World.vars[value] = ret = success ? 1 : 0;
                if (!success) break;
                World.hasOpenGut = 2;
                World.myteam.gold += 1000;
                World.saveRecord(2);
                break;
            }
            case 43: {
                int id = Integer.parseInt(this.texts[this.getParameter()]);
                this.gotoWebGetHeaven(id);
                break;
            }
            case 44: {
                break;
            }
            case 45: {
                break;
            }
            case 46: 
            case 47: {
                UI.showHelpAbout(World.g, this.texts[this.getParameter()], actionId == 47);
                break;
            }
            case 48: {
                World.destroy();
                break;
            }
            case 49: {
                break;
            }
            case 50: {
                World.gameover = true;
                World.saveRecord(2);
                UI.showStaff(World.g);
                this.getParameter();
                World.loadLevel(0, -1, -1, -1);
                break;
            }
            case 51: {
                this.getShort();
                int var = this.getShort();
                World.vars[var] = World.human[this.getParameter()].getArm((int)0).id;
                break;
            }
            case 52: {
                int id = this.getParameter();
                Mate mate = World.human[id];
                mate.arms[1] = -1;
                mate.arms[2] = -1;
                if (id == 0) {
                    World.myteam.addArm(0, 1);
                    World.myteam.addArm(32, 1);
                }
                if (id != 1) break;
                World.myteam.addArm(11, 1);
                World.myteam.addArm(33, 1);
                break;
            }
            case 53: {
                this.getShort();
                int var = this.getShort();
                World.vars[var] = World.human[this.getParameter()].agree;
                break;
            }
            case 54: {
                Mate mate = World.human[this.getParameter()];
                mate.agree = (short)(mate.agree + this.getParameter());
                break;
            }
            case 55: {
                this.setVariable(World.myteam.gold);
                break;
            }
            case 56: {
                World.myteam.gold += this.getParameter();
                break;
            }
            case 57: {
                int value = this.getParameter();
                Mate mate = World.human[this.getParameter()];
                int index = this.getParameter();
                switch (index) {
                    case 8: {
                        if (mate.level > value) {
                            mate.calcUpLevelAttribute(-mate.level);
                        } else {
                            mate.calcUpLevelAttribute(value);
                        }
                        mate.level = value;
                    }
                }
                mate.refreshAttribute();
                mate.recoverAttribute();
                break;
            }
            case 58: {
                Mate mate = World.human[this.getParameter()];
                int index = this.getParameter();
                int value = this.getParameter();
                switch (index) {
                    case 1: {
                        mate.e_minatt += value;
                        break;
                    }
                    case 0: {
                        mate.e_maxatt += value;
                        break;
                    }
                    case 2: {
                        mate.e_hp += value;
                        break;
                    }
                    case 3: {
                        mate.e_mp += value;
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        mate.e_define += value;
                        break;
                    }
                    case 6: {
                        mate.e_breakhit += value;
                        break;
                    }
                    case 7: {
                        mate.e_jink += value;
                    }
                }
                mate.refreshAttribute();
                break;
            }
            case 75: {
                Mate mate = World.human[this.getParameter()];
                int index = this.getParameter();
                int value = this.getParameter();
                switch (index) {
                    case 1: {
                        mate.e_minatt = value;
                        break;
                    }
                    case 0: {
                        mate.e_maxatt = value;
                        break;
                    }
                    case 2: {
                        mate.e_hp = value;
                        break;
                    }
                    case 3: {
                        mate.e_mp = value;
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        mate.e_define = value;
                        break;
                    }
                    case 6: {
                        mate.e_breakhit = value;
                        break;
                    }
                    case 7: {
                        mate.e_jink = value;
                    }
                }
                mate.refreshAttribute();
                break;
            }
            case 59: {
                int ret;
                this.getShort();
                int var = this.getShort();
                World.vars[var] = ret = World.myteam.getArticalCount(this.getParameter(), this.getParameter());
                break;
            }
            case 60: {
                int type = this.getParameter();
                int id = this.getParameter();
                int count = this.getParameter();
                switch (type) {
                    case 0: {
                        if (count < 0) {
                            World.myteam.delArm((short)id, -count);
                            break;
                        }
                        World.myteam.addArm(id, count);
                        break;
                    }
                    case 1: {
                        if (count < 0) {
                            World.myteam.delItem(id, -count);
                            break;
                        }
                        World.myteam.addItem(id, count);
                    }
                }
                break;
            }
            case 61: {
                World.human[this.getParameter()].exp += this.getParameter();
                break;
            }
            case 78: {
                World.human[this.getParameter()].exp = 0;
                break;
            }
            case 62: {
                Mate mate = World.human[this.getParameter()];
                mate.addSkill((short)this.getParameter());
                break;
            }
            case 77: {
                Mate mate = World.human[this.getParameter()];
                mate.delSkill((short)this.getParameter());
                break;
            }
            case 63: {
                int ret;
                boolean successful = this.player.landingActor();
                if (successful) {
                    this.player.layer = 1;
                }
                this.getShort();
                int varid = this.getShort();
                int etid = this.getParameter();
                int other = this.getParameter();
                int flag = 0;
                if (this.getBooleanParam()) {
                    flag |= 2;
                }
                if (this.getBooleanParam()) {
                    flag |= 8;
                }
                if (this.getBooleanParam()) {
                    flag |= 4;
                }
                if (this.getBooleanParam()) {
                    flag |= 0x10;
                }
                if (this.getBooleanParam()) {
                    flag |= 0x20;
                }
                if (this.getBooleanParam()) {
                    flag |= 0x40;
                    BiBai = true;
                }
                if (this.getBooleanParam()) {
                    flag |= 0x80;
                }
                if (this.getBooleanParam()) {
                    flag |= 0x100;
                }
                if (this.getBooleanParam()) {
                    flag |= 0x200;
                }
                String name = this.texts[this.getParameter()];
                String msg = this.texts[this.getParameter()];
                int faceId = this.getParameter();
                int facial = this.getParameter();
                World.scene.flash(World.g, 5, 0);
                UI.drawLoading(5);
                Battle battle = new Battle();
                battle.setBattleMessage(name, faceId, facial, msg);
                World.vars[varid] = ret = battle.enterBattle(etid, flag, other);
                battle = null;
                if (ret != 2) break;
                if ((Battle.battleFlag & 8) != 0) {
                    World.myteam.reliveAll();
                    break;
                }
                if ((Battle.battleFlag & 0x40) != 0 || other == 1) break;
                UI.showMessage(World.g, "\u6280\u4e0d\u5982\u4eba,\u996e\u6068\u800c\u7ec8", -1, 3);
                World.loadLevel(0, -1, -1, -1);
                this.trailerEnd = true;
                break;
            }
            case 64: {
                for (int i = 0; i < World.myteam.existcount; ++i) {
                    World.myteam.mates[i].recoverAttribute();
                }
                break;
            }
            case 65: {
                int id = this.getParameter();
                this.showShop(id);
                break;
            }
            case 66: {
                this.getShort();
                int var = this.getShort();
                int id = this.getParameter();
                boolean isInTeam = false;
                for (int i = 0; i < World.myteam.existcount; ++i) {
                    if (World.myteam.mates[i].id != id) continue;
                    isInTeam = true;
                }
                World.vars[var] = isInTeam ? 1 : 0;
                break;
            }
            case 67: {
                World.gutmsg = this.texts[this.getParameter()];
                World.gutid = this.getParameter();
                break;
            }
            case 68: {
                World.myteam.addTeamMate((short)this.getParameter());
                this.followTeamLink();
                break;
            }
            case 69: {
                World.myteam.delTeamMate((short)this.getParameter());
                this.followTeamLink();
                break;
            }
            case 70: {
                int mateid = this.getParameter();
                boolean allowbat = this.getBooleanParam();
                if (allowbat) break;
                World.human[mateid].isallowbattle = allowbat;
                break;
            }
            case 71: {
                this.drawAddressCount = 0;
                this.isDrawAddress = true;
                break;
            }
            case 72: {
                int npcid = this.getParameter();
                int sel = UI.showSelector(World.g, "\u662f\u5426\u8981\u8d4c\u535a\uff1f", new String[]{"\u8d4c\u5c31\u8d4c", "\u624b\u6c14\u5dee,\u7b97\u4e86"}, true, false);
                if (sel != 0) break;
                while (this.showRoll(npcid)) {
                    World.scene.drawIfAvaiable();
                    sel = UI.showSelector(World.g, "\u6709\u80c6\u518d\u8d4c\u5417?", new String[]{"\u8d4c\u5c31\u8d4c", "\u624b\u6c14\u5dee,\u7b97\u4e86"}, true, false);
                    if (sel == 0) continue;
                    break block0;
                }
                break;
            }
        }
    }

    private void gotoWebGetHeaven(int id) {
        if (World.WEBSET_GOTO[id] >= 1) {
            return;
        }
    }

    private boolean showRoll(int npcid) {
        int pmt_count = World.myteam.gold;
        int pmt_need = 400;
        if (pmt_count < pmt_need) {
            UI.showMessage(World.g, "\u91d1\u4e0d\u8db3", -1, 0);
            return false;
        }
        World.myteam.gold -= pmt_need;
        UI.showMessage(World.g, "\u62bc\u4e0a400\u94f6", -1, 0);
        int artcount = World.NPC_ROLL_LIST[npcid].length - 1;
        for (int i = 1; i < artcount + 1; ++i) {
            if (Tools.random(99) > World.NPC_ROLL_LIST[npcid][i][0]) continue;
            short unittype = World.NPC_ROLL_LIST[npcid][i][1];
            short unitid = World.NPC_ROLL_LIST[npcid][i][2];
            short unitcount = World.NPC_ROLL_LIST[npcid][i][3];
            Unit unit = Data.getUnitValue(unittype, unitid);
            UI.showMessage(World.g, "\u606d\u559c\u83b7\u5f97" + unit.name + unitcount + '\u4e2a', -1, 0);
            if (unittype == 0) {
                World.myteam.addArm(unitid, unitcount);
            } else {
                World.myteam.addItem(unitid, unitcount);
            }
            return true;
        }
        UI.showMessage(World.g, "\u8840\u672c\u65e0\u5f52", -1, 0);
        return true;
    }

    public int computeVariable(int leftValue, int operator, int rightValue) {
        switch (operator) {
            case 0: {
                return leftValue + rightValue;
            }
            case 1: {
                return leftValue - rightValue;
            }
            case 2: {
                return leftValue * rightValue;
            }
            case 3: {
                return leftValue / rightValue;
            }
        }
        return leftValue + rightValue;
    }

    public void moveActorTo(Actor actor) {
        while (actor.getFlag(1024)) {
            actor.updatePos();
            this.updateFrame();
            this.draw(World.g);
            World.gameCanvas.flush();
            World.waitAnyTime(60L);
        }
    }

    public void playActorAction(Actor actor) {
        while (!actor.actionOver) {
            this.updateFrame();
            this.draw(World.g);
            World.gameCanvas.flush();
            World.waitAnyTime(60L);
        }
    }

    public void drawIfAvaiable() {
        if (this.bg != null && this.anims != null) {
            this.draw(World.g);
        }
    }

    public void showDialog(int faceId, int facial, String name, String text) {
        UI.showDialog(name, text, this, null, 0, faceId);
    }

    private void showFace(int faceId, int facial, int faceHeight, int speed, int acc, int FINAL_SPEED, int waitpos, int waitframe, boolean reverse) {
        Actor face = this.actors[faceId];
        face.setAction(facial, true);
        int pos = 0;
        int FINAL_POS = GameCanvas.SCREEN_WIDTH - face.collideBox[2];
        int faceY = this.viewH / 2;
        faceY += (this.actors[faceId].collideBox[3] - this.actors[faceId].collideBox[1]) / 2;
        Graphics g = World.g;
        GameCanvas.SCREEN_TOP = (this.viewH - faceHeight) / 2;
        GameCanvas.SCREEN_DOWN = GameCanvas.SCREEN_TOP + faceHeight;
        boolean isquit = false;
        while (!isquit && pos < GameCanvas.SCREEN_WIDTH) {
            if (pos >= FINAL_POS * waitpos / 100 && waitframe > 0) {
                pos = FINAL_POS * waitpos / 100;
                --waitframe;
            } else {
                pos += speed;
                speed += acc;
                speed = Math.min(speed, FINAL_SPEED);
            }
            this.drawFaceRect(faceHeight, g);
            if (!reverse) {
                this.actors[faceId].anim.draw(World.g, pos, faceY, this.actors[faceId].flipX, this.actors[faceId].flipY, this.actors[faceId].frameIndex);
            } else {
                this.actors[faceId].anim.draw(World.g, FINAL_POS - pos, faceY, this.actors[faceId].flipX, this.actors[faceId].flipY, this.actors[faceId].frameIndex);
            }
            this.actors[faceId].nextFrame();
            World.gameCanvas.flush();
            World.waitOneFrame();
        }
        GameCanvas.SCREEN_TOP = 0;
        GameCanvas.SCREEN_DOWN = GameCanvas.SCREEN_HEIGHT;
    }

    private void drawFaceRect(int faceHeight, Graphics g) {
        int beginY = (this.viewH - faceHeight) / 2;
        int th = 1;
        int cr = 255;
        int cg = 0;
        int cb = 0;
        for (int tmp = faceHeight; tmp > 0; tmp -= th) {
            cr = Tools.random(100, 255);
            g.setColor(cr, cg, cb);
            th = Tools.random(1, 5);
            if (beginY + th > (this.viewH - faceHeight) / 2 + faceHeight) {
                th = (this.viewH - faceHeight) / 2 + faceHeight - beginY;
            }
            g.fillRect(0, beginY, this.viewW, th);
            beginY += th;
        }
    }

    public void flashScreen(int flashId, int color) {
        Graphics g = World.gameCanvas.getGraphics();
        int flashX = this.viewW / 2;
        int flashY = this.viewH / 2;
        if (flashId < 0) {
            for (int i = 0; i < 3; ++i) {
                g.setColor(0);
                g.fillRect(0, 0, this.viewW, this.viewH);
                World.gameCanvas.flush();
                World.waitAnyTime(60L);
            }
            this.flash(g, 7, color);
            return;
        }
        this.actors[flashId].setAction(this.actors[flashId].actionIDNow, true);
        while (!this.actors[flashId].actionOver) {
            g.setColor(0);
            g.fillRect(0, 0, this.viewW, this.viewH);
            this.actors[flashId].anim.draw(World.g, flashX, flashY, this.actors[flashId].flipX, this.actors[flashId].flipY, this.actors[flashId].frameIndex);
            this.actors[flashId].nextFrame();
            World.gameCanvas.flush();
            World.waitAnyTime(60L);
        }
        this.flash(g, 7, color);
    }

    public void flash(Graphics g, int count, int color) {
        for (int i = 0; i < count; ++i) {
            g.setColor((i & 1) == 0 ? 0 : this.getColor(color));
            g.fillRect(0, 0, this.viewW, this.viewH);
            this.drawTrailerMode(g);
            World.gameCanvas.flush();
            World.waitAnyTime(60L);
        }
    }

    public void screenFade(boolean isFadeIn, int fadeId) {
        Graphics g = World.g;
        if (isFadeIn) {
            this.effectId &= 0xFFFFFFFE;
        }
        if (fadeId == 0) {
            int fade = 0;
            int fade1 = 0;
            int limit = -13;
            limit = this.viewW + 13;
            int limit1 = 0;
            if (isFadeIn) {
                fade = limit;
                fade1 = limit1;
            }
            while (fade >= -13 && fade <= limit) {
                this.draw(g);
                g.setColor(0);
                g.fillRect(0, 0, fade, GameCanvas.SCREEN_HEIGHT);
                g.fillRect(fade + 3, 0, 9, GameCanvas.SCREEN_HEIGHT);
                g.fillRect(fade + 3 + 9 + 7, 0, 4, GameCanvas.SCREEN_HEIGHT);
                g.fillRect(fade1, 0, fade, GameCanvas.SCREEN_HEIGHT);
                g.fillRect(fade1 + 3, 0, 9, GameCanvas.SCREEN_HEIGHT);
                g.fillRect(fade1 + 3 + 9 + 7, 0, 4, GameCanvas.SCREEN_HEIGHT);
                if (isFadeIn) {
                    fade -= 13;
                    fade1 += 13;
                } else {
                    fade += 13;
                    fade1 += 13;
                }
                this.drawTrailerMode(g);
                World.gameCanvas.flush();
                World.waitAnyTime(60L);
            }
        }
        if (!isFadeIn) {
            this.effectOn = true;
            this.effectId |= 1;
        }
    }

    public boolean learnSteal() {
        if (World.isLearnSteal) {
            return true;
        }
        if (Tools.isMdo) {
            if (UI.showConfirm(World.g, "\u5f00\u542f\u79d2\u624b\u7a7a\u7a7a", true)) {
                if (World.myteam.gold > 5000) {
                    World.myteam.gold -= 5000;
                    World.isLearnSteal = true;
                }
                World.saveRecord(2);
                return true;
            }
            UI.showMessage(World.g, "\u6709\u4e9b\u4e1c\u897f\u9519\u8fc7\u5c31\u4e0d\u518d", 20, 1);
            return false;
        }
        if (UI.showSMSPanel(World.g, 8)) {
            System.out.println("\uff01\uff01\uff01\uff01\uff01\uff01\uff013");
            return true;
        }
        UI.showMessage(World.g, "\u6709\u4e9b\u4e1c\u897f\u9519\u8fc7\u5c31\u4e0d\u518d", -1, 1);
        return false;
    }

    public boolean learnFly() {
        if (World.isLearnFly) {
            return true;
        }
        if (UI.showSMSPanel(World.g, 7)) {
            return true;
        }
        UI.showMessage(World.g, "\u811a\u8e0f\u5b9e\u5730\u4e5f\u5f88\u597d", 20, 1);
        return false;
    }

    public void showShop(int id) {
        UI.showGameShop(World.g, id, this);
    }

    public int getColor(int colorId) {
        if (colorId == 0) {
            return 0xFFFFFF;
        }
        if (colorId == 1) {
            return 0xFF0000;
        }
        if (colorId == 2) {
            return 0;
        }
        return 0;
    }

    public void sceneInitialize() {
        this.initResource();
        this.fireEvent(0);
    }

    public void sceneLoaded() {
        GameCanvas gc = World.gameCanvas;
        Graphics g = gc.getGraphics();
        this.draw(g);
        gc.flush();
        Tools.playSound(0, true);
        this.fireEvent(1);
    }

    private void dealGotoWebPrice(Graphics g) {
        for (int id = 0; id < World.WEBSET_GOTO.length; ++id) {
            if (World.WEBSET_GOTO[id] != 1) continue;
            World.myteam.addArm(World.WEBSET_ARM[id], 1);
            UI.showMessage(g, "\u606d\u559c\u60a8\u83b7\u5f97" + Data.getUnitValue((int)0, (int)World.WEBSET_ARM[id]).name, -1, 0);
            World.WEBSET_GOTO[id] = 2;
            World.saveRecord(1);
            World.saveRecord(2);
        }
    }

    public void sceneUnloaded() {
        this.fireEvent(2);
    }

    public void keyLogic() {
        if (World.level != 0) {
            if (GameCanvas.haveKeyPressed(4096)) {
                UI.showTIPS(World.g, this, 0);
                GameCanvas.resetKey();
            } else if (GameCanvas.haveKeyPressed(8192)) {
                UI.showGameMenu(World.g, this);
                GameCanvas.resetKey();
            } else if (GameCanvas.haveKeyPressed(1024)) {
                // empty if block
            }
        }
        if (GameCanvas.anyKeyPressed()) {
            this.fireEvent(8);
        }
    }

    public void sceneLogic() {
        this.fireEvent(3);
    }

    public void followTeamLink() {
        int i;
        Actor t_actor = null;
        short[] tmp = new short[World.myteam.existcount];
        for (i = World.myteam.existcount - 1; i < this.followTeam.length; ++i) {
            if (this.followTeam[i] == null) continue;
            this.followTeam[i].followActor = null;
        }
        for (i = 0; i < tmp.length; ++i) {
            tmp[i] = World.myteam.mates[i].id;
        }
        for (i = 0; i < tmp.length; ++i) {
            if (this.followTeam[tmp[i]] == null) continue;
            if (i == 0) {
                this.player = this.followTeam[tmp[i]];
                this.player.followActor = null;
                this.viewActor = this.player;
                t_actor = this.player;
            } else {
                this.followTeam[tmp[i]].follow(t_actor);
                t_actor = this.followTeam[tmp[i]];
            }
            t_actor.enabled = true;
        }
    }

    static {
        BiBai = false;
        npcNameTextID = -1;
        s_snowX = new int[120];
        s_snowY = new int[120];
        s_snowSpeedY = new int[120];
        s_snowSpeedX = new int[120];
        s_snowBulk = new byte[120];
        s_isInitSnow = false;
        s_isInitRain = false;
        s_isChangeSnow = true;
        s_frameCountOfChangeSnow = 1;
        s_frameCircle = 0;
        RAINPIXELNUMBER = 20;
    }
}

