/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.rmi.xmlrpc;

import de.enough.polish.io.RedirectHttpConnection;
import de.enough.polish.io.xmlrpc.XmlRpcSerializer;
import de.enough.polish.rmi.RemoteClient;
import de.enough.polish.rmi.RemoteException;
import de.enough.polish.rmi.xmlrpc.XmlRpcRemoteException;
import de.enough.polish.util.TextUtil;
import de.enough.polish.xml.XmlDomNode;
import de.enough.polish.xml.XmlDomParser;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;

public class XmlRpcRemoteClient
extends RemoteClient {
    public XmlRpcRemoteClient(String url) {
        super(url);
    }

    protected Object callMethodSynchrone(String name, long primitivesFlag, Object[] parameters) throws RemoteException {
        String dot = "__";
        name = TextUtil.replace(name, dot, ".");
        StringBuffer methodBuffer = new StringBuffer();
        methodBuffer.append("<?xml version=\"1.0\"?>").append("<methodCall>").append("<methodName>").append(name).append("</methodName>");
        if (parameters != null && parameters.length > 0) {
            methodBuffer.append("<params>");
            for (int i = 0; i < parameters.length; ++i) {
                methodBuffer.append("<param><value>");
                Object object = parameters[i];
                try {
                    XmlRpcSerializer.serialize(methodBuffer, object);
                }
                catch (IOException e) {
                    throw new RemoteException(e);
                }
                methodBuffer.append("</value></param>");
            }
            methodBuffer.append("</params>");
        }
        methodBuffer.append("</methodCall>");
        byte[] methodData = methodBuffer.toString().getBytes();
        RedirectHttpConnection connection = null;
        FilterOutputStream out = null;
        FilterInputStream in = null;
        try {
            int read;
            connection = new RedirectHttpConnection(this.url);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "text/xml");
            connection.setRequestProperty("Content-Length", Integer.toString(methodData.length));
            if (this.cookie != null) {
                connection.setRequestProperty("cookie", this.cookie);
            }
            out = connection.openDataOutputStream();
            ((OutputStream)out).write(methodData);
            in = connection.openDataInputStream();
            int status = connection.getResponseCode();
            if (status != 200) {
                throw new RemoteException("Server responded with response code " + status);
            }
            ((DataOutputStream)out).flush();
            String newCookie = connection.getHeaderField("Set-cookie");
            if (newCookie != null) {
                int semicolonPos = newCookie.indexOf(59);
                if (semicolonPos != -1) {
                    newCookie = newCookie.substring(0, semicolonPos);
                }
                this.cookie = newCookie;
            }
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            byte[] readBuffer = new byte[8192];
            while ((read = ((DataInputStream)in).read(readBuffer)) != -1) {
                byteOut.write(readBuffer, 0, read);
            }
            String response = new String(byteOut.toByteArray());
            XmlDomNode node = XmlDomParser.parseTree(response).getChild("methodResponse").getChild(0);
            if (node.getName().equals("fault")) {
                node = node.getChild("value");
                Hashtable struct = (Hashtable)XmlRpcSerializer.deserialize(node);
                int faultCode = -1;
                Integer faultCodeInt = (Integer)struct.get("faultCode");
                if (faultCodeInt != null) {
                    faultCode = faultCodeInt;
                }
                String message = (String)struct.get("faultString");
                throw new XmlRpcRemoteException(faultCode, message);
            }
            node = node.getChild("param").getChild("value");
            Object object = XmlRpcSerializer.deserialize(node);
            return object;
        }
        catch (IOException e) {
            throw new RemoteException(e);
        }
        catch (Throwable e) {
            throw new RemoteException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                    connection = null;
                }
                catch (Exception e) {}
            }
        }
    }
}

