/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import javax.microedition.lcdui.Graphics;

public final class DrawUtil {
    static int COLOR_BIT_MASK = 255;
    public static byte[][] FILTER_GAUSSIAN_2 = new byte[][]{{1, 2, 1}, {2, 4, 2}, {1, 2, 1}};
    public static byte[][] FILTER_GAUSSIAN_3 = new byte[][]{{0, 1, 2, 1, 0}, {1, 3, 5, 3, 1}, {2, 5, 9, 5, 2}, {1, 3, 5, 3, 1}, {0, 1, 2, 1, 0}};

    public static final void fillRect(int x, int y, int width, int height, int color, Graphics g) {
        if ((color & 0xFF000000) == 0) {
            g.setColor(color);
            g.fillRect(x, y, width, height);
            return;
        }
        int[] buffer = new int[width];
        for (int i = buffer.length - 1; i >= 0; --i) {
            buffer[i] = color;
        }
        if (x < 0) {
            width += x;
            x = 0;
        }
        if (width <= 0) {
            return;
        }
        if (y < 0) {
            height += y;
            y = 0;
        }
        if (height <= 0) {
            return;
        }
        g.drawRGB(buffer, 0, 0, x, y, width, height, true);
    }

    public static void drawPolygon(int[] xPoints, int[] yPoints, int color, Graphics g) {
        DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
        if ((color & 0xFF000000) == 0) {
            color |= 0xFF000000;
        }
        dg.drawPolygon(xPoints, 0, yPoints, 0, xPoints.length, color);
    }

    public static final void fillPolygon(int[] xPoints, int[] yPoints, int color, Graphics g) {
        DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
        if ((color & 0xFF000000) == 0) {
            color |= 0xFF000000;
        }
        dg.fillPolygon(xPoints, 0, yPoints, 0, xPoints.length, color);
    }

    public static void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3, Graphics g) {
        g.fillTriangle(x1, y1, x2, y2, x3, y3);
    }

    public static int getCenter(int n1, int n2, int n3) {
        int max = Math.max(n1, Math.max(n2, n3));
        int min = Math.min(n1, Math.min(n2, n3));
        return min + (max - min) / 2;
    }

    public static void drawTriangle(int x1, int y1, int x2, int y2, int x3, int y3, Graphics g) {
        g.drawLine(x1, y1, x2, y2);
        g.drawLine(x2, y2, x3, y3);
        g.drawLine(x3, y3, x1, y1);
    }

    static int indexOfLeast(int[] elements) {
        int index = 0;
        int least = elements[0];
        for (int i = 1; i < elements.length; ++i) {
            if (elements[i] >= least) continue;
            index = i;
            least = elements[i];
        }
        return index;
    }

    private static boolean withinBounds(int px, int py, int ax, int ay, int bx, int by, int cx, int cy) {
        if (px < Math.min(ax, Math.min(bx, cx)) || px > Math.max(ax, Math.max(bx, cx)) || py < Math.min(ay, Math.min(by, cy)) || py > Math.max(ay, Math.max(by, cy))) {
            return false;
        }
        boolean sameabc = DrawUtil.sameSide(px, py, ax, ay, bx, by, cx, cy);
        boolean samebac = DrawUtil.sameSide(px, py, bx, by, ax, ay, cx, cy);
        boolean samecab = DrawUtil.sameSide(px, py, cx, cy, ax, ay, bx, by);
        return sameabc && samebac && samecab;
    }

    private static boolean sameSide(int p1x, int p1y, int p2x, int p2y, int l1x, int l1y, int l2x, int l2y) {
        long lhs = (p1x - l1x) * (l2y - l1y) - (l2x - l1x) * (p1y - l1y);
        long rhs = (p2x - l1x) * (l2y - l1y) - (l2x - l1x) * (p2y - l1y);
        long product = lhs * rhs;
        boolean result = product >= 0L;
        return result;
    }

    private static int[][] trimEar(int[] xPoints, int[] yPoints, int earIndex) {
        int[] newXPoints = new int[xPoints.length - 1];
        int[] newYPoints = new int[yPoints.length - 1];
        int[][] newPoly = new int[][]{newXPoints, newYPoints};
        int p = 0;
        for (int i = 0; i < xPoints.length; ++i) {
            if (i == earIndex) continue;
            newXPoints[p] = xPoints[i];
            newYPoints[p] = yPoints[i];
            ++p;
        }
        return newPoly;
    }

    private static int[][][] split(int[] xPoints, int[] yPoints, int aIndex, int bIndex) {
        int index;
        int i;
        int firstLen = bIndex < aIndex ? xPoints.length - aIndex + bIndex + 1 : bIndex - aIndex + 1;
        int secondLen = xPoints.length - firstLen + 2;
        int[][] first = new int[2][firstLen];
        int[][] second = new int[2][secondLen];
        for (i = 0; i < firstLen; ++i) {
            index = (aIndex + i) % xPoints.length;
            first[0][i] = xPoints[index];
            first[1][i] = yPoints[index];
        }
        for (i = 0; i < secondLen; ++i) {
            index = (bIndex + i) % xPoints.length;
            second[0][i] = xPoints[index];
            second[1][i] = yPoints[index];
        }
        int[][][] result = new int[][][]{first, second};
        return result;
    }

    public static final int[] getGradient(int startColor, int endColor, int steps) {
        int[] gradient = new int[steps];
        DrawUtil.getGradient(startColor, endColor, gradient);
        return gradient;
    }

    public static final void getGradient(int startColor, int endColor, int[] gradient) {
        int steps = gradient.length;
        if (steps == 0) {
            return;
        }
        if (steps == 1) {
            gradient[0] = startColor;
            return;
        }
        int startAlpha = startColor >>> 24;
        int startRed = startColor >>> 16 & 0xFF;
        int startGreen = startColor >>> 8 & 0xFF;
        int startBlue = startColor & 0xFF;
        int endAlpha = endColor >>> 24;
        int endRed = endColor >>> 16 & 0xFF;
        int endGreen = endColor >>> 8 & 0xFF;
        int endBlue = endColor & 0xFF;
        int stepAlpha = (endAlpha - startAlpha << 8) / (steps - 1);
        int stepRed = (endRed - startRed << 8) / (steps - 1);
        int stepGreen = (endGreen - startGreen << 8) / (steps - 1);
        int stepBlue = (endBlue - startBlue << 8) / (steps - 1);
        startAlpha <<= 8;
        startRed <<= 8;
        startGreen <<= 8;
        startBlue <<= 8;
        gradient[0] = startColor;
        for (int i = 1; i < steps; ++i) {
            gradient[i] = (startAlpha += stepAlpha) << 16 & 0xFF000000 | (startRed += stepRed) << 8 & 0xFF0000 | (startGreen += stepGreen) & 0xFF00 | (startBlue += stepBlue) >>> 8;
        }
    }

    public static final int getGradientColor(int startColor, int endColor, int permille) {
        int alpha = startColor >>> 24;
        int red = startColor >>> 16 & 0xFF;
        int green = startColor >>> 8 & 0xFF;
        int blue = startColor & 0xFF;
        int diffAlpha = (endColor >>> 24) - alpha;
        int diffRed = (endColor >>> 16 & 0xFF) - red;
        int diffGreen = (endColor >>> 8 & 0xFF) - green;
        int diffBlue = (endColor & 0xFF) - blue;
        return (alpha += diffAlpha * permille / 1000) << 24 | (red += diffRed * permille / 1000) << 16 | (green += diffGreen * permille / 1000) << 8 | (blue += diffBlue * permille / 1000);
    }

    public static final int getGradientColor(int startColor, int endColor, int step, int numberOfSteps) {
        int permille = step * 1000 / numberOfSteps;
        return DrawUtil.getGradientColor(startColor, endColor, permille);
    }

    public static int getComplementaryColor(int color) {
        return 0xFF000000 & color | 255 - ((0xFF0000 & color) >> 16) << 16 | 255 - ((0xFF00 & color) >> 8) << 8 | 255 - (0xFF & color);
    }

    public static final void dropShadow(int[] argbData, int width, int height, int xOffset, int yOffset, int size, int innerColor, int outerColor) {
        int iLeft = size - xOffset < 0 ? 0 : size - xOffset;
        int iRight = size + xOffset < 0 ? 0 : size + xOffset;
        int iTop = size - yOffset < 0 ? 0 : size - yOffset;
        int iBottom = size + yOffset < 0 ? 0 : size + yOffset;
        int[] gradient = DrawUtil.getGradient(innerColor, outerColor, size);
        for (int ix = -size + 1; ix < size; ++ix) {
            for (int iy = -size + 1; iy < size; ++iy) {
                int r = (int)Math.sqrt(ix * ix + iy * iy);
                if (r >= size) continue;
                int gColor = gradient[r];
                for (int col = iLeft; col < width - iRight; ++col) {
                    for (int row = iTop; row < height - iBottom - 1; ++row) {
                        if (argbData[row * width + col] >>> 24 != 255 || argbData[(row + yOffset + iy) * width + col + xOffset + ix] >>> 24 >= gColor >>> 24) continue;
                        argbData[(row + yOffset + iy) * width + col + xOffset + ix] = gColor;
                    }
                }
            }
        }
    }

    public static final void applyFilter(byte[][] filterMatrix, int brightness, int[] argbData, int width, int height) {
        if (filterMatrix.length % 2 != 1 || filterMatrix[0].length % 2 != 1) {
            throw new IllegalArgumentException();
        }
        int fhRadius = filterMatrix.length / 2 + 1;
        int fwRadius = filterMatrix[0].length / 2 + 1;
        int currentPixel = 0;
        int divisor = 0;
        for (int fRow = 0; fRow < filterMatrix.length; ++fRow) {
            for (int fCol = 0; fCol < filterMatrix[0].length; ++fCol) {
                divisor += filterMatrix[fRow][fCol];
            }
        }
        if (divisor == 0) {
            return;
        }
        int[] tmpRect = new int[width * filterMatrix.length];
        System.arraycopy(argbData, 0, tmpRect, 0, width * filterMatrix.length);
        int row = fhRadius - 1;
        while (row + fhRadius < height + 1) {
            int col = fwRadius - 1;
            while (col + fwRadius < width + 1) {
                int newTran = 0;
                int newRed = 0;
                int newGreen = 0;
                int newBlue = 0;
                for (int fRow = 0; fRow < filterMatrix.length; ++fRow) {
                    for (int fCol = 0; fCol < filterMatrix[0].length; ++fCol) {
                        currentPixel = tmpRect[fRow * width + col + fCol - fwRadius + 1];
                        if ((currentPixel >>> 24 & COLOR_BIT_MASK) == 0) continue;
                        newTran += filterMatrix[fRow][fCol] * (currentPixel >>> 24 & COLOR_BIT_MASK);
                        newRed += filterMatrix[fRow][fCol] * (currentPixel >>> 16 & COLOR_BIT_MASK);
                        newGreen += filterMatrix[fRow][fCol] * (currentPixel >>> 8 & COLOR_BIT_MASK);
                        newBlue += filterMatrix[fRow][fCol] * (currentPixel & COLOR_BIT_MASK);
                    }
                }
                newTran = newTran * brightness / 100 / divisor;
                newRed = newRed * brightness / 100 / divisor;
                newGreen = newGreen * brightness / 100 / divisor;
                newBlue = newBlue * brightness / 100 / divisor;
                newTran = Math.max(0, Math.min(255, newTran));
                newRed = Math.max(0, Math.min(255, newRed));
                newGreen = Math.max(0, Math.min(255, newGreen));
                newBlue = Math.max(0, Math.min(255, newBlue));
                argbData[row * width + col] = newTran << 24 | newRed << 16 | newGreen << 8 | newBlue;
                ++col;
            }
            if (row + fhRadius != height) {
                System.arraycopy(tmpRect, width, tmpRect, 0, width * (filterMatrix.length - 1));
                System.arraycopy(argbData, width * (row + fhRadius), tmpRect, width * (filterMatrix.length - 1), width);
            }
            ++row;
        }
    }

    public static void drawLine(int color, int x1, int y1, int x2, int y2, Graphics g) {
        int[] xPoints = new int[]{x1, x2};
        int[] yPoints = new int[]{y1, y2};
        DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
        dg.drawPolygon(xPoints, 0, yPoints, 0, 2, color);
    }

    public static void drawRgb(int[] rgb, int x, int y, int width, int height, boolean processAlpha, Graphics g) {
        DrawUtil.drawRgb(rgb, x, y, width, height, processAlpha, g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight(), g);
    }

    public static void drawRgb(int[] rgb, int x, int y, int width, int height, boolean processAlpha, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        if (x + width < clipX || x > clipX + clipWidth || y + height < clipY || y > clipY + clipHeight) {
            return;
        }
        int offset = 0;
        if (x < clipX) {
            offset = clipX - x;
            x = clipX;
        }
        int scanlength = width;
        if (x + (width -= offset) > clipX + clipWidth) {
            width = clipX + clipWidth - x;
        }
        if (width <= 0) {
            return;
        }
        if (y < clipY) {
            offset += (clipY - y) * scanlength;
            height -= clipY - y;
            y = clipY;
        }
        if (y + height > clipY + clipHeight) {
            height = clipY + clipHeight - y;
        }
        if (height <= 0) {
            return;
        }
        g.drawRGB(rgb, offset, scanlength, x, y, width, height, processAlpha);
    }

    public static class FadeUtil {
        public static final int FADE_IN = 1;
        public static final int FADE_OUT = 2;
        public static final int FADE_LOOP = 3;
        public static final int FADE_BREAK = 0;
        public int[] gradient;
        public boolean changed;
        public int startColor = -16744193;
        public int endColor = -8323328;
        public int steps;
        public int delay = 0;
        public int stepsIn = 5;
        public int stepsOut = 5;
        public int sWaitTimeIn = 10;
        public int sWaitTimeOut = 0;
        public int mode = 3;
        public int cColor;
        public int cStep;

        private void initialize() {
            this.cStep = 0;
            switch (this.mode) {
                case 2: {
                    this.stepsIn = 0;
                    this.sWaitTimeIn = 0;
                    this.cColor = this.endColor;
                    break;
                }
                case 1: {
                    this.stepsOut = 0;
                    this.sWaitTimeOut = 0;
                    this.cColor = this.startColor;
                    break;
                }
                default: {
                    this.cColor = this.startColor;
                }
            }
            this.cStep -= this.delay;
            this.steps = this.stepsIn + this.stepsOut + this.sWaitTimeIn + this.sWaitTimeOut;
            this.gradient = DrawUtil.getGradient(this.startColor, this.endColor, Math.max(this.stepsIn, this.stepsOut));
        }

        public boolean step() {
            ++this.cStep;
            if (this.gradient == null | this.changed) {
                this.initialize();
            }
            this.changed = false;
            if (this.mode == 0) {
                return false;
            }
            if (this.cStep < 0) {
                return true;
            }
            if (this.cStep == this.steps) {
                this.cStep = 0;
                if (this.mode != 3) {
                    this.mode = 0;
                    return true;
                }
            }
            if (this.cStep < this.stepsIn) {
                this.cColor = this.gradient[this.cStep];
                return true;
            }
            if (this.cStep < this.stepsIn + this.sWaitTimeIn) {
                if (this.cColor != this.endColor) {
                    this.cColor = this.endColor;
                    return true;
                }
            } else {
                if (this.cStep < this.stepsIn + this.sWaitTimeIn + this.stepsOut) {
                    this.cColor = this.gradient[this.stepsIn + this.sWaitTimeIn + this.stepsOut - this.cStep - 1];
                    return true;
                }
                if (this.cColor != this.startColor) {
                    this.cColor = this.startColor;
                    return true;
                }
            }
            return false;
        }
    }
}

