/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;

public class Actor {
    public Scene scene;
    public short id;
    public short animId;
    public Animation anim;
    public int actionIDNow;
    public int actionIDBefore;
    public int frameId;
    public int frameIndex;
    public int frameDuration;
    public boolean actionCycle = true;
    public boolean actionOver;
    public int layer;
    public int phylayer;
    public int flag;
    public boolean flipX;
    public boolean flipY;
    public boolean visible = true;
    public boolean enabled;
    public boolean oneoff;
    public boolean needDraw = true;
    public boolean isScreen = false;
    public short[] collideBox = new short[0];
    public short[] activeBox = new short[0];
    public short[] parameters = new short[0];
    public static final int ACTOR_FLAG_PLAYER = 32;
    public static final int ACTOR_FLAG_ONEOFF = 64;
    public static final int ACTOR_FLAG_ISSCREEN = 128;
    public static final int ACTOR_FLAG_ACTIVE = 256;
    public static final int ACTOR_FLAG_LOGIC = 512;
    public static final int ACTOR_FLAG_MOVING = 1024;
    public static final int ACTOR_FLAG_MONSTER = 2048;
    public static final int ACTOR_FLAG_BOX = 4096;
    public static final int ACTOR_FLAG_NPC = 8192;
    public static final int ACTOR_FLAG_FACE = 16384;
    public static final int ACTOR_FLAG_SAVE = 32768;
    public static final int ACTOR_FLAG_MAPNAME = 65536;
    public static final int FM_FOLLOW = 0;
    public static final int FM_FLEX = 1;
    public static final int FM_MEET = 2;
    public static final int FP_POSX = 0;
    public static final int FP_POSY = 1;
    public static final int FP_LAYER = 2;
    public static final int FP_PHYLAYER = 3;
    public static final int FP_ACTION = 4;
    public static final int FP_CYCLE = 5;
    public static final int FP_COUNT = 6;
    public static final int DELAY = 2;
    public static int followMode = 0;
    public Actor followActor = null;
    public int[][] followParam = null;
    private int followIndex = 0;
    private int followBegin = 0;
    private int followLenth = 0;
    public int posX;
    public int posY;
    public int prevPosX;
    public int prevPosY;
    public int destX;
    public int destY;
    public int velocity;
    public int vX;
    public int vY;
    private static final int REBORN_TIME = 200;
    private int timerToReborn = 0;
    private int startX;
    private int startY;
    private int endX;
    private int endY;
    private boolean isWake = true;
    private boolean isDirX = true;
    public static int boxIndex = 0;
    public static final int FACE_WENHAO = 3;
    public static final int AC_RESTN = 0;
    public static final int AC_RESTS = 1;
    public static final int AC_RESTW = 2;
    public static final int AC_RESTE = 3;
    public static final int AC_NORTH = 4;
    public static final int AC_SOUTH = 5;
    public static final int AC_WEST = 6;
    public static final int AC_EAST = 7;
    public static final int AC_FLYN = 8;
    public static final int AC_FLYS = 9;
    public static final int AC_FLYW = 10;
    public static final int AC_FLYE = 11;
    public static final int AC_FLYNORTH = 8;
    public static final int AC_FLYESOUTH = 9;
    public static final int AC_FLYEWEST = 10;
    public static final int AC_FLYEEAST = 11;
    public static final int LAYER_MOVE = 1;
    public static final int LAYER_FLY = 2;
    private static final int COL_TOP = 1;
    private static final int COL_BOTTOM = 2;
    private static final int COL_LEFT = 4;
    private static final int COL_RIGHT = 8;
    public static final int HIGH_LAYER = 8;

    public Actor() {
    }

    public Actor(String path, int effect, boolean loadImg) {
        try {
            this.anim = new Animation(path, effect, loadImg);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.enabled = false;
        this.visible = false;
    }

    public Actor(Scene scene) {
        this.scene = scene;
    }

    public void load(DataInputStream dis) throws Exception {
        this.posX = dis.readShort();
        this.posY = dis.readShort();
        this.layer = dis.readByte();
        this.flag = dis.readInt();
        this.flipX = (this.flag & 1) != 0;
        this.flipY = (this.flag & 2) != 0;
        this.enabled = (this.flag & 4) != 0;
        this.visible = (this.flag & 8) != 0;
        this.oneoff = (this.flag & 0x40) != 0;
        this.isScreen = (this.flag & 0x80) != 0;
        this.animId = (short)dis.readUnsignedByte();
        this.actionIDNow = dis.readUnsignedByte();
        this.collideBox = new short[4];
        this.collideBox[0] = dis.readShort();
        this.collideBox[1] = dis.readShort();
        this.collideBox[2] = dis.readShort();
        this.collideBox[2] = (short)(this.collideBox[0] + this.collideBox[2]);
        this.collideBox[3] = dis.readShort();
        this.collideBox[3] = (short)(this.collideBox[1] + this.collideBox[3]);
        this.activeBox = new short[4];
        this.activeBox[0] = dis.readShort();
        this.activeBox[1] = dis.readShort();
        this.activeBox[2] = dis.readShort();
        this.activeBox[2] = (short)(this.activeBox[0] + this.activeBox[2]);
        this.activeBox[3] = dis.readShort();
        this.activeBox[3] = (short)(this.activeBox[1] + this.activeBox[3]);
        int bytesCount = dis.readShort();
        int temp_parameterCount = bytesCount;
        if (temp_parameterCount != 0) {
            this.parameters = new short[temp_parameterCount];
            for (int j = 0; j < temp_parameterCount; ++j) {
                this.parameters[j] = dis.readShort();
            }
        }
    }

    public Actor clone() {
        return this.clone(this);
    }

    public Actor clone(Actor actor) {
        Actor ca = new Actor();
        ca.scene = actor.scene;
        ca.animId = actor.animId;
        ca.anim = actor.anim;
        ca.actionIDNow = actor.actionIDNow;
        ca.actionIDBefore = actor.actionIDBefore;
        ca.frameId = actor.frameId;
        ca.frameIndex = actor.frameIndex;
        ca.frameDuration = actor.frameDuration;
        ca.actionCycle = actor.actionCycle;
        ca.actionOver = actor.actionOver;
        ca.layer = actor.layer;
        ca.phylayer = actor.phylayer;
        ca.flag = actor.flag;
        ca.flipX = actor.flipX;
        ca.flipY = actor.flipY;
        ca.visible = actor.visible;
        ca.enabled = actor.enabled;
        ca.needDraw = actor.needDraw;
        ca.oneoff = actor.oneoff;
        ca.isScreen = actor.isScreen;
        ca.posX = actor.posX;
        ca.posY = actor.posY;
        ca.vX = actor.vX;
        ca.vY = actor.vY;
        ca.collideBox = new short[actor.collideBox.length];
        System.arraycopy(actor.collideBox, 0, ca.collideBox, 0, actor.collideBox.length);
        ca.activeBox = new short[actor.activeBox.length];
        System.arraycopy(actor.activeBox, 0, ca.activeBox, 0, actor.activeBox.length);
        ca.parameters = new short[actor.parameters.length];
        System.arraycopy(actor.parameters, 0, ca.parameters, 0, actor.parameters.length);
        return ca;
    }

    public void dispose() {
        if (this.anim != null) {
            this.anim.dispose();
            this.anim = null;
        }
        this.collideBox = null;
        this.activeBox = null;
        this.parameters = null;
    }

    public void setFlag(int index, boolean status) {
        if (index == 0) {
            this.flipX = status;
        } else if (index == 1) {
            this.flipY = status;
        } else if (index == 2) {
            this.setEnabled(status);
        } else if (index == 3) {
            this.setVisible(status);
        } else if (index == 6) {
            this.oneoff = status;
        } else if (index == 7) {
            this.isScreen = status;
        } else {
            this.flag = status ? (this.flag |= 1 << index) : (this.flag &= ~(1 << index));
        }
    }

    public boolean getFlag(int index) {
        if (index == 0) {
            return this.flipX;
        }
        if (index == 1) {
            return this.flipY;
        }
        if (index == 2) {
            return this.enabled;
        }
        if (index == 3) {
            return this.visible;
        }
        if (index == 6) {
            return this.oneoff;
        }
        if (index == 7) {
            return this.isScreen;
        }
        return (this.flag & 1 << index) != 0;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        if (!visible && Battle.battle == null) {
            this.scene.eventActorClass = this.animId;
            this.scene.eventActorId = this.id;
            this.scene.eventActorAction = this.actionIDNow;
            this.scene.fireEvent(10);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled && Battle.battle == null) {
            this.scene.eventActorClass = this.animId;
            this.scene.eventActorId = this.id;
            this.scene.eventActorAction = this.actionIDNow;
            this.scene.fireEvent(11);
        }
    }

    public void setParameter(int index, int value) {
        if (index >= this.parameters.length) {
            return;
        }
        this.parameters[index] = (short)value;
    }

    public short getParameter(int index) {
        if (index >= this.parameters.length) {
            return -1;
        }
        return this.parameters[index];
    }

    public void setAction(int actionIDNext, boolean mustChange) {
        if (!mustChange && this.actionIDNow == actionIDNext) {
            return;
        }
        this.actionIDBefore = this.actionIDNow;
        this.actionIDNow = actionIDNext;
        this.frameId = 0;
        if (this.actionIDNow >= 0) {
            this.frameIndex = this.actionIDNow < this.anim.actions.length ? this.anim.actions[this.actionIDNow][0] & 0x3FF : this.anim.actions[this.actionIDNow % this.anim.actions.length][0] & 0x3FF;
        }
        this.frameDuration = 0;
        this.actionOver = false;
    }

    public void setFrame(int frameID) {
        this.frameId = frameID %= this.anim.actions[this.actionIDNow].length;
        this.frameIndex = this.anim.actions[this.actionIDNow][frameID] & 0x3FF;
        this.frameDuration = 0;
    }

    public void setActionFrame(int actionIDNext, int frameID) {
        this.setAction(actionIDNext, true);
        this.setFrame(frameID);
    }

    public void preFrame() {
        --this.frameDuration;
        if (this.anim == null || this.frameDuration < (this.anim.actions[this.actionIDNow][this.frameId] & 0xFFFF) >> 10) {
            return;
        }
        --this.frameId;
        if (this.frameId < 0) {
            this.actionOver = true;
            if ((this.flag & 0x100) != 0) {
                this.scene.eventActorClass = this.animId;
                this.scene.eventActorId = this.id;
                this.scene.eventActorAction = this.actionIDNow;
                this.scene.fireEvent(9);
            }
            this.frameId = this.actionCycle ? this.anim.actions[this.actionIDNow].length - 1 : ++this.frameId;
        }
        this.frameIndex = this.anim.actions[this.actionIDNow][this.frameId] & 0x3FF;
        this.frameDuration = 0;
    }

    public void nextFrame() {
        ++this.frameDuration;
        if (this.anim == null || this.actionIDNow >= this.anim.actions.length || this.frameId >= this.anim.actions[this.actionIDNow].length || this.frameDuration < (this.anim.actions[this.actionIDNow][this.frameId] & 0xFFFF) >> 10) {
            return;
        }
        ++this.frameId;
        if (this.frameId >= this.anim.actions[this.actionIDNow].length) {
            this.actionOver = true;
            if ((this.flag & 0x100) != 0 && Battle.battle == null) {
                this.scene.eventActorClass = this.animId;
                this.scene.eventActorId = this.id;
                this.scene.eventActorAction = this.actionIDNow;
                this.scene.fireEvent(9);
            }
            if (this.oneoff && this.actionOver) {
                this.setEnabled(false);
            }
            this.frameId = this.actionCycle ? 0 : --this.frameId;
        }
        this.frameIndex = this.anim.actions[this.actionIDNow][this.frameId] & 0x3FF;
        this.frameDuration = 0;
    }

    public int getActionTime() {
        int time = 0;
        for (int i = 0; i < this.anim.actions[this.actionIDNow].length; ++i) {
            time += (this.anim.actions[this.actionIDNow][this.frameId] & 0xFFFF) >> 10;
        }
        return time;
    }

    public void draw(Graphics g, int camX, int camY) {
        int x = this.posX;
        int y = this.posY;
        if (!this.isScreen) {
            x = this.posX - camX;
            y = this.posY - camY;
        }
        this.anim.draw(g, x, y, this.flipX, this.flipY, this.frameIndex);
    }

    public void follow(Actor followActor) {
        this.followActor = followActor;
        this.followParam = new int[2][6];
        this.followParam[0][0] = followActor.posX;
        this.followParam[0][1] = followActor.posY;
        this.followParam[0][2] = followActor.layer;
        this.followParam[0][3] = followActor.phylayer;
        this.followParam[0][4] = followActor.actionIDNow;
        this.actionCycle = followActor.actionCycle;
        this.followIndex = 0;
        this.followLenth = 1;
        this.posX = followActor.posX;
        this.posY = followActor.posY;
        this.followBegin = 0;
        this.layer = followActor.layer;
        this.phylayer = followActor.phylayer;
    }

    private void updateFollow() {
        switch (followMode) {
            case 0: {
                if (!this.visible) {
                    this.visible = true;
                    this.follow(this.followActor);
                    this.setAction(this.followActor.actionIDNow % 8, true);
                }
                this.updateFollowParam();
                break;
            }
            case 1: {
                this.visible = true;
                this.updateFollowParam();
                break;
            }
            case 2: {
                this.posX = this.followActor.posX;
                this.posY = this.followActor.posY;
                if (!this.visible) break;
                this.layer = this.followActor.layer;
                this.phylayer = this.followActor.phylayer;
                this.visible = false;
            }
        }
    }

    private void updateFollowParam() {
        if (this.followLenth < 2) {
            this.followIndex = (this.followIndex + 1) % 2;
            this.followParam[this.followIndex][0] = this.followActor.posX;
            this.followParam[this.followIndex][1] = this.followActor.posY;
            this.followParam[this.followIndex][2] = this.followActor.layer;
            this.followParam[this.followIndex][3] = this.followActor.phylayer;
            this.followParam[this.followIndex][4] = this.followActor.actionIDNow % 8;
            this.followParam[this.followIndex][5] = this.followActor.actionCycle ? 1 : 0;
            ++this.followLenth;
        } else {
            this.posX = this.followParam[this.followBegin][0];
            this.posY = this.followParam[this.followBegin][1];
            this.layer = this.followParam[this.followBegin][2];
            this.phylayer = this.followParam[this.followBegin][3];
            this.actionIDNow = this.followParam[this.followBegin][4];
            this.actionCycle = this.followParam[this.followBegin][5] == 1;
            this.setAction(this.actionIDNow, false);
            this.vX = this.followActor.vX;
            this.vY = this.followActor.vY;
            if (this.followActor.vX == 0 && this.followActor.vY == 0) {
                this.vX = 0;
                this.vY = 0;
            } else {
                this.followIndex = this.followBegin;
                this.followParam[this.followIndex][0] = this.followActor.posX;
                this.followParam[this.followIndex][1] = this.followActor.posY;
                this.followParam[this.followIndex][2] = this.followActor.layer;
                this.followParam[this.followIndex][3] = this.followActor.phylayer;
                this.followParam[this.followIndex][4] = this.followActor.actionIDNow % 8;
                this.followParam[this.followIndex][5] = this.followActor.actionCycle ? 1 : 0;
                this.followBegin = (this.followBegin + 1) % 2;
            }
        }
    }

    public void updatePos() {
        if (this.followActor != null) {
            this.updateFollow();
            return;
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.posX += this.vX;
        this.posY += this.vY;
        if (this == this.scene.player) {
            this.posX = Tools.limit(this.posX, 0 - this.collideBox[0], this.scene.bgWidth - this.collideBox[2]);
            this.posY = Tools.limit(this.posY, 0 - this.collideBox[1], this.scene.bgHeight - this.collideBox[3]);
        }
        if (this.getFlag(1024)) {
            if (Math.abs(this.posX - this.destX) <= Math.abs(this.vX)) {
                this.posX = this.destX;
            }
            if (Math.abs(this.posY - this.destY) <= Math.abs(this.vY)) {
                this.posY = this.destY;
            }
            if (this.posX == this.destX && this.posY == this.destY) {
                this.vX = 0;
                this.vY = 0;
                this.setFlag(1024, false);
            }
        }
        this.needDraw = this.isScreen ? this.posX + this.collideBox[2] >= 0 && this.posX + this.collideBox[0] <= this.scene.viewW && this.posY + this.collideBox[3] >= 0 && this.posY + this.collideBox[1] <= this.scene.viewH : this.posX + this.collideBox[2] >= this.scene.viewX && this.posX + this.collideBox[0] <= this.scene.viewX + this.scene.viewW && this.posY + this.collideBox[3] >= this.scene.viewY && this.posY + this.collideBox[1] <= this.scene.viewY + this.scene.viewH;
    }

    public void restorePos() {
        this.posX = this.prevPosX;
        this.posY = this.prevPosY;
    }

    public boolean testCollide(Actor actor, boolean ignoreLayer) {
        if (actor == null) {
            return false;
        }
        int x = this.posX + this.collideBox[0];
        int y = this.posY + this.collideBox[1];
        int w = this.posX + this.collideBox[2];
        int h = this.posY + this.collideBox[3];
        int ox = actor.posX + actor.collideBox[0];
        int oy = actor.posY + actor.collideBox[1];
        int ow = actor.posX + actor.collideBox[2];
        int oh = actor.posY + actor.collideBox[3];
        boolean result = Tools.testIntersecting(x, y, w, h, ox, oy, ow, oh);
        if (ignoreLayer) {
            return result;
        }
        return this.phylayer == actor.phylayer && result;
    }

    public boolean testActive(Actor actor, boolean ignoreLayer) {
        if (actor == null) {
            return false;
        }
        int x = this.posX + this.activeBox[0];
        int y = this.posY + this.activeBox[1];
        int w = this.posX + this.activeBox[2];
        int h = this.posY + this.activeBox[3];
        int ox = actor.posX + actor.collideBox[0];
        int oy = actor.posY + actor.collideBox[1];
        int ow = actor.posX + actor.collideBox[2];
        int oh = actor.posY + actor.collideBox[3];
        boolean result = Tools.testIntersecting(x, y, w, h, ox, oy, ow, oh);
        if (ignoreLayer) {
            return result;
        }
        return this.phylayer == actor.phylayer && result;
    }

    public void initActor() {
        if ((this.flag & 0x20) != 0) {
            this.scene.followTeam[this.parameters[0]] = this;
            this.velocity = 8;
            this.collideBox[0] = -8;
            this.collideBox[1] = -12;
            this.collideBox[2] = 7;
            this.collideBox[3] = 2;
        }
        this.landingActor();
        if ((this.flag & 0x800) != 0) {
            this.velocity = 2;
            this.isWake = false;
            this.initLimitPos();
            this.activeBox[0] = -32;
            this.activeBox[1] = -32;
            this.activeBox[2] = 32;
            this.activeBox[3] = 32;
        } else if ((this.flag & 0x1000) != 0) {
            boolean isOpen = (World.boxFlags[World.level] & 1 << boxIndex) != 0;
            this.actionIDNow = isOpen ? 1 : 0;
            this.followIndex = boxIndex++;
        } else if ((this.flag & 0x4000) != 0) {
            this.scene.face = this;
            this.oneoff = true;
        }
    }

    public void doAI() {
        if (this == this.scene.player) {
            this.ai_PLAYER();
            return;
        }
        this.ai_COMMON();
        if ((this.flag & 0x800) != 0) {
            this.ai_MONSTER();
        } else if ((this.flag & 0x200) != 0) {
            this.ai_BALK();
        } else if ((this.flag & 0x1000) != 0) {
            this.ai_BOX();
        } else if ((this.flag & 0x2000) != 0) {
            this.ai_NPC();
        } else if ((this.flag & 0x8000) != 0) {
            this.ai_SAVE();
        } else if ((this.flag & 0x10000) != 0) {
            this.ai_MAPNAME();
        }
    }

    public void ai_BALK() {
        if (this.testCollide(this.scene.player, false)) {
            this.scene.player.restorePos();
        }
        if (this.scene.player.followActor != null) {
            if (this.testCollide(this.scene.player.followActor, false)) {
                this.scene.player.followActor.restorePos();
            }
            if (this.scene.player.followActor.followActor != null && this.testCollide(this.scene.player.followActor.followActor, false)) {
                this.scene.player.followActor.followActor.restorePos();
            }
        }
    }

    public void ai_COMMON() {
        if (this.testCollide(this.scene.player, true)) {
            this.scene.eventActorClass = this.animId;
            this.scene.eventActorId = this.id;
            this.scene.eventActorAction = this.actionIDNow;
            this.scene.fireEvent(4);
        }
        if (this.testActive(this.scene.player, true)) {
            this.scene.eventActorClass = this.animId;
            this.scene.eventActorId = this.id;
            this.scene.eventActorAction = this.actionIDNow;
            this.scene.fireEvent(5);
        }
        if ((this.flag & 0x100) != 0) {
            for (int i = 0; i < this.scene.activeCount; ++i) {
                if (this.scene.activeList[i] == null || !this.scene.activeList[i].enabled || (this.scene.activeList[i].flag & 0x100) == 0 || this.scene.activeList[i] == this) continue;
                if (this.testCollide(this.scene.activeList[i], true)) {
                    this.scene.eventActorClass = this.animId;
                    this.scene.eventActorId = this.id;
                    this.scene.eventActorAction = this.actionIDNow;
                    this.scene.collideActorClass = this.scene.activeList[i].animId;
                    this.scene.collideActorId = this.scene.activeList[i].id;
                    this.scene.collideActorAction = this.scene.activeList[i].actionIDNow;
                    this.scene.fireEvent(6);
                }
                if (!this.testActive(this.scene.activeList[i], true)) continue;
                this.scene.eventActorClass = this.animId;
                this.scene.eventActorId = this.id;
                this.scene.eventActorAction = this.actionIDNow;
                this.scene.collideActorClass = this.scene.activeList[i].animId;
                this.scene.collideActorId = this.scene.activeList[i].id;
                this.scene.collideActorAction = this.scene.activeList[i].actionIDNow;
                this.scene.fireEvent(7);
            }
        }
    }

    public void ai_MONSTER() {
        if (!this.visible) {
            this.vX = 0;
            this.vY = 0;
            ++this.timerToReborn;
            if (this.timerToReborn >= 200 && this.parameters[0] == 1) {
                this.visible = true;
            }
            return;
        }
        if (!this.isWake) {
            this.posX = Tools.limit(this.posX, this.startX, this.endX);
            this.posY = Tools.limit(this.posY, this.startY, this.endY);
        }
        this.bgCollide();
        if (this.visible && this.testCollide(this.scene.player, false) && this.parameters.length >= 2) {
            this.timerToReborn = 0;
            this.visible = false;
            short enemyId = this.parameters[Tools.random(1, this.parameters.length - 1)];
            World.scene.flash(World.g, 5, 0);
            UI.drawLoading(5);
            Battle battle = new Battle();
            if (2 == battle.enterBattle(enemyId, 1, 0)) {
                World.loadLevel(0, -1, -1, -1);
            }
            battle = null;
            return;
        }
        if (this.testActive(this.scene.player, false)) {
            if (!this.isWake) {
                this.isWake = true;
                this.zoomInActiveBox();
                this.velocity = 6;
            }
            this.updateVelocity(this.posX - this.scene.player.posX, this.posY - this.scene.player.posY);
        } else {
            if (this.isWake) {
                this.isWake = false;
                this.zoomOutActiveBox();
                this.velocity = 2;
                this.initLimitPos();
            }
            if (this.isDirX) {
                if (this.posX == this.startX || this.posX == this.endX) {
                    this.vX *= -1;
                }
            } else if (this.posY == this.startY || this.posY == this.endY) {
                this.vY *= -1;
            }
        }
    }

    private void initLimitPos() {
        this.isDirX = Tools.random(0, 1) == 0;
        int span = Tools.random(16, 24);
        if (this.isDirX) {
            this.startX = this.posX - span;
            this.endX = this.posX + span;
            this.startY = this.endY = this.posY;
            this.vX = (Tools.random(0, 1) == 0 ? 1 : -1) * this.velocity;
            this.vY = 0;
        } else {
            this.startY = this.posY - span;
            this.endY = this.posY + span;
            this.startX = this.endX = this.posX;
            this.vY = (Tools.random(0, 1) == 0 ? 1 : -1) * this.velocity;
            this.vX = 0;
        }
    }

    private void updateVelocity(int spanX, int spanY) {
        int lx = Math.abs(spanX);
        int ly = Math.abs(spanY);
        int vx = this.velocity;
        int vy = this.velocity;
        if (lx != 0 || ly != 0) {
            vx = this.velocity * lx / (lx + ly);
            vy = this.velocity - vx;
        }
        this.vX = (spanX > 0 ? -1 : 1) * vx;
        this.vY = (spanY > 0 ? -1 : 1) * vy;
    }

    private void zoomInActiveBox() {
        this.activeBox[0] = (short)(this.activeBox[0] * 3);
        this.activeBox[1] = (short)(this.activeBox[1] * 3);
        this.activeBox[2] = (short)(this.activeBox[2] * 3);
        this.activeBox[3] = (short)(this.activeBox[3] * 3);
        this.activeBox[0] = (short)(this.activeBox[0] / 2);
        this.activeBox[1] = (short)(this.activeBox[1] / 2);
        this.activeBox[2] = (short)(this.activeBox[2] / 2);
        this.activeBox[3] = (short)(this.activeBox[3] / 2);
    }

    private void zoomOutActiveBox() {
        this.activeBox[0] = (short)(this.activeBox[0] * 2);
        this.activeBox[1] = (short)(this.activeBox[1] * 2);
        this.activeBox[2] = (short)(this.activeBox[2] * 2);
        this.activeBox[3] = (short)(this.activeBox[3] * 2);
        this.activeBox[0] = (short)(this.activeBox[0] / 3);
        this.activeBox[1] = (short)(this.activeBox[1] / 3);
        this.activeBox[2] = (short)(this.activeBox[2] / 3);
        this.activeBox[3] = (short)(this.activeBox[3] / 3);
    }

    public void ai_BOX() {
        if (this.testCollide(this.scene.player, true) && GameCanvas.haveKeyPressed(256)) {
            if (this.actionIDNow == 0) {
                if (this.parameters[2] == 0 || World.isLearnSteal) {
                    String artName;
                    if (this.parameters[0] == 0) {
                        World.myteam.addArm(this.parameters[1], 1);
                        artName = Data.STRING_ARM[this.parameters[1]][0];
                    } else if (this.parameters[0] == 1) {
                        World.myteam.addItem(this.parameters[1], 1);
                        artName = Data.STRING_ITEM[this.parameters[1]][0];
                    } else {
                        World.myteam.gold += this.parameters[3];
                        artName = "\u5f97\u5230" + this.parameters[3] + "\u91d1";
                    }
                    this.setAction(1, false);
                    int n = World.level;
                    World.boxFlags[n] = (byte)(World.boxFlags[n] | 1 << this.followIndex);
                    StringBuffer sb = new StringBuffer();
                    if (this.parameters[2] == 1) {
                        sb.append("\u65bd\u5c55\u5999\u624b\u7a7a\u7a7a|");
                    }
                    sb.append("\u83b7\u5f97");
                    sb.append(artName);
                    UI.showMessage(World.g, sb.toString(), 15, 1);
                } else {
                    UI.showMessage(World.g, "\u7bb1\u5b50\u662f\u9501\u7740\u7684", 15, 1);
                    this.scene.learnSteal();
                }
            } else {
                UI.showMessage(World.g, "\u7bb1\u5b50\u5df2\u7ecf\u6253\u5f00", 15, 1);
            }
        }
    }

    public void ai_NPC() {
    }

    public void ai_SAVE() {
        if (this.testCollide(this.scene.player, false)) {
            this.addFace(3);
            if (GameCanvas.keyConfirmed() && UI.showConfirm(World.g, "\u662f\u5426\u786e\u5b9a\u8981\u5b58\u6863?")) {
                World.saveRecord(1);
                UI.showMessage(World.g, "\u5b58\u6863\u5b8c\u6210!", 10, 1);
            }
        }
    }

    public void ai_MAPNAME() {
        this.setVisible(this.testCollide(this.scene.player, true));
    }

    public void addFace(int faceAction) {
        if (!this.scene.face.enabled) {
            this.scene.face.setAction(faceAction, true);
            this.scene.face.enabled = true;
            this.scene.face.visible = true;
            this.scene.face.actionCycle = true;
            this.scene.face.posX = this.posX;
            this.scene.face.posY = this.posY - 25;
        }
    }

    public void ai_PLAYER() {
        this.bgCollide();
        this.vX = 0;
        this.vY = 0;
        if (GameCanvas.haveKeyPressed(1) || GameCanvas.haveKeyHold(1)) {
            this.vX = 0;
            this.vY = -this.velocity;
            this.actionCycle = true;
            if (this.phylayer == 8) {
                this.setAction(8, false);
            } else {
                this.setAction(4, false);
            }
        } else if (GameCanvas.haveKeyPressed(16) || GameCanvas.haveKeyHold(16)) {
            this.vX = 0;
            this.vY = this.velocity;
            this.actionCycle = true;
            if (this.phylayer == 8) {
                this.setAction(9, false);
            } else {
                this.setAction(5, false);
            }
        } else if (GameCanvas.haveKeyPressed(64) || GameCanvas.haveKeyHold(64)) {
            this.vY = 0;
            this.vX = -this.velocity;
            this.actionCycle = true;
            if (this.phylayer == 8) {
                this.setAction(10, false);
            } else {
                this.setAction(6, false);
            }
        } else if (GameCanvas.haveKeyPressed(4) || GameCanvas.haveKeyHold(4)) {
            this.vY = 0;
            this.vX = this.velocity;
            this.actionCycle = true;
            if (this.phylayer == 8) {
                this.setAction(11, false);
            } else {
                this.setAction(7, false);
            }
        } else {
            this.setAction((this.actionIDNow >> 3 << 3) + this.actionIDNow % 4, false);
            if (GameCanvas.haveKeyPressed(8)) {
                this.switchFlyMode();
            } else if (GameCanvas.haveKeyPressed(32) && World.gutmsg.length() > 0 && World.gutid == World.vars[0]) {
                UI.drawMessageBox(World.g, null, Scene.name, 0, 0, GameCanvas.SCREEN_WIDTH, 34, false);
                this.scene.showDialog(-1, World.gutid, "\u9171\u6cb9\u795e", "\u63d0\u793a\uff1a" + World.gutmsg);
            }
        }
    }

    public void switchFlyMode() {
        if (this.scene.learnFly()) {
            if (followMode == 0) {
                System.out.print("!!!!!!!!!!!!!!!!!!!!!!!!!\u98de");
                followMode = 2;
                this.phylayer = 8;
                this.layer = 2;
                this.scene.followTeam[0].setAction(this.actionIDNow + 8, false);
                World.b_fly = true;
            } else {
                System.out.print("!!!!!!!!!!!!!!!!!!!!!!!!!\u9a6c");
                if (this.landingActor()) {
                    followMode = 0;
                    this.layer = 1;
                    this.scene.followTeam[0].setAction((this.actionIDNow - 8 + this.anim.actions.length) % this.anim.actions.length, false);
                    this.scene.followTeamLink();
                    World.b_fly = false;
                }
            }
        }
    }

    private int getStandPhy() {
        if (this.scene.bg == null || this.scene.bg.phylayer == null) {
            return 8;
        }
        int collideX = this.posX + this.collideBox[0];
        int collideWidth = this.posX + this.collideBox[2];
        int collideY = this.posY + this.collideBox[1];
        int collideHeight = this.posY + this.collideBox[3];
        int startTileX = collideX / this.scene.bg.tileW;
        int startTileY = collideY / this.scene.bg.tileH;
        int endTileX = collideWidth / this.scene.bg.tileW;
        int endTileY = collideHeight / this.scene.bg.tileH;
        int phy = -1;
        startTileX = Tools.limit(startTileX, 0, this.scene.bg.columns - 1);
        endTileX = Tools.limit(endTileX, 0, this.scene.bg.columns - 1);
        startTileY = Tools.limit(startTileY, 0, this.scene.bg.rows - 1);
        endTileY = Tools.limit(endTileY, 0, this.scene.bg.rows - 1);
        for (int i = startTileX; i <= endTileX; ++i) {
            for (int j = startTileY; j <= endTileY; ++j) {
                phy = this.scene.bg.phylayer.phydata[j * this.scene.bg.columns + i];
                if (phy != 0) continue;
                return phy;
            }
        }
        return phy;
    }

    public boolean landingActor() {
        int phy = this.getStandPhy();
        if (phy >= 8) {
            this.phylayer = (phy - 8) * 2;
            return true;
        }
        if (phy >= 4) {
            this.phylayer = (phy - 4) * 2;
            return true;
        }
        return false;
    }

    public void bgCollide() {
        byte phy;
        int j;
        int i;
        int collide = 0;
        if (this.phylayer == 8) {
            return;
        }
        int collideX = this.posX + this.collideBox[0];
        int collideWidth = this.posX + this.collideBox[2];
        int collideY = this.posY + this.collideBox[1];
        int collideHeight = this.posY + this.collideBox[3];
        int startTileX = collideX / this.scene.bg.tileW;
        int startTileY = collideY / this.scene.bg.tileH;
        int endTileX = collideWidth / this.scene.bg.tileW;
        int endTileY = collideHeight / this.scene.bg.tileH;
        startTileX = Tools.limit(startTileX, 0, this.scene.bg.columns - 1);
        endTileX = Tools.limit(endTileX, 0, this.scene.bg.columns - 1);
        startTileY = Tools.limit(startTileY, 0, this.scene.bg.rows - 1);
        endTileY = Tools.limit(endTileY, 0, this.scene.bg.rows - 1);
        collide = 0;
        for (i = startTileX; i <= endTileX; ++i) {
            for (j = startTileY; j <= endTileY; ++j) {
                byte collideNum = this.scene.bg.phylayer.phydata[j * this.scene.bg.columns + i];
                if (collideNum < 4 || collideNum > 5) continue;
                this.phylayer = collideNum - 4 << 1;
                collide = 1;
                break;
            }
            if (collide == 1) break;
        }
        collide = 0;
        for (i = startTileX; i <= endTileX; ++i) {
            for (j = startTileY; j <= endTileY; ++j) {
                int collideNum = this.scene.bg.phylayer.phydata[j * this.scene.bg.columns + i] & 0x3F;
                if (collideNum != 0 && (this.phylayer != 0 || collideNum != 9) && (this.phylayer != 2 || collideNum != 8)) continue;
                if (i == startTileX && this.vX < 0) {
                    this.posX = (i + 1) * this.scene.bg.tileW - this.collideBox[0];
                    collide |= 4;
                }
                if (i == endTileX && this.vX > 0) {
                    this.posX = i * this.scene.bg.tileW - this.collideBox[2] - 1;
                    collide |= 8;
                }
                if (j == startTileY && this.vY < 0) {
                    this.posY = (j + 1) * this.scene.bg.tileH - this.collideBox[1];
                    collide |= 1;
                }
                if (j != endTileY || this.vY <= 0) continue;
                this.posY = j * this.scene.bg.tileH - this.collideBox[3] - 1;
                collide |= 2;
            }
        }
        if ((collide & 4) != 0) {
            phy = this.scene.bg.phylayer.phydata[startTileY * this.scene.bg.columns + startTileX];
            if (phy == -1 || this.phylayer == 0 && phy == 8 || this.phylayer == 2 && phy == 9) {
                this.posY -= this.velocity - Math.abs(this.posX - this.prevPosX);
                this.posY = Math.max((startTileY + 1) * this.scene.bg.tileH - this.collideBox[3] - 1, this.posY);
                return;
            }
            phy = this.scene.bg.phylayer.phydata[endTileY * this.scene.bg.columns + startTileX];
            if (phy == -1 || this.phylayer == 0 && phy == 8 || this.phylayer == 2 && phy == 9) {
                this.posY += this.velocity - Math.abs(this.posX - this.prevPosX);
                this.posY = Math.min(endTileY * this.scene.bg.tileH - this.collideBox[1] + 1, this.posY);
                return;
            }
        }
        if ((collide & 8) != 0) {
            phy = this.scene.bg.phylayer.phydata[startTileY * this.scene.bg.columns + endTileX];
            if (phy == -1 || this.phylayer == 0 && phy == 8 || this.phylayer == 2 && phy == 9) {
                this.posY -= this.velocity - Math.abs(this.posX - this.prevPosX);
                this.posY = Math.max((startTileY + 1) * this.scene.bg.tileH - this.collideBox[3] - 1, this.posY);
                return;
            }
            phy = this.scene.bg.phylayer.phydata[endTileY * this.scene.bg.columns + endTileX];
            if (phy == -1 || this.phylayer == 0 && phy == 8 || this.phylayer == 2 && phy == 9) {
                this.posY += this.velocity - Math.abs(this.posX - this.prevPosX);
                this.posY = Math.min(endTileY * this.scene.bg.tileH - this.collideBox[1] + 1, this.posY);
                return;
            }
        }
        if ((collide & 1) != 0) {
            phy = this.scene.bg.phylayer.phydata[startTileY * this.scene.bg.columns + startTileX];
            if (phy == -1 || this.phylayer == 0 && phy == 8 || this.phylayer == 2 && phy == 9) {
                this.posX -= this.velocity - Math.abs(this.posY - this.prevPosY);
                this.posX = Math.max(this.posX, (startTileX + 1) * this.scene.bg.tileW - this.collideBox[2] - 1);
                return;
            }
            phy = this.scene.bg.phylayer.phydata[startTileY * this.scene.bg.columns + endTileX];
            if (phy == -1 || this.phylayer == 0 && phy == 8 || this.phylayer == 2 && phy == 9) {
                this.posX += this.velocity - Math.abs(this.posY - this.prevPosY);
                this.posX = Math.min(this.posX, endTileX * this.scene.bg.tileW - this.collideBox[0] + 1);
                return;
            }
        }
        if ((collide & 2) != 0) {
            phy = this.scene.bg.phylayer.phydata[endTileY * this.scene.bg.columns + startTileX];
            if (phy == -1 || this.phylayer == 0 && phy == 8 || this.phylayer == 2 && phy == 9) {
                this.posX -= this.velocity - Math.abs(this.posY - this.prevPosY);
                this.posX = Math.max(this.posX, (startTileX + 1) * this.scene.bg.tileW - this.collideBox[2] - 1);
                return;
            }
            phy = this.scene.bg.phylayer.phydata[endTileY * this.scene.bg.columns + endTileX];
            if (phy == -1 || this.phylayer == 0 && phy == 8 || this.phylayer == 2 && phy == 9) {
                this.posX += this.velocity - Math.abs(this.posY - this.prevPosY);
                this.posX = Math.min(this.posX, endTileX * this.scene.bg.tileW - this.collideBox[0] + 1);
                return;
            }
        }
    }

    private void calc2SemiCollidePos(int tx, int ty, int tx1, int ty1, int dis, int dir) {
    }

    private void updateLeftCollide(int startTileX, int startTileY, int endTileX, int endTileY) {
        int flip = 0;
        int phy = this.scene.bg.phylayer.phydata[startTileY * this.scene.bg.columns + startTileX];
        if (phy != -1) {
            flip = (phy & 0xC0) >> 6;
            phy &= 0x3F;
        }
        if (phy == -1 || this.phylayer == 0 && phy == 8 || this.phylayer == 2 && phy == 9) {
            this.posY -= this.velocity - Math.abs(this.posX - this.prevPosX);
            this.posY = Math.max((startTileY + 1) * this.scene.bg.tileH - this.collideBox[3] - 1, this.posY);
            return;
        }
        if (phy == 6) {
            if (flip == 1) {
                int offx = (startTileX + 1) * this.scene.bg.tileW - (this.posX + this.collideBox[0]);
                int offy = (startTileY + 1) * this.scene.bg.tileH - (this.posY + this.collideBox[1]);
                if (this.scene.bg.tileW - offx < offy * 2) {
                    offy -= (this.scene.bg.tileW - offx) / 2 - 1;
                }
                this.posY += offy;
                return;
            }
            this.posY -= this.velocity - Math.abs(this.posX - this.prevPosX);
            this.posY = Math.max((startTileY + 1) * this.scene.bg.tileH - this.collideBox[3] - 1, this.posY);
            return;
        }
        if (phy == 7) {
            if ((flip & 1) != 0) {
                int offy = (startTileY + 1) * this.scene.bg.tileH - (this.posY + this.collideBox[1]);
                int offx = (startTileX + 1) * this.scene.bg.tileW - (this.posX + this.collideBox[0]);
                if (offy < this.scene.bg.tileH / 2) {
                    offy = 0;
                } else if (flip == 1) {
                    if (this.scene.bg.tileW - offx < (offy - this.scene.bg.tileH / 2) * 2) {
                        offy -= (this.scene.bg.tileW - offx) / 2 - 1;
                    }
                } else {
                    offy = 0;
                    this.posY -= this.velocity - Math.abs(this.posX - this.prevPosX);
                    this.posY = Math.max((startTileY + 1) * this.scene.bg.tileH - this.collideBox[3] - 1, this.posY);
                }
                this.posY += offy;
                return;
            }
            this.posY -= this.velocity - Math.abs(this.posX - this.prevPosX);
            this.posY = Math.max((startTileY + 1) * this.scene.bg.tileH - this.collideBox[3] - 1, this.posY);
            return;
        }
        phy = this.scene.bg.phylayer.phydata[endTileY * this.scene.bg.columns + startTileX];
        if (phy != -1) {
            flip = (phy & 0xC0) >> 6;
            phy &= 0x3F;
        }
        if (phy == -1 || this.phylayer == 0 && phy == 8 || this.phylayer == 2 && phy == 9) {
            this.posY += this.velocity - Math.abs(this.posX - this.prevPosX);
            this.posY = Math.min(endTileY * this.scene.bg.tileH - this.collideBox[1] + 1, this.posY);
            return;
        }
        if (phy == 6) {
            if (flip == 0) {
                int offx = (startTileX + 1) * this.scene.bg.tileW - (this.posX + this.collideBox[0]);
                int offy = (startTileY + 1) * this.scene.bg.tileH - (this.posY + this.collideBox[1]);
                if (this.scene.bg.tileW - offx < offy * 2) {
                    offy -= (this.scene.bg.tileW - offx) / 2 - 1;
                }
                this.posY += offy;
                return;
            }
            this.posY -= this.velocity - Math.abs(this.posX - this.prevPosX);
            this.posY = Math.max((startTileY + 1) * this.scene.bg.tileH - this.collideBox[3] - 1, this.posY);
            return;
        }
        if (phy == 7) {
            if ((flip & 1) != 0) {
                int offy = (startTileY + 1) * this.scene.bg.tileH - (this.posY + this.collideBox[1]);
                int offx = (startTileX + 1) * this.scene.bg.tileW - (this.posX + this.collideBox[0]);
                if (offy < this.scene.bg.tileH / 2) {
                    offy = 0;
                } else if (flip == 1) {
                    if (this.scene.bg.tileW - offx < (offy - this.scene.bg.tileH / 2) * 2) {
                        offy -= (this.scene.bg.tileW - offx) / 2 - 1;
                    }
                } else {
                    offy = 0;
                    this.posY -= this.velocity - Math.abs(this.posX - this.prevPosX);
                    this.posY = Math.max((startTileY + 1) * this.scene.bg.tileH - this.collideBox[3] - 1, this.posY);
                }
                this.posY += offy;
                return;
            }
            this.posY -= this.velocity - Math.abs(this.posX - this.prevPosX);
            this.posY = Math.max((startTileY + 1) * this.scene.bg.tileH - this.collideBox[3] - 1, this.posY);
            return;
        }
    }

    public void drawAndNextFrame(Graphics g) {
        this.draw(g, 0, 0);
        this.nextFrame();
    }

    public void setActorParam(int action, boolean mustchange, boolean oneoff, boolean cycle, boolean flip, int posx, int posy) {
        this.setAction(action, mustchange);
        this.oneoff = oneoff;
        this.actionCycle = cycle;
        this.posX = posx;
        this.posY = posy;
        this.enabled = true;
        this.visible = true;
    }
}

