/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Animation {
    public int id;
    public int effectId;
    public String imageFile;
    public Image image;
    public short imageWidth;
    public short imageHeight;
    public boolean hasPalette = false;
    public int paletteStart;
    public byte[] paletteData;
    private short[] modules;
    private short[][] frames;
    public short[][] actions;
    public byte[] vXYs;

    public Animation() {
    }

    public Animation(String file, int effect, boolean loadImg) throws Exception {
        StringBuffer sb = new StringBuffer();
        if (!file.startsWith("/")) {
            sb.append("/ani/");
        } else {
            sb.append("/ani");
        }
        sb.append(file);
        sb.append(".bin");
        DataInputStream dis = new DataInputStream(sb.toString().getClass().getResourceAsStream(sb.toString()));
        this.loadAction(dis);
        String path = dis.readUTF();
        StringBuffer msb = new StringBuffer();
        msb.append(path);
        msb.append(".png");
        this.effectId = effect;
        this.imageFile = "/ani" + msb.toString();
        if (loadImg) {
            this.image = World.getSceneImage(this.imageFile, this.effectId);
            this.imageWidth = (short)this.image.getWidth();
            this.imageHeight = (short)this.image.getHeight();
        }
        this.loadFrame(dis);
        this.loadMoudle(dis);
        dis.close();
        dis = null;
    }

    public static Animation[] loadAnimation(long[] animMask) throws Exception {
        Animation[] anims = new Animation[66];
        DataInputStream dis = null;
        dis = new DataInputStream("/b2".getClass().getResourceAsStream("/b2"));
        for (int i = 0; i < 66; ++i) {
            long loadMask = animMask[i / 64];
            int maskId = i % 64;
            short length = dis.readShort();
            if ((1L << maskId & loadMask) != 0L) {
                anims[i] = new Animation();
                anims[i].id = i;
                anims[i].load(dis);
                continue;
            }
            dis.skip(length);
        }
        dis.close();
        dis = null;
        return anims;
    }

    public static Animation loadAnimation(int animId, int effectId) throws Exception {
        Animation anim = new Animation();
        anim.id = animId;
        anim.effectId = effectId;
        String animFile = "/b2";
        DataInputStream dis = new DataInputStream(animFile.getClass().getResourceAsStream(animFile));
        int count = dis.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            short length = dis.readShort();
            if (i == animId) break;
            dis.skip(length);
        }
        dis.readShort();
        anim.load(dis);
        dis.close();
        dis = null;
        return anim;
    }

    public void loadMoudle(DataInputStream dis) throws Exception {
        int count = dis.readInt();
        this.modules = new short[count * 4];
        for (int i = 0; i < count; ++i) {
            this.modules[i * 4] = (short)dis.readInt();
            this.modules[i * 4 + 1] = (short)dis.readInt();
            this.modules[i * 4 + 2] = (short)dis.readInt();
            this.modules[i * 4 + 3] = (short)dis.readInt();
        }
    }

    public void loadFrame(DataInputStream dis) throws Exception {
        int count = dis.readUnsignedByte();
        this.frames = new short[count][];
        for (int i = 0; i < count; ++i) {
            dis.skipBytes(2);
            int count2 = dis.readUnsignedByte();
            this.frames[i] = new short[count2 * 4];
            for (int ii = 0; ii < count2 * 4; ++ii) {
                this.frames[i][ii] = (short)dis.readUnsignedShort();
            }
        }
    }

    public void loadAction(DataInputStream dis) throws Exception {
        int count = dis.readUnsignedByte();
        this.actions = new short[count][];
        this.vXYs = new byte[count * 2];
        for (int i = 0; i < count; ++i) {
            dis.skipBytes(1);
            int count2 = dis.readUnsignedByte();
            this.actions[i] = new short[count2];
            for (int j = 0; j < count2; ++j) {
                int data1 = dis.readUnsignedByte();
                int data2 = dis.readUnsignedByte();
                this.actions[i][j] = (short)((data2 << 8) + data1);
            }
            this.vXYs[i * 2] = (byte)(dis.readShort() >> 8);
            this.vXYs[i * 2 + 1] = (byte)(dis.readShort() >> 8);
        }
    }

    public void loadImage(int effect) {
        this.effectId = effect;
        this.image = World.getSceneImage(this.imageFile, this.effectId);
        this.imageWidth = (short)this.image.getWidth();
        this.imageHeight = (short)this.image.getHeight();
    }

    public void load(DataInputStream dis) throws Exception {
        this.loadAction(dis);
        this.imageFile = dis.readUTF();
        this.imageFile = "/ani" + this.imageFile;
        this.loadFrame(dis);
        this.hasPalette = dis.readBoolean();
        this.loadMoudle(dis);
    }

    public void initResource() {
        this.image = this.hasPalette ? World.getSceneImage(this.imageFile, this.paletteStart, this.paletteData) : World.getSceneImage(this.imageFile, this.effectId);
        this.imageWidth = (short)this.image.getWidth();
        this.imageHeight = (short)this.image.getHeight();
    }

    public void releaseResource() {
        if (this.hasPalette) {
            World.removeImage(this.imageFile, this.paletteStart, this.paletteData);
        } else {
            World.removeImage(this.imageFile, this.effectId);
        }
        this.image = null;
    }

    public void dispose() {
        int i;
        this.releaseResource();
        this.imageFile = null;
        this.modules = null;
        if (this.frames != null) {
            for (i = 0; i < this.frames.length; ++i) {
                this.frames[i] = null;
            }
            this.frames = null;
        }
        if (this.actions != null) {
            for (i = 0; i < this.actions.length; ++i) {
                this.actions[i] = null;
            }
            this.actions = null;
        }
        this.vXYs = null;
    }

    public void draw(Graphics g, int x, int y, boolean flipX, boolean flipY, int frameIndex) {
        short[] frame = this.frames[frameIndex];
        for (int i = 0; i < frame.length; i += 4) {
            int modID = (frame[i] & 0xFFFF) << 2;
            int flag = frame[i + 1] & 0xFFFF;
            int modX = this.modules[modID];
            int modY = this.modules[modID + 1];
            int modW = this.modules[modID + 2];
            int modH = this.modules[modID + 3];
            if (modX + modW > this.imageWidth) {
                modW = (short)(this.imageWidth - modX);
            }
            if (modY + modH > this.imageHeight) {
                modH = (short)(this.imageHeight - modY);
            }
            if (modW <= 0 || modH <= 0) continue;
            boolean flipX_real = flipX ^ (flag & 1) != 0;
            boolean flipY_real = flipY ^ (flag & 2) != 0;
            int posX = x;
            int posY = y;
            posX = flipX ? (posX -= frame[i + 2]) : (posX += frame[i + 2]);
            posY = flipY ? (posY -= frame[i + 3]) : (posY += frame[i + 3]);
            if (flipX_real) {
                posX -= modW;
            }
            if (flipY_real) {
                posY -= modH;
            }
            flag = GameCanvas.trans(flipX_real, flipY_real);
            if (posX + modW < 0 || posX >= GameCanvas.SCREEN_WIDTH) continue;
            int clipX = posX;
            int clipY = posY;
            int clipW = modW;
            int clipH = modH;
            if (clipY < GameCanvas.SCREEN_TOP) {
                clipH += clipY - GameCanvas.SCREEN_TOP;
                clipY = GameCanvas.SCREEN_TOP;
            }
            if (clipY + clipH > GameCanvas.SCREEN_DOWN) {
                clipH = GameCanvas.SCREEN_DOWN - clipY;
            }
            if (clipX < 0) {
                clipW += clipX;
                clipX = 0;
            }
            if (clipX + clipW > GameCanvas.SCREEN_WIDTH) {
                clipW = GameCanvas.SCREEN_WIDTH - clipX;
            }
            g.setClip(clipX, clipY, clipW, clipH);
            g.clipRect(clipX, clipY, clipW, clipH);
            posX -= flipX_real ? this.imageWidth - modX - modW : modX;
            posY -= flipY_real ? this.imageHeight - modY - modH : modY;
            if (flag == 0) {
                g.drawImage(this.image, posX, posY, 20);
                continue;
            }
            g.drawRegion(this.image, 0, 0, (int)this.imageWidth, (int)this.imageHeight, flag, posX, posY, 0);
        }
        g.setClip(0, 0, GameCanvas.SCREEN_WIDTH, GameCanvas.SCREEN_HEIGHT);
        g.clipRect(0, 0, GameCanvas.SCREEN_WIDTH, GameCanvas.SCREEN_HEIGHT);
    }

    public short[] getModules() {
        return this.modules;
    }
}

