/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;

public class Battle {
    public static Battle battle;
    public static final int FLAG_NORMAL_BATTLE = 1;
    public static final int FLAG_AUTO_BATTLE = 2;
    public static final int FLAG_CANNOT_ESCAPE = 4;
    public static final int FLAG_CANNOT_RELIVE = 8;
    public static final int FLAG_BE_STEAL = 16;
    public static final int FLAG_STEAL_EMEMY = 32;
    public static final int FLAG_MUST_LOSE = 64;
    public static final int FLAG_KEEP_SOMEROUND = 128;
    public static final int FLAG_PROTECT_SOMEONE = 256;
    public static final int FLAG_HURT_HP = 512;
    private Graphics g = World.g;
    public Team ownTeam;
    public Team enemyTeam;
    public static int battleFlag;
    public static int otherFlag;
    public Role[] fighter;
    public static final int[][] MATE_INIT_POS;
    public static final int[][] ENEMY_INIT_POS;
    int battle_faceId;
    int battle_facial;
    String battle_msg = "";
    String battle_name = "";
    public static int battleResult;
    public static final int RESULT_WIN = 1;
    public static final int RESULT_LOSE = 2;
    public static final int RESULT_SELF_ESCAPE = 3;
    public static final int EFF_DEFAULT = 0;
    public static final int EFF_DIE = 1;
    public static final int EFF_BURN = 2;
    public static final int EFF_CHAOS = 3;
    public static final int EFF_LIMIT = 4;
    public static final int EFF_ATTACK1 = 5;
    public static final int EFF_HARM1 = 6;
    public static final int EFF_ATTACK2 = 7;
    public static final int EFF_ATTACK3 = 8;
    public static final int EFF_MAGIC = 9;
    public static final int EFF_RESTORE = 10;
    public static final int EFF_xy02 = 12;

    public Battle() {
        battle = this;
    }

    public int enterBattle(int enemyTeamID, int flag, int other) {
        int i;
        battleFlag = flag;
        otherFlag = other;
        UI.initBattleResource();
        UI.drawLoading(20);
        EnemyTeam et = new EnemyTeam(enemyTeamID);
        et.loadFighters();
        UI.drawLoading(30);
        short[] tmparray = Tools.upArrayIndex(et.fightersId, true);
        Monster[] enemy = World.readEnemyFromFile(tmparray);
        for (i = 0; i < et.fightersId.length; ++i) {
            et.fighters[i] = new Monster(enemy[et.fightersId[i]]);
        }
        for (i = 0; i < et.fightersId.length; ++i) {
            enemy[i] = null;
        }
        enemy = null;
        UI.drawLoading(40);
        World.myteam.loadFighters();
        UI.drawLoading(50);
        this.ownTeam = World.myteam;
        this.enemyTeam = et;
        this.mergeFighters();
        UI.drawLoading(60);
        this.loadActors();
        UI.drawLoading(70);
        World.myteam.init(MATE_INIT_POS);
        et.init(ENEMY_INIT_POS);
        UI.drawLoading(80);
        for (i = 0; i < this.fighter.length; ++i) {
            this.fighter[i].setStatus(0);
            this.fighter[i].refreshAttribute();
        }
        UI.drawLoading(100);
        Tools.playSound(1, true);
        this.dealBeforeBattle();
        this.runBattle();
        this.dealAfterBattle(battleResult);
        GameCanvas.resetKey();
        return battleResult;
    }

    public void setBattleMessage(String name, int faceId, int facial, String msg) {
        this.battle_msg = msg;
        this.battle_name = name;
        this.battle_faceId = faceId;
        this.battle_facial = facial;
    }

    public void dealBeforeBattle() {
        battleResult = 0;
        if (this.battle_msg == null || this.battle_msg.length() == 0) {
            return;
        }
        World.g.setColor(0);
        World.g.fillRect(0, 0, GameCanvas.SCREEN_WIDTH, GameCanvas.SCREEN_HEIGHT);
        UI.showBattle(1);
        this.battle_msg = null;
        if ((battleFlag & 0x20) != 0) {
            this.ownTeam.pos = otherFlag;
        }
        if ((battleFlag & 0x10) != 0) {
            this.enemyTeam.pos = otherFlag;
        }
    }

    private void dealAfterBattle(int result) {
        UI.showBattle(6);
        for (int i = 0; i < this.ownTeam.fighters.length; ++i) {
            Role mate = this.ownTeam.fighters[i];
            mate.burn = 0;
            mate.chaos = 0;
            mate.frozen = 0;
            mate.buftime = 0;
        }
        switch (result) {
            case 1: {
                ((OwnTeam)this.ownTeam).dealWinPrice();
                break;
            }
            case 2: {
                UI.showMessage(this.g, "\u6211\u65b9\u6218\u8d25\u3002", 10, 3);
                break;
            }
            case 3: {
                UI.showMessage(this.g, "\u6211\u65b9\u9003\u8dd1", 10, 3);
            }
        }
        if ((0x40 & battleFlag) != 0 || otherFlag == 1) {
            this.ownTeam.reliveAll();
        }
        Tools.disposeObject(this.fighter);
        this.fighter = null;
        this.ownTeam.disposeFighters();
        this.enemyTeam.disposeFighters();
        this.ownTeam = null;
        this.enemyTeam = null;
        UI.releaseBattleResource();
        Tools.playSound(0, true);
        World.scene.initResource();
    }

    private void loadActors() {
        Hashtable<String, Animation> ht = new Hashtable<String, Animation>();
        Actor effActor = new Actor("effect", 0, true);
        Actor selArrowActor = new Actor("a_zhishi", 0, true);
        for (int i = 0; i < this.fighter.length; ++i) {
            Role role = this.fighter[i];
            role.actor = new Actor();
            String tmpKey = role.path + role.effect;
            if (ht.containsKey(tmpKey)) {
                role.actor.anim = (Animation)ht.get(tmpKey);
            } else {
                try {
                    role.actor.anim = new Animation(role.path, role.effect, true);
                    ht.put(tmpKey, role.actor.anim);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            role.effactor = effActor.clone();
            role.selactor = selArrowActor.clone();
        }
    }

    private void runBattle() {
        UI.drawBattle(World.g);
        UI.drawFightersHead(World.g);
        World.scene.showDialog(-1, -1, this.battle_name, this.battle_msg);
        World.clearResource(2);
        boolean isAuto = (battleFlag & 2) != 0;
        boolean isquit = false;
        while (!isquit) {
            this.ownTeam.startTurn(this.enemyTeam, isAuto);
            if ((battleFlag & 0x80) != 0 && this.ownTeam.turn >= otherFlag) {
                battleResult = 1;
            } else if (battleResult == 0) {
                this.enemyTeam.startTurn(this.ownTeam, true);
            }
            if (battleResult == 0) {
                UI.drawBattle(this.g);
                UI.drawFightersHead(this.g);
                GameCanvas.canvas.flush();
                World.waitOneFrame();
                continue;
            }
            isquit = true;
        }
    }

    private void getBattleResult() {
        if (this.ownTeam.getFighterCount() == 0) {
            battleResult = 2;
        } else if (this.enemyTeam.getFighterCount() == 0) {
            battleResult = 1;
        } else if (this.ownTeam.isEscape) {
            battleResult = 3;
        }
    }

    private void mergeFighters() {
        int i;
        this.fighter = new Role[this.ownTeam.fighterCount + this.enemyTeam.fighterCount];
        int count = 0;
        for (i = 0; i < this.ownTeam.fighterCount; ++i) {
            this.ownTeam.fighters[i].flip = false;
            this.fighter[count++] = this.ownTeam.fighters[i];
            for (int k = 0; k < this.ownTeam.fighters[i].t_loseHPFrame.length; ++k) {
                this.ownTeam.fighters[i].t_loseHPFrame[k] = -1;
            }
        }
        for (i = 0; i < this.enemyTeam.fighterCount; ++i) {
            if (this.enemyTeam.fighters[i].id == 9 | this.enemyTeam.fighters[i].id == 10 | this.enemyTeam.fighters[i].id == 11 | this.enemyTeam.fighters[i].id == 14 | this.enemyTeam.fighters[i].id == 21 | this.enemyTeam.fighters[i].id == 22 | this.enemyTeam.fighters[i].id == 23 | this.enemyTeam.fighters[i].id == 47 | this.enemyTeam.fighters[i].id == 48 | this.enemyTeam.fighters[i].id == 62 | this.enemyTeam.fighters[i].id == 63 | this.enemyTeam.fighters[i].id == 65 | this.enemyTeam.fighters[i].id == 66 | this.enemyTeam.fighters[i].id == 28) {
                this.enemyTeam.fighters[i].flip = true;
            }
            this.fighter[count++] = this.enemyTeam.fighters[i];
        }
    }

    public void drawFighters() {
        int i;
        for (i = 0; i < this.fighter.length - 1; ++i) {
            for (int j = i + 1; j < this.fighter.length; ++j) {
                if (this.fighter[i].actor.posY <= this.fighter[j].actor.posY) continue;
                Role role = this.fighter[i];
                this.fighter[i] = this.fighter[j];
                this.fighter[j] = role;
            }
        }
        for (i = 0; i < this.fighter.length; ++i) {
            this.fighter[i].draw(this.g);
        }
    }

    public void resetFightersPos() {
        for (int i = 0; i < this.fighter.length; ++i) {
            if (!this.fighter[i].isLiving) continue;
            this.fighter[i].actor.visible = true;
            this.fighter[i].setStatus(0);
            this.fighter[i].actor.posX = this.fighter[i].posx;
            this.fighter[i].actor.posY = this.fighter[i].posy;
        }
    }

    public void dealAfterTurn() {
        for (int i = 0; i < this.fighter.length; ++i) {
            if (!this.fighter[i].isLiving) continue;
            this.fighter[i].setDebufEffect();
            this.fighter[i].setStatus(0);
        }
        this.getBattleResult();
    }

    static {
        MATE_INIT_POS = new int[][]{{GameCanvas.SCREEN_WIDTH * 78 / 100, GameCanvas.SCREEN_HEIGHT * 42 / 100}, {GameCanvas.SCREEN_WIDTH * 67 / 100, GameCanvas.SCREEN_HEIGHT * 54 / 100}, {GameCanvas.SCREEN_WIDTH * 85 / 100, GameCanvas.SCREEN_HEIGHT * 66 / 100}};
        ENEMY_INIT_POS = new int[][]{{GameCanvas.SCREEN_WIDTH * 38 / 100, GameCanvas.SCREEN_HEIGHT * 42 / 100}, {GameCanvas.SCREEN_WIDTH * 25 / 100, GameCanvas.SCREEN_HEIGHT * 52 / 100}, {GameCanvas.SCREEN_WIDTH * 12 / 100, GameCanvas.SCREEN_HEIGHT * 61 / 100}, {GameCanvas.SCREEN_WIDTH * 40 / 100, GameCanvas.SCREEN_HEIGHT * 48 / 100}, {GameCanvas.SCREEN_WIDTH * 33 / 100, GameCanvas.SCREEN_HEIGHT * 58 / 100}};
        battleResult = 0;
    }
}

