/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameCanvas
extends Canvas {
    public static GameCanvas canvas;
    public static int SCREEN_TOP;
    public static int SCREEN_DOWN;
    public static int SCREEN_X;
    public static int SCREEN_Y;
    public static boolean _n97_wait;
    private int n97w = 320;
    public static int SCREEN_WIDTH;
    public static int SCREEN_HEIGHT;
    public static int FONT_H;
    public static byte AC_LEFT_TOP;
    public static byte AC_RIGHT_TOP;
    public static byte AC_LEFT_BOTTOM;
    public static byte AC_LEFT_CENTER;
    public static byte AC_RIGHT_BOTTOM;
    public static byte AC_RIGHT_CENTER;
    public static byte AC_CENTER;
    public static byte AC_CENTER_TOP;
    public static byte AC_CENTER_BOTTOM;
    public static final Font font;
    public static final Font font_big;
    private Image bufferImage;
    private Graphics g;
    public static int shakeFrame;
    public static int shakeX;
    public static int clipX;
    public static int clipY;
    public static int clipW;
    public static int clipH;
    public static boolean hideNotify;
    public static final int GK_UP = 1;
    public static final int GK_UPRIGHT = 2;
    public static final int GK_RIGHT = 4;
    public static final int GK_DOWNRIGHT = 8;
    public static final int GK_DOWN = 16;
    public static final int GK_DOWNLEFT = 32;
    public static final int GK_LEFT = 64;
    public static final int GK_UPLEFT = 128;
    public static final int GK_A = 256;
    public static final int GK_B = 512;
    public static final int GK_C = 1024;
    public static final int GK_D = 2048;
    public static final int GK_LEFT_SOFT = 4096;
    public static final int GK_RIGHT_SOFT = 8192;
    private static final int GAME_KEY_COUNT = 14;
    private static int keyCount;
    public static int keyCurrent;
    private static int keyPressed;
    private static int key;
    private static int keyOff;
    private static final int NOK_UP_ARROW = 1;
    private static final int NOK_DOWN_ARROW = 2;
    private static final int NOK_LEFT_ARROW = 3;
    private static final int NOK_RIGHT_ARROW = 4;
    private static final int NOK_MIDDLE = 5;
    private static final int NOK_LEFT_SOFT = 6;
    private static final int NOK_RIGHT_SOFT = 7;
    final int offset_x;
    final int offset_y;
    public static int keyRepeat;
    public static final int KEY_REPEAT_DELAY = 10;
    public static int[] lastPress;
    public static boolean[] s_isKeyPressed;
    public static int[] intervalPress;
    private static final int DOUBLEPRESS_INTERVAL = 5;
    public static boolean s_isSupportDouble;
    public static final boolean ISRIGHTCONFIRM = false;
    public static final int FONT_TOPLINE = 0;
    public static final int FONT_BOTTOMLINE = 16;
    public static int FONT_HEIGHT;
    public static int FONT_WIDTH;
    public static int LINE_HEIGHT;
    private static GameCanvas instance;

    protected void sizeChanged(int w, int h) {
    }

    public GameCanvas() {
        this.offset_x = 30;
        this.offset_y = 30;
        this.setFullScreenMode(true);
        SCREEN_DOWN = SCREEN_HEIGHT;
        FONT_H = font.getHeight() + 2;
        this.bufferImage = Image.createImage((int)SCREEN_WIDTH, (int)SCREEN_HEIGHT);
        this.g = this.bufferImage.getGraphics();
        this.g.setFont(font);
        canvas = this;
    }

    public Graphics getGraphics() {
        return this.g;
    }

    public static int SCREEN_WIDTH() {
        if (SCREEN_WIDTH > 176) {
            return 176;
        }
        return SCREEN_WIDTH;
    }

    public static int SCREEN_HEIGHT() {
        if (SCREEN_HEIGHT > 220) {
            return 208;
        }
        return SCREEN_HEIGHT;
    }

    public static int SCREEN_X() {
        if (SCREEN_WIDTH > 176) {
            SCREEN_X = (SCREEN_WIDTH - 176) / 2;
        }
        return SCREEN_X;
    }

    public static int SCREEN_Y() {
        if (SCREEN_HEIGHT > 220) {
            SCREEN_Y = (SCREEN_HEIGHT - 208) / 2;
        }
        return SCREEN_Y;
    }

    public void paint(Graphics g) {
        if (hideNotify) {
            g.setFont(font);
            g.setColor(0);
            g.fillRect(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
            g.setColor(0xFFFFFF);
            g.drawString("\u97f3\u4e50\u5df2\u5e2e\u60a8\u6682\u505c", SCREEN_WIDTH / 2, SCREEN_HEIGHT / 2, 17);
            g.drawString("\u7ee7\u7eed", SCREEN_WIDTH, SCREEN_HEIGHT - 26, 24);
            return;
        }
        if (shakeFrame > 0) {
            shakeX = (--shakeFrame & 1) == 0 ? 3 : -3;
            g.drawImage(this.bufferImage, 0 + shakeX, 0, 0);
            return;
        }
        g.drawImage(this.bufferImage, 0, 0, 0);
    }

    public static void setClip(Graphics g, int x, int y, int w, int h) {
        clipX = g.getClipX();
        clipY = g.getClipY();
        clipW = g.getClipWidth();
        clipH = g.getClipHeight();
        g.setClip(x, y, w, h);
        g.clipRect(x, y, w, h);
    }

    public static void restoreClip(Graphics g) {
        g.setClip(clipX, clipY, clipW, clipH);
        g.clipRect(clipX, clipY, clipW, clipH);
    }

    public void flush() {
        this.repaint();
        this.serviceRepaints();
    }

    public static boolean collide(int x, int y, int x2, int y2, int oX, int oY, int oX2, int oY2) {
        return x <= oX2 && x2 >= oX && y <= oY2 && y2 >= oY;
    }

    public static int trans(boolean flipX, boolean flipY) {
        if (flipX) {
            if (flipY) {
                return 3;
            }
            return 2;
        }
        if (flipY) {
            return 1;
        }
        return 0;
    }

    public void drawRegion(Image img, int x_src, int y_src, int width, int height, int transform, int x_dest, int y_dest, int anchor) {
        if (x_src + width > img.getWidth()) {
            width = img.getWidth() - x_src;
        }
        if (y_src + height > img.getHeight()) {
            height = img.getHeight() - y_src;
        }
        this.g.drawRegion(img, x_src, y_src, width, height, transform, x_dest, y_dest, anchor);
    }

    public void drawRegion(Image img, int x_dest, int y_dest, int trans, int anchor) {
        this.g.drawRegion(img, 0, 0, img.getWidth(), img.getHeight(), trans, x_dest, y_dest, anchor);
    }

    protected void hideNotify() {
        hideNotify = true;
        Tools.stopSound();
        this.repaint();
    }

    protected void showNotify() {
        this.repaint();
    }

    public static void resetKey() {
        keyCount = 0;
        keyCurrent = 0;
        keyPressed = 0;
        key = 0;
        keyOff = 0;
        keyRepeat = 0;
    }

    public static void updateKeyBegin() {
        GameCanvas.privateKeyBegin();
    }

    public static void updateKeyEnd() {
        GameCanvas.privateKeyEnd();
    }

    private static void privateKeyBegin() {
        keyPressed = ~key & keyCurrent;
        key = keyCurrent;
        ++keyCount;
    }

    private static void privateKeyEnd() {
        keyCurrent &= ~keyOff;
        keyOff = 0;
    }

    protected void keyPressed(int keyCode) {
        int gameKey = GameCanvas.getKey(keyCode);
        keyCurrent |= gameKey;
        if (hideNotify) {
            if (gameKey == 8192) {
                hideNotify = false;
                if (Tools.soundOn) {
                    Tools.soundOn = true;
                    Tools.playSound(Tools.currentSoundID, true);
                }
            }
            return;
        }
        if (s_isSupportDouble && (gameKey == 64 || gameKey == 1 || gameKey == 16 || gameKey == 4)) {
            int index = GameCanvas.log2(gameKey);
            GameCanvas.intervalPress[index] = keyCount - 5 - lastPress[index];
            GameCanvas.lastPress[index] = keyCount - 5;
            GameCanvas.s_isKeyPressed[index] = true;
        }
    }

    protected void keyReleased(int keyCode) {
        int gameKey = GameCanvas.getKey(keyCode);
        if ((key & gameKey) != 0) {
            keyCurrent &= ~gameKey;
            keyRepeat = 0;
        } else {
            keyOff |= gameKey;
        }
    }

    protected void pointerPressed(int x, int y) {
        if (x - (SCREEN_WIDTH / 2 - 15) > 0 & x - (SCREEN_WIDTH / 2 - 15) < 30 && y < 30) {
            this.keyPressed(48);
        }
        if (x < SCREEN_WIDTH / 2 && y > SCREEN_HEIGHT - 90) {
            this.keyPressed(6);
        }
        if (x > SCREEN_WIDTH - SCREEN_WIDTH / 2 && y > SCREEN_HEIGHT - 90) {
            this.keyPressed(7);
        }
        if (x < 30 && y < 30) {
            this.keyPressed(55);
        }
        if (x > SCREEN_WIDTH - 30 && y < 30) {
            this.keyPressed(57);
        }
    }

    protected void pointerReleased(int x, int y) {
        GameCanvas.resetKey();
        if (x - (SCREEN_WIDTH / 2 - 15) > 0 & x - (SCREEN_WIDTH / 2 - 15) < 30 && y < 30) {
            this.keyReleased(48);
        }
        if (x < SCREEN_WIDTH / 2 && y > SCREEN_HEIGHT - 90) {
            this.keyReleased(6);
        }
        if (x > SCREEN_WIDTH - SCREEN_WIDTH / 2 && y > SCREEN_HEIGHT - 90) {
            this.keyReleased(7);
        }
        if (x < 30 && y < 30) {
            this.keyReleased(55);
        }
        if (x > SCREEN_WIDTH - 30 && y < 30) {
            this.keyReleased(57);
        }
    }

    public static boolean haveKeyHold(int gameKey) {
        return (keyCurrent & gameKey) != 0;
    }

    public static boolean haveKeyPressed(int gameKey) {
        return (keyPressed & gameKey) != 0;
    }

    public static boolean haveKeyRepeated(int gameKey) {
        if (keyRepeat == 0) {
            if ((keyCurrent & gameKey) == 0) {
                return false;
            }
            ++keyRepeat;
            return true;
        }
        if (keyRepeat > 10) {
            return (keyCurrent & gameKey) != 0;
        }
        ++keyRepeat;
        return false;
    }

    public static int log2(int number) {
        int result = 0;
        while (number >> 1 != 0) {
            number >>= 1;
            ++result;
        }
        return result;
    }

    public static boolean haveKeyDoublePressed(int gameKey) {
        int index = GameCanvas.log2(gameKey);
        if (!s_isKeyPressed[index]) {
            return false;
        }
        GameCanvas.s_isKeyPressed[index] = false;
        return intervalPress[index] > 0 && intervalPress[index] < 5;
    }

    public static boolean anyKeyHold() {
        return keyCurrent != 0;
    }

    public static boolean anyKeyPressed() {
        return GameCanvas.haveKeyPressed(16383);
    }

    public static boolean runKeyPressed() {
        boolean runkey = GameCanvas.haveKeyPressed(68);
        runkey = runkey || GameCanvas.haveKeyHold(68);
        return runkey;
    }

    public static boolean runLeftKeyPressed() {
        boolean runkey = GameCanvas.haveKeyPressed(64);
        runkey = runkey || GameCanvas.haveKeyHold(64);
        return runkey;
    }

    public static boolean runRightKeyPressed() {
        boolean runkey = GameCanvas.haveKeyPressed(4);
        runkey = runkey || GameCanvas.haveKeyHold(4);
        return runkey;
    }

    private static int getKey(int keyCode) {
        if (keyCode < 0) {
            keyCode = -keyCode;
        }
        switch (keyCode) {
            case 1: 
            case 50: {
                return 1;
            }
            case 2: 
            case 56: {
                return 16;
            }
            case 3: 
            case 52: {
                return 64;
            }
            case 4: 
            case 54: {
                return 4;
            }
            case 49: {
                return 128;
            }
            case 55: {
                return 32;
            }
            case 51: {
                return 2;
            }
            case 57: {
                return 8;
            }
            case 5: 
            case 53: {
                return 256;
            }
            case 35: {
                return 512;
            }
            case 48: {
                return 1024;
            }
            case 42: {
                return 2048;
            }
            case 6: {
                return 4096;
            }
            case 7: {
                return 8192;
            }
        }
        return 0;
    }

    public static boolean keyCanceled() {
        return GameCanvas.haveKeyPressed(8192);
    }

    public static boolean keyConfirmed() {
        int confirmKey = 0;
        confirmKey = 4096;
        return GameCanvas.haveKeyPressed(confirmKey | 0x100);
    }

    public static boolean keyConfirmed2() {
        int confirmKey = 0;
        confirmKey = 4096;
        return GameCanvas.haveKeyPressed(confirmKey);
    }

    public void drawString(Graphics g, String str, int x_dest, int y_dest, int anchor) {
        if (str == null || str.length() <= 0) {
            return;
        }
        int x = x_dest;
        if ((anchor & 8) != 0) {
            x -= g.getFont().stringWidth(str);
        } else if ((anchor & 1) != 0) {
            x -= g.getFont().stringWidth(str) >> 1;
        }
        int y = y_dest - 0;
        if ((anchor & 0x20) != 0) {
            y -= FONT_HEIGHT;
        } else if ((anchor & 2) != 0) {
            y -= FONT_HEIGHT >> 1;
        }
        g.drawString(str, x, y, 20);
    }

    public static GameCanvas getInstance() {
        if (instance == null) {
            instance = new GameCanvas();
        }
        return instance;
    }

    static {
        SCREEN_TOP = 0;
        SCREEN_DOWN = 0;
        SCREEN_X = 0;
        SCREEN_Y = 0;
        _n97_wait = false;
        SCREEN_WIDTH = 240;
        SCREEN_HEIGHT = 320;
        AC_LEFT_TOP = (byte)20;
        AC_RIGHT_TOP = (byte)24;
        AC_LEFT_BOTTOM = (byte)36;
        AC_LEFT_CENTER = (byte)6;
        AC_RIGHT_BOTTOM = (byte)40;
        AC_RIGHT_CENTER = (byte)10;
        AC_CENTER = (byte)3;
        AC_CENTER_TOP = (byte)17;
        AC_CENTER_BOTTOM = (byte)33;
        font = Font.getFont((int)0, (int)0, (int)8);
        font_big = Font.getFont((int)0, (int)0, (int)16);
        shakeFrame = 0;
        shakeX = 0;
        hideNotify = false;
        keyCount = 0;
        keyCurrent = 0;
        keyPressed = 0;
        key = 0;
        keyOff = 0;
        keyRepeat = 0;
        lastPress = new int[14];
        s_isKeyPressed = new boolean[14];
        intervalPress = new int[14];
        s_isSupportDouble = false;
        FONT_HEIGHT = 20;
        FONT_WIDTH = font.charWidth('\u54c8');
        LINE_HEIGHT = FONT_HEIGHT + 2;
    }
}

