/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

public abstract class Team {
    public Role[] fighters;
    public short[] fightersId;
    public short fighterCount;
    public int turn = 0;
    public int pos = 0;
    public int step = 1;
    public int teamLevel = 0;
    public boolean isEscape;
    public short id;
    private static final byte[][] IND_POS = new byte[][]{{1}, {0, 2}, {0, 1, 2}, {0, 2, 3, 4}, {0, 1, 2, 3, 4}};
    private static int attCount = 0;
    private static int keyCout = 0;
    private static boolean isDraw = false;
    private static final int BASE_COUNT = keyCout;

    public void init(int[][] MATE_POS) {
        this.isEscape = false;
        this.pos = 0;
        this.turn = 0;
        byte[] index = IND_POS[this.fighters.length - 1];
        for (int i = 0; i < this.fighters.length; ++i) {
            this.fighters[i].setStatus(0);
            this.fighters[i].actor.posX = MATE_POS[index[i]][0];
            this.fighters[i].actor.posY = MATE_POS[index[i]][1];
            this.fighters[i].posx = (short)this.fighters[i].actor.posX;
            this.fighters[i].posy = (short)this.fighters[i].actor.posY;
            this.fighters[i].selactor.posX = this.fighters[i].posx;
            this.fighters[i].selactor.posY = this.fighters[i].posy - this.fighters[i].height;
            this.fighters[i].effactor.posX = this.fighters[i].posx;
            this.fighters[i].effactor.posY = this.fighters[i].posy;
            if (this.fighters[i].flip) {
                this.fighters[i].actor.flipX = true;
            }
            if (this.fighters[i].posx <= GameCanvas.SCREEN_WIDTH / 2) continue;
            this.fighters[i].effactor.flipX = true;
        }
        this.teamLevel = this.getTeamLevel();
    }

    public void load(DataInputStream dis) {
        try {
            this.id = dis.readShort();
            this.fighterCount = dis.readShort();
            this.fightersId = new short[this.fighterCount];
            for (int i = 0; i < this.fighterCount; ++i) {
                this.fightersId[i] = dis.readShort();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public abstract void loadFighters();

    public void disposeFighters() {
        for (int i = 0; i < this.fighters.length; ++i) {
            this.fighters[i].actor.dispose();
            this.fighters[i].effactor.dispose();
            this.fighters[i].selactor.dispose();
            this.fighters[i].actor = null;
            this.fighters[i].effactor = null;
            this.fighters[i].selactor = null;
            this.fighters[i] = null;
        }
        this.fighters = null;
    }

    public int getTeamLevel() {
        int level = 0;
        for (int i = 0; i < this.fighters.length; ++i) {
            level += this.fighters[i].level;
        }
        return level /= this.fighters.length;
    }

    public void startTurn(Team otherTeam, boolean isAuto) {
        this.pos += this.step;
        if (this.pos < 300) {
            // empty if block
        }
        UI.flashIcon = 3;
        while (UI.flashIcon-- >= 0) {
            UI.drawBattle(World.g);
            UI.drawFightersHead(World.g);
            GameCanvas.canvas.flush();
            World.waitAnyTime(80L);
        }
        this.pos = 0;
        ++this.turn;
        if (this.isEscape) {
            return;
        }
        for (int i = 0; i < this.fighters.length; ++i) {
            this.fighters[i].initTurn();
        }
        this.runTurn(otherTeam, isAuto);
        Battle.battle.dealAfterTurn();
    }

    public void runTurn(Team otherTeam, boolean isAuto) {
        Role role = null;
        Object role1 = null;
        boolean isquit = false;
        int[] flags = new int[]{22, 18, 2};
        int index = 0;
        while (!isquit && index < 3) {
            role = isAuto ? this.autoSelectActFighter(flags[index]) : this.selectActFighter(flags[index]);
            if (role != null) {
                role.isSelected = false;
                role.actor.posX = role.posx < GameCanvas.SCREEN_WIDTH / 2 ? (role.actor.posX += 4) : (role.actor.posX -= 4);
                UI.showBattle(2);
                int ret = role.startAction(this, otherTeam, isAuto);
                if (isAuto) {
                    // empty if block
                }
                role.actor.posX = role.posx < GameCanvas.SCREEN_WIDTH / 2 ? (role.actor.posX -= 4) : (role.actor.posX += 4);
                UI.showBattle(1);
                if (this.isEscape && (Battle.battleFlag & 4) == 0) {
                    isquit = true;
                }
                if (2 == ret) {
                    isquit = true;
                }
                System.out.println("rolec_HP" + role.c_hp);
                System.out.println("roleb_HP" + role.b_hp);
                System.out.println("rolef_HP" + role.f_hp);
            } else {
                if (index < 3) {
                    ++index;
                }
                System.out.println("\u65e0\u53ef\u63a7\u89d2\u8272,");
                isAuto = false;
            }
            if (this.fighterCount != 0 && otherTeam.getFighterCount() != 0) continue;
            System.out.println("\u8bbe\u4e3a\u81ea\u52a8\u5904\u7406");
            isquit = true;
        }
    }

    public abstract Role selectActFighter(int var1);

    public Role autoSelectActFighter(int flag) {
        for (int i = 0; i < this.fighters.length; ++i) {
            if (this.fighters[i].hasAction && this.fighters[i].autoHasAction || !this.fighters[i].matchRole(flag)) continue;
            return this.fighters[i];
        }
        return null;
    }

    public Role autoSelectActFighter1(int flag) {
        for (int i = 0; i < this.fighters.length; ++i) {
            if (this.fighters[i].autoHasAction || !this.fighters[i].matchRole(flag) || !this.fighters[i].helper) continue;
            return this.fighters[i];
        }
        return null;
    }

    public Role[] selectOppFighters(int flag, Role actRole, int count) {
        Vector<Role> vecRoles = new Vector<Role>(5);
        for (int i = 0; i < this.fighters.length; ++i) {
            if (!this.fighters[i].matchRole(flag) || this.fighters[i] == actRole) continue;
            vecRoles.addElement(this.fighters[i]);
        }
        Role[] roles = new Role[vecRoles.size()];
        for (int i = 0; i < vecRoles.size(); ++i) {
            roles[i] = (Role)vecRoles.elementAt(i);
        }
        roles = UI.selectRoles(roles, count, true);
        return roles;
    }

    public short getFighterCount() {
        short ret = 0;
        for (int i = 0; i < this.fighters.length; ++i) {
            if (!this.fighters[i].isLiving) continue;
            ret = (short)(ret + 1);
        }
        return ret;
    }

    public Role[] autoSelectOppFighters(int flag, Role actRole, int count) {
        Vector<Role> vecRoles = new Vector<Role>();
        for (int i = 0; i < this.fighters.length; ++i) {
            if (this.fighters[i] == actRole || !this.fighters[i].matchRole(flag)) continue;
            vecRoles.addElement(this.fighters[i]);
        }
        int c = Math.min(count, vecRoles.size());
        int start = Tools.random(0, vecRoles.size() - c);
        Role[] ret = new Role[c];
        for (int i = 0; i < c; ++i) {
            ret[i] = (Role)vecRoles.elementAt(start + i);
        }
        return ret;
    }

    public void reliveAll() {
        if (this.fighters == null) {
            for (int i = 0; i < World.myteam.existcount; ++i) {
                World.myteam.mates[i].recoverAttribute();
            }
        } else {
            for (int i = 0; i < this.fighters.length; ++i) {
                this.fighters[i].recoverAttribute();
            }
            this.fighterCount = (short)this.fighters.length;
        }
    }

    private boolean havaKeyNum5() {
        World.gameCanvas.updateKeyBegin();
        if (GameCanvas.haveKeyPressed(256) & keyCout < 1) {
            ++keyCout;
            UI.isDrawNun5 = false;
            return false;
        }
        World.gameCanvas.updateKeyEnd();
        UI.isDrawNun5 = true;
        return true;
    }

    private void banZhuan(int attackSum) {
        attCount = 0;
        keyCout = 0;
        isDraw = true;
        this.havaKeyNum5();
        UI.isDrawNun5 = true;
        this.juQi();
        while (attCount++ < 15) {
            UI.drawBattle(World.g);
            this.havaKeyNum5();
            World.gameCanvas.flush();
            World.waitAnyTime(10L);
            int attack = 0;
            attack = attack * 101 / 100;
            attackSum += attack;
            this.havaKeyNum5();
            UI.setBgBlackMode(false);
        }
        UI.isDrawNun5 = false;
        isDraw = false;
        UI.showBattle(1);
        UI.drawNumbers(World.g, 4, 0, UI.mapNumToBit(String.valueOf(Math.abs(attackSum))), 100, 28, 2);
        World.gameCanvas.flush();
        World.waitAnyTime(1000L);
    }

    private void juQi() {
        for (int i = 0; i < 10; ++i) {
            UI.drawBattle(World.g);
            UI.drawFightersHead(World.g);
            UI.gc.flush();
            World.waitOneFrame();
            this.havaKeyNum5();
        }
    }

    public void killAll() {
        if (this.fighters != null) {
            for (int i = 0; i < this.fighters.length; ++i) {
                if (!this.fighters[i].isLiving) continue;
                this.fighters[i].calcHP(-999999999);
                this.fighters[i].setDie(Battle.battle.enemyTeam, World.myteam, null);
            }
        }
    }
}

